/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import autoroute.AutorouteEngine;
import board.Component;
import board.Connectable;
import board.DrillItem;
import board.FixedState;
import board.Item;
import board.ObstacleArea;
import board.OptViaAlgo;
import board.Pin;
import board.PolylineTrace;
import board.RoutingBoard;
import board.TestLevel;
import board.Via;
import datastructures.Stoppable;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.Point;
import geometry.planar.Vector;
import interactive.BoardHandling;
import interactive.ClearanceViolations;
import interactive.CutoutRouteState;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import interactive.MoveItemState;
import interactive.SelectItemsInRegionState;
import interactive.ZoomRegionState;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import library.Package;
import rules.Net;

public class SelectedItemState
extends InteractiveState {
    private Set<Item> item_list;
    private ClearanceViolations clearance_violations = null;

    public static SelectedItemState get_instance(Set<Item> p_item_list, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        if (p_item_list.isEmpty()) {
            return null;
        }
        SelectedItemState new_state = new SelectedItemState(p_item_list, p_parent_state, p_board_handling, p_logfile);
        return new_state;
    }

    private SelectedItemState(Set<Item> p_item_list, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
        this.item_list = p_item_list;
    }

    public Collection<Item> get_item_list() {
        return this.item_list;
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        return this.toggle_select(p_location);
    }

    @Override
    public InteractiveState mouse_dragged(FloatPoint p_point) {
        return SelectItemsInRegionState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg, this.logfile);
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState result = this;
        if (p_key_char == 'a') {
            this.hdlg.autoroute_selected_items();
        } else if (p_key_char == 'b') {
            this.extent_to_whole_components();
        } else if (p_key_char == 'd') {
            result = this.cutout_items();
        } else if (p_key_char == 'e') {
            result = this.extent_to_whole_connections();
        } else if (p_key_char == 'f') {
            this.fix_items();
        } else if (p_key_char == 'i') {
            result = this.info();
        } else if (p_key_char == 'm') {
            result = MoveItemState.get_instance(this.hdlg.get_current_mouse_position(), this.item_list, this.return_state, this.hdlg, this.logfile);
        } else if (p_key_char == 'n') {
            this.extent_to_whole_nets();
        } else if (p_key_char == 'p') {
            this.hdlg.optimize_selected_items();
        } else if (p_key_char == 'r') {
            result = ZoomRegionState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg, this.logfile);
        } else if (p_key_char == 's') {
            result = this.extent_to_whole_connected_sets();
        } else if (p_key_char == 'u') {
            this.unfix_items();
        } else if (p_key_char == 'v') {
            this.toggle_clearance_violations();
        } else if (p_key_char == 'w') {
            this.hdlg.zoom_selection();
        } else {
            result = p_key_char == '\u007f' ? this.delete_items() : super.key_typed(p_key_char);
        }
        return result;
    }

    public void fix_items() {
        for (Item curr_ob : this.item_list) {
            if (curr_ob.get_fixed_state().ordinal() >= FixedState.USER_FIXED.ordinal()) continue;
            curr_ob.set_fixed_state(FixedState.USER_FIXED);
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.FIX_SELECTED_ITEMS);
        }
    }

    public void unfix_items() {
        for (Item curr_ob : this.item_list) {
            curr_ob.unfix();
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.UNFIX_SELECTED_ITEMS);
        }
    }

    public InteractiveState assign_items_to_new_net() {
        RoutingBoard board = this.hdlg.get_routing_board();
        board.generate_snapshot();
        boolean items_already_connected = false;
        Net new_net = board.rules.nets.new_net(this.hdlg.get_locale());
        for (Item curr_item : this.item_list) {
            if (curr_item instanceof ObstacleArea) {
                board.make_conductive((ObstacleArea)curr_item, new_net.net_number);
                continue;
            }
            if (!(curr_item instanceof DrillItem)) continue;
            if (curr_item.is_connected()) {
                items_already_connected = true;
                continue;
            }
            curr_item.assign_net_no(new_net.net_number);
        }
        if (items_already_connected) {
            // empty if block
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.ASSIGN_SELECTED_TO_NEW_NET);
        }
        this.hdlg.update_ratsnest();
        return this.return_state;
    }

    public InteractiveState assign_items_to_new_group() {
        RoutingBoard board = this.hdlg.get_routing_board();
        board.generate_snapshot();
        double gravity_x = 0.0;
        double gravity_y = 0.0;
        int pin_count = 0;
        Iterator<Item> it = this.item_list.iterator();
        while (it.hasNext()) {
            Item curr_ob = it.next();
            if (curr_ob instanceof Via) {
                FloatPoint curr_center = ((DrillItem)curr_ob).get_center().to_float();
                gravity_x += curr_center.x;
                gravity_y += curr_center.y;
                ++pin_count;
                continue;
            }
            it.remove();
        }
        if (pin_count == 0) {
            return this.return_state;
        }
        IntPoint gravity_point = new IntPoint((int)Math.round(gravity_x /= (double)pin_count), (int)Math.round(gravity_y /= (double)pin_count));
        Package.Pin[] pin_arr = new Package.Pin[this.item_list.size()];
        it = this.item_list.iterator();
        for (int i = 0; i < pin_arr.length; ++i) {
            Via curr_via = (Via)it.next();
            Vector rel_coor = curr_via.get_center().difference_by((Point)gravity_point);
            String pin_name = new Integer(i + 1).toString();
            pin_arr[i] = new Package.Pin(pin_name, curr_via.get_padstack().no, rel_coor, 0.0);
        }
        Package new_package = board.library.packages.add(pin_arr);
        Component new_component = board.components.add(gravity_point, 0.0, true, new_package);
        it = this.item_list.iterator();
        for (int i = 0; i < pin_arr.length; ++i) {
            Via curr_via = (Via)it.next();
            board.remove_item(curr_via);
            int[] net_no_arr = new int[curr_via.net_count()];
            for (int j = 0; j < net_no_arr.length; ++j) {
                net_no_arr[j] = curr_via.get_net_no(j);
            }
            board.insert_pin(new_component.no, i, net_no_arr, curr_via.clearance_class_no(), curr_via.get_fixed_state());
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.ASSIGN_SELECTED_TO_NEW_GROUP);
        }
        return this.return_state;
    }

    public InteractiveState delete_items() {
        this.hdlg.get_routing_board().generate_snapshot();
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            for (int i = 0; i < curr_item.net_count(); ++i) {
                changed_nets.add(curr_item.get_net_no(i));
            }
        }
        boolean with_delete_fixed = this.hdlg.get_routing_board().get_test_level() != TestLevel.RELEASE_VERSION;
        boolean all_items_removed = this.hdlg.settings.push_enabled ? this.hdlg.get_routing_board().remove_items_and_pull_tight(this.item_list, this.hdlg.settings.trace_pull_tight_region_width, this.hdlg.settings.trace_pull_tight_accuracy, with_delete_fixed) : this.hdlg.get_routing_board().remove_items(this.item_list, with_delete_fixed);
        if (!all_items_removed) {
            // empty if block
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.DELETE_SELECTED);
        }
        for (Integer curr_net_no : changed_nets) {
            this.hdlg.update_ratsnest(curr_net_no);
        }
        return this.return_state;
    }

    public InteractiveState cutout_items() {
        return CutoutRouteState.get_instance(this.item_list, this.return_state, this.hdlg, this.logfile);
    }

    public InteractiveState autoroute(Stoppable p_stoppable_thread) {
        boolean saved_board_read_only = this.hdlg.is_board_read_only();
        this.hdlg.set_board_read_only(true);
        if (p_stoppable_thread != null) {
            String string = this.resources.getString("autoroute") + " " + this.resources.getString("stop_message");
        }
        Integer not_found_count = 0;
        Integer found_count = 0;
        boolean interrupted = false;
        LinkedList<Item> autoroute_item_list = new LinkedList<Item>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            for (int i = 0; i < curr_item.net_count(); ++i) {
                if (curr_item.get_unconnected_set(curr_item.get_net_no(i)).isEmpty()) continue;
                autoroute_item_list.add(curr_item);
            }
        }
        int items_to_go_count = autoroute_item_list.size();
        this.item_list = new TreeSet<Item>();
        boolean ratsnest_hidden_before = this.hdlg.get_ratsnest().is_hidden();
        if (!ratsnest_hidden_before) {
            this.hdlg.get_ratsnest().hide();
        }
        for (Item curr_item : autoroute_item_list) {
            if (p_stoppable_thread != null && p_stoppable_thread.is_stop_requested()) {
                interrupted = true;
                break;
            }
            if (curr_item.net_count() != 1) continue;
            boolean contains_plane = false;
            Net route_net = this.hdlg.get_routing_board().rules.nets.get(curr_item.get_net_no(0));
            if (route_net != null) {
                contains_plane = route_net.contains_plane();
            }
            int via_costs = contains_plane ? this.hdlg.settings.autoroute_settings.get_plane_via_costs() : this.hdlg.settings.autoroute_settings.get_via_costs();
            this.hdlg.get_routing_board().start_marking_changed_area();
            AutorouteEngine.AutorouteResult autoroute_result = this.hdlg.get_routing_board().autoroute(curr_item, this.hdlg.settings, via_costs, p_stoppable_thread, null);
            if (autoroute_result == AutorouteEngine.AutorouteResult.ROUTED) {
                found_count = found_count + 1;
            } else if (autoroute_result != AutorouteEngine.AutorouteResult.ALREADY_CONNECTED) {
                not_found_count = not_found_count + 1;
            }
            --items_to_go_count;
        }
        if (p_stoppable_thread != null) {
            String curr_message = interrupted ? this.resources.getString("interrupted") : this.resources.getString("completed");
            String string = this.resources.getString("autoroute") + " " + curr_message + ": " + found_count.toString() + " " + this.resources.getString("connections_found") + ", " + not_found_count.toString() + " " + this.resources.getString("connections_not_found");
        }
        this.hdlg.set_board_read_only(saved_board_read_only);
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.AUTOROUTE_SELECTED);
        }
        this.hdlg.update_ratsnest();
        if (!ratsnest_hidden_before) {
            this.hdlg.get_ratsnest().show();
        }
        return this.return_state;
    }

    public InteractiveState fanout(Stoppable p_stoppable_thread) {
        boolean saved_board_read_only = this.hdlg.is_board_read_only();
        this.hdlg.set_board_read_only(true);
        if (p_stoppable_thread != null) {
            String string = this.resources.getString("fanout") + " " + this.resources.getString("stop_message");
        }
        Integer not_found_count = 0;
        Integer found_count = 0;
        int trace_pull_tight_accuracy = this.hdlg.settings.trace_pull_tight_accuracy;
        boolean interrupted = false;
        LinkedList<Pin> fanout_list = new LinkedList<Pin>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Pin)) continue;
            fanout_list.add((Pin)curr_item);
        }
        int items_to_go_count = fanout_list.size();
        this.item_list = new TreeSet<Item>();
        boolean ratsnest_hidden_before = this.hdlg.get_ratsnest().is_hidden();
        if (!ratsnest_hidden_before) {
            this.hdlg.get_ratsnest().hide();
        }
        for (Pin curr_pin : fanout_list) {
            if (p_stoppable_thread != null && p_stoppable_thread.is_stop_requested()) {
                interrupted = true;
                break;
            }
            this.hdlg.get_routing_board().start_marking_changed_area();
            AutorouteEngine.AutorouteResult autoroute_result = this.hdlg.get_routing_board().fanout(curr_pin, this.hdlg.settings, -1, p_stoppable_thread, null);
            if (autoroute_result == AutorouteEngine.AutorouteResult.ROUTED) {
                found_count = found_count + 1;
            } else if (autoroute_result != AutorouteEngine.AutorouteResult.ALREADY_CONNECTED) {
                not_found_count = not_found_count + 1;
            }
            --items_to_go_count;
        }
        if (p_stoppable_thread != null) {
            String curr_message = interrupted ? this.resources.getString("interrupted") : this.resources.getString("completed");
            String string = this.resources.getString("fanout") + " " + curr_message + ": " + found_count.toString() + " " + this.resources.getString("connections_found") + ", " + not_found_count.toString() + " " + this.resources.getString("connections_not_found");
        }
        this.hdlg.set_board_read_only(saved_board_read_only);
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.FANOUT_SELECTED);
        }
        this.hdlg.update_ratsnest();
        if (!ratsnest_hidden_before) {
            this.hdlg.get_ratsnest().show();
        }
        return this.return_state;
    }

    public InteractiveState pull_tight(Stoppable p_stoppable_thread) {
        boolean saved_board_read_only = this.hdlg.is_board_read_only();
        this.hdlg.set_board_read_only(true);
        if (p_stoppable_thread != null) {
            String string = this.resources.getString("pull_tight") + " " + this.resources.getString("stop_message");
        }
        this.hdlg.get_routing_board().start_marking_changed_area();
        boolean interrupted = false;
        for (Item curr_item : this.item_list) {
            if (p_stoppable_thread != null && p_stoppable_thread.is_stop_requested()) {
                interrupted = true;
                break;
            }
            if (curr_item.net_count() != 1) continue;
            if (curr_item instanceof PolylineTrace) {
                PolylineTrace curr_trace = (PolylineTrace)curr_item;
                boolean something_changed = curr_trace.pull_tight(!this.hdlg.settings.push_enabled, this.hdlg.settings.trace_pull_tight_accuracy, p_stoppable_thread);
                if (something_changed) continue;
                curr_trace.smoothen_end_corners_fork(!this.hdlg.settings.push_enabled, this.hdlg.settings.trace_pull_tight_accuracy, p_stoppable_thread);
                continue;
            }
            if (!(curr_item instanceof Via)) continue;
            OptViaAlgo.opt_via_location(this.hdlg.get_routing_board(), (Via)curr_item, null, this.hdlg.settings.trace_pull_tight_accuracy, 10);
        }
        if (this.hdlg.settings.push_enabled && !interrupted) {
            this.hdlg.get_routing_board().opt_changed_area(new int[0], null, this.hdlg.settings.trace_pull_tight_accuracy, null, p_stoppable_thread, 0);
        }
        if (p_stoppable_thread != null) {
            String curr_message = interrupted ? this.resources.getString("interrupted") : this.resources.getString("completed");
            String string = this.resources.getString("pull_tight") + " " + curr_message;
        }
        this.hdlg.set_board_read_only(saved_board_read_only);
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.OPTIMIZE_SELECTED);
        }
        this.hdlg.update_ratsnest();
        return this.return_state;
    }

    public InteractiveState assign_clearance_class(int p_cl_class_index) {
        RoutingBoard routing_board = this.hdlg.get_routing_board();
        if (p_cl_class_index < 0 || p_cl_class_index >= routing_board.rules.clearance_matrix.get_class_count()) {
            return this.return_state;
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.ASSIGN_CLEARANCE_CLASS);
            this.logfile.add_int(p_cl_class_index);
        }
        routing_board.generate_snapshot();
        for (Item curr_item : this.item_list) {
            if (curr_item.clearance_class_no() == p_cl_class_index) continue;
            curr_item.change_clearance_class(p_cl_class_index);
        }
        return this.return_state;
    }

    public InteractiveState extent_to_whole_nets() {
        TreeSet<Integer> curr_net_no_set = new TreeSet<Integer>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            for (int i = 0; i < curr_item.net_count(); ++i) {
                curr_net_no_set.add(curr_item.get_net_no(i));
            }
        }
        TreeSet<Item> new_selected_items = new TreeSet<Item>();
        Iterator it2 = curr_net_no_set.iterator();
        while (it2.hasNext()) {
            int curr_net_no = (Integer)it2.next();
            new_selected_items.addAll(this.hdlg.get_routing_board().get_connectable_items(curr_net_no));
        }
        this.item_list = new_selected_items;
        if (new_selected_items.isEmpty()) {
            return this.return_state;
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.EXTEND_TO_WHOLE_NETS);
        }
        this.filter();
        return this;
    }

    public InteractiveState extent_to_whole_components() {
        TreeSet<Integer> curr_group_no_set = new TreeSet<Integer>();
        for (Item curr_item : this.item_list) {
            if (curr_item.get_component_no() <= 0) continue;
            curr_group_no_set.add(curr_item.get_component_no());
        }
        TreeSet<Item> new_selected_items = new TreeSet<Item>();
        new_selected_items.addAll(this.item_list);
        Iterator it2 = curr_group_no_set.iterator();
        while (it2.hasNext()) {
            int curr_group_no = (Integer)it2.next();
            new_selected_items.addAll(this.hdlg.get_routing_board().get_component_items(curr_group_no));
        }
        if (new_selected_items.isEmpty()) {
            return this.return_state;
        }
        this.item_list = new_selected_items;
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.EXTEND_TO_WHOLE_COMPONENTS);
        }
        return this;
    }

    public InteractiveState extent_to_whole_connected_sets() {
        TreeSet<Item> new_selected_items = new TreeSet<Item>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            new_selected_items.addAll(curr_item.get_connected_set(-1));
        }
        if (new_selected_items.isEmpty()) {
            return this.return_state;
        }
        this.item_list = new_selected_items;
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.EXTEND_TO_WHOLE_CONNECTED_SETS);
        }
        this.filter();
        return this;
    }

    public InteractiveState extent_to_whole_connections() {
        TreeSet<Item> new_selected_items = new TreeSet<Item>();
        for (Item curr_item : this.item_list) {
            if (!(curr_item instanceof Connectable)) continue;
            new_selected_items.addAll(curr_item.get_connection_items());
        }
        if (new_selected_items.isEmpty()) {
            return this.return_state;
        }
        this.item_list = new_selected_items;
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.EXTEND_TO_WHOLE_CONNECTIONS);
        }
        this.filter();
        return this;
    }

    public InteractiveState toggle_select(FloatPoint p_point) {
        Set<Item> picked_items = this.hdlg.pick_items(p_point);
        boolean state_ended = picked_items.isEmpty();
        if (picked_items.size() == 1) {
            Item picked_item = (Item)picked_items.iterator().next();
            if (this.item_list.contains(picked_item)) {
                this.item_list.remove(picked_item);
                if (this.item_list.isEmpty()) {
                    state_ended = true;
                }
            } else {
                this.item_list.add(picked_item);
            }
        }
        InteractiveState result = state_ended ? this.return_state : this;
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.TOGGLE_SELECT, p_point);
        }
        return result;
    }

    public void toggle_clearance_violations() {
        if (this.clearance_violations == null) {
            this.clearance_violations = new ClearanceViolations(this.item_list);
            Integer violation_count = new Integer(this.clearance_violations.list.size());
            String string = violation_count.toString() + " " + this.resources.getString("clearance_violations_found");
        } else {
            this.clearance_violations = null;
        }
    }

    public InteractiveState filter() {
        this.item_list = this.hdlg.settings.item_selection_filter.filter(this.item_list);
        InteractiveState result = this;
        if (this.item_list.isEmpty()) {
            result = this.return_state;
        }
        return result;
    }

    public SelectedItemState info() {
        return this;
    }

    @Override
    public String get_help_id() {
        return "SelectedItemState";
    }

    @Override
    public void draw(Graphics p_graphics) {
        if (this.item_list == null) {
            return;
        }
        for (Item curr_item : this.item_list) {
            curr_item.draw(p_graphics, this.hdlg.graphics_context, this.hdlg.graphics_context.get_hilight_color(), this.hdlg.graphics_context.get_hilight_color_intensity());
        }
        if (this.clearance_violations != null) {
            this.clearance_violations.draw(p_graphics, this.hdlg.graphics_context);
        }
    }

    @Override
    public void set_toolbar() {
    }

    @Override
    public void display_default_message() {
    }
}

