/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.Item;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntPoint;
import interactive.BoardHandling;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import interactive.SelectRegionState;
import interactive.SelectedItemState;
import java.util.Set;
import java.util.TreeSet;

public class SelectItemsInRegionState
extends SelectRegionState {
    public static SelectItemsInRegionState get_instance(InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        return SelectItemsInRegionState.get_instance(null, p_parent_state, p_board_handling, p_logfile);
    }

    public static SelectItemsInRegionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        p_board_handling.display_layer_messsage();
        SelectItemsInRegionState new_instance = new SelectItemsInRegionState(p_parent_state, p_board_handling, p_logfile);
        new_instance.corner1 = p_location;
        if (new_instance.logfile != null) {
            new_instance.logfile.add_corner(p_location);
        }
        return new_instance;
    }

    private SelectItemsInRegionState(InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.SELECT_REGION);
        }
    }

    @Override
    public InteractiveState complete() {
        if (!this.hdlg.is_board_read_only()) {
            this.corner2 = this.hdlg.get_current_mouse_position();
            if (this.logfile != null) {
                this.logfile.add_corner(this.corner2);
            }
            this.select_all_in_region();
        }
        return this.return_state;
    }

    private void select_all_in_region() {
        boolean something_found;
        IntPoint p1 = this.corner1.round();
        IntPoint p2 = this.corner2.round();
        IntBox b = new IntBox(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
        int select_layer = this.hdlg.settings.select_on_all_visible_layers ? -1 : this.hdlg.settings.layer;
        Set<Item> found_items = this.hdlg.settings.item_selection_filter.filter(this.hdlg.get_routing_board().overlapping_items(b, select_layer));
        if (this.hdlg.settings.select_on_all_visible_layers) {
            TreeSet<Item> visible_items = new TreeSet<Item>();
            block0: for (Item curr_item : found_items) {
                for (int i = curr_item.first_layer(); i <= curr_item.last_layer(); ++i) {
                    if (!(this.hdlg.graphics_context.get_layer_visibility(i) > 0.0)) continue;
                    visible_items.add(curr_item);
                    continue block0;
                }
            }
            found_items = visible_items;
        }
        boolean bl = something_found = found_items.size() > 0;
        if (something_found) {
            if (this.return_state instanceof SelectedItemState) {
                ((SelectedItemState)this.return_state).get_item_list().addAll(found_items);
            } else {
                this.return_state = SelectedItemState.get_instance(found_items, this.return_state, this.hdlg, this.logfile);
            }
        }
    }
}

