/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.ConductionArea;
import board.DrillItem;
import board.Item;
import board.ItemSelectionFilter;
import board.Layer;
import board.LayerStructure;
import board.Pin;
import board.PolylineTrace;
import board.RoutingBoard;
import board.Trace;
import board.Via;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.Point;
import interactive.BoardHandling;
import interactive.DynamicRouteState;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import interactive.MenuState;
import interactive.Route;
import interactive.StitchRouteState;
import java.awt.Graphics;
import java.util.Set;
import java.util.TreeSet;
import rules.Net;

public class RouteState
extends InteractiveState {
    protected Route route = null;
    private Set<Item> routing_target_set = null;
    protected boolean observers_activated = false;

    public static RouteState get_instance(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        DrillItem drill_item;
        Point center;
        int[] route_net_no_arr;
        if (!(p_parent_state instanceof MenuState)) {
            System.out.println("RouteState.get_instance: unexpected parent state");
        }
        p_board_handling.display_layer_messsage();
        IntPoint location = p_location.round();
        Item picked_item = RouteState.start_ok(location, p_board_handling);
        if (picked_item == null) {
            return null;
        }
        int net_count = picked_item.net_count();
        if (net_count <= 0) {
            return null;
        }
        if (picked_item instanceof Pin && net_count > 1) {
            route_net_no_arr = RouteState.get_route_net_numbers_at_tie_pin((Pin)picked_item, p_board_handling.settings.layer);
        } else {
            route_net_no_arr = new int[net_count];
            for (int i = 0; i < net_count; ++i) {
                route_net_no_arr[i] = picked_item.get_net_no(i);
            }
        }
        if (route_net_no_arr.length <= 0) {
            return null;
        }
        RoutingBoard routing_board = p_board_handling.get_routing_board();
        int[] trace_half_widths = new int[routing_board.get_layer_count()];
        boolean[] layer_active_arr = new boolean[trace_half_widths.length];
        for (int i = 0; i < trace_half_widths.length; ++i) {
            trace_half_widths[i] = p_board_handling.get_trace_halfwidth(route_net_no_arr[0], i);
            layer_active_arr[i] = false;
            for (int j = 0; j < route_net_no_arr.length; ++j) {
                if (!p_board_handling.is_active_routing_layer(route_net_no_arr[j], i)) continue;
                layer_active_arr[i] = true;
            }
        }
        int trace_clearance_class = p_board_handling.get_trace_clearance_class(route_net_no_arr[0]);
        boolean start_ok = true;
        if (picked_item instanceof Trace) {
            Trace picked_trace = (Trace)picked_item;
            Point picked_corner = picked_trace.nearest_end_point(location);
            if (picked_corner instanceof IntPoint && p_location.distance(picked_corner.to_float()) < (double)(5 * picked_trace.get_half_width())) {
                location = (IntPoint)picked_corner;
            } else {
                if (picked_trace instanceof PolylineTrace) {
                    FloatPoint nearest_point = ((PolylineTrace)picked_trace).polyline().nearest_point_approx(p_location);
                    location = nearest_point.round();
                }
                if (!routing_board.connect_to_trace(location, picked_trace, picked_trace.get_half_width(), picked_trace.clearance_class_no())) {
                    start_ok = false;
                }
            }
            if (start_ok && !p_board_handling.settings.manual_rule_selection) {
                int[] new_trace_half_widths = new int[trace_half_widths.length];
                System.arraycopy(trace_half_widths, 0, new_trace_half_widths, 0, trace_half_widths.length);
                new_trace_half_widths[picked_trace.get_layer()] = picked_trace.get_half_width();
                trace_half_widths = new_trace_half_widths;
                trace_clearance_class = picked_trace.clearance_class_no();
            }
        } else if (picked_item instanceof DrillItem && (center = (drill_item = (DrillItem)picked_item).get_center()) instanceof IntPoint) {
            location = (IntPoint)center;
        }
        if (!start_ok) {
            return null;
        }
        Net curr_net = routing_board.rules.nets.get(route_net_no_arr[0]);
        if (curr_net == null) {
            return null;
        }
        boolean is_stitch_route = p_board_handling.settings.is_stitch_route || curr_net.get_class().is_shove_fixed() || !curr_net.get_class().get_pull_tight();
        routing_board.generate_snapshot();
        RouteState new_instance = is_stitch_route ? new StitchRouteState(p_parent_state, p_board_handling, p_logfile) : new DynamicRouteState(p_parent_state, p_board_handling, p_logfile);
        new_instance.routing_target_set = picked_item.get_unconnected_set(-1);
        new_instance.route = new Route(location, p_board_handling.settings.layer, trace_half_widths, layer_active_arr, route_net_no_arr, trace_clearance_class, p_board_handling.get_via_rule(route_net_no_arr[0]), p_board_handling.settings.push_enabled, p_board_handling.settings.trace_pull_tight_region_width, p_board_handling.settings.trace_pull_tight_accuracy, picked_item, new_instance.routing_target_set, routing_board, is_stitch_route, p_board_handling.settings.automatic_neckdown, p_board_handling.settings.via_snap_to_smd_center, p_board_handling.settings.hilight_routing_obstacle);
        boolean bl = new_instance.observers_activated = !routing_board.observers_active();
        if (new_instance.observers_activated) {
            routing_board.start_notify_observers();
        }
        if (new_instance != null) {
            if (new_instance.logfile != null) {
                new_instance.logfile.start_scope(LogfileScope.CREATING_TRACE, p_location);
                p_board_handling.hide_ratsnest();
            }
            new_instance.display_default_message();
        }
        return new_instance;
    }

    protected RouteState(InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
    }

    protected static Item start_ok(IntPoint p_location, BoardHandling p_hdlg) {
        RoutingBoard routing_board = p_hdlg.get_routing_board();
        Item picked_item = routing_board.pick_nearest_routing_item(p_location, p_hdlg.settings.layer, null);
        int layer_count = routing_board.get_layer_count();
        if (picked_item == null && p_hdlg.settings.select_on_all_visible_layers) {
            int i;
            picked_item = RouteState.pick_routing_item(p_location, 0, p_hdlg);
            if (picked_item == null) {
                picked_item = RouteState.pick_routing_item(p_location, layer_count - 1, p_hdlg);
            }
            if (picked_item == null) {
                for (i = 1; !(i >= layer_count - 1 || routing_board.layer_structure.arr[i].is_signal && (picked_item = RouteState.pick_routing_item(p_location, i, p_hdlg)) != null); ++i) {
                }
            }
            if (picked_item == null) {
                for (i = 1; i < layer_count - 1 && (routing_board.layer_structure.arr[i].is_signal || (picked_item = RouteState.pick_routing_item(p_location, i, p_hdlg)) == null); ++i) {
                }
            }
        }
        return picked_item;
    }

    private static Item pick_routing_item(IntPoint p_location, int p_layer_no, BoardHandling p_hdlg) {
        if (p_layer_no == p_hdlg.settings.layer || p_hdlg.graphics_context.get_layer_visibility(p_layer_no) <= 0.0) {
            return null;
        }
        Item picked_item = p_hdlg.get_routing_board().pick_nearest_routing_item(p_location, p_layer_no, null);
        if (picked_item != null) {
            p_hdlg.set_layer(picked_item.first_layer());
        }
        return picked_item;
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_point) {
        return this.add_corner(p_point);
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState curr_return_state = this;
        if (Character.isDigit(p_key_char)) {
            LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
            int d = Character.digit(p_key_char, 10);
            d = Math.min(d, layer_structure.signal_layer_count());
            d = Math.max(d - 1, 0);
            Layer new_layer = layer_structure.get_signal_layer(d);
            if ((d = layer_structure.get_no(new_layer)) >= 0) {
                this.change_layer_action(d);
            }
        } else if (p_key_char == '+') {
            LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
            int current_layer_no = this.hdlg.settings.layer;
            while (++current_layer_no < layer_structure.arr.length && !layer_structure.arr[current_layer_no].is_signal) {
            }
            if (current_layer_no < layer_structure.arr.length) {
                this.change_layer_action(current_layer_no);
            }
        } else if (p_key_char == '-') {
            LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
            int current_layer_no = this.hdlg.settings.layer;
            while (--current_layer_no >= 0 && !layer_structure.arr[current_layer_no].is_signal) {
            }
            if (current_layer_no >= 0) {
                this.change_layer_action(current_layer_no);
            }
        } else {
            curr_return_state = super.key_typed(p_key_char);
        }
        return curr_return_state;
    }

    public InteractiveState add_corner(FloatPoint p_location) {
        InteractiveState result;
        boolean route_completed = this.route.next_corner(p_location);
        String layer_string = this.hdlg.get_routing_board().layer_structure.arr[this.route.nearest_target_layer()].name;
        if (this.logfile != null) {
            this.logfile.add_corner(p_location);
        }
        if (route_completed && this.observers_activated) {
            this.hdlg.get_routing_board().end_notify_observers();
            this.observers_activated = false;
        }
        if (route_completed) {
            result = this.return_state;
            for (int curr_net_no : this.route.net_no_arr) {
                this.hdlg.update_ratsnest(curr_net_no);
            }
        } else {
            result = this;
        }
        this.hdlg.recalculate_length_violations();
        return result;
    }

    @Override
    public InteractiveState cancel() {
        Trace tail = this.hdlg.get_routing_board().get_trace_tail(this.route.get_last_corner(), this.hdlg.settings.layer, this.route.net_no_arr);
        if (tail != null) {
            Set<Item> remove_items = tail.get_connection_items(Item.StopConnectionOption.VIA);
            if (this.hdlg.settings.push_enabled) {
                this.hdlg.get_routing_board().remove_items_and_pull_tight(remove_items, this.hdlg.settings.trace_pull_tight_region_width, this.hdlg.settings.trace_pull_tight_accuracy, false);
            } else {
                this.hdlg.get_routing_board().remove_items(remove_items, false);
            }
        }
        if (this.observers_activated) {
            this.hdlg.get_routing_board().end_notify_observers();
            this.observers_activated = false;
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.CANCEL_SCOPE);
        }
        for (int curr_net_no : this.route.net_no_arr) {
            this.hdlg.update_ratsnest(curr_net_no);
        }
        return this.return_state;
    }

    @Override
    public boolean change_layer_action(int p_new_layer) {
        boolean result = true;
        if (p_new_layer >= 0 && p_new_layer < this.hdlg.get_routing_board().get_layer_count()) {
            boolean change_layer_succeeded;
            if (this.route != null && !this.route.is_layer_active(p_new_layer)) {
                String string = this.hdlg.get_routing_board().layer_structure.arr[p_new_layer].name;
            }
            if (change_layer_succeeded = this.route.change_layer(p_new_layer)) {
                boolean connected_to_plane = false;
                int old_layer = this.hdlg.settings.get_layer();
                ItemSelectionFilter selection_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.VIAS);
                Set<Item> picked_items = this.hdlg.get_routing_board().pick_items(this.route.get_last_corner(), old_layer, selection_filter);
                Via new_via = null;
                for (Item curr_via : picked_items) {
                    if (!curr_via.shares_net_no(this.route.net_no_arr)) continue;
                    new_via = (Via)curr_via;
                    break;
                }
                if (new_via != null) {
                    int to_layer;
                    int from_layer;
                    if (old_layer < p_new_layer) {
                        from_layer = old_layer + 1;
                        to_layer = p_new_layer;
                    } else {
                        from_layer = p_new_layer;
                        to_layer = old_layer - 1;
                    }
                    Set<Item> contacts = new_via.get_normal_contacts();
                    for (Item curr_item : contacts) {
                        ConductionArea curr_area;
                        if (!(curr_item instanceof ConductionArea) || (curr_area = (ConductionArea)curr_item).get_layer() < from_layer || curr_area.get_layer() > to_layer) continue;
                        connected_to_plane = true;
                        break;
                    }
                }
                if (connected_to_plane) {
                    this.hdlg.set_interactive_state(this.return_state);
                    for (int curr_net_no : this.route.net_no_arr) {
                        this.hdlg.update_ratsnest(curr_net_no);
                    }
                } else {
                    this.hdlg.set_layer(p_new_layer);
                    String layer_name = this.hdlg.get_routing_board().layer_structure.arr[p_new_layer].name;
                    this.hdlg.get_routing_board().generate_snapshot();
                }
                if (this.logfile != null) {
                    this.logfile.start_scope(LogfileScope.CHANGE_LAYER, p_new_layer);
                }
            } else {
                int shove_failing_layer = this.hdlg.get_routing_board().get_shove_failing_layer();
                if (shove_failing_layer >= 0) {
                    String string = this.hdlg.get_routing_board().layer_structure.arr[this.hdlg.get_routing_board().get_shove_failing_layer()].name;
                } else {
                    System.out.println("RouteState.change_layer_action: shove_failing_layer not set");
                }
                result = false;
            }
        }
        return result;
    }

    static int[] get_route_net_numbers_at_tie_pin(Pin p_pin, int p_layer) {
        TreeSet<Integer> net_number_list = new TreeSet<Integer>();
        for (int i = 0; i < p_pin.net_count(); ++i) {
            net_number_list.add(p_pin.get_net_no(i));
        }
        Set<Item> contacts = p_pin.get_normal_contacts();
        for (Item curr_contact : contacts) {
            if (curr_contact.first_layer() > p_layer || curr_contact.last_layer() < p_layer) continue;
            for (int i = 0; i < curr_contact.net_count(); ++i) {
                net_number_list.remove(curr_contact.get_net_no(i));
            }
        }
        int[] result = new int[net_number_list.size()];
        int curr_ind = 0;
        for (Integer curr_net_number : net_number_list) {
            result[curr_ind] = curr_net_number;
            ++curr_ind;
        }
        return result;
    }

    @Override
    public void draw(Graphics p_graphics) {
        if (this.route != null) {
            this.route.draw(p_graphics, this.hdlg.graphics_context);
        }
    }

    @Override
    public void display_default_message() {
        if (this.route != null) {
            Net net = this.hdlg.get_routing_board().rules.nets.get(this.route.net_no_arr[0]);
        }
    }
}

