/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.FixedState;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.Point;
import geometry.planar.PolygonShape;
import interactive.BoardHandling;
import interactive.CornerItemConstructionState;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import java.util.Iterator;
import rules.BoardRules;

public class PolygonShapeConstructionState
extends CornerItemConstructionState {
    public static PolygonShapeConstructionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        return new PolygonShapeConstructionState(p_location, p_parent_state, p_board_handling, p_logfile);
    }

    private PolygonShapeConstructionState(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.CREATING_POLYGONSHAPE);
        }
        this.add_corner(p_location);
    }

    @Override
    public InteractiveState complete() {
        boolean construction_succeeded;
        this.add_corner_for_snap_angle();
        int corner_count = this.corner_list.size();
        boolean bl = construction_succeeded = corner_count > 2;
        if (construction_succeeded) {
            Point[] corner_arr = new IntPoint[corner_count];
            Iterator it = this.corner_list.iterator();
            for (int i = 0; i < corner_count; ++i) {
                corner_arr[i] = (IntPoint)it.next();
            }
            PolygonShape obstacle_shape = new PolygonShape(corner_arr);
            int cl_class = BoardRules.clearance_class_none();
            construction_succeeded = obstacle_shape.split_to_convex() == null ? false : this.hdlg.get_routing_board().check_shape(obstacle_shape, this.hdlg.settings.layer, new int[0], cl_class);
            if (construction_succeeded) {
                boolean bl2 = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().start_notify_observers();
                }
                this.hdlg.get_routing_board().generate_snapshot();
                this.hdlg.get_routing_board().insert_obstacle(obstacle_shape, this.hdlg.settings.layer, cl_class, FixedState.UNFIXED);
                this.hdlg.get_routing_board().end_notify_observers();
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().end_notify_observers();
                    this.observers_activated = false;
                }
            }
        }
        if (construction_succeeded) {
            // empty if block
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.COMPLETE_SCOPE);
        }
        return this.return_state;
    }

    @Override
    public void display_default_message() {
    }
}

