/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.Item;
import board.ItemSelectionFilter;
import board.Pin;
import geometry.planar.FloatPoint;
import interactive.BoardHandling;
import interactive.InteractiveState;
import interactive.Logfile;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Set;

public class PinSwapState
extends InteractiveState {
    private final Pin from_pin;
    private Pin to_pin = null;
    private Set<Pin> swappable_pins;

    public static InteractiveState get_instance(Pin p_pin_to_swap, InteractiveState p_return_state, BoardHandling p_board_handling, Logfile p_logfile) {
        PinSwapState new_state = new PinSwapState(p_pin_to_swap, p_return_state, p_board_handling, p_logfile);
        if (new_state.swappable_pins.isEmpty()) {
            return p_return_state;
        }
        return new_state;
    }

    private PinSwapState(Pin p_pin_to_swap, InteractiveState p_return_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_return_state, p_board_handling, p_logfile);
        this.from_pin = p_pin_to_swap;
        this.swappable_pins = p_pin_to_swap.get_swappable_pins();
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        ItemSelectionFilter selection_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.PINS);
        Set<Item> picked_items = this.hdlg.pick_items(p_location, selection_filter);
        if (picked_items.isEmpty()) {
            return this.cancel();
        }
        Item to_item = (Item)picked_items.iterator().next();
        if (!(to_item instanceof Pin)) {
            return this.cancel();
        }
        this.to_pin = (Pin)to_item;
        if (!this.swappable_pins.contains(this.to_pin)) {
            return this.cancel();
        }
        return this.complete();
    }

    @Override
    public InteractiveState complete() {
        int i;
        if (this.from_pin == null || this.to_pin == null) {
            return this.cancel();
        }
        if (this.from_pin.net_count() > 1 || this.to_pin.net_count() > 1) {
            System.out.println("PinSwapState.complete: pin swap not yet implemented for pins belonging to more than 1 net ");
            return this.cancel();
        }
        int from_net_no = this.from_pin.net_count() > 0 ? this.from_pin.get_net_no(0) : -1;
        int to_net_no = this.to_pin.net_count() > 0 ? this.to_pin.get_net_no(0) : -1;
        if (!this.hdlg.get_routing_board().check_change_net(this.from_pin, to_net_no)) {
            return this.cancel();
        }
        if (!this.hdlg.get_routing_board().check_change_net(this.to_pin, from_net_no)) {
            return this.cancel();
        }
        this.hdlg.get_routing_board().generate_snapshot();
        this.from_pin.swap(this.to_pin);
        for (i = 0; i < this.from_pin.net_count(); ++i) {
            this.hdlg.update_ratsnest(this.from_pin.get_net_no(i));
        }
        for (i = 0; i < this.to_pin.net_count(); ++i) {
            this.hdlg.update_ratsnest(this.to_pin.get_net_no(i));
        }
        return this.return_state;
    }

    @Override
    public void draw(Graphics p_graphics) {
        Color highlight_color = this.hdlg.graphics_context.get_hilight_color();
        double highligt_color_intensity = this.hdlg.graphics_context.get_hilight_color_intensity();
        this.from_pin.draw(p_graphics, this.hdlg.graphics_context, highlight_color, 0.5 * highligt_color_intensity);
        for (Pin curr_pin : this.swappable_pins) {
            curr_pin.draw(p_graphics, this.hdlg.graphics_context, highlight_color, highligt_color_intensity);
        }
    }
}

