/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.Item;
import board.ItemSelectionFilter;
import board.LayerStructure;
import board.Pin;
import board.TestLevel;
import geometry.planar.FloatPoint;
import interactive.BoardHandling;
import interactive.DragMenuState;
import interactive.ExpandTestState;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import interactive.PinSwapState;
import interactive.RouteMenuState;
import interactive.RouteState;
import interactive.SelectMenuState;
import interactive.SelectedItemState;
import java.util.Set;

public class MenuState
extends InteractiveState {
    MenuState(BoardHandling p_board_handle, Logfile p_logfile) {
        super(null, p_board_handle, p_logfile);
        this.return_state = this;
    }

    public InteractiveState select_items(FloatPoint p_location) {
        InteractiveState result;
        boolean something_found;
        this.hdlg.display_layer_messsage();
        Set<Item> picked_items = this.hdlg.pick_items(p_location);
        boolean bl = something_found = picked_items.size() > 0;
        if (something_found) {
            result = SelectedItemState.get_instance(picked_items, this, this.hdlg, this.logfile);
            if (this.logfile != null) {
                this.logfile.start_scope(LogfileScope.START_SELECT, p_location);
            }
        } else {
            result = this;
        }
        return result;
    }

    public InteractiveState swap_pin(FloatPoint p_location) {
        ItemSelectionFilter selection_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.PINS);
        Set<Item> picked_items = this.hdlg.pick_items(p_location, selection_filter);
        InteractiveState result = this;
        if (picked_items.size() > 0) {
            Item first_item = (Item)picked_items.iterator().next();
            if (!(first_item instanceof Pin)) {
                System.out.println("MenuState.swap_pin: Pin expected");
                return this;
            }
            Pin selected_pin = (Pin)first_item;
            result = PinSwapState.get_instance(selected_pin, this, this.hdlg, this.logfile);
        }
        return result;
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState curr_return_state = this;
        if (p_key_char == 'b') {
            this.hdlg.redo();
        } else if (p_key_char == 'd') {
            curr_return_state = DragMenuState.get_instance(this.hdlg, this.logfile);
        } else if (p_key_char == 'e') {
            if (this.hdlg.get_routing_board().get_test_level() != TestLevel.RELEASE_VERSION) {
                curr_return_state = ExpandTestState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg);
            }
        } else if (p_key_char == 'g') {
            this.hdlg.toggle_ratsnest();
        } else if (p_key_char == 'i') {
            curr_return_state = this.select_items(this.hdlg.get_current_mouse_position());
        } else if (p_key_char == 'p') {
            this.hdlg.settings.set_push_enabled(!this.hdlg.settings.push_enabled);
        } else if (p_key_char == 'r') {
            curr_return_state = RouteMenuState.get_instance(this.hdlg, this.logfile);
        } else if (p_key_char == 's') {
            curr_return_state = SelectMenuState.get_instance(this.hdlg, this.logfile);
        } else if (p_key_char == 't') {
            curr_return_state = RouteState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg, this.logfile);
        } else if (p_key_char == 'u') {
            this.hdlg.undo();
        } else if (p_key_char == 'v') {
            this.hdlg.toggle_clearance_violations();
        } else if (p_key_char == 'w') {
            curr_return_state = this.swap_pin(this.hdlg.get_current_mouse_position());
        } else if (p_key_char == '+') {
            LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
            int current_layer_no = this.hdlg.settings.layer;
            while (++current_layer_no < layer_structure.arr.length && !layer_structure.arr[current_layer_no].is_signal) {
            }
            if (current_layer_no < layer_structure.arr.length) {
                this.hdlg.set_current_layer(current_layer_no);
            }
        } else if (p_key_char == '-') {
            LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
            int current_layer_no = this.hdlg.settings.layer;
            while (--current_layer_no >= 0 && !layer_structure.arr[current_layer_no].is_signal) {
            }
            if (current_layer_no >= 0) {
                this.hdlg.set_current_layer(current_layer_no);
            }
        } else {
            curr_return_state = super.key_typed(p_key_char);
        }
        return curr_return_state;
    }

    @Override
    public InteractiveState complete() {
        return this;
    }

    @Override
    public InteractiveState cancel() {
        return this;
    }

    @Override
    public void set_toolbar() {
    }
}

