/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.AngleRestriction;
import board.RoutingBoard;
import geometry.planar.FloatPoint;
import geometry.planar.Point;
import interactive.BoardHandling;
import interactive.DragState;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import interactive.Route;
import java.awt.Graphics;
import rules.ViaRule;

public class MakeSpaceState
extends DragState {
    private Route route;

    public MakeSpaceState(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_location, p_parent_state, p_board_handling, p_logfile);
        int[] shove_trace_width_arr = new int[this.hdlg.get_routing_board().get_layer_count()];
        boolean[] layer_active_arr = new boolean[shove_trace_width_arr.length];
        int shove_trace_width = Math.min(100, this.hdlg.get_routing_board().get_min_trace_half_width() / 10);
        shove_trace_width = Math.max(shove_trace_width, 5);
        for (int i = 0; i < shove_trace_width_arr.length; ++i) {
            shove_trace_width_arr[i] = shove_trace_width;
            layer_active_arr[i] = true;
        }
        int[] route_net_no_arr = new int[]{10000001};
        this.route = new Route(p_location.round(), this.hdlg.settings.layer, shove_trace_width_arr, layer_active_arr, route_net_no_arr, 0, ViaRule.EMPTY, true, this.hdlg.settings.trace_pull_tight_region_width, this.hdlg.settings.trace_pull_tight_accuracy, null, null, this.hdlg.get_routing_board(), false, false, false, this.hdlg.settings.hilight_routing_obstacle);
    }

    @Override
    public InteractiveState move_to(FloatPoint p_to_location) {
        if (!this.something_dragged) {
            boolean bl = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
            if (this.observers_activated) {
                this.hdlg.get_routing_board().start_notify_observers();
            }
            this.hdlg.get_routing_board().generate_snapshot();
            if (this.logfile != null) {
                this.logfile.start_scope(LogfileScope.MAKING_SPACE, this.previous_location);
            }
            this.something_dragged = true;
        }
        this.route.next_corner(p_to_location);
        Point route_end = this.route.get_last_corner();
        if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NONE && !route_end.equals(p_to_location.round())) {
            this.hdlg.move_mouse(route_end.to_float());
        }
        this.hdlg.recalculate_length_violations();
        return this;
    }

    @Override
    public InteractiveState button_released() {
        int delete_net_no = 10000001;
        RoutingBoard board = this.hdlg.get_routing_board();
        board.remove_items(board.get_connectable_items(delete_net_no), false);
        if (this.observers_activated) {
            this.hdlg.get_routing_board().end_notify_observers();
            this.observers_activated = false;
        }
        if (this.logfile != null && this.something_dragged) {
            this.logfile.start_scope(LogfileScope.COMPLETE_SCOPE);
        }
        this.hdlg.show_ratsnest();
        return this.return_state;
    }

    @Override
    public void draw(Graphics p_graphics) {
        if (this.route != null) {
            this.route.draw(p_graphics, this.hdlg.graphics_context);
        }
    }
}

