/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import geometry.planar.FloatPoint;
import interactive.LogfileScanner;
import interactive.LogfileScope;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class Logfile {
    private LogfileScanner scanner = null;
    private FileWriter file_writer = null;
    private boolean write_enabled = false;
    private Object pending_token = null;

    public boolean start_read(InputStream p_input_stream) {
        this.scanner = new LogfileScanner(p_input_stream);
        return this.scanner != null;
    }

    public FloatPoint read_corner() {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < 2; ++i) {
            Object curr_ob = this.next_token();
            if (!(curr_ob instanceof Double)) {
                this.pending_token = curr_ob;
                return null;
            }
            double f = (Double)curr_ob;
            if (i == 0) {
                x = f;
                continue;
            }
            y = f;
        }
        return new FloatPoint(x, y);
    }

    public void close_output() {
        if (this.file_writer != null) {
            try {
                this.file_writer.close();
            }
            catch (IOException e) {
                System.out.println("unable to close logfile");
            }
        }
        this.write_enabled = false;
    }

    public boolean start_write(File p_file) {
        try {
            this.file_writer = new FileWriter(p_file);
        }
        catch (IOException e) {
            System.out.println("unable to create logfile");
            return false;
        }
        this.write_enabled = true;
        return true;
    }

    public void start_scope(LogfileScope p_logfile_scope) {
        if (this.write_enabled) {
            try {
                this.file_writer.write(p_logfile_scope.name);
                this.file_writer.write("\n");
            }
            catch (IOException e2) {
                System.out.println("Logfile.start_scope: write failed");
            }
        }
    }

    public void start_scope(LogfileScope p_logfile_scope, int p_int_value) {
        this.start_scope(p_logfile_scope);
        this.add_int(p_int_value);
    }

    public void start_scope(LogfileScope p_logfile_scope, boolean p_boolean_value) {
        this.start_scope(p_logfile_scope);
        int int_value = p_boolean_value ? 1 : 0;
        this.add_int(int_value);
    }

    public void start_scope(LogfileScope p_logfile_scope, FloatPoint p_start_corner) {
        this.start_scope(p_logfile_scope);
        this.add_corner(p_start_corner);
    }

    public LogfileScope start_read_scope() {
        Object curr_ob = this.next_token();
        if (curr_ob == null) {
            return null;
        }
        if (!(curr_ob instanceof String)) {
            System.out.println("Logfile.start_read_scope: String expected");
            this.pending_token = curr_ob;
            return null;
        }
        LogfileScope result = LogfileScope.get_scope((String)curr_ob);
        return result;
    }

    public void add_int(int p_int) {
        if (this.write_enabled) {
            try {
                this.file_writer.write(new Integer(p_int).toString());
                this.file_writer.write("\n");
            }
            catch (IOException e2) {
                System.out.println("unable to write integer to logfile");
            }
        }
    }

    public int read_int() {
        Object curr_ob = this.next_token();
        if (!(curr_ob instanceof Integer)) {
            System.out.println("Logfile.read_int: Integer expected");
            this.pending_token = curr_ob;
            return -1;
        }
        return (Integer)curr_ob;
    }

    public void add_corner(FloatPoint p_corner) {
        if (this.write_enabled) {
            if (p_corner == null) {
                System.out.println("logfile.add_corner: p_corner is null");
                return;
            }
            try {
                this.file_writer.write(new Double(p_corner.x).toString());
                this.file_writer.write(" ");
                this.file_writer.write(new Double(p_corner.y).toString());
                this.file_writer.write("\n");
            }
            catch (IOException e2) {
                System.out.println("unable to write to logfile while adding corner");
            }
        }
    }

    private Object next_token() {
        if (this.pending_token != null) {
            Object result = this.pending_token;
            this.pending_token = null;
            return result;
        }
        try {
            Object result = this.scanner.next_token();
            return result;
        }
        catch (IOException e) {
            System.out.println("Logfile.next_token: IO error scanning file");
            return null;
        }
    }
}

