/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import geometry.planar.FloatPoint;
import interactive.BoardHandling;
import interactive.Logfile;
import interactive.LogfileScope;
import java.awt.Graphics;
import java.util.ResourceBundle;

public class InteractiveState {
    protected final BoardHandling hdlg;
    protected InteractiveState return_state;
    protected final Logfile logfile;
    protected final ResourceBundle resources;

    protected InteractiveState(InteractiveState p_return_state, BoardHandling p_board_handling, Logfile p_logfile) {
        this.return_state = p_return_state;
        this.hdlg = p_board_handling;
        this.logfile = p_logfile;
        this.resources = ResourceBundle.getBundle("interactive.resources.InteractiveState", p_board_handling.get_locale());
    }

    public void draw(Graphics p_graphics) {
    }

    public InteractiveState left_button_clicked(FloatPoint p_location) {
        return this;
    }

    public InteractiveState button_released() {
        return this;
    }

    public InteractiveState mouse_moved() {
        FloatPoint mouse_position = this.hdlg.coordinate_transform.board_to_user(this.hdlg.get_current_mouse_position());
        return this;
    }

    public InteractiveState mouse_dragged(FloatPoint p_point) {
        return this;
    }

    public InteractiveState mouse_pressed(FloatPoint p_point) {
        return this;
    }

    public InteractiveState mouse_wheel_moved(int p_rotation) {
        return null;
    }

    public InteractiveState key_typed(char p_key_char) {
        return null;
    }

    public InteractiveState complete() {
        if (this.return_state != this && this.logfile != null) {
            this.logfile.start_scope(LogfileScope.COMPLETE_SCOPE);
        }
        return this.return_state;
    }

    public InteractiveState cancel() {
        if (this.return_state != this && this.logfile != null) {
            this.logfile.start_scope(LogfileScope.CANCEL_SCOPE);
        }
        return this.return_state;
    }

    public boolean change_layer_action(int p_new_layer) {
        this.hdlg.set_layer(p_new_layer);
        return true;
    }

    public InteractiveState process_logfile_point(FloatPoint p_point) {
        return this;
    }

    public void display_default_message() {
    }

    public String get_help_id() {
        return "MenuState";
    }

    public void set_toolbar() {
    }
}

