/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import datastructures.Stoppable;
import interactive.BatchAutorouterThread;
import interactive.BoardHandling;
import interactive.InteractiveState;
import interactive.LogfileScope;
import interactive.SelectedItemState;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;

public abstract class InteractiveActionThread
extends Thread
implements Stoppable {
    private volatile boolean isStopped = false;
    private volatile boolean stop_requested = false;
    public final BoardHandling hdlg;

    public static InteractiveActionThread get_autoroute_instance(BoardHandling p_board_handling) {
        return new AutorouteThread(p_board_handling);
    }

    public static InteractiveActionThread get_batch_autorouter_instance(BoardHandling p_board_handling) {
        return new BatchAutorouterThread(p_board_handling);
    }

    public static InteractiveActionThread get_fanout_instance(BoardHandling p_board_handling) {
        return new FanoutThread(p_board_handling);
    }

    public static InteractiveActionThread get_pull_tight_instance(BoardHandling p_board_handling) {
        return new PullTightThread(p_board_handling);
    }

    public static InteractiveActionThread get_read_logfile_instance(BoardHandling p_board_handling, InputStream p_input_stream) {
        return new ReadLogfileThread(p_board_handling, p_input_stream);
    }

    protected InteractiveActionThread(BoardHandling p_board_handling) {
        this.hdlg = p_board_handling;
    }

    protected abstract void thread_action();

    @Override
    public void run() {
        try {
            this.thread_action();
        }
        finally {
            this.notifyStopped();
        }
    }

    @Override
    public void request_stop() {
        this.stop_requested = true;
    }

    @Override
    public boolean is_stop_requested() {
        return this.stop_requested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitStopped(int millisecond) throws InterruptedException {
        InteractiveActionThread interactiveActionThread = this;
        synchronized (interactiveActionThread) {
            if (this.isStopped) {
                return;
            }
            this.wait(millisecond);
            if (!this.isStopped) {
                throw new InterruptedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStopped() {
        InteractiveActionThread interactiveActionThread = this;
        synchronized (interactiveActionThread) {
            if (this.isStopped) {
                return;
            }
            this.isStopped = true;
            this.notifyAll();
        }
    }

    public synchronized void draw(Graphics p_graphics) {
    }

    private static class ReadLogfileThread
    extends InteractiveActionThread {
        private final InputStream input_stream;

        private ReadLogfileThread(BoardHandling p_board_handling, InputStream p_input_stream) {
            super(p_board_handling);
            this.input_stream = p_input_stream;
        }

        @Override
        protected void thread_action() {
            ResourceBundle resources = ResourceBundle.getBundle("interactive.resources.InteractiveState", this.hdlg.get_locale());
            boolean saved_board_read_only = this.hdlg.is_board_read_only();
            this.hdlg.set_board_read_only(true);
            String start_message = resources.getString("logfile") + " " + resources.getString("stop_message");
            boolean done = false;
            InteractiveState previous_state = this.hdlg.interactive_state;
            if (!this.hdlg.logfile.start_read(this.input_stream)) {
                done = true;
            }
            boolean interrupted = false;
            int debug_counter = 0;
            this.hdlg.paint_immediately = true;
            while (!done) {
                if (this.is_stop_requested()) {
                    interrupted = true;
                    done = true;
                }
                ++debug_counter;
                LogfileScope logfile_scope = this.hdlg.logfile.start_read_scope();
                if (logfile_scope == null) {
                    done = true;
                }
                if (done) continue;
                try {
                    InteractiveState new_state = logfile_scope.read_scope(this.hdlg.logfile, this.hdlg.interactive_state, this.hdlg);
                    if (new_state == null) {
                        System.out.println("BoardHandling:read_logfile: inconsistent logfile scope");
                        new_state = previous_state;
                    }
                    this.hdlg.set_interactive_state(new_state);
                }
                catch (Exception e) {
                    done = true;
                }
            }
            this.hdlg.paint_immediately = false;
            try {
                this.input_stream.close();
            }
            catch (IOException e) {
                System.out.println("ReadLogfileThread: unable to close input stream");
            }
            String curr_message = interrupted ? resources.getString("interrupted") : resources.getString("completed");
            String end_message = resources.getString("logfile") + " " + curr_message;
            this.hdlg.set_board_read_only(saved_board_read_only);
        }
    }

    private static class PullTightThread
    extends InteractiveActionThread {
        private PullTightThread(BoardHandling p_board_handling) {
            super(p_board_handling);
        }

        @Override
        protected void thread_action() {
            if (!(this.hdlg.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.hdlg.interactive_state).pull_tight(this);
            this.hdlg.set_interactive_state(return_state);
        }
    }

    private static class FanoutThread
    extends InteractiveActionThread {
        private FanoutThread(BoardHandling p_board_handling) {
            super(p_board_handling);
        }

        @Override
        protected void thread_action() {
            if (!(this.hdlg.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.hdlg.interactive_state).fanout(this);
            this.hdlg.set_interactive_state(return_state);
        }
    }

    private static class AutorouteThread
    extends InteractiveActionThread {
        private AutorouteThread(BoardHandling p_board_handling) {
            super(p_board_handling);
        }

        @Override
        protected void thread_action() {
            if (!(this.hdlg.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.hdlg.interactive_state).autoroute(this);
            this.hdlg.set_interactive_state(return_state);
        }
    }
}

