/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.FixedState;
import board.Item;
import board.ItemSelectionFilter;
import board.ObstacleArea;
import geometry.planar.Area;
import geometry.planar.Circle;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.Point;
import geometry.planar.PolygonShape;
import geometry.planar.PolylineArea;
import geometry.planar.PolylineShape;
import geometry.planar.Shape;
import interactive.BoardHandling;
import interactive.CornerItemConstructionState;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import java.util.Iterator;
import java.util.Set;

public class HoleConstructionState
extends CornerItemConstructionState {
    private ObstacleArea item_to_modify = null;

    public static HoleConstructionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        HoleConstructionState new_instance = new HoleConstructionState(p_parent_state, p_board_handling, p_logfile);
        if (!new_instance.start_ok(p_location)) {
            new_instance = null;
        }
        return new_instance;
    }

    private HoleConstructionState(InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
    }

    private boolean start_ok(FloatPoint p_location) {
        IntPoint pick_location = p_location.round();
        ItemSelectionFilter.SelectableChoices[] selectable_choices = new ItemSelectionFilter.SelectableChoices[]{ItemSelectionFilter.SelectableChoices.KEEPOUT, ItemSelectionFilter.SelectableChoices.VIA_KEEPOUT, ItemSelectionFilter.SelectableChoices.CONDUCTION};
        ItemSelectionFilter selection_filter = new ItemSelectionFilter(selectable_choices);
        Set<Item> found_items = this.hdlg.get_routing_board().pick_items(pick_location, this.hdlg.settings.layer, selection_filter);
        if (found_items.size() != 1) {
            return false;
        }
        Item found_item = (Item)found_items.iterator().next();
        if (!(found_item instanceof ObstacleArea)) {
            return false;
        }
        this.item_to_modify = (ObstacleArea)found_item;
        if (this.item_to_modify.get_area() instanceof Circle) {
            return false;
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.ADDING_HOLE);
        }
        this.add_corner(p_location);
        return true;
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_next_corner) {
        if (this.item_to_modify == null) {
            return this.return_state;
        }
        if (this.item_to_modify.get_area().contains(p_next_corner)) {
            super.add_corner(p_next_corner);
        }
        return this;
    }

    @Override
    public InteractiveState complete() {
        int i;
        if (this.item_to_modify == null) {
            return this.return_state;
        }
        this.add_corner_for_snap_angle();
        int corner_count = this.corner_list.size();
        boolean construction_succeeded = corner_count > 2;
        PolylineShape[] new_holes = null;
        PolylineShape new_border = null;
        if (construction_succeeded) {
            Area obs_area = this.item_to_modify.get_area();
            Shape[] old_holes = obs_area.get_holes();
            new_border = (PolylineShape)obs_area.get_border();
            if (new_border == null) {
                construction_succeeded = false;
            } else {
                new_holes = new PolylineShape[old_holes.length + 1];
                for (i = 0; i < old_holes.length; ++i) {
                    new_holes[i] = (PolylineShape)old_holes[i];
                    if (new_holes[i] != null) continue;
                    construction_succeeded = false;
                    break;
                }
            }
        }
        if (construction_succeeded) {
            Point[] new_hole_corners = new IntPoint[corner_count];
            Iterator it = this.corner_list.iterator();
            for (i = 0; i < corner_count; ++i) {
                new_hole_corners[i] = (IntPoint)it.next();
            }
            new_holes[new_holes.length - 1] = new PolygonShape(new_hole_corners);
            PolylineArea new_obs_area = new PolylineArea(new_border, new_holes);
            if (new_obs_area.split_to_convex() == null) {
                construction_succeeded = false;
            } else {
                boolean bl = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().start_notify_observers();
                }
                this.hdlg.get_routing_board().generate_snapshot();
                this.hdlg.get_routing_board().remove_item(this.item_to_modify);
                this.hdlg.get_routing_board().insert_obstacle(new_obs_area, this.item_to_modify.get_layer(), this.item_to_modify.clearance_class_no(), FixedState.UNFIXED);
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().end_notify_observers();
                    this.observers_activated = false;
                }
            }
        }
        if (construction_succeeded) {
            // empty if block
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.COMPLETE_SCOPE);
        }
        return this.return_state;
    }

    @Override
    public void display_default_message() {
    }
}

