/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import geometry.planar.FloatPoint;
import interactive.BoardHandling;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import interactive.RouteState;

public class DynamicRouteState
extends RouteState {
    protected DynamicRouteState(InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
    }

    @Override
    public InteractiveState mouse_moved() {
        super.mouse_moved();
        return this.add_corner(this.hdlg.get_current_mouse_position());
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        if (this.observers_activated) {
            this.hdlg.get_routing_board().end_notify_observers();
            this.observers_activated = false;
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.COMPLETE_SCOPE);
        }
        for (int curr_net_no : this.route.net_no_arr) {
            this.hdlg.update_ratsnest(curr_net_no);
        }
        return this.return_state;
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState curr_return_state = this;
        if (p_key_char == 's') {
            this.hdlg.generate_snapshot();
        } else {
            curr_return_state = super.key_typed(p_key_char);
        }
        return curr_return_state;
    }

    @Override
    public String get_help_id() {
        return "RouteState_DynamicRouteState";
    }
}

