/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.AngleRestriction;
import board.Item;
import board.MoveComponent;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.Point;
import geometry.planar.Vector;
import interactive.BoardHandling;
import interactive.DragState;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import java.util.Collection;
import java.util.TreeSet;

public class DragItemState
extends DragState {
    private Item item_to_move = null;

    protected DragItemState(Item p_item_to_move, FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_location, p_parent_state, p_board_handling, p_logfile);
        this.item_to_move = p_item_to_move;
    }

    @Override
    public void display_default_message() {
    }

    @Override
    public InteractiveState move_to(FloatPoint p_to_location) {
        IntPoint to_location = p_to_location.round();
        IntPoint from_location = this.previous_location.round();
        if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE) {
            to_location = to_location.orthogonal_projection(from_location);
        } else if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE) {
            to_location = to_location.fortyfive_degree_projection(from_location);
        }
        if (to_location.equals(from_location)) {
            return this;
        }
        if (this.item_to_move.is_user_fixed()) {
            return this;
        }
        MoveComponent move_component = null;
        Vector rel_coor = to_location.difference_by((Point)from_location);
        double length = rel_coor.length_approx();
        boolean shove_ok = false;
        for (int i = 0; i < 2; ++i) {
            double sample_width;
            move_component = new MoveComponent(this.item_to_move, rel_coor, 99, 5);
            if (move_component.check()) {
                shove_ok = true;
                break;
            }
            if (i != 0 || !(length > (sample_width = (double)(2 * this.hdlg.get_routing_board().get_min_trace_half_width())))) continue;
            rel_coor = rel_coor.change_length_approx(sample_width);
        }
        if (shove_ok) {
            if (!this.something_dragged) {
                boolean bl = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().start_notify_observers();
                }
                this.hdlg.get_routing_board().generate_snapshot();
                if (this.logfile != null) {
                    this.logfile.start_scope(LogfileScope.DRAGGING_ITEMS, this.previous_location);
                }
                this.something_dragged = true;
            }
            if (!move_component.insert(this.hdlg.settings.trace_pull_tight_region_width, this.hdlg.settings.trace_pull_tight_accuracy)) {
                return this.return_state;
            }
        }
        this.previous_location = p_to_location;
        return this;
    }

    @Override
    public InteractiveState button_released() {
        if (this.observers_activated) {
            this.hdlg.get_routing_board().end_notify_observers();
            this.observers_activated = false;
        }
        if (this.logfile != null && this.something_dragged) {
            this.logfile.start_scope(LogfileScope.COMPLETE_SCOPE);
        }
        if (this.something_dragged) {
            if (this.item_to_move.get_component_no() == 0) {
                for (int i = 0; i < this.item_to_move.net_count(); ++i) {
                    this.hdlg.update_ratsnest(this.item_to_move.get_net_no(i));
                }
            } else {
                Collection<Item> moved_items = this.hdlg.get_routing_board().get_component_items(this.item_to_move.get_component_no());
                TreeSet<Integer> changed_nets = new TreeSet<Integer>();
                for (Item curr_moved_item : moved_items) {
                    for (int i = 0; i < curr_moved_item.net_count(); ++i) {
                        changed_nets.add(new Integer(curr_moved_item.get_net_no(i)));
                    }
                }
                for (Integer curr_net_no : changed_nets) {
                    this.hdlg.update_ratsnest(curr_net_no);
                }
            }
        } else {
            this.hdlg.show_ratsnest();
        }
        return this.return_state;
    }
}

