/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.Item;
import board.PolylineTrace;
import board.ShapeTraceEntries;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntPoint;
import interactive.BoardHandling;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import interactive.SelectRegionState;
import java.awt.Graphics;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;

public class CutoutRouteState
extends SelectRegionState {
    private final Collection<PolylineTrace> trace_list;

    public static CutoutRouteState get_instance(Collection<Item> p_item_list, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        return CutoutRouteState.get_instance(p_item_list, null, p_parent_state, p_board_handling, p_logfile);
    }

    public static CutoutRouteState get_instance(Collection<Item> p_item_list, FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        p_board_handling.display_layer_messsage();
        LinkedList<PolylineTrace> item_list = new LinkedList<PolylineTrace>();
        for (Item curr_item : p_item_list) {
            if (curr_item.is_user_fixed() || !(curr_item instanceof PolylineTrace)) continue;
            item_list.add((PolylineTrace)curr_item);
        }
        CutoutRouteState new_instance = new CutoutRouteState(item_list, p_parent_state, p_board_handling, p_logfile);
        new_instance.corner1 = p_location;
        if (p_location != null && new_instance.logfile != null) {
            new_instance.logfile.add_corner(p_location);
        }
        return new_instance;
    }

    private CutoutRouteState(Collection<PolylineTrace> p_item_list, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.CUTOUT_ROUTE);
        }
        this.trace_list = p_item_list;
    }

    @Override
    public InteractiveState complete() {
        this.corner2 = this.hdlg.get_current_mouse_position();
        if (this.logfile != null) {
            this.logfile.add_corner(this.corner2);
        }
        this.cutout_route();
        return this.return_state;
    }

    private void cutout_route() {
        if (this.corner1 == null || this.corner2 == null) {
            return;
        }
        this.hdlg.get_routing_board().generate_snapshot();
        IntPoint p1 = this.corner1.round();
        IntPoint p2 = this.corner2.round();
        IntBox cut_box = new IntBox(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        for (PolylineTrace curr_trace : this.trace_list) {
            ShapeTraceEntries.cutout_trace(curr_trace, cut_box, 0);
            for (int i = 0; i < curr_trace.net_count(); ++i) {
                changed_nets.add(curr_trace.get_net_no(i));
            }
        }
        for (Integer changed_net : changed_nets) {
            this.hdlg.update_ratsnest(changed_net);
        }
    }

    @Override
    public void draw(Graphics p_graphics) {
        if (this.trace_list == null) {
            return;
        }
        for (PolylineTrace curr_trace : this.trace_list) {
            curr_trace.draw(p_graphics, this.hdlg.graphics_context, this.hdlg.graphics_context.get_hilight_color(), this.hdlg.graphics_context.get_hilight_color_intensity());
        }
        super.draw(p_graphics);
    }
}

