/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.ClearanceViolation;
import board.Item;
import boardgraphics.GraphicsContext;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.LinkedList;

public class ClearanceViolations {
    public final Collection<ClearanceViolation> list = new LinkedList<ClearanceViolation>();

    public ClearanceViolations(Collection<Item> p_item_list) {
        for (Item curr_item : p_item_list) {
            this.list.addAll(curr_item.clearance_violations());
        }
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context) {
        Color draw_color = p_graphics_context.get_violations_color();
        for (ClearanceViolation curr_violation : this.list) {
            double intensity = p_graphics_context.get_layer_visibility(curr_violation.layer);
            p_graphics_context.fill_area(curr_violation.shape, p_graphics, draw_color, intensity);
            double draw_radius = curr_violation.first_item.board.rules.get_min_trace_half_width() * 5;
            p_graphics_context.draw_circle(curr_violation.shape.centre_of_gravity(), draw_radius, 0.1 * draw_radius, draw_color, p_graphics, intensity);
        }
    }
}

