/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.AngleRestriction;
import board.FixedState;
import board.RoutingBoard;
import geometry.planar.Circle;
import geometry.planar.ConvexShape;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import interactive.BoardHandling;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import java.awt.Color;
import java.awt.Graphics;
import rules.BoardRules;

public class CircleConstructionState
extends InteractiveState {
    private final FloatPoint circle_center;
    private double circle_radius = 0.0;
    private boolean observers_activated = false;

    public static CircleConstructionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        p_board_handling.remove_ratsnest();
        return new CircleConstructionState(p_location, p_parent_state, p_board_handling, p_logfile);
    }

    private CircleConstructionState(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
        this.circle_center = p_location;
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.CREATING_CIRCLE, p_location);
        }
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        if (this.logfile != null) {
            this.logfile.add_corner(p_location);
        }
        return this.complete();
    }

    @Override
    public InteractiveState mouse_moved() {
        super.mouse_moved();
        return this;
    }

    @Override
    public InteractiveState complete() {
        IntPoint center = this.circle_center.round();
        int radius = (int)Math.round(this.circle_radius);
        int layer = this.hdlg.settings.layer;
        RoutingBoard board = this.hdlg.get_routing_board();
        int cl_class = BoardRules.clearance_class_none();
        boolean construction_succeeded = this.circle_radius > 0.0;
        ConvexShape obstacle_shape = null;
        if (construction_succeeded) {
            obstacle_shape = new Circle(center, radius);
            if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE) {
                obstacle_shape = obstacle_shape.bounding_box();
            } else if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE) {
                obstacle_shape = obstacle_shape.bounding_octagon();
            }
            construction_succeeded = board.check_shape(obstacle_shape, layer, new int[0], cl_class);
        }
        if (construction_succeeded) {
            boolean bl = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
            if (this.observers_activated) {
                this.hdlg.get_routing_board().start_notify_observers();
            }
            board.generate_snapshot();
            board.insert_obstacle(obstacle_shape, layer, cl_class, FixedState.UNFIXED);
            if (this.observers_activated) {
                this.hdlg.get_routing_board().end_notify_observers();
                this.observers_activated = false;
            }
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.COMPLETE_SCOPE);
        }
        return this.return_state;
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_point) {
        this.circle_radius = this.circle_center.distance(p_point);
        return this;
    }

    @Override
    public void draw(Graphics p_graphics) {
        FloatPoint current_mouse_position = this.hdlg.get_current_mouse_position();
        if (current_mouse_position == null) {
            return;
        }
        this.circle_radius = this.circle_center.distance(current_mouse_position);
        this.hdlg.graphics_context.draw_circle(this.circle_center, this.circle_radius, 300.0, Color.white, p_graphics, 1.0);
    }

    @Override
    public void display_default_message() {
    }
}

