/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.AngleRestriction;
import board.BoardObservers;
import board.Communication;
import board.CoordinateTransform;
import board.FixedState;
import board.Item;
import board.ItemSelectionFilter;
import board.Layer;
import board.LayerStructure;
import board.Pin;
import board.PolylineTrace;
import board.RoutingBoard;
import board.TestLevel;
import board.Unit;
import boardgraphics.GraphicsContext;
import datastructures.IdNoGenerator;
import designformats.specctra.DsnFile;
import designformats.specctra.SessionFile;
import designformats.specctra.SessionToEagle;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntPoint;
import geometry.planar.PolylineShape;
import interactive.CircleConstructionState;
import interactive.ClearanceViolations;
import interactive.CopyItemState;
import interactive.DragMenuState;
import interactive.HoleConstructionState;
import interactive.InteractiveActionThread;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import interactive.MenuState;
import interactive.MoveItemState;
import interactive.PolygonShapeConstructionState;
import interactive.RatsNest;
import interactive.RouteMenuState;
import interactive.RouteState;
import interactive.RouterCache;
import interactive.SelectItemsInRegionState;
import interactive.SelectMenuState;
import interactive.SelectedItemState;
import interactive.Settings;
import interactive.TileConstructionState;
import interactive.ZoomRegionState;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import rules.BoardRules;
import rules.DefaultItemClearanceClasses;
import rules.Net;
import rules.NetClass;
import rules.ViaRule;

public class BoardHandling {
    public GraphicsContext graphics_context = null;
    public CoordinateTransform coordinate_transform = null;
    public Settings settings = null;
    InteractiveState interactive_state = null;
    private InteractiveActionThread interactive_action_thread = null;
    private RatsNest ratsnest = null;
    private ClearanceViolations clearance_violations = null;
    private RoutingBoard board = null;
    public final Logfile logfile;
    private boolean board_is_read_only = false;
    private FloatPoint current_mouse_position = null;
    boolean paint_immediately = false;
    private final ResourceBundle resources;
    private final Locale locale;
    private final AtomicBoolean updateFlag = new AtomicBoolean(false);
    private volatile ByteArrayOutputStream cache;
    private volatile int inCompletesNum;
    private final AtomicInteger optTimes;
    public volatile boolean isFinished = false;
    public volatile Exception exception;

    public BoardHandling(Locale p_locale, int maxOptTimes) {
        this.locale = p_locale;
        this.optTimes = new AtomicInteger(maxOptTimes);
        this.logfile = new Logfile();
        this.set_interactive_state(SelectMenuState.get_instance(this, this.logfile));
        this.resources = ResourceBundle.getBundle("interactive.resources.BoardHandling", p_locale);
    }

    public void set_board_read_only(boolean p_value) {
        this.board_is_read_only = p_value;
        this.settings.set_read_only(p_value);
    }

    public boolean is_board_read_only() {
        return this.board_is_read_only;
    }

    public Locale get_locale() {
        return this.locale;
    }

    public int get_layer_count() {
        if (this.board == null) {
            return 0;
        }
        return this.board.get_layer_count();
    }

    public RoutingBoard get_routing_board() {
        return this.board;
    }

    public FloatPoint get_current_mouse_position() {
        return this.current_mouse_position;
    }

    void set_current_mouse_position(FloatPoint p_point) {
        this.current_mouse_position = p_point;
    }

    public void set_ignore_conduction(boolean p_value) {
        if (this.board_is_read_only) {
            return;
        }
        this.board.change_conduction_is_obstacle(!p_value);
        this.logfile.start_scope(LogfileScope.SET_IGNORE_CONDUCTION, p_value);
    }

    public void set_pin_edge_to_turn_dist(double p_value) {
        if (this.board_is_read_only) {
            return;
        }
        double edge_to_turn_dist = this.coordinate_transform.user_to_board(p_value);
        if (edge_to_turn_dist != this.board.rules.get_pin_edge_to_turn_dist()) {
            Collection<Pin> pin_list = this.board.get_pins();
            for (Pin curr_pin : pin_list) {
                if (!curr_pin.has_trace_exit_restrictions()) continue;
                Set<Item> contact_list = curr_pin.get_normal_contacts();
                for (Item curr_contact : contact_list) {
                    if (!(curr_contact instanceof PolylineTrace) || curr_contact.get_fixed_state() != FixedState.SHOVE_FIXED || ((PolylineTrace)curr_contact).corner_count() != 2) continue;
                    curr_contact.set_fixed_state(FixedState.UNFIXED);
                }
            }
        }
        this.board.rules.set_pin_edge_to_turn_dist(edge_to_turn_dist);
    }

    public void set_layer_visibility(int p_layer, double p_value) {
        if (p_layer >= 0 && p_layer < this.graphics_context.layer_count()) {
            this.graphics_context.set_layer_visibility(p_layer, p_value);
            if (p_value == 0.0 && this.settings.layer == p_layer) {
                double best_visibility = 0.0;
                int best_visible_layer = 0;
                for (int i = 0; i < this.graphics_context.layer_count(); ++i) {
                    if (!(this.graphics_context.get_layer_visibility(i) > best_visibility)) continue;
                    best_visibility = this.graphics_context.get_layer_visibility(i);
                    best_visible_layer = i;
                }
                this.settings.layer = best_visible_layer;
            }
        }
    }

    public int get_trace_halfwidth(int p_net_no, int p_layer) {
        int result = this.settings.manual_rule_selection ? this.settings.manual_trace_half_width_arr[p_layer] : this.board.rules.get_trace_half_width(p_net_no, p_layer);
        return result;
    }

    public boolean is_active_routing_layer(int p_net_no, int p_layer) {
        if (this.settings.manual_rule_selection) {
            return true;
        }
        Net curr_net = this.board.rules.nets.get(p_net_no);
        if (curr_net == null) {
            return true;
        }
        NetClass curr_net_class = curr_net.get_class();
        if (curr_net_class == null) {
            return true;
        }
        return curr_net_class.is_active_routing_layer(p_layer);
    }

    public int get_trace_clearance_class(int p_net_no) {
        int result = this.settings.manual_rule_selection ? this.settings.manual_trace_clearance_class : this.board.rules.nets.get(p_net_no).get_class().get_trace_clearance_class();
        return result;
    }

    public ViaRule get_via_rule(int p_net_no) {
        ViaRule result = null;
        if (this.settings.manual_rule_selection) {
            result = this.board.rules.via_rules.get(this.settings.manual_via_rule_index);
        }
        if (result == null) {
            result = this.board.rules.nets.get(p_net_no).get_class().get_via_rule();
        }
        return result;
    }

    public void set_default_trace_halfwidth(int p_layer, int p_value) {
        if (this.board_is_read_only) {
            return;
        }
        if (p_layer >= 0 && p_layer <= this.board.get_layer_count()) {
            this.board.rules.set_default_trace_half_width(p_layer, p_value);
            this.logfile.start_scope(LogfileScope.SET_TRACE_HALF_WIDTH, p_layer);
            this.logfile.add_int(p_value);
        }
    }

    public void set_clearance_compensation(boolean p_value) {
        if (this.board_is_read_only) {
            return;
        }
        this.board.search_tree_manager.set_clearance_compensation_used(p_value);
        this.logfile.start_scope(LogfileScope.SET_CLEARANCE_COMPENSATION, p_value);
    }

    public void set_current_snap_angle(AngleRestriction p_snap_angle) {
        if (this.board_is_read_only) {
            return;
        }
        this.board.rules.set_trace_angle_restriction(p_snap_angle);
        this.logfile.start_scope(LogfileScope.SET_SNAP_ANGLE, p_snap_angle.get_no());
    }

    public void set_current_layer(int p_layer) {
        if (this.board_is_read_only) {
            return;
        }
        int layer = Math.max(p_layer, 0);
        layer = Math.min(layer, this.board.get_layer_count() - 1);
        this.set_layer(layer);
        this.logfile.start_scope(LogfileScope.SET_LAYER, p_layer);
    }

    void set_layer(int p_layer_no) {
        Layer curr_layer = this.board.layer_structure.arr[p_layer_no];
        this.settings.layer = p_layer_no;
        int signal_layer_no = this.board.layer_structure.get_signal_layer_no(curr_layer);
        if (!this.board_is_read_only) {
            // empty if block
        }
    }

    public void display_layer_messsage() {
        Layer curr_layer = this.board.layer_structure.arr[this.settings.layer];
    }

    public void initialize_manual_trace_half_widths() {
        for (int i = 0; i < this.settings.manual_trace_half_width_arr.length; ++i) {
            this.settings.manual_trace_half_width_arr[i] = this.board.rules.get_default_net_class().get_trace_half_width(i);
        }
    }

    public void set_manual_trace_half_width(int p_layer_no, int p_value) {
        this.settings.set_manual_trace_half_width(p_layer_no, p_value);
    }

    public void set_selectable(ItemSelectionFilter.SelectableChoices p_item_type, boolean p_value) {
        this.settings.set_selectable(p_item_type, p_value);
        if (!p_value && this.interactive_state instanceof SelectedItemState) {
            this.set_interactive_state(((SelectedItemState)this.interactive_state).filter());
        }
    }

    public void toggle_ratsnest() {
        if (this.ratsnest == null || this.ratsnest.is_hidden()) {
            this.create_ratsnest();
        } else {
            this.ratsnest = null;
        }
    }

    public void toggle_clearance_violations() {
        if (this.clearance_violations == null) {
            this.clearance_violations = new ClearanceViolations(this.board.get_items());
            Integer violation_count = new Integer((this.clearance_violations.list.size() + 1) / 2);
            String string = violation_count.toString() + " " + this.resources.getString("clearance_violations_found");
        } else {
            this.clearance_violations = null;
        }
    }

    public int getInCompletesNum() {
        RatsNest ratsnest = new RatsNest(this.board, this.locale);
        return ratsnest.incomplete_count();
    }

    public int getVioLationNum() {
        ClearanceViolations violations = new ClearanceViolations(this.board.get_items());
        return new Integer((this.clearance_violations.list.size() + 1) / 2);
    }

    public void create_ratsnest() {
        this.ratsnest = new RatsNest(this.board, this.locale);
        Integer incomplete_count = this.ratsnest.incomplete_count();
        Integer length_violation_count = this.ratsnest.length_violation_count();
        if (length_violation_count == 0) {
            String curr_message = incomplete_count.toString() + " " + this.resources.getString("incomplete_connections_to_route");
        } else {
            String curr_message = incomplete_count.toString() + " " + this.resources.getString("incompletes") + " " + length_violation_count.toString() + " " + this.resources.getString("length_violations");
        }
    }

    void update_ratsnest(int p_net_no) {
        if (this.ratsnest != null && p_net_no > 0) {
            this.ratsnest.recalculate(p_net_no, this.board);
            this.ratsnest.show();
        }
    }

    void update_ratsnest(int p_net_no, Collection<Item> p_item_list) {
        if (this.ratsnest != null && p_net_no > 0) {
            this.ratsnest.recalculate(p_net_no, p_item_list, this.board);
            this.ratsnest.show();
        }
    }

    void update_ratsnest() {
        if (this.ratsnest != null) {
            this.ratsnest = new RatsNest(this.board, this.locale);
        }
    }

    public void hide_ratsnest() {
        if (this.ratsnest != null) {
            this.ratsnest.hide();
        }
    }

    public void show_ratsnest() {
        if (this.ratsnest != null) {
            this.ratsnest.show();
        }
    }

    public void remove_ratsnest() {
        this.ratsnest = null;
    }

    public RatsNest get_ratsnest() {
        if (this.ratsnest == null) {
            this.ratsnest = new RatsNest(this.board, this.locale);
        }
        return this.ratsnest;
    }

    public void recalculate_length_violations() {
        if (this.ratsnest == null || !this.ratsnest.recalculate_length_violations() || !this.ratsnest.is_hidden()) {
            // empty if block
        }
    }

    public void set_incompletes_filter(int p_net_no, boolean p_value) {
        if (this.ratsnest != null) {
            this.ratsnest.set_filter(p_net_no, p_value);
        }
    }

    public void create_board(IntBox p_bounding_box, LayerStructure p_layer_structure, PolylineShape[] p_outline_shapes, String p_outline_clearance_class_name, BoardRules p_rules, Communication p_board_communication, TestLevel p_test_level) {
        if (this.board != null) {
            System.out.println(" BoardHandling.create_board: board already created");
        }
        int outline_cl_class_no = 0;
        if (p_rules != null) {
            if (p_outline_clearance_class_name != null && p_rules.clearance_matrix != null) {
                outline_cl_class_no = p_rules.clearance_matrix.get_no(p_outline_clearance_class_name);
                outline_cl_class_no = Math.max(outline_cl_class_no, 0);
            } else {
                outline_cl_class_no = p_rules.get_default_net_class().default_item_clearance_classes.get(DefaultItemClearanceClasses.ItemClass.AREA);
            }
        }
        this.board = new RoutingBoard(p_bounding_box, p_layer_structure, p_outline_shapes, outline_cl_class_no, p_rules, p_board_communication, p_test_level);
        double unit_factor = p_board_communication.coordinate_transform.board_to_dsn(1.0);
        this.coordinate_transform = new CoordinateTransform(1.0, p_board_communication.unit, unit_factor, p_board_communication.unit);
        this.settings = new Settings(this.board, this.logfile);
    }

    public void change_user_unit_factor(double p_new_factor) {
        CoordinateTransform old_transform = this.coordinate_transform;
        this.coordinate_transform = new CoordinateTransform(p_new_factor, old_transform.user_unit, old_transform.board_unit_factor, old_transform.board_unit);
    }

    public void change_user_unit(Unit p_unit) {
        CoordinateTransform old_transform = this.coordinate_transform;
        this.coordinate_transform = new CoordinateTransform(old_transform.user_unit_factor, p_unit, old_transform.board_unit_factor, old_transform.board_unit);
    }

    public void start_logfile(File p_filename) {
        if (this.board_is_read_only) {
            return;
        }
        this.logfile.start_write(p_filename);
    }

    public void draw(Graphics p_graphics) {
        if (this.board == null) {
            return;
        }
        this.board.draw(p_graphics, this.graphics_context);
        if (this.ratsnest != null) {
            this.ratsnest.draw(p_graphics, this.graphics_context);
        }
        if (this.clearance_violations != null) {
            this.clearance_violations.draw(p_graphics, this.graphics_context);
        }
        if (this.interactive_state != null) {
            this.interactive_state.draw(p_graphics);
        }
        if (this.interactive_action_thread != null) {
            this.interactive_action_thread.draw(p_graphics);
        }
    }

    public void generate_snapshot() {
        if (this.board_is_read_only) {
            return;
        }
        this.board.generate_snapshot();
        this.logfile.start_scope(LogfileScope.GENERATE_SNAPSHOT);
    }

    public void undo() {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        if (this.board.undo(changed_nets)) {
            for (Integer changed_net : changed_nets) {
                this.update_ratsnest(changed_net);
            }
            if (changed_nets.size() > 0) {
                this.settings.autoroute_settings.set_pass_no(1);
            }
        }
        this.logfile.start_scope(LogfileScope.UNDO);
    }

    public void redo() {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        if (this.board.redo(changed_nets)) {
            for (Integer changed_net : changed_nets) {
                this.update_ratsnest(changed_net);
            }
        }
        this.logfile.start_scope(LogfileScope.REDO);
    }

    public void terminate() throws InterruptedException {
        if (this.interactive_action_thread != null) {
            this.interactive_action_thread.request_stop();
            this.interactive_action_thread.waitStopped(1000);
        }
    }

    public void mouse_moved(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        if (this.interactive_state != null && this.graphics_context != null) {
            this.current_mouse_position = this.graphics_context.coordinate_transform.screen_to_board(p_point);
            InteractiveState return_state = this.interactive_state.mouse_moved();
            if (return_state != this.interactive_state) {
                this.set_interactive_state(return_state);
            }
        }
    }

    public void mouse_pressed(Point2D p_point) {
        if (this.interactive_state != null && this.graphics_context != null) {
            this.current_mouse_position = this.graphics_context.coordinate_transform.screen_to_board(p_point);
            this.set_interactive_state(this.interactive_state.mouse_pressed(this.current_mouse_position));
        }
    }

    public void mouse_dragged(Point2D p_point) {
        if (this.interactive_state != null && this.graphics_context != null) {
            this.current_mouse_position = this.graphics_context.coordinate_transform.screen_to_board(p_point);
            InteractiveState return_state = this.interactive_state.mouse_dragged(this.current_mouse_position);
            if (return_state != this.interactive_state) {
                this.set_interactive_state(return_state);
            }
        }
    }

    public void button_released() {
        InteractiveState return_state;
        if (this.interactive_state != null && (return_state = this.interactive_state.button_released()) != this.interactive_state) {
            this.set_interactive_state(return_state);
        }
    }

    public void return_from_state() {
        if (this.board_is_read_only) {
            return;
        }
        InteractiveState new_state = this.interactive_state.complete();
        if (new_state != this.interactive_state) {
            this.set_interactive_state(new_state);
        }
    }

    public void cancel_state() {
        if (this.board_is_read_only) {
            return;
        }
        InteractiveState new_state = this.interactive_state.cancel();
        if (new_state != this.interactive_state) {
            this.set_interactive_state(new_state);
        }
    }

    public boolean change_layer_action(int p_new_layer) {
        boolean result = true;
        if (this.interactive_state != null && !this.board_is_read_only) {
            result = this.interactive_state.change_layer_action(p_new_layer);
        }
        return result;
    }

    public void set_select_menu_state() {
        this.interactive_state = SelectMenuState.get_instance(this, this.logfile);
    }

    public void set_route_menu_state() {
        this.interactive_state = RouteMenuState.get_instance(this, this.logfile);
    }

    public void set_drag_menu_state() {
        this.interactive_state = DragMenuState.get_instance(this, this.logfile);
    }

    public boolean read_design(ObjectInputStream p_design, TestLevel p_test_level) {
        try {
            this.board = (RoutingBoard)p_design.readObject();
            this.settings = (Settings)p_design.readObject();
            this.settings.set_logfile(this.logfile);
            this.coordinate_transform = (CoordinateTransform)p_design.readObject();
            this.graphics_context = (GraphicsContext)p_design.readObject();
        }
        catch (Exception e) {
            return false;
        }
        this.board.set_test_level(p_test_level);
        return true;
    }

    public DsnFile.ReadResult import_design(InputStream p_design, BoardObservers p_observers, IdNoGenerator p_item_id_no_generator, TestLevel p_test_level) {
        DsnFile.ReadResult read_result;
        try {
            read_result = DsnFile.read(p_design, this, p_observers, p_item_id_no_generator, p_test_level);
        }
        catch (Exception e) {
            read_result = DsnFile.ReadResult.ERROR;
        }
        if (read_result == DsnFile.ReadResult.OK) {
            this.board.reduce_nets_of_route_items();
            this.set_layer(0);
            for (int i = 0; i < this.board.get_layer_count(); ++i) {
                if (this.settings.autoroute_settings.get_layer_active(i)) continue;
                this.graphics_context.set_layer_visibility(i, 0.0);
            }
        }
        return read_result;
    }

    public boolean export_to_dsn_file(OutputStream p_output_stream, String p_design_name, boolean p_compat_mode) {
        if (this.board_is_read_only || p_output_stream == null) {
            return false;
        }
        return DsnFile.write(this, p_output_stream, p_design_name, p_compat_mode);
    }

    public boolean export_eagle_session_file(InputStream p_input_stream, OutputStream p_output_stream) {
        if (this.board_is_read_only) {
            return false;
        }
        return SessionToEagle.get_instance(p_input_stream, p_output_stream, this.board);
    }

    public boolean export_specctra_session_file(String p_design_name, OutputStream p_output_stream) {
        if (this.board_is_read_only) {
            return false;
        }
        return SessionFile.write(this.get_routing_board(), p_output_stream, p_design_name);
    }

    public boolean save_design_file(ObjectOutputStream p_object_stream) {
        boolean result = true;
        try {
            p_object_stream.writeObject(this.board);
            p_object_stream.writeObject(this.settings);
            p_object_stream.writeObject(this.coordinate_transform);
            p_object_stream.writeObject(this.graphics_context);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public void read_logfile(InputStream p_input_stream) {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        this.interactive_action_thread = InteractiveActionThread.get_read_logfile_instance(this, p_input_stream);
        this.interactive_action_thread.start();
    }

    public void close_files() {
        if (this.logfile != null) {
            this.logfile.close_output();
        }
    }

    public void start_route(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        RouteState new_state = RouteState.get_instance(location, this.interactive_state, this, this.logfile);
        this.set_interactive_state(new_state);
    }

    public void select_items(Point2D p_point) {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        InteractiveState return_state = ((MenuState)this.interactive_state).select_items(location);
        this.set_interactive_state(return_state);
    }

    public void select_items_in_region() {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        this.set_interactive_state(SelectItemsInRegionState.get_instance(this.interactive_state, this, this.logfile));
    }

    public void select_items(Set<Item> p_items) {
        if (this.board_is_read_only) {
            return;
        }
        this.display_layer_messsage();
        if (this.interactive_state instanceof MenuState) {
            this.set_interactive_state(SelectedItemState.get_instance(p_items, this.interactive_state, this, this.logfile));
        } else if (this.interactive_state instanceof SelectedItemState) {
            ((SelectedItemState)this.interactive_state).get_item_list().addAll(p_items);
        }
    }

    public void swap_pin(Point2D p_location) {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_location);
        InteractiveState return_state = ((MenuState)this.interactive_state).swap_pin(location);
        this.set_interactive_state(return_state);
    }

    public void zoom_selection() {
        if (!(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        IntBox bounding_box = this.board.get_bounding_box(((SelectedItemState)this.interactive_state).get_item_list());
        bounding_box = bounding_box.offset(this.board.rules.get_max_trace_half_width());
        Point2D lower_left = this.graphics_context.coordinate_transform.board_to_screen(bounding_box.ll.to_float());
        Point2D upper_right = this.graphics_context.coordinate_transform.board_to_screen(bounding_box.ur.to_float());
    }

    public void toggle_select_action(Point2D p_point) {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        InteractiveState return_state = ((SelectedItemState)this.interactive_state).toggle_select(location);
        if (return_state != this.interactive_state) {
            this.set_interactive_state(return_state);
        }
    }

    public void fix_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        ((SelectedItemState)this.interactive_state).fix_items();
    }

    public void unfix_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        ((SelectedItemState)this.interactive_state).unfix_items();
    }

    public void display_selected_item_info() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        ((SelectedItemState)this.interactive_state).info();
    }

    public void assign_selected_to_new_net() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).assign_items_to_new_net();
        this.set_interactive_state(new_state);
    }

    public void assign_selected_to_new_group() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).assign_items_to_new_group();
        this.set_interactive_state(new_state);
    }

    public void delete_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).delete_items();
        this.set_interactive_state(new_state);
    }

    public void cutout_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).cutout_items();
        this.set_interactive_state(new_state);
    }

    public void assign_clearance_classs_to_selected_items(int p_cl_class_index) {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).assign_clearance_class(p_cl_class_index);
        this.set_interactive_state(new_state);
    }

    public void move_selected_items(Point2D p_from_location) {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        SelectedItemState curr_state = (SelectedItemState)this.interactive_state;
        Collection<Item> item_list = curr_state.get_item_list();
        FloatPoint from_location = this.graphics_context.coordinate_transform.screen_to_board(p_from_location);
        MoveItemState new_state = MoveItemState.get_instance(from_location, item_list, this.interactive_state, this, this.logfile);
        this.set_interactive_state(new_state);
    }

    public void copy_selected_items(Point2D p_from_location) {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        SelectedItemState curr_state = (SelectedItemState)this.interactive_state;
        curr_state.extent_to_whole_components();
        Collection<Item> item_list = curr_state.get_item_list();
        FloatPoint from_location = this.graphics_context.coordinate_transform.screen_to_board(p_from_location);
        CopyItemState new_state = CopyItemState.get_instance(from_location, item_list, this.interactive_state.return_state, this, this.logfile);
        this.set_interactive_state(new_state);
    }

    public void optimize_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.board.generate_snapshot();
        this.interactive_action_thread = InteractiveActionThread.get_pull_tight_instance(this);
        this.interactive_action_thread.start();
    }

    public void autoroute_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.board.generate_snapshot();
        this.interactive_action_thread = InteractiveActionThread.get_autoroute_instance(this);
        this.interactive_action_thread.start();
    }

    public void fanout_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.board.generate_snapshot();
        this.interactive_action_thread = InteractiveActionThread.get_fanout_instance(this);
        this.interactive_action_thread.start();
    }

    public void start_batch_autorouter() {
        if (this.board_is_read_only) {
            return;
        }
        this.board.generate_snapshot();
        this.interactive_action_thread = InteractiveActionThread.get_batch_autorouter_instance(this);
        this.interactive_action_thread.start();
    }

    public void extend_selection_to_whole_nets() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.set_interactive_state(((SelectedItemState)this.interactive_state).extent_to_whole_nets());
    }

    public void extend_selection_to_whole_components() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.set_interactive_state(((SelectedItemState)this.interactive_state).extent_to_whole_components());
    }

    public void extend_selection_to_whole_connected_sets() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.set_interactive_state(((SelectedItemState)this.interactive_state).extent_to_whole_connected_sets());
    }

    public void extend_selection_to_whole_connections() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.set_interactive_state(((SelectedItemState)this.interactive_state).extent_to_whole_connections());
    }

    public void toggle_selected_item_violations() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        ((SelectedItemState)this.interactive_state).toggle_clearance_violations();
    }

    public void turn_45_degree(int p_factor) {
        if (this.board_is_read_only || !(this.interactive_state instanceof MoveItemState)) {
            return;
        }
        ((MoveItemState)this.interactive_state).turn_45_degree(p_factor);
    }

    public void change_placement_side() {
        if (this.board_is_read_only || !(this.interactive_state instanceof MoveItemState)) {
            return;
        }
        ((MoveItemState)this.interactive_state).change_placement_side();
    }

    public void zoom_region() {
        this.interactive_state = ZoomRegionState.get_instance(this.interactive_state, this, this.logfile);
    }

    public void start_circle(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        this.set_interactive_state(CircleConstructionState.get_instance(location, this.interactive_state, this, this.logfile));
    }

    public void start_tile(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        this.set_interactive_state(TileConstructionState.get_instance(location, this.interactive_state, this, this.logfile));
    }

    public void start_polygonshape_item(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        this.set_interactive_state(PolygonShapeConstructionState.get_instance(location, this.interactive_state, this, this.logfile));
    }

    public void start_adding_hole(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        HoleConstructionState new_state = HoleConstructionState.get_instance(location, this.interactive_state, this, this.logfile);
        this.set_interactive_state(new_state);
    }

    Rectangle get_graphics_update_rectangle() {
        Rectangle result;
        IntBox update_box = this.board.get_graphics_update_box();
        if (update_box == null || update_box.is_empty()) {
            result = new Rectangle(0, 0, 0, 0);
        } else {
            IntBox offset_box = update_box.offset(this.board.get_max_trace_half_width());
            result = this.graphics_context.coordinate_transform.board_to_screen(offset_box);
        }
        return result;
    }

    Set<Item> pick_items(FloatPoint p_location) {
        return this.pick_items(p_location, this.settings.item_selection_filter);
    }

    Set<Item> pick_items(FloatPoint p_location, ItemSelectionFilter p_item_filter) {
        IntPoint location = p_location.round();
        Set<Item> result = this.board.pick_items(location, this.settings.layer, p_item_filter);
        if (result.size() == 0 && this.settings.select_on_all_visible_layers) {
            for (int i = 0; i < this.graphics_context.layer_count(); ++i) {
                if (i == this.settings.layer || this.graphics_context.get_layer_visibility(i) <= 0.0) continue;
                result.addAll(this.board.pick_items(location, i, p_item_filter));
            }
        }
        return result;
    }

    void move_mouse(FloatPoint p_to_location) {
    }

    public InteractiveState get_interactive_state() {
        return this.interactive_state;
    }

    public void set_interactive_state(InteractiveState p_state) {
        if (p_state != null && p_state != this.interactive_state) {
            this.interactive_state = p_state;
            if (!this.board_is_read_only) {
                p_state.set_toolbar();
            }
        }
    }

    public void adjust_design_bounds() {
        IntBox new_bounding_box = this.board.get_bounding_box();
        Collection<Item> board_items = this.board.get_items();
        for (Item curr_item : board_items) {
            IntBox curr_bounding_box = curr_item.bounding_box();
            if (curr_bounding_box.ur.x >= Integer.MAX_VALUE) continue;
            new_bounding_box = new_bounding_box.union(curr_bounding_box);
        }
        this.graphics_context.change_design_bounds(new_bounding_box);
    }

    public void dispose() {
        this.close_files();
        this.graphics_context = null;
        this.coordinate_transform = null;
        this.settings = null;
        this.interactive_state = null;
        this.ratsnest = null;
        this.clearance_violations = null;
        this.board = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheIfNeeded() {
        if (this.updateFlag.compareAndSet(true, false)) {
            BoardHandling boardHandling = this;
            synchronized (boardHandling) {
                this.inCompletesNum = this.getInCompletesNum();
                this.cache = new ByteArrayOutputStream();
                this.set_board_read_only(false);
                this.export_specctra_session_file("tmp", this.cache);
                this.set_board_read_only(true);
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterCache waitCurrentCache() throws InterruptedException {
        this.updateFlag.set(true);
        BoardHandling boardHandling = this;
        synchronized (boardHandling) {
            this.wait(1000L);
            if (this.updateFlag.get()) {
                throw new InterruptedException();
            }
            return new RouterCache(this.inCompletesNum, this.cache.toString());
        }
    }

    public int reduceOptTimes() {
        return this.optTimes.decrementAndGet();
    }
}

