/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import autoroute.BatchAutorouter;
import autoroute.BatchFanout;
import autoroute.BatchOptRoute;
import board.AngleRestriction;
import board.TestLevel;
import board.Unit;
import geometry.planar.FloatLine;
import geometry.planar.FloatPoint;
import interactive.AutorouteSettings;
import interactive.BoardHandling;
import interactive.InteractiveActionThread;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ResourceBundle;
import test.Validate;

public class BatchAutorouterThread
extends InteractiveActionThread {
    private final BatchAutorouter batch_autorouter;
    private final BatchOptRoute batch_opt_route;

    protected BatchAutorouterThread(BoardHandling p_board_handling) {
        super(p_board_handling);
        AutorouteSettings autoroute_settings = p_board_handling.settings.autoroute_settings;
        this.batch_autorouter = new BatchAutorouter(this, !autoroute_settings.get_with_fanout(), true, autoroute_settings.get_start_ripup_costs());
        this.batch_opt_route = new BatchOptRoute(this);
    }

    @Override
    protected void thread_action() {
        try {
            boolean fanout_first;
            ResourceBundle resources = ResourceBundle.getBundle("interactive.resources.InteractiveState", this.hdlg.get_locale());
            boolean saved_board_read_only = this.hdlg.is_board_read_only();
            this.hdlg.set_board_read_only(true);
            boolean ratsnest_hidden_before = this.hdlg.get_ratsnest().is_hidden();
            if (!ratsnest_hidden_before) {
                this.hdlg.get_ratsnest().hide();
            }
            String start_message = resources.getString("batch_autorouter") + " " + resources.getString("stop_message");
            boolean bl = fanout_first = this.hdlg.settings.autoroute_settings.get_with_fanout() && this.hdlg.settings.autoroute_settings.get_pass_no() <= 1;
            if (fanout_first) {
                BatchFanout.fanout_board(this);
            }
            if (this.hdlg.settings.autoroute_settings.get_with_autoroute() && !this.is_stop_requested()) {
                this.batch_autorouter.autoroute_passes();
            }
            this.hdlg.get_routing_board().finish_autoroute();
            if (this.hdlg.settings.autoroute_settings.get_with_postroute() && !this.is_stop_requested()) {
                String opt_message = resources.getString("batch_optimizer") + " " + resources.getString("stop_message");
                this.batch_opt_route.optimize_board();
                String curr_message = this.is_stop_requested() ? resources.getString("interrupted") : resources.getString("completed");
                String string = resources.getString("postroute") + " " + curr_message;
            } else {
                String curr_message = this.is_stop_requested() ? resources.getString("interrupted") : resources.getString("completed");
                Integer incomplete_count = this.hdlg.get_ratsnest().incomplete_count();
                String string = resources.getString("autoroute") + " " + curr_message + ", " + incomplete_count.toString() + " " + resources.getString("connections_not_found");
            }
            this.hdlg.set_board_read_only(saved_board_read_only);
            this.hdlg.update_ratsnest();
            if (!ratsnest_hidden_before) {
                this.hdlg.get_ratsnest().show();
            }
            if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE && this.hdlg.get_routing_board().get_test_level() != TestLevel.RELEASE_VERSION) {
                Validate.multiple_of_45_degree("after autoroute: ", this.hdlg.get_routing_board());
            }
            this.hdlg.isFinished = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.hdlg.exception = e;
        }
    }

    @Override
    public void draw(Graphics p_graphics) {
        FloatLine curr_air_line = this.batch_autorouter.get_air_line();
        if (curr_air_line != null) {
            FloatPoint[] draw_line = new FloatPoint[]{curr_air_line.a, curr_air_line.b};
            Color draw_color = this.hdlg.graphics_context.get_incomplete_color();
            double draw_width = Math.min(this.hdlg.get_routing_board().communication.get_resolution(Unit.MIL) * 3.0, 300.0);
            this.hdlg.graphics_context.draw(draw_line, draw_width, draw_color, p_graphics, 1.0);
        }
        FloatPoint current_opt_position = this.batch_opt_route.get_current_position();
        int radius = 10 * this.hdlg.get_routing_board().rules.get_default_trace_half_width(0);
        if (current_opt_position != null) {
            boolean draw_width = true;
            Color draw_color = this.hdlg.graphics_context.get_incomplete_color();
            FloatPoint[] draw_points = new FloatPoint[]{new FloatPoint(current_opt_position.x - (double)radius, current_opt_position.y - (double)radius), new FloatPoint(current_opt_position.x + (double)radius, current_opt_position.y + (double)radius)};
            this.hdlg.graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, 1.0);
            draw_points[0] = new FloatPoint(current_opt_position.x + (double)radius, current_opt_position.y - (double)radius);
            draw_points[1] = new FloatPoint(current_opt_position.x - (double)radius, current_opt_position.y + (double)radius);
            this.hdlg.graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, 1.0);
            this.hdlg.graphics_context.draw_circle(current_opt_position, radius, 1.0, draw_color, p_graphics, 1.0);
        }
    }
}

