/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import autoroute.AutorouteControl;
import board.RoutingBoard;
import java.io.Serializable;

public class AutorouteSettings
implements Serializable {
    private boolean with_fanout;
    private boolean with_autoroute;
    private boolean with_postroute;
    private boolean vias_allowed;
    private int via_costs;
    private int plane_via_costs;
    private int start_ripup_costs;
    private int start_pass_no;
    private final boolean[] layer_active_arr;
    private final boolean[] preferred_direction_is_horizontal_arr;
    private final double[] preferred_direction_trace_cost_arr;
    private final double[] against_preferred_direction_trace_cost_arr;

    public AutorouteSettings(int p_layer_count) {
        this.layer_active_arr = new boolean[p_layer_count];
        this.preferred_direction_is_horizontal_arr = new boolean[p_layer_count];
        this.preferred_direction_trace_cost_arr = new double[p_layer_count];
        this.against_preferred_direction_trace_cost_arr = new double[p_layer_count];
    }

    public AutorouteSettings(RoutingBoard p_board) {
        this(p_board.get_layer_count());
        this.start_ripup_costs = 100;
        this.start_pass_no = 1;
        this.vias_allowed = true;
        this.with_fanout = false;
        this.with_autoroute = true;
        this.with_postroute = true;
        this.via_costs = 50;
        this.plane_via_costs = 5;
        double horizontal_width = p_board.bounding_box.width();
        double vertical_width = p_board.bounding_box.height();
        int layer_count = p_board.get_layer_count();
        double horizontal_add_costs_against_preferred_dir = 0.1 * (double)Math.round(10.0 * horizontal_width / vertical_width);
        double vertical_add_costs_against_preferred_dir = 0.1 * (double)Math.round(10.0 * vertical_width / horizontal_width);
        boolean curr_preferred_direction_is_horizontal = horizontal_width < vertical_width;
        for (int i = 0; i < layer_count; ++i) {
            this.layer_active_arr[i] = p_board.layer_structure.arr[i].is_signal;
            if (p_board.layer_structure.arr[i].is_signal) {
                curr_preferred_direction_is_horizontal = !curr_preferred_direction_is_horizontal;
            }
            this.preferred_direction_is_horizontal_arr[i] = curr_preferred_direction_is_horizontal;
            this.preferred_direction_trace_cost_arr[i] = 1.0;
            this.against_preferred_direction_trace_cost_arr[i] = 1.0;
            if (curr_preferred_direction_is_horizontal) {
                int n = i;
                this.against_preferred_direction_trace_cost_arr[n] = this.against_preferred_direction_trace_cost_arr[n] + horizontal_add_costs_against_preferred_dir;
                continue;
            }
            int n = i;
            this.against_preferred_direction_trace_cost_arr[n] = this.against_preferred_direction_trace_cost_arr[n] + vertical_add_costs_against_preferred_dir;
        }
        int signal_layer_count = p_board.layer_structure.signal_layer_count();
        if (signal_layer_count > 2) {
            double outer_add_costs = 0.2 * (double)signal_layer_count;
            this.preferred_direction_trace_cost_arr[0] = this.preferred_direction_trace_cost_arr[0] + outer_add_costs;
            int n = layer_count - 1;
            this.preferred_direction_trace_cost_arr[n] = this.preferred_direction_trace_cost_arr[n] + outer_add_costs;
            this.against_preferred_direction_trace_cost_arr[0] = this.against_preferred_direction_trace_cost_arr[0] + outer_add_costs;
            int n2 = layer_count - 1;
            this.against_preferred_direction_trace_cost_arr[n2] = this.against_preferred_direction_trace_cost_arr[n2] + outer_add_costs;
        }
    }

    public AutorouteSettings(AutorouteSettings p_settings) {
        this.start_ripup_costs = p_settings.start_ripup_costs;
        this.start_pass_no = p_settings.start_pass_no;
        this.via_costs = p_settings.via_costs;
        this.plane_via_costs = p_settings.plane_via_costs;
        this.layer_active_arr = new boolean[p_settings.layer_active_arr.length];
        System.arraycopy(p_settings.layer_active_arr, 0, this.layer_active_arr, 0, this.layer_active_arr.length);
        this.preferred_direction_is_horizontal_arr = new boolean[p_settings.preferred_direction_is_horizontal_arr.length];
        System.arraycopy(p_settings.preferred_direction_is_horizontal_arr, 0, this.preferred_direction_is_horizontal_arr, 0, this.preferred_direction_is_horizontal_arr.length);
        this.preferred_direction_trace_cost_arr = new double[p_settings.preferred_direction_trace_cost_arr.length];
        System.arraycopy(p_settings.preferred_direction_trace_cost_arr, 0, this.preferred_direction_trace_cost_arr, 0, this.preferred_direction_trace_cost_arr.length);
        this.against_preferred_direction_trace_cost_arr = new double[p_settings.against_preferred_direction_trace_cost_arr.length];
        System.arraycopy(p_settings.against_preferred_direction_trace_cost_arr, 0, this.against_preferred_direction_trace_cost_arr, 0, this.against_preferred_direction_trace_cost_arr.length);
    }

    public void set_start_ripup_costs(int p_value) {
        this.start_ripup_costs = Math.max(p_value, 1);
    }

    public int get_start_ripup_costs() {
        return this.start_ripup_costs;
    }

    public void set_pass_no(int p_value) {
        this.start_pass_no = Math.max(p_value, 1);
        this.start_pass_no = Math.min(this.start_pass_no, 99);
    }

    public int get_pass_no() {
        return this.start_pass_no;
    }

    public void increment_pass_no() {
        ++this.start_pass_no;
    }

    public void set_with_fanout(boolean p_value) {
        this.with_fanout = p_value;
    }

    public boolean get_with_fanout() {
        return this.with_fanout;
    }

    public void set_with_autoroute(boolean p_value) {
        this.with_autoroute = p_value;
    }

    public boolean get_with_autoroute() {
        return this.with_autoroute;
    }

    public void set_with_postroute(boolean p_value) {
        this.with_postroute = p_value;
    }

    public boolean get_with_postroute() {
        return this.with_postroute;
    }

    public void set_vias_allowed(boolean p_value) {
        this.vias_allowed = p_value;
    }

    public boolean get_vias_allowed() {
        return this.vias_allowed;
    }

    public void set_via_costs(int p_value) {
        this.via_costs = Math.max(p_value, 1);
    }

    public int get_via_costs() {
        return this.via_costs;
    }

    public void set_plane_via_costs(int p_value) {
        this.plane_via_costs = Math.max(p_value, 1);
    }

    public int get_plane_via_costs() {
        return this.plane_via_costs;
    }

    public void set_layer_active(int p_layer, boolean p_value) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.set_layer_active: p_layer out of range");
            return;
        }
        this.layer_active_arr[p_layer] = p_value;
    }

    public boolean get_layer_active(int p_layer) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.get_layer_active: p_layer out of range");
            return false;
        }
        return this.layer_active_arr[p_layer];
    }

    public void set_preferred_direction_is_horizontal(int p_layer, boolean p_value) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.set_preferred_direction_is_horizontal: p_layer out of range");
            return;
        }
        this.preferred_direction_is_horizontal_arr[p_layer] = p_value;
    }

    public boolean get_preferred_direction_is_horizontal(int p_layer) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.get_preferred_direction_is_horizontal: p_layer out of range");
            return false;
        }
        return this.preferred_direction_is_horizontal_arr[p_layer];
    }

    public void set_preferred_direction_trace_costs(int p_layer, double p_value) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.set_preferred_direction_trace_costs: p_layer out of range");
            return;
        }
        this.preferred_direction_trace_cost_arr[p_layer] = Math.max(p_value, 0.1);
    }

    public double get_preferred_direction_trace_costs(int p_layer) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.get_preferred_direction_trace_costs: p_layer out of range");
            return 0.0;
        }
        return this.preferred_direction_trace_cost_arr[p_layer];
    }

    public double get_against_preferred_direction_trace_costs(int p_layer) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.get_against_preferred_direction_trace_costs: p_layer out of range");
            return 0.0;
        }
        return this.against_preferred_direction_trace_cost_arr[p_layer];
    }

    public double get_horizontal_trace_costs(int p_layer) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.get_preferred_direction_trace_costs: p_layer out of range");
            return 0.0;
        }
        double result = this.preferred_direction_is_horizontal_arr[p_layer] ? this.preferred_direction_trace_cost_arr[p_layer] : this.against_preferred_direction_trace_cost_arr[p_layer];
        return result;
    }

    public void set_against_preferred_direction_trace_costs(int p_layer, double p_value) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.set_against_preferred_direction_trace_costs: p_layer out of range");
            return;
        }
        this.against_preferred_direction_trace_cost_arr[p_layer] = Math.max(p_value, 0.1);
    }

    public double get_vertical_trace_costs(int p_layer) {
        if (p_layer < 0 || p_layer >= this.layer_active_arr.length) {
            System.out.println("AutorouteSettings.get_against_preferred_direction_trace_costs: p_layer out of range");
            return 0.0;
        }
        double result = this.preferred_direction_is_horizontal_arr[p_layer] ? this.against_preferred_direction_trace_cost_arr[p_layer] : this.preferred_direction_trace_cost_arr[p_layer];
        return result;
    }

    public AutorouteControl.ExpansionCostFactor[] get_trace_cost_arr() {
        AutorouteControl.ExpansionCostFactor[] result = new AutorouteControl.ExpansionCostFactor[this.preferred_direction_trace_cost_arr.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new AutorouteControl.ExpansionCostFactor(this.get_horizontal_trace_costs(i), this.get_vertical_trace_costs(i));
        }
        return result;
    }
}

