/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import geometry.planar.Circle;
import geometry.planar.Direction;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntDirection;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.IntVector;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.RegularTileShape;
import geometry.planar.Shape;
import geometry.planar.ShapeBoundingDirections;
import geometry.planar.Side;
import geometry.planar.TileShape;
import geometry.planar.Vector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class Simplex
extends TileShape
implements Serializable {
    public static final Simplex EMPTY = new Simplex(new Line[0]);
    private final Line[] arr;
    private transient Point[] precalculated_corners = null;
    private transient FloatPoint[] precalculated_float_corners = null;
    private transient IntBox precalculated_bounding_box = null;
    private transient IntOctagon precalculated_bounding_octagon = null;

    public static Simplex get_instance(Line[] p_line_arr) {
        if (p_line_arr.length <= 0) {
            return EMPTY;
        }
        Object[] curr_arr = new Line[p_line_arr.length];
        System.arraycopy(p_line_arr, 0, curr_arr, 0, p_line_arr.length);
        Arrays.sort(curr_arr);
        Simplex curr_simplex = new Simplex((Line[])curr_arr);
        Simplex result = curr_simplex.remove_redundant_lines();
        return result;
    }

    @Override
    public boolean is_empty() {
        return this.arr.length == 0;
    }

    @Override
    public TileShape simplify() {
        TileShape result = this;
        if (this.is_empty()) {
            result = EMPTY;
        } else if (this.is_IntBox()) {
            result = this.bounding_box();
        } else if (this.is_IntOctagon()) {
            result = this.to_IntOctagon();
        }
        return result;
    }

    @Override
    public boolean corner_is_bounded(int p_no) {
        int no;
        if (p_no < 0) {
            System.out.println("corner: p_no is < 0");
            no = 0;
        } else if (p_no >= this.arr.length) {
            System.out.println("corner: p_index must be less than arr.length - 1");
            no = this.arr.length - 1;
        } else {
            no = p_no;
        }
        if (this.arr.length == 1) {
            return false;
        }
        int prev_no = no == 0 ? this.arr.length - 1 : no - 1;
        IntVector prev_dir = (IntVector)this.arr[prev_no].direction().get_vector();
        IntVector curr_dir = (IntVector)this.arr[no].direction().get_vector();
        return prev_dir.determinant(curr_dir) > 0L;
    }

    @Override
    public boolean is_bounded() {
        if (this.arr.length == 0) {
            return true;
        }
        if (this.arr.length < 3) {
            return false;
        }
        for (int i = 0; i < this.arr.length; ++i) {
            if (this.corner_is_bounded(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int border_line_count() {
        return this.arr.length;
    }

    @Override
    public Point corner(int p_no) {
        int no;
        if (p_no < 0) {
            System.out.println("Simplex.corner: p_no is < 0");
            no = 0;
        } else if (p_no >= this.arr.length) {
            System.out.println("Simplex.corner: p_no must be less than arr.length - 1");
            no = this.arr.length - 1;
        } else {
            no = p_no;
        }
        if (this.precalculated_corners == null) {
            this.precalculated_corners = new Point[this.arr.length];
        }
        if (this.precalculated_corners[no] == null) {
            Line prev = no == 0 ? this.arr[this.arr.length - 1] : this.arr[no - 1];
            this.precalculated_corners[no] = this.arr[no].intersection(prev);
        }
        return this.precalculated_corners[no];
    }

    @Override
    public FloatPoint corner_approx(int p_no) {
        int no;
        if (this.arr.length <= 0) {
            return null;
        }
        if (p_no < 0) {
            System.out.println("Simplex.corner_approx: p_no is < 0");
            no = 0;
        } else if (p_no >= this.arr.length) {
            System.out.println("Simplex.corner_approx: p_no must be less than arr.length - 1");
            no = this.arr.length - 1;
        } else {
            no = p_no;
        }
        if (this.precalculated_float_corners == null) {
            this.precalculated_float_corners = new FloatPoint[this.arr.length];
        }
        if (this.precalculated_float_corners[no] == null) {
            Line prev = no == 0 ? this.arr[this.arr.length - 1] : this.arr[no - 1];
            this.precalculated_float_corners[no] = this.arr[no].intersection_approx(prev);
        }
        return this.precalculated_float_corners[no];
    }

    @Override
    public FloatPoint[] corner_approx_arr() {
        if (this.precalculated_float_corners == null) {
            this.precalculated_float_corners = new FloatPoint[this.arr.length];
        }
        for (int i = 0; i < this.precalculated_float_corners.length; ++i) {
            if (this.precalculated_float_corners[i] != null) continue;
            Line prev = i == 0 ? this.arr[this.arr.length - 1] : this.arr[i - 1];
            this.precalculated_float_corners[i] = this.arr[i].intersection_approx(prev);
        }
        return this.precalculated_float_corners;
    }

    @Override
    public Line border_line(int p_no) {
        int no;
        if (this.arr.length <= 0) {
            System.out.println("Simplex.edge_line : simplex is empty");
            return null;
        }
        if (p_no < 0) {
            System.out.println("Simplex.edge_line : p_no is < 0");
            no = 0;
        } else if (p_no >= this.arr.length) {
            System.out.println("Simplex.edge_line: p_no must be less than arr.length - 1");
            no = this.arr.length - 1;
        } else {
            no = p_no;
        }
        return this.arr[no];
    }

    @Override
    public int dimension() {
        if (this.arr.length == 0) {
            return -1;
        }
        if (this.arr.length > 4) {
            return 2;
        }
        if (this.arr.length == 1) {
            return 2;
        }
        if (this.arr.length == 2) {
            if (this.arr[0].overlaps(this.arr[1])) {
                return 1;
            }
            return 2;
        }
        if (this.arr.length == 3) {
            if (this.arr[0].overlaps(this.arr[1]) || this.arr[0].overlaps(this.arr[2]) || this.arr[1].overlaps(this.arr[2])) {
                return 1;
            }
            Point intersection = this.arr[1].intersection(this.arr[2]);
            Side side_of_line0 = this.arr[0].side_of(intersection);
            if (side_of_line0 == Side.ON_THE_RIGHT) {
                return 2;
            }
            if (side_of_line0 == Side.ON_THE_LEFT) {
                System.out.println("empty Simplex not normalized");
                return -1;
            }
            return 0;
        }
        boolean collinear_0_2 = this.arr[0].overlaps(this.arr[2]);
        boolean collinear_1_3 = this.arr[1].overlaps(this.arr[3]);
        if (collinear_0_2 && collinear_1_3) {
            return 0;
        }
        if (collinear_0_2 || collinear_1_3) {
            return 1;
        }
        return 2;
    }

    @Override
    public double max_width() {
        if (!this.is_bounded()) {
            return 2.147483647E9;
        }
        double max_distance = -2.147483648E9;
        double max_distance_2 = -2.147483648E9;
        FloatPoint gravity_point = this.centre_of_gravity();
        for (int i = 0; i < this.border_line_count(); ++i) {
            double curr_distance = Math.abs(this.arr[i].signed_distance(gravity_point));
            if (curr_distance > max_distance) {
                max_distance_2 = max_distance;
                max_distance = curr_distance;
                continue;
            }
            if (!(curr_distance > max_distance_2)) continue;
            max_distance_2 = curr_distance;
        }
        return max_distance + max_distance_2;
    }

    @Override
    public double min_width() {
        if (!this.is_bounded()) {
            return 2.147483647E9;
        }
        double min_distance = 2.147483647E9;
        double min_distance_2 = 2.147483647E9;
        FloatPoint gravity_point = this.centre_of_gravity();
        for (int i = 0; i < this.border_line_count(); ++i) {
            double curr_distance = Math.abs(this.arr[i].signed_distance(gravity_point));
            if (curr_distance < min_distance) {
                min_distance_2 = min_distance;
                min_distance = curr_distance;
                continue;
            }
            if (!(curr_distance < min_distance_2)) continue;
            min_distance_2 = curr_distance;
        }
        return min_distance + min_distance_2;
    }

    @Override
    public boolean is_IntBox() {
        for (int i = 0; i < this.arr.length; ++i) {
            Line curr_line = this.arr[i];
            if (!(curr_line.a instanceof IntPoint) || !(curr_line.b instanceof IntPoint)) {
                return false;
            }
            if (!curr_line.is_orthogonal()) {
                return false;
            }
            if (this.corner_is_bounded(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean is_IntOctagon() {
        for (int i = 0; i < this.arr.length; ++i) {
            Line curr_line = this.arr[i];
            if (!(curr_line.a instanceof IntPoint) || !(curr_line.b instanceof IntPoint)) {
                return false;
            }
            if (!curr_line.is_multiple_of_45_degree()) {
                return false;
            }
            if (this.corner_is_bounded(i)) continue;
            return false;
        }
        return true;
    }

    public IntOctagon to_IntOctagon() {
        if (!this.is_IntOctagon()) {
            return null;
        }
        if (this.is_empty()) {
            return IntOctagon.EMPTY;
        }
        int rx = 0x2000000;
        int uy = 0x2000000;
        int lrx = 0x2000000;
        int urx = 0x2000000;
        int lx = -33554432;
        int ly = -33554432;
        int llx = -33554432;
        int ulx = -33554432;
        for (int i = 0; i < this.arr.length; ++i) {
            Line curr_line = this.arr[i];
            IntPoint a = (IntPoint)curr_line.a;
            IntPoint b = (IntPoint)curr_line.b;
            if (a.y == b.y) {
                if (b.x >= a.x) {
                    ly = a.y;
                }
                if (b.x <= a.x) {
                    uy = a.y;
                }
            }
            if (a.x == b.x) {
                if (b.y >= a.y) {
                    rx = a.x;
                }
                if (b.y <= a.y) {
                    lx = a.x;
                }
            }
            if (a.y < b.y) {
                if (a.x < b.x) {
                    lrx = a.x - a.y;
                    continue;
                }
                if (a.x <= b.x) continue;
                urx = a.x + a.y;
                continue;
            }
            if (a.y <= b.y) continue;
            if (a.x < b.x) {
                llx = a.x + a.y;
                continue;
            }
            if (a.x <= b.x) continue;
            ulx = a.x - a.y;
        }
        IntOctagon result = new IntOctagon(lx, ly, rx, uy, ulx, lrx, llx, urx);
        return result.normalize();
    }

    @Override
    public Simplex translate_by(Vector p_vector) {
        if (p_vector.equals(Vector.ZERO)) {
            return this;
        }
        Line[] new_arr = new Line[this.arr.length];
        for (int i = 0; i < this.arr.length; ++i) {
            new_arr[i] = this.arr[i].translate_by(p_vector);
        }
        return new Simplex(new_arr);
    }

    @Override
    public IntBox bounding_box() {
        if (this.arr.length == 0) {
            return IntBox.EMPTY;
        }
        if (this.precalculated_bounding_box == null) {
            double llx = 2.147483647E9;
            double lly = 2.147483647E9;
            double urx = -2.147483648E9;
            double ury = -2.147483648E9;
            for (int i = 0; i < this.arr.length; ++i) {
                FloatPoint curr = this.corner_approx(i);
                llx = Math.min(llx, curr.x);
                lly = Math.min(lly, curr.y);
                urx = Math.max(urx, curr.x);
                ury = Math.max(ury, curr.y);
            }
            IntPoint lower_left = new IntPoint((int)Math.floor(llx), (int)Math.floor(lly));
            IntPoint upper_right = new IntPoint((int)Math.ceil(urx), (int)Math.ceil(ury));
            this.precalculated_bounding_box = new IntBox(lower_left, upper_right);
        }
        return this.precalculated_bounding_box;
    }

    @Override
    public IntOctagon bounding_octagon() {
        if (this.precalculated_bounding_octagon == null) {
            double lx = 2.147483647E9;
            double ly = 2.147483647E9;
            double rx = -2.147483648E9;
            double uy = -2.147483648E9;
            double ulx = 2.147483647E9;
            double lrx = -2.147483648E9;
            double llx = 2.147483647E9;
            double urx = -2.147483648E9;
            for (int i = 0; i < this.arr.length; ++i) {
                FloatPoint curr = this.corner_approx(i);
                lx = Math.min(lx, curr.x);
                ly = Math.min(ly, curr.y);
                rx = Math.max(rx, curr.x);
                uy = Math.max(uy, curr.y);
                double tmp = curr.x - curr.y;
                ulx = Math.min(ulx, tmp);
                lrx = Math.max(lrx, tmp);
                tmp = curr.x + curr.y;
                llx = Math.min(llx, tmp);
                urx = Math.max(urx, tmp);
            }
            if (Math.min(lx, ly) < -3.3554432E7 || Math.max(rx, uy) > 3.3554432E7 || Math.min(ulx, llx) < -3.3554432E7 || Math.max(lrx, urx) > 3.3554432E7) {
                return null;
            }
            this.precalculated_bounding_octagon = new IntOctagon((int)Math.floor(lx), (int)Math.floor(ly), (int)Math.ceil(rx), (int)Math.ceil(uy), (int)Math.floor(ulx), (int)Math.ceil(lrx), (int)Math.floor(llx), (int)Math.ceil(urx));
        }
        return this.precalculated_bounding_octagon;
    }

    @Override
    public Simplex bounding_tile() {
        return this;
    }

    @Override
    public RegularTileShape bounding_shape(ShapeBoundingDirections p_dirs) {
        return p_dirs.bounds(this);
    }

    @Override
    public Simplex offset(double p_width) {
        if (p_width == 0.0) {
            return this;
        }
        Line[] new_arr = new Line[this.arr.length];
        for (int i = 0; i < this.arr.length; ++i) {
            new_arr[i] = this.arr[i].translate(-p_width);
        }
        Simplex offset_simplex = new Simplex(new_arr);
        if (p_width < 0.0) {
            offset_simplex = offset_simplex.remove_redundant_lines();
        }
        return offset_simplex;
    }

    @Override
    public Simplex enlarge(double p_offset) {
        if (p_offset == 0.0) {
            return this;
        }
        Simplex offset_simplex = this.offset(p_offset);
        IntOctagon bounding_oct = this.bounding_octagon();
        if (bounding_oct == null) {
            return EMPTY;
        }
        IntOctagon offset_oct = bounding_oct.offset(p_offset);
        return offset_simplex.intersection(offset_oct.to_Simplex());
    }

    public int index_of_right_most_corner(Point p_from_point) {
        Point pole = p_from_point;
        Point right_most_corner = this.corner(0);
        int result = 0;
        for (int i = 1; i < this.arr.length; ++i) {
            Point curr_corner = this.corner(i);
            if (curr_corner.side_of(pole, right_most_corner) != Side.ON_THE_RIGHT) continue;
            right_most_corner = curr_corner;
            result = i;
        }
        return result;
    }

    @Override
    public Simplex intersection(IntBox p_box) {
        return this.intersection(p_box.to_Simplex());
    }

    @Override
    public Simplex intersection(Simplex p_other) {
        if (this.is_empty() || p_other.is_empty()) {
            return EMPTY;
        }
        Object[] new_arr = new Line[this.arr.length + p_other.arr.length];
        System.arraycopy(this.arr, 0, new_arr, 0, this.arr.length);
        System.arraycopy(p_other.arr, 0, new_arr, this.arr.length, p_other.arr.length);
        Arrays.sort(new_arr);
        Simplex result = new Simplex((Line[])new_arr);
        return result.remove_redundant_lines();
    }

    @Override
    public TileShape intersection(TileShape p_other) {
        TileShape result = p_other.intersection(this);
        return result;
    }

    @Override
    public boolean intersects(Shape p_other) {
        return p_other.intersects(this);
    }

    @Override
    public boolean intersects(Simplex p_other) {
        Simplex is = this.intersection(p_other);
        return !is.is_empty();
    }

    @Override
    public int border_line_index(Line p_line) {
        for (int i = 0; i < this.arr.length; ++i) {
            if (!p_line.equals(this.arr[i])) continue;
            return i;
        }
        return -1;
    }

    public Simplex remove_border_line(int p_no) {
        if (p_no < 0 || p_no >= this.arr.length) {
            return this;
        }
        Line[] new_arr = new Line[this.arr.length - 1];
        System.arraycopy(this.arr, 0, new_arr, 0, p_no);
        System.arraycopy(this.arr, p_no + 1, new_arr, p_no, new_arr.length - p_no);
        return new Simplex(new_arr);
    }

    public Simplex(Line[] p_line_arr) {
        this.arr = p_line_arr;
    }

    @Override
    public Simplex to_Simplex() {
        return this;
    }

    @Override
    Simplex intersection(IntOctagon p_other) {
        return this.intersection(p_other.to_Simplex());
    }

    @Override
    public TileShape[] cutout(TileShape p_shape) {
        return p_shape.cutout_from(this);
    }

    public Simplex[] cutout_from(Simplex p_outer_simplex) {
        if (this.dimension() < 2) {
            System.out.println("Simplex.cutout_from only implemented for 2-dim simplex");
            return null;
        }
        Simplex inner_simplex = this.intersection(p_outer_simplex);
        if (inner_simplex.dimension() < 2) {
            Simplex[] result = new Simplex[]{p_outer_simplex};
            return result;
        }
        int inner_corner_count = inner_simplex.arr.length;
        Line[][] division_line_arr = new Line[inner_corner_count][];
        for (int inner_corner_no = 0; inner_corner_no < inner_corner_count; ++inner_corner_no) {
            division_line_arr[inner_corner_no] = inner_simplex.calc_division_lines(inner_corner_no, p_outer_simplex);
            if (division_line_arr[inner_corner_no] != null) continue;
            System.out.println("Simplex.cutout_from: division line is null");
            Simplex[] result = new Simplex[]{p_outer_simplex};
            return result;
        }
        boolean check_cross_first_line = false;
        Line prev_division_line = null;
        Line first_division_line = division_line_arr[0][0];
        IntDirection first_direction = (IntDirection)first_division_line.direction();
        LinkedList<Simplex> result_list = new LinkedList<Simplex>();
        for (int inner_corner_no = 0; inner_corner_no < inner_corner_count; ++inner_corner_no) {
            IntDirection next_dir;
            IntDirection prev_dir;
            Line next_division_line = inner_corner_no == inner_simplex.arr.length - 1 ? division_line_arr[0][0] : division_line_arr[inner_corner_no + 1][0];
            Line[] curr_division_lines = division_line_arr[inner_corner_no];
            if (curr_division_lines.length == 2) {
                IntDirection curr_dir2;
                IntDirection prev_dir2;
                IntDirection curr_dir = (IntDirection)curr_division_lines[0].direction();
                boolean merge_prev_division_line = false;
                boolean merge_first_division_line = false;
                if (prev_division_line != null && curr_dir.determinant(prev_dir2 = (IntDirection)prev_division_line.direction()) > 0.0) {
                    merge_prev_division_line = true;
                }
                if (!check_cross_first_line) {
                    boolean bl = check_cross_first_line = inner_corner_no > 0 && curr_dir.determinant(first_direction) > 0.0;
                }
                if (check_cross_first_line && (curr_dir2 = (IntDirection)curr_division_lines[1].direction()).determinant(first_direction) < 0.0) {
                    merge_first_division_line = true;
                }
                int piece_line_count = 2;
                if (merge_prev_division_line) {
                    ++piece_line_count;
                }
                if (merge_first_division_line) {
                    ++piece_line_count;
                }
                Line[] piece_lines = new Line[piece_line_count];
                piece_lines[0] = new Line(curr_division_lines[1].b, curr_division_lines[1].a);
                piece_lines[1] = curr_division_lines[0];
                int curr_line_no = 1;
                if (merge_prev_division_line) {
                    piece_lines[++curr_line_no] = prev_division_line;
                }
                if (merge_first_division_line) {
                    piece_lines[++curr_line_no] = new Line(first_division_line.b, first_division_line.a);
                }
                Simplex curr_piece = new Simplex(piece_lines);
                result_list.add(curr_piece.intersection(p_outer_simplex));
            }
            boolean merge_next_division_line = !next_division_line.b.equals(next_division_line.a);
            Line last_curr_division_line = curr_division_lines[curr_division_lines.length - 1];
            IntDirection last_curr_dir = (IntDirection)last_curr_division_line.direction();
            boolean merge_last_curr_division_line = !last_curr_division_line.b.equals(last_curr_division_line.a);
            boolean merge_prev_division_line = false;
            boolean merge_first_division_line = false;
            if (prev_division_line != null && last_curr_dir.determinant(prev_dir = (IntDirection)prev_division_line.direction()) > 0.0) {
                merge_prev_division_line = true;
            }
            if (!check_cross_first_line) {
                boolean bl = check_cross_first_line = inner_corner_no > 0 && last_curr_dir.determinant(first_direction) > 0.0 && last_curr_dir.get_vector().scalar_product(first_direction.get_vector()) < 0.0;
            }
            if (check_cross_first_line && (next_dir = (IntDirection)next_division_line.direction()).determinant(first_direction) < 0.0) {
                merge_first_division_line = true;
            }
            int piece_line_count = 1;
            if (merge_next_division_line) {
                ++piece_line_count;
            }
            if (merge_last_curr_division_line) {
                ++piece_line_count;
            }
            if (merge_prev_division_line) {
                ++piece_line_count;
            }
            if (merge_first_division_line) {
                ++piece_line_count;
            }
            Line[] piece_lines = new Line[piece_line_count];
            Line curr_line = inner_simplex.arr[inner_corner_no];
            piece_lines[0] = new Line(curr_line.b, curr_line.a);
            int curr_line_no = 0;
            if (merge_next_division_line) {
                piece_lines[++curr_line_no] = new Line(next_division_line.b, next_division_line.a);
            }
            if (merge_last_curr_division_line) {
                piece_lines[++curr_line_no] = last_curr_division_line;
            }
            if (merge_prev_division_line) {
                piece_lines[++curr_line_no] = prev_division_line;
            }
            if (merge_first_division_line) {
                piece_lines[++curr_line_no] = new Line(first_division_line.b, first_division_line.a);
            }
            Simplex curr_piece = new Simplex(piece_lines);
            result_list.add(curr_piece.intersection(p_outer_simplex));
            next_division_line = prev_division_line;
        }
        Simplex[] result = new Simplex[result_list.size()];
        Iterator it = result_list.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Simplex)it.next();
        }
        return result;
    }

    Simplex[] cutout_from(IntOctagon p_oct) {
        return this.cutout_from(p_oct.to_Simplex());
    }

    Simplex[] cutout_from(IntBox p_box) {
        return this.cutout_from(p_box.to_Simplex());
    }

    Simplex remove_redundant_lines() {
        Line[] line_arr = new Line[this.arr.length];
        int new_length = 1;
        line_arr[0] = this.arr[0];
        Line prev = line_arr[0];
        for (int i = 1; i < this.arr.length; ++i) {
            if (this.arr[i].fast_equals(prev)) continue;
            line_arr[new_length] = this.arr[i];
            prev = line_arr[new_length];
            ++new_length;
        }
        Side[] intersection_sides = new Side[new_length];
        boolean try_again = new_length > 2;
        int index_of_last_removed_line = new_length;
        block1: while (try_again) {
            try_again = false;
            int prev_ind = new_length - 1;
            Line prev_line = line_arr[prev_ind];
            Line curr_line = line_arr[0];
            for (int ind = 0; ind < new_length; ++ind) {
                IntDirection next_dir;
                int next_ind = ind == new_length - 1 ? 0 : ind + 1;
                Line next_line = line_arr[next_ind];
                boolean remove_line = false;
                IntDirection prev_dir = (IntDirection)prev_line.direction();
                double det = prev_dir.determinant(next_dir = (IntDirection)next_line.direction());
                if (det != 0.0) {
                    IntDirection curr_dir;
                    if (intersection_sides[ind] == null) {
                        intersection_sides[ind] = curr_line.side_of_intersection(prev_line, next_line);
                    }
                    if (det > 0.0) {
                        remove_line = intersection_sides[ind] != Side.ON_THE_LEFT;
                    } else if (intersection_sides[ind] == Side.ON_THE_LEFT && prev_dir.determinant(curr_dir = (IntDirection)curr_line.direction()) > 0.0) {
                        new_length = 0;
                        try_again = false;
                        continue block1;
                    }
                } else if (prev_line.side_of(next_line.a) == Side.ON_THE_LEFT) {
                    new_length = 0;
                    try_again = false;
                    continue block1;
                }
                if (remove_line) {
                    try_again = true;
                    --new_length;
                    for (int i = ind; i < new_length; ++i) {
                        line_arr[i] = line_arr[i + 1];
                        intersection_sides[i] = intersection_sides[i + 1];
                    }
                    if (new_length < 3) {
                        try_again = false;
                        continue block1;
                    }
                    if (ind == 0) {
                        prev_ind = new_length - 1;
                    }
                    intersection_sides[prev_ind] = null;
                    next_ind = ind >= new_length ? 0 : ind;
                    intersection_sides[next_ind] = null;
                    index_of_last_removed_line = --ind;
                } else {
                    prev_line = curr_line;
                    prev_ind = ind;
                }
                curr_line = next_line;
                if (!try_again && ind >= index_of_last_removed_line) continue block1;
            }
        }
        if (new_length == 2 && line_arr[0].is_parallel(line_arr[1])) {
            if (line_arr[0].direction().equals(line_arr[1].direction())) {
                if (line_arr[1].side_of(line_arr[0].a) == Side.ON_THE_LEFT) {
                    line_arr[0] = line_arr[1];
                }
                --new_length;
            } else if (line_arr[1].side_of(line_arr[0].a) == Side.ON_THE_LEFT) {
                new_length = 0;
            }
        }
        if (new_length == this.arr.length) {
            return this;
        }
        if (new_length == 0) {
            return EMPTY;
        }
        Line[] result = new Line[new_length];
        System.arraycopy(line_arr, 0, result, 0, new_length);
        return new Simplex(result);
    }

    @Override
    public boolean intersects(IntBox p_box) {
        return this.intersects(p_box.to_Simplex());
    }

    @Override
    public boolean intersects(IntOctagon p_octagon) {
        return this.intersects(p_octagon.to_Simplex());
    }

    @Override
    public boolean intersects(Circle p_circle) {
        return p_circle.intersects(this);
    }

    private Line[] calc_division_lines(int p_inner_corner_no, Simplex p_outer_simplex) {
        boolean is_exact;
        Line curr_inner_line = this.arr[p_inner_corner_no];
        Line prev_inner_line = p_inner_corner_no != 0 ? this.arr[p_inner_corner_no - 1] : this.arr[this.arr.length - 1];
        FloatPoint intersection = curr_inner_line.intersection_approx(prev_inner_line);
        if (intersection.x >= 2.147483647E9) {
            System.out.println("Simplex.calc_division_lines: intersection expexted");
            return null;
        }
        IntPoint inner_corner = intersection.round();
        double c_tolerance = 1.0E-4;
        boolean bl = is_exact = Math.abs((double)inner_corner.x - intersection.x) < c_tolerance && Math.abs((double)inner_corner.y - intersection.y) < c_tolerance;
        if (!is_exact) {
            Line[] result = new Line[]{prev_inner_line};
            return result;
        }
        IntDirection first_projection_dir = Direction.NULL;
        IntDirection second_projection_dir = Direction.NULL;
        IntDirection prev_inner_dir = (IntDirection)prev_inner_line.direction().opposite();
        IntDirection next_inner_dir = (IntDirection)curr_inner_line.direction();
        int outer_line_no = 0;
        double min_distance = 2.147483647E9;
        for (int ind = 0; ind < p_outer_simplex.arr.length; ++ind) {
            boolean projection_visible;
            Line outer_line = p_outer_simplex.arr[outer_line_no];
            IntDirection curr_projection_dir = (IntDirection)inner_corner.perpendicular_direction(outer_line);
            if (curr_projection_dir == Direction.NULL) {
                Line[] result = new Line[]{new Line((Point)inner_corner, inner_corner)};
                return result;
            }
            boolean bl2 = projection_visible = prev_inner_dir.determinant(curr_projection_dir) >= 0.0;
            if (projection_visible) {
                double curr_distance = Math.abs(outer_line.signed_distance(inner_corner.to_float()));
                boolean second_division_necessary = curr_projection_dir.determinant(next_inner_dir) < 0.0;
                IntDirection curr_second_projection_dir = curr_projection_dir;
                if (second_division_necessary) {
                    boolean second_projection_visible = false;
                    int tmp_outer_line_no = outer_line_no;
                    while (!second_projection_visible) {
                        tmp_outer_line_no = tmp_outer_line_no == p_outer_simplex.arr.length - 1 ? 0 : ++tmp_outer_line_no;
                        curr_second_projection_dir = (IntDirection)inner_corner.perpendicular_direction(p_outer_simplex.arr[tmp_outer_line_no]);
                        if (curr_second_projection_dir == Direction.NULL) {
                            Line[] result = new Line[]{new Line((Point)inner_corner, inner_corner)};
                            return result;
                        }
                        if (curr_projection_dir.determinant(curr_second_projection_dir) < 0.0) {
                            curr_distance = 2.147483647E9;
                            break;
                        }
                        second_projection_visible = curr_second_projection_dir.determinant(next_inner_dir) >= 0.0;
                    }
                    curr_distance += Math.abs(p_outer_simplex.arr[tmp_outer_line_no].signed_distance(inner_corner.to_float()));
                }
                if (curr_distance < min_distance) {
                    min_distance = curr_distance;
                    first_projection_dir = curr_projection_dir;
                    second_projection_dir = curr_second_projection_dir;
                }
            }
            if (outer_line_no == p_outer_simplex.arr.length - 1) {
                outer_line_no = 0;
                continue;
            }
            ++outer_line_no;
        }
        if (min_distance == 2.147483647E9) {
            System.out.println("Simplex.calc_division_lines: division not found");
            return null;
        }
        Line[] result = first_projection_dir.equals(second_projection_dir) ? new Line[]{new Line((Point)inner_corner, first_projection_dir)} : new Line[]{new Line((Point)inner_corner, first_projection_dir), new Line((Point)inner_corner, second_projection_dir)};
        return result;
    }
}

