/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import geometry.planar.FloatLine;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntPoint;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.Shape;
import geometry.planar.Side;
import geometry.planar.Vector;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class PolylineShape
implements Shape,
Serializable {
    public abstract boolean corner_is_bounded(int var1);

    public abstract int border_line_count();

    public abstract Point corner(int var1);

    @Override
    public abstract PolylineShape turn_90_degree(int var1, IntPoint var2);

    @Override
    public abstract PolylineShape rotate_approx(double var1, FloatPoint var3);

    @Override
    public abstract PolylineShape mirror_horizontal(IntPoint var1);

    @Override
    public abstract PolylineShape mirror_vertical(IntPoint var1);

    @Override
    public abstract PolylineShape translate_by(Vector var1);

    public Point[] bounded_corners() {
        int corner_count = this.border_line_count();
        LinkedList<Point> result_list = new LinkedList<Point>();
        for (int i = 0; i < corner_count; ++i) {
            if (!this.corner_is_bounded(i)) continue;
            result_list.add(this.corner(i));
        }
        Point[] result = new Point[result_list.size()];
        Iterator it = result_list.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Point)it.next();
        }
        return result;
    }

    public FloatPoint corner_approx(int p_no) {
        return this.corner(p_no).to_float();
    }

    @Override
    public FloatPoint[] corner_approx_arr() {
        int corner_count = this.border_line_count();
        FloatPoint[] result = new FloatPoint[corner_count];
        for (int i = 0; i < corner_count; ++i) {
            result[i] = this.corner_approx(i);
        }
        return result;
    }

    public int equals_corner(Point p_point) {
        for (int i = 0; i < this.border_line_count(); ++i) {
            if (!p_point.equals(this.corner(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double circumference() {
        if (!this.is_bounded()) {
            return 2.147483647E9;
        }
        int corner_count = this.border_line_count();
        double result = 0.0;
        FloatPoint prev_corner = this.corner_approx(corner_count - 1);
        for (int i = 0; i < corner_count; ++i) {
            FloatPoint curr_corner = this.corner_approx(i);
            result += curr_corner.distance(prev_corner);
            prev_corner = curr_corner;
        }
        return result;
    }

    @Override
    public FloatPoint centre_of_gravity() {
        int corner_count = this.border_line_count();
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < corner_count; ++i) {
            FloatPoint curr_point = this.corner_approx(i);
            x += curr_point.x;
            y += curr_point.y;
        }
        return new FloatPoint(x /= (double)corner_count, y /= (double)corner_count);
    }

    @Override
    public boolean is_contained_in(IntBox p_box) {
        return p_box.contains(this.bounding_box());
    }

    public int index_of_left_most_corner(FloatPoint p_from_point) {
        FloatPoint left_most_corner = this.corner_approx(0);
        int corner_count = this.border_line_count();
        int result = 0;
        for (int i = 1; i < corner_count; ++i) {
            FloatPoint curr_corner = this.corner_approx(i);
            if (curr_corner.side_of(p_from_point, left_most_corner) != Side.ON_THE_LEFT) continue;
            left_most_corner = curr_corner;
            result = i;
        }
        return result;
    }

    public int index_of_right_most_corner(FloatPoint p_from_point) {
        FloatPoint right_most_corner = this.corner_approx(0);
        int corner_count = this.border_line_count();
        int result = 0;
        for (int i = 1; i < corner_count; ++i) {
            FloatPoint curr_corner = this.corner_approx(i);
            if (curr_corner.side_of(p_from_point, right_most_corner) != Side.ON_THE_RIGHT) continue;
            right_most_corner = curr_corner;
            result = i;
        }
        return result;
    }

    public FloatLine polar_line_segment(FloatPoint p_from_point) {
        if (this.is_empty()) {
            System.out.println("PolylineShape.polar_line_segment: shape is empty");
            return null;
        }
        FloatPoint left_most_corner = this.corner_approx(0);
        FloatPoint right_most_corner = this.corner_approx(0);
        int corner_count = this.border_line_count();
        for (int i = 1; i < corner_count; ++i) {
            FloatPoint curr_corner = this.corner_approx(i);
            if (curr_corner.side_of(p_from_point, right_most_corner) == Side.ON_THE_RIGHT) {
                right_most_corner = curr_corner;
            }
            if (curr_corner.side_of(p_from_point, left_most_corner) != Side.ON_THE_LEFT) continue;
            left_most_corner = curr_corner;
        }
        return new FloatLine(left_most_corner, right_most_corner);
    }

    public abstract Line border_line(int var1);

    public int prev_no(int p_no) {
        int result = p_no == 0 ? this.border_line_count() - 1 : p_no - 1;
        return result;
    }

    public int next_no(int p_no) {
        int result = p_no == this.border_line_count() - 1 ? 0 : p_no + 1;
        return result;
    }

    @Override
    public PolylineShape get_border() {
        return this;
    }

    @Override
    public Shape[] get_holes() {
        return new Shape[0];
    }

    public boolean intersects(Line p_line) {
        Side side_of_first_corner = p_line.side_of(this.corner(0));
        if (side_of_first_corner == Side.COLLINEAR) {
            return true;
        }
        for (int i = 1; i < this.border_line_count(); ++i) {
            if (p_line.side_of(this.corner(i)) == side_of_first_corner) continue;
            return true;
        }
        return false;
    }

    public Point left_most_corner(Point p_from_point) {
        if (this.is_empty()) {
            return p_from_point;
        }
        Point result = this.corner(0);
        int corner_count = this.border_line_count();
        for (int i = 1; i < corner_count; ++i) {
            Point curr_corner = this.corner(i);
            if (curr_corner.side_of(p_from_point, result) != Side.ON_THE_LEFT) continue;
            result = curr_corner;
        }
        return result;
    }

    public Point right_most_corner(Point p_from_point) {
        if (this.is_empty()) {
            return p_from_point;
        }
        Point result = this.corner(0);
        int corner_count = this.border_line_count();
        for (int i = 1; i < corner_count; ++i) {
            Point curr_corner = this.corner(i);
            if (curr_corner.side_of(p_from_point, result) != Side.ON_THE_RIGHT) continue;
            result = curr_corner;
        }
        return result;
    }
}

