/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import datastructures.Stoppable;
import geometry.planar.Area;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.Point;
import geometry.planar.PolylineShape;
import geometry.planar.TileShape;
import geometry.planar.Vector;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class PolylineArea
implements Area,
Serializable {
    final PolylineShape border_shape;
    final PolylineShape[] hole_arr;
    private transient TileShape[] precalculated_convex_pieces = null;

    public PolylineArea(PolylineShape p_border_shape, PolylineShape[] p_hole_arr) {
        this.border_shape = p_border_shape;
        this.hole_arr = p_hole_arr;
    }

    @Override
    public int dimension() {
        return this.border_shape.dimension();
    }

    @Override
    public boolean is_bounded() {
        return this.border_shape.is_bounded();
    }

    @Override
    public boolean is_empty() {
        return this.border_shape.is_empty();
    }

    @Override
    public boolean is_contained_in(IntBox p_box) {
        return this.border_shape.is_contained_in(p_box);
    }

    @Override
    public PolylineShape get_border() {
        return this.border_shape;
    }

    public PolylineShape[] get_holes() {
        return this.hole_arr;
    }

    @Override
    public IntBox bounding_box() {
        return this.border_shape.bounding_box();
    }

    @Override
    public IntOctagon bounding_octagon() {
        return this.border_shape.bounding_octagon();
    }

    @Override
    public boolean contains(FloatPoint p_point) {
        if (!this.border_shape.contains(p_point)) {
            return false;
        }
        for (int i = 0; i < this.hole_arr.length; ++i) {
            if (!this.hole_arr[i].contains(p_point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Point p_point) {
        if (!this.border_shape.contains(p_point)) {
            return false;
        }
        for (int i = 0; i < this.hole_arr.length; ++i) {
            if (!this.hole_arr[i].contains_inside(p_point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FloatPoint nearest_point_approx(FloatPoint p_from_point) {
        double min_dist = Double.MAX_VALUE;
        FloatPoint result = null;
        TileShape[] convex_shapes = this.split_to_convex();
        for (int i = 0; i < convex_shapes.length; ++i) {
            FloatPoint curr_nearest_point = convex_shapes[i].nearest_point_approx(p_from_point);
            double curr_dist = curr_nearest_point.distance_square(p_from_point);
            if (!(curr_dist < min_dist)) continue;
            min_dist = curr_dist;
            result = curr_nearest_point;
        }
        return result;
    }

    @Override
    public PolylineArea translate_by(Vector p_vector) {
        if (p_vector.equals(Vector.ZERO)) {
            return this;
        }
        PolylineShape translated_border = this.border_shape.translate_by(p_vector);
        PolylineShape[] translated_holes = new PolylineShape[this.hole_arr.length];
        for (int i = 0; i < this.hole_arr.length; ++i) {
            translated_holes[i] = this.hole_arr[i].translate_by(p_vector);
        }
        return new PolylineArea(translated_border, translated_holes);
    }

    @Override
    public FloatPoint[] corner_approx_arr() {
        int corner_count = this.border_shape.border_line_count();
        for (int i = 0; i < this.hole_arr.length; ++i) {
            corner_count += this.hole_arr[i].border_line_count();
        }
        FloatPoint[] result = new FloatPoint[corner_count];
        FloatPoint[] curr_corner_arr = this.border_shape.corner_approx_arr();
        System.arraycopy(curr_corner_arr, 0, result, 0, curr_corner_arr.length);
        int dest_pos = curr_corner_arr.length;
        for (int i = 0; i < this.hole_arr.length; ++i) {
            curr_corner_arr = this.hole_arr[i].corner_approx_arr();
            System.arraycopy(curr_corner_arr, 0, result, dest_pos, curr_corner_arr.length);
            dest_pos += curr_corner_arr.length;
        }
        return result;
    }

    @Override
    public TileShape[] split_to_convex() {
        return this.split_to_convex(null);
    }

    public TileShape[] split_to_convex(Stoppable p_stoppable_thread) {
        if (this.precalculated_convex_pieces == null) {
            int i;
            TileShape[] convex_border_pieces = this.border_shape.split_to_convex();
            if (convex_border_pieces == null) {
                return null;
            }
            LinkedList<TileShape> curr_piece_list = new LinkedList<TileShape>();
            for (i = 0; i < convex_border_pieces.length; ++i) {
                curr_piece_list.add(convex_border_pieces[i]);
            }
            for (i = 0; i < this.hole_arr.length; ++i) {
                if (this.hole_arr[i].dimension() < 2) {
                    System.out.println("PolylineArea. split_to_convex: dimennsion 2 for hole expected");
                    continue;
                }
                TileShape[] convex_hole_pieces = this.hole_arr[i].split_to_convex();
                if (convex_hole_pieces == null) {
                    return null;
                }
                for (int j = 0; j < convex_hole_pieces.length; ++j) {
                    TileShape curr_hole_piece = convex_hole_pieces[j];
                    LinkedList<TileShape> new_piece_list = new LinkedList<TileShape>();
                    Iterator it = curr_piece_list.iterator();
                    while (it.hasNext()) {
                        if (p_stoppable_thread != null && p_stoppable_thread.is_stop_requested()) {
                            return null;
                        }
                        TileShape curr_divide_piece = (TileShape)it.next();
                        PolylineArea.cutout_hole_piece(curr_divide_piece, curr_hole_piece, new_piece_list);
                    }
                    curr_piece_list = new_piece_list;
                }
            }
            this.precalculated_convex_pieces = new TileShape[curr_piece_list.size()];
            Iterator it = curr_piece_list.iterator();
            for (int i2 = 0; i2 < this.precalculated_convex_pieces.length; ++i2) {
                this.precalculated_convex_pieces[i2] = (TileShape)it.next();
            }
        }
        return this.precalculated_convex_pieces;
    }

    @Override
    public PolylineArea turn_90_degree(int p_factor, IntPoint p_pole) {
        PolylineShape new_border = this.border_shape.turn_90_degree(p_factor, p_pole);
        PolylineShape[] new_hole_arr = new PolylineShape[this.hole_arr.length];
        for (int i = 0; i < new_hole_arr.length; ++i) {
            new_hole_arr[i] = this.hole_arr[i].turn_90_degree(p_factor, p_pole);
        }
        return new PolylineArea(new_border, new_hole_arr);
    }

    @Override
    public PolylineArea rotate_approx(double p_angle, FloatPoint p_pole) {
        PolylineShape new_border = this.border_shape.rotate_approx(p_angle, p_pole);
        PolylineShape[] new_hole_arr = new PolylineShape[this.hole_arr.length];
        for (int i = 0; i < new_hole_arr.length; ++i) {
            new_hole_arr[i] = this.hole_arr[i].rotate_approx(p_angle, p_pole);
        }
        return new PolylineArea(new_border, new_hole_arr);
    }

    @Override
    public PolylineArea mirror_vertical(IntPoint p_pole) {
        PolylineShape new_border = this.border_shape.mirror_vertical(p_pole);
        PolylineShape[] new_hole_arr = new PolylineShape[this.hole_arr.length];
        for (int i = 0; i < new_hole_arr.length; ++i) {
            new_hole_arr[i] = this.hole_arr[i].mirror_vertical(p_pole);
        }
        return new PolylineArea(new_border, new_hole_arr);
    }

    @Override
    public PolylineArea mirror_horizontal(IntPoint p_pole) {
        PolylineShape new_border = this.border_shape.mirror_horizontal(p_pole);
        PolylineShape[] new_hole_arr = new PolylineShape[this.hole_arr.length];
        for (int i = 0; i < new_hole_arr.length; ++i) {
            new_hole_arr[i] = this.hole_arr[i].mirror_horizontal(p_pole);
        }
        return new PolylineArea(new_border, new_hole_arr);
    }

    private static void cutout_hole_piece(TileShape p_divide_piece, TileShape p_hole_piece, Collection<TileShape> p_result_pieces) {
        TileShape[] result_pieces = p_divide_piece.cutout(p_hole_piece);
        for (int i = 0; i < result_pieces.length; ++i) {
            TileShape curr_piece = result_pieces[i];
            if (curr_piece.dimension() != 2) continue;
            p_result_pieces.add(curr_piece);
        }
    }
}

