/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import geometry.planar.Direction;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.Line;
import geometry.planar.LineSegment;
import geometry.planar.Point;
import geometry.planar.Polygon;
import geometry.planar.Side;
import geometry.planar.TileShape;
import geometry.planar.Vector;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

public class Polyline
implements Serializable {
    public final Line[] arr;
    private transient FloatPoint[] precalculated_float_corners = null;
    private transient Point[] precalculated_corners = null;
    private transient IntBox precalculated_bounding_box = null;
    private static final boolean USE_BOUNDING_OCTAGON_FOR_OFFSET_SHAPES = true;

    public Polyline(Polygon p_polygon) {
        Point[] point_arr = p_polygon.corner_array();
        if (point_arr.length < 2) {
            System.out.println("Polyline: must contain at least 2 different points");
            this.arr = new Line[0];
            return;
        }
        this.arr = new Line[point_arr.length + 1];
        for (int i = 1; i < point_arr.length; ++i) {
            this.arr[i] = new Line(point_arr[i - 1], point_arr[i]);
        }
        Direction dir = Direction.get_instance(point_arr[0], point_arr[1]);
        this.arr[0] = Line.get_instance(point_arr[0], dir.turn_45_degree(2));
        dir = Direction.get_instance(point_arr[point_arr.length - 1], point_arr[point_arr.length - 2]);
        this.arr[point_arr.length] = Line.get_instance(point_arr[point_arr.length - 1], dir.turn_45_degree(2));
    }

    public Polyline(Point[] p_points) {
        this(new Polygon(p_points));
    }

    public Polyline(Point p_from_corner, Point p_to_corner) {
        if (p_from_corner.equals(p_to_corner)) {
            this.arr = new Line[0];
            return;
        }
        this.arr = new Line[3];
        Direction dir = Direction.get_instance(p_from_corner, p_to_corner);
        this.arr[0] = Line.get_instance(p_from_corner, dir.turn_45_degree(2));
        this.arr[1] = new Line(p_from_corner, p_to_corner);
        dir = Direction.get_instance(p_from_corner, p_to_corner);
        this.arr[2] = Line.get_instance(p_to_corner, dir.turn_45_degree(2));
    }

    public Polyline(Line[] p_line_arr) {
        Line[] lines = Polyline.remove_consecutive_parallel_lines(p_line_arr);
        lines = Polyline.remove_overlaps(lines);
        if (lines.length < 3) {
            this.arr = new Line[0];
            return;
        }
        this.precalculated_float_corners = new FloatPoint[lines.length - 1];
        for (int i = 1; i < lines.length - 1; ++i) {
            Direction d1;
            Direction d0;
            Side side1;
            this.precalculated_float_corners[i] = lines[i].intersection_approx(lines[i + 1]);
            Side side_of_line = lines[i - 1].side_of(this.precalculated_float_corners[i]);
            if (side_of_line == Side.COLLINEAR || (side1 = (d0 = lines[i - 1].direction()).side_of(d1 = lines[i].direction())) == side_of_line) continue;
            lines[i] = lines[i].opposite();
        }
        this.arr = lines;
    }

    public int corner_count() {
        return this.arr.length - 1;
    }

    public boolean is_empty() {
        return this.arr.length < 3;
    }

    public boolean is_point() {
        if (this.arr.length < 3) {
            return true;
        }
        Point first_corner = this.corner(0);
        for (int i = 1; i < this.arr.length - 1; ++i) {
            if (this.corner(i).equals(first_corner)) continue;
            return false;
        }
        return true;
    }

    public boolean is_orthogonal() {
        for (int i = 0; i < this.arr.length; ++i) {
            if (this.arr[i].is_orthogonal()) continue;
            return false;
        }
        return true;
    }

    public boolean is_multiple_of_45_degree() {
        for (int i = 0; i < this.arr.length; ++i) {
            if (this.arr[i].is_multiple_of_45_degree()) continue;
            return false;
        }
        return true;
    }

    public Point first_corner() {
        return this.corner(0);
    }

    public Point last_corner() {
        return this.corner(this.arr.length - 2);
    }

    public Point[] corner_arr() {
        if (this.arr.length < 2) {
            return new Point[0];
        }
        if (this.precalculated_corners == null) {
            this.precalculated_corners = new Point[this.arr.length - 1];
        }
        for (int i = 0; i < this.precalculated_corners.length; ++i) {
            if (this.precalculated_corners[i] != null) continue;
            this.precalculated_corners[i] = this.arr[i].intersection(this.arr[i + 1]);
        }
        return this.precalculated_corners;
    }

    public FloatPoint[] corner_approx_arr() {
        if (this.arr.length < 2) {
            return new FloatPoint[0];
        }
        if (this.precalculated_float_corners == null) {
            this.precalculated_float_corners = new FloatPoint[this.arr.length - 1];
        }
        for (int i = 0; i < this.precalculated_float_corners.length; ++i) {
            if (this.precalculated_float_corners[i] != null) continue;
            this.precalculated_float_corners[i] = this.arr[i].intersection_approx(this.arr[i + 1]);
        }
        return this.precalculated_float_corners;
    }

    public FloatPoint corner_approx(int p_no) {
        int no;
        if (p_no < 0) {
            System.out.println("Polyline.corner_approx: p_no is < 0");
            no = 0;
        } else if (p_no >= this.arr.length - 1) {
            System.out.println("Polyline.corner_approx: p_no must be less than arr.length - 1");
            no = this.arr.length - 2;
        } else {
            no = p_no;
        }
        if (this.precalculated_float_corners == null) {
            this.precalculated_float_corners = new FloatPoint[this.arr.length - 1];
            for (int i = 0; i < this.precalculated_float_corners.length; ++i) {
                this.precalculated_float_corners[i] = null;
            }
        }
        if (this.precalculated_float_corners[no] == null) {
            this.precalculated_float_corners[no] = this.arr[no].intersection_approx(this.arr[no + 1]);
        }
        return this.precalculated_float_corners[no];
    }

    public Point corner(int p_no) {
        int no;
        if (this.arr.length < 2) {
            System.out.println("Polyline.corner: arr.length is < 2");
            return null;
        }
        if (p_no < 0) {
            System.out.println("Polyline.corner: p_no is < 0");
            no = 0;
        } else if (p_no >= this.arr.length - 1) {
            System.out.println("Polyline.corner: p_no must be less than arr.length - 1");
            no = this.arr.length - 2;
        } else {
            no = p_no;
        }
        if (this.precalculated_corners == null) {
            this.precalculated_corners = new Point[this.arr.length - 1];
            for (int i = 0; i < this.precalculated_corners.length; ++i) {
                this.precalculated_corners[i] = null;
            }
        }
        if (this.precalculated_corners[no] == null) {
            this.precalculated_corners[no] = this.arr[no].intersection(this.arr[no + 1]);
        }
        return this.precalculated_corners[no];
    }

    public Polyline reverse() {
        Line[] reversed_lines = new Line[this.arr.length];
        for (int i = 0; i < this.arr.length; ++i) {
            reversed_lines[i] = this.arr[this.arr.length - i - 1].opposite();
        }
        return new Polyline(reversed_lines);
    }

    public double length_approx(int p_from_corner, int p_to_corner) {
        int from_corner = Math.max(p_from_corner, 0);
        int to_corner = Math.min(p_to_corner, this.arr.length - 2);
        double result = 0.0;
        for (int i = from_corner; i < to_corner; ++i) {
            result += this.corner_approx(i + 1).distance(this.corner_approx(i));
        }
        return result;
    }

    public double length_approx() {
        return this.length_approx(0, this.arr.length - 2);
    }

    public TileShape[] offset_shapes(int p_half_width) {
        return this.offset_shapes(p_half_width, 0, this.arr.length - 1);
    }

    public TileShape[] offset_shapes(int p_half_width, int p_from_no, int p_to_no) {
        int from_no = Math.max(p_from_no, 0);
        int to_no = Math.min(p_to_no, this.arr.length - 1);
        int shape_count = Math.max(to_no - from_no - 1, 0);
        TileShape[] shape_arr = new TileShape[shape_count];
        if (shape_count == 0) {
            return shape_arr;
        }
        Vector prev_dir = this.arr[from_no].direction().get_vector();
        Vector curr_dir = this.arr[from_no + 1].direction().get_vector();
        for (int i = from_no + 1; i < to_no; ++i) {
            int j;
            Vector next_dir = this.arr[i + 1].direction().get_vector();
            Line[] lines = new Line[4];
            lines[0] = this.arr[i].translate(-p_half_width);
            Side next_dir_from_curr_dir = next_dir.side_of(curr_dir);
            lines[1] = next_dir_from_curr_dir == Side.ON_THE_LEFT ? this.arr[i + 1].translate(-p_half_width) : this.arr[i + 1].opposite().translate(-p_half_width);
            lines[2] = this.arr[i].opposite().translate(-p_half_width);
            Side curr_dir_from_prev_dir = curr_dir.side_of(prev_dir);
            lines[3] = curr_dir_from_prev_dir == Side.ON_THE_LEFT ? this.arr[i - 1].translate(-p_half_width) : this.arr[i - 1].opposite().translate(-p_half_width);
            FloatPoint corner_to_check = null;
            Line curr_line = lines[1];
            Line check_line = null;
            check_line = next_dir_from_curr_dir == Side.ON_THE_LEFT ? lines[2] : lines[0];
            FloatPoint check_distance_corner = this.corner_approx(i);
            double check_dist_square = 2.0 * (double)p_half_width * (double)p_half_width;
            LinkedList<Line> cut_dog_ear_lines = new LinkedList<Line>();
            Vector tmp_curr_dir = next_dir;
            boolean direction_changed = false;
            for (j = i + 2; j < this.arr.length - 1 && !(this.corner_approx(j - 1).distance_square(check_distance_corner) > check_dist_square); ++j) {
                if (!direction_changed) {
                    corner_to_check = curr_line.intersection_approx(check_line);
                }
                Vector tmp_next_dir = this.arr[j].direction().get_vector();
                Line next_border_line = null;
                Side tmp_next_dir_from_tmp_curr_dir = tmp_next_dir.side_of(tmp_curr_dir);
                boolean bl = direction_changed = tmp_next_dir_from_tmp_curr_dir != next_dir_from_curr_dir;
                if (direction_changed) continue;
                next_border_line = tmp_next_dir_from_tmp_curr_dir == Side.ON_THE_LEFT ? this.arr[j].translate(-p_half_width) : this.arr[j].opposite().translate(-p_half_width);
                if (next_border_line.side_of(corner_to_check) == Side.ON_THE_LEFT && next_border_line.side_of(this.corner(i)) == Side.ON_THE_RIGHT && next_border_line.side_of(this.corner(i - 1)) == Side.ON_THE_RIGHT) {
                    cut_dog_ear_lines.add(next_border_line);
                }
                tmp_curr_dir = tmp_next_dir;
                curr_line = next_border_line;
            }
            check_distance_corner = this.corner_approx(i - 1);
            check_line = curr_dir_from_prev_dir == Side.ON_THE_LEFT ? lines[2] : lines[0];
            curr_line = lines[3];
            tmp_curr_dir = prev_dir;
            direction_changed = false;
            for (j = i - 2; j >= 1 && !(this.corner_approx(j).distance_square(check_distance_corner) > check_dist_square); --j) {
                if (!direction_changed) {
                    corner_to_check = curr_line.intersection_approx(check_line);
                }
                Vector tmp_prev_dir = this.arr[j].direction().get_vector();
                Line prev_border_line = null;
                Side tmp_curr_dir_from_tmp_prev_dir = tmp_curr_dir.side_of(tmp_prev_dir);
                boolean bl = direction_changed = tmp_curr_dir_from_tmp_prev_dir != curr_dir_from_prev_dir;
                if (direction_changed) continue;
                prev_border_line = tmp_curr_dir.side_of(tmp_prev_dir) == Side.ON_THE_LEFT ? this.arr[j].translate(-p_half_width) : this.arr[j].opposite().translate(-p_half_width);
                if (prev_border_line.side_of(corner_to_check) == Side.ON_THE_LEFT && prev_border_line.side_of(this.corner(i)) == Side.ON_THE_RIGHT && prev_border_line.side_of(this.corner(i - 1)) == Side.ON_THE_RIGHT) {
                    cut_dog_ear_lines.add(prev_border_line);
                }
                tmp_curr_dir = tmp_prev_dir;
                curr_line = prev_border_line;
            }
            TileShape s1 = TileShape.get_instance(lines);
            int cut_line_count = cut_dog_ear_lines.size();
            if (cut_line_count > 0) {
                Line[] cut_lines = new Line[cut_line_count];
                Iterator it = cut_dog_ear_lines.iterator();
                for (int j2 = 0; j2 < cut_line_count; ++j2) {
                    cut_lines[j2] = (Line)it.next();
                }
                s1 = s1.intersection(TileShape.get_instance(cut_lines));
            }
            int curr_shape_no = i - from_no - 1;
            IntOctagon surr_oct = this.bounding_octagon(i - 1, i);
            IntOctagon bounding_shape = surr_oct.offset(p_half_width);
            shape_arr[curr_shape_no] = bounding_shape.intersection_with_simplify(s1);
            if (shape_arr[curr_shape_no].is_empty()) {
                System.out.println("offset_shapes: shape is empty");
            }
            prev_dir = curr_dir;
            curr_dir = next_dir;
        }
        return shape_arr;
    }

    public TileShape offset_shape(int p_half_width, int p_no) {
        if (p_no < 0 || p_no > this.arr.length - 3) {
            System.out.println("Polyline.offset_shape: p_no out of range");
            return null;
        }
        TileShape[] result = this.offset_shapes(p_half_width, p_no, p_no + 2);
        return result[0];
    }

    public IntBox offset_box(int p_half_width, int p_no) {
        LineSegment curr_line_segment = new LineSegment(this, p_no + 1);
        IntBox result = curr_line_segment.bounding_box().offset(p_half_width);
        return result;
    }

    public Polyline translate_by(Vector p_vector) {
        if (p_vector.equals(Vector.ZERO)) {
            return this;
        }
        Line[] new_arr = new Line[this.arr.length];
        for (int i = 0; i < new_arr.length; ++i) {
            new_arr[i] = this.arr[i].translate_by(p_vector);
        }
        return new Polyline(new_arr);
    }

    public Polyline turn_90_degree(int p_factor, IntPoint p_pole) {
        Line[] new_arr = new Line[this.arr.length];
        for (int i = 0; i < new_arr.length; ++i) {
            new_arr[i] = this.arr[i].turn_90_degree(p_factor, p_pole);
        }
        return new Polyline(new_arr);
    }

    public Polyline rotate_approx(double p_angle, FloatPoint p_pole) {
        if (p_angle == 0.0) {
            return this;
        }
        Point[] new_corners = new IntPoint[this.corner_count()];
        for (int i = 0; i < new_corners.length; ++i) {
            new_corners[i] = this.corner_approx(i).rotate(p_angle, p_pole).round();
        }
        return new Polyline(new_corners);
    }

    public Polyline mirror_vertical(IntPoint p_pole) {
        Line[] new_arr = new Line[this.arr.length];
        for (int i = 0; i < new_arr.length; ++i) {
            new_arr[i] = this.arr[i].mirror_vertical(p_pole);
        }
        return new Polyline(new_arr);
    }

    public Polyline mirror_horizontal(IntPoint p_pole) {
        Line[] new_arr = new Line[this.arr.length];
        for (int i = 0; i < new_arr.length; ++i) {
            new_arr[i] = this.arr[i].mirror_horizontal(p_pole);
        }
        return new Polyline(new_arr);
    }

    public IntBox bounding_box(int p_from_corner_no, int p_to_corner_no) {
        double urx;
        double llx;
        int from_corner_no = Math.max(p_from_corner_no, 0);
        int to_corner_no = Math.min(p_to_corner_no, this.arr.length - 2);
        double lly = llx = 2.147483647E9;
        double ury = urx = -2.147483648E9;
        for (int i = from_corner_no; i <= to_corner_no; ++i) {
            FloatPoint curr_corner = this.corner_approx(i);
            llx = Math.min(llx, curr_corner.x);
            lly = Math.min(lly, curr_corner.y);
            urx = Math.max(urx, curr_corner.x);
            ury = Math.max(ury, curr_corner.y);
        }
        IntPoint lower_left = new IntPoint((int)Math.floor(llx), (int)Math.floor(lly));
        IntPoint upper_right = new IntPoint((int)Math.ceil(urx), (int)Math.ceil(ury));
        return new IntBox(lower_left, upper_right);
    }

    public IntBox bounding_box() {
        if (this.precalculated_bounding_box == null) {
            this.precalculated_bounding_box = this.bounding_box(0, this.corner_count() - 1);
        }
        return this.precalculated_bounding_box;
    }

    public IntOctagon bounding_octagon(int p_from_corner_no, int p_to_corner_no) {
        int from_corner_no = Math.max(p_from_corner_no, 0);
        int to_corner_no = Math.min(p_to_corner_no, this.arr.length - 2);
        double lx = 2.147483647E9;
        double ly = 2.147483647E9;
        double rx = -2.147483648E9;
        double uy = -2.147483648E9;
        double ulx = 2.147483647E9;
        double lrx = -2.147483648E9;
        double llx = 2.147483647E9;
        double urx = -2.147483648E9;
        for (int i = from_corner_no; i <= to_corner_no; ++i) {
            FloatPoint curr = this.corner_approx(i);
            lx = Math.min(lx, curr.x);
            ly = Math.min(ly, curr.y);
            rx = Math.max(rx, curr.x);
            uy = Math.max(uy, curr.y);
            double tmp = curr.x - curr.y;
            ulx = Math.min(ulx, tmp);
            lrx = Math.max(lrx, tmp);
            tmp = curr.x + curr.y;
            llx = Math.min(llx, tmp);
            urx = Math.max(urx, tmp);
        }
        IntOctagon surrounding_octagon = new IntOctagon((int)Math.floor(lx), (int)Math.floor(ly), (int)Math.ceil(rx), (int)Math.ceil(uy), (int)Math.floor(ulx), (int)Math.ceil(lrx), (int)Math.floor(llx), (int)Math.ceil(urx));
        return surrounding_octagon;
    }

    public FloatPoint nearest_point_approx(FloatPoint p_from_point) {
        double min_distance = Double.MAX_VALUE;
        FloatPoint nearest_point = null;
        FloatPoint[] corners = this.corner_approx_arr();
        for (int i = 0; i < corners.length; ++i) {
            double curr_distance = corners[i].distance(p_from_point);
            if (!(curr_distance < min_distance)) continue;
            min_distance = curr_distance;
            nearest_point = corners[i];
        }
        double c_tolerance = 1.0;
        for (int i = 1; i < this.arr.length - 1; ++i) {
            FloatPoint projection = p_from_point.projection_approx(this.arr[i]);
            double curr_distance = projection.distance(p_from_point);
            if (!(curr_distance < min_distance)) continue;
            double segment_length = corners[i].distance(corners[i - 1]);
            if (!(projection.distance(corners[i]) + projection.distance(corners[i - 1]) < segment_length + 1.0)) continue;
            min_distance = curr_distance;
            nearest_point = projection;
        }
        return nearest_point;
    }

    public double distance(FloatPoint p_from_point) {
        double result = p_from_point.distance(this.nearest_point_approx(p_from_point));
        return result;
    }

    public Polyline combine(Polyline p_other) {
        boolean combine_other_at_start;
        boolean combine_at_start;
        if (p_other == null || this.arr.length < 3 || p_other.arr.length < 3) {
            return this;
        }
        if (this.first_corner().equals(p_other.first_corner())) {
            combine_at_start = true;
            combine_other_at_start = true;
        } else if (this.first_corner().equals(p_other.last_corner())) {
            combine_at_start = true;
            combine_other_at_start = false;
        } else if (this.last_corner().equals(p_other.first_corner())) {
            combine_at_start = false;
            combine_other_at_start = true;
        } else if (this.last_corner().equals(p_other.last_corner())) {
            combine_at_start = false;
            combine_other_at_start = false;
        } else {
            return this;
        }
        Line[] line_arr = new Line[this.arr.length + p_other.arr.length - 2];
        if (combine_at_start) {
            int i;
            if (combine_other_at_start) {
                for (i = 0; i < p_other.arr.length - 1; ++i) {
                    line_arr[i] = p_other.arr[p_other.arr.length - i - 1].opposite();
                }
            } else {
                for (i = 0; i < p_other.arr.length - 1; ++i) {
                    line_arr[i] = p_other.arr[i];
                }
            }
            for (i = 1; i < this.arr.length; ++i) {
                line_arr[p_other.arr.length + i - 2] = this.arr[i];
            }
        } else {
            int i;
            for (i = 0; i < this.arr.length - 1; ++i) {
                line_arr[i] = this.arr[i];
            }
            if (combine_other_at_start) {
                for (i = 1; i < p_other.arr.length; ++i) {
                    line_arr[this.arr.length + i - 2] = p_other.arr[i];
                }
            } else {
                for (i = 1; i < p_other.arr.length; ++i) {
                    line_arr[this.arr.length + i - 2] = p_other.arr[p_other.arr.length - i - 1].opposite();
                }
            }
        }
        return new Polyline(line_arr);
    }

    public Polyline[] split(int p_line_no, Line p_end_line) {
        Line[] second_piece;
        Line[] first_piece;
        if (p_line_no < 1 || p_line_no > this.arr.length - 2) {
            System.out.println("Polyline.split: p_line_no out of range");
            return null;
        }
        if (this.arr[p_line_no].is_parallel(p_end_line)) {
            return null;
        }
        Point new_end_corner = this.arr[p_line_no].intersection(p_end_line);
        if (p_line_no <= 1 && new_end_corner.equals(this.first_corner()) || p_line_no >= this.arr.length - 2 && new_end_corner.equals(this.last_corner())) {
            return null;
        }
        if (this.corner(p_line_no - 1).equals(new_end_corner)) {
            first_piece = new Line[p_line_no + 1];
            System.arraycopy(this.arr, 0, first_piece, 0, first_piece.length);
        } else {
            first_piece = new Line[p_line_no + 2];
            System.arraycopy(this.arr, 0, first_piece, 0, p_line_no + 1);
            first_piece[p_line_no + 1] = p_end_line;
        }
        if (this.corner(p_line_no).equals(new_end_corner)) {
            second_piece = new Line[this.arr.length - p_line_no];
            System.arraycopy(this.arr, p_line_no, second_piece, 0, second_piece.length);
        } else {
            second_piece = new Line[this.arr.length - p_line_no + 1];
            second_piece[0] = p_end_line;
            System.arraycopy(this.arr, p_line_no, second_piece, 1, second_piece.length - 1);
        }
        Polyline[] result = new Polyline[]{new Polyline(first_piece), new Polyline(second_piece)};
        if (result[0].is_point() || result[1].is_point()) {
            return null;
        }
        return result;
    }

    public Polyline skip_lines(int p_from_no, int p_to_no) {
        if (p_from_no < 0 || p_to_no > this.arr.length - 1 || p_from_no > p_to_no) {
            return this;
        }
        Line[] new_lines = new Line[this.arr.length - (p_to_no - p_from_no + 1)];
        System.arraycopy(this.arr, 0, new_lines, 0, p_from_no);
        System.arraycopy(this.arr, p_to_no + 1, new_lines, p_from_no, new_lines.length - p_from_no);
        return new Polyline(new_lines);
    }

    public boolean contains(Point p_point) {
        for (int i = 1; i < this.arr.length - 1; ++i) {
            LineSegment curr_segment = new LineSegment(this, i);
            if (!curr_segment.contains(p_point)) continue;
            return true;
        }
        return false;
    }

    public LineSegment projection_line(Point p_from_point) {
        FloatPoint from_point = p_from_point.to_float();
        double min_distance = Double.MAX_VALUE;
        Line result_line = null;
        Line nearest_line = null;
        for (int i = 1; i < this.arr.length - 1; ++i) {
            Direction direction_towards_line;
            FloatPoint projection = from_point.projection_approx(this.arr[i]);
            double curr_distance = projection.distance(from_point);
            if (!(curr_distance < min_distance) || (direction_towards_line = this.arr[i].perpendicular_direction(p_from_point)) == null) continue;
            Line curr_result_line = new Line(p_from_point, direction_towards_line);
            Point prev_corner = this.corner(i - 1);
            Point next_corner = this.corner(i);
            Side prev_corner_side = curr_result_line.side_of(prev_corner);
            Side next_corner_side = curr_result_line.side_of(next_corner);
            if (prev_corner_side != Side.COLLINEAR && next_corner_side != Side.COLLINEAR && prev_corner_side == next_corner_side) continue;
            nearest_line = this.arr[i];
            min_distance = curr_distance;
            result_line = curr_result_line;
        }
        if (nearest_line == null) {
            return null;
        }
        Line start_line = new Line(p_from_point, nearest_line.direction());
        LineSegment result = new LineSegment(start_line, result_line, nearest_line);
        return result;
    }

    public Polyline shorten(int p_new_line_count, double p_last_segment_length) {
        Line new_prev_last_line;
        FloatPoint last_corner = this.corner_approx(p_new_line_count - 2);
        FloatPoint prev_last_corner = this.corner_approx(p_new_line_count - 3);
        IntPoint new_last_corner = prev_last_corner.change_length(last_corner, p_last_segment_length).round();
        if (new_last_corner.equals(this.corner(this.corner_count() - 2))) {
            return this.skip_lines(p_new_line_count - 1, p_new_line_count - 1);
        }
        Line[] new_lines = new Line[p_new_line_count];
        System.arraycopy(this.arr, 0, new_lines, 0, p_new_line_count - 2);
        Point first_line_point = this.arr[p_new_line_count - 2].a;
        if (first_line_point.equals(new_last_corner)) {
            first_line_point = this.arr[p_new_line_count - 2].b;
        }
        new_lines[p_new_line_count - 2] = new_prev_last_line = new Line(first_line_point, new_last_corner);
        new_lines[p_new_line_count - 1] = Line.get_instance(new_last_corner, new_prev_last_line.direction().turn_45_degree(6));
        return new Polyline(new_lines);
    }

    private static Line[] remove_consecutive_parallel_lines(Line[] p_line_arr) {
        if (p_line_arr.length < 3) {
            return p_line_arr;
        }
        Line[] tmp_arr = new Line[p_line_arr.length];
        int new_length = 0;
        tmp_arr[0] = p_line_arr[0];
        for (int i = 1; i < p_line_arr.length; ++i) {
            if (tmp_arr[new_length].is_parallel(p_line_arr[i])) continue;
            tmp_arr[++new_length] = p_line_arr[i];
        }
        if (++new_length == p_line_arr.length) {
            return p_line_arr;
        }
        if (new_length < 3) {
            return new Line[0];
        }
        Line[] result = new Line[new_length];
        System.arraycopy(tmp_arr, 0, result, 0, new_length);
        return result;
    }

    private static Line[] remove_overlaps(Line[] p_line_arr) {
        if (p_line_arr.length < 4) {
            return p_line_arr;
        }
        int new_length = 0;
        Line[] tmp_arr = new Line[p_line_arr.length];
        tmp_arr[0] = p_line_arr[0];
        if (!p_line_arr[0].is_equal_or_opposite(p_line_arr[2])) {
            ++new_length;
        }
        tmp_arr[new_length] = p_line_arr[1];
        ++new_length;
        for (int i = 2; i < p_line_arr.length - 2; ++i) {
            if (tmp_arr[new_length - 1].is_equal_or_opposite(p_line_arr[i + 1])) {
                --new_length;
                continue;
            }
            tmp_arr[new_length] = p_line_arr[i];
            ++new_length;
        }
        tmp_arr[new_length] = p_line_arr[p_line_arr.length - 2];
        if (!p_line_arr[p_line_arr.length - 1].is_equal_or_opposite(tmp_arr[++new_length - 2])) {
            tmp_arr[new_length] = p_line_arr[p_line_arr.length - 1];
            ++new_length;
        }
        if (new_length == p_line_arr.length) {
            return p_line_arr;
        }
        if (new_length < 3) {
            return new Line[0];
        }
        Line[] result = new Line[new_length];
        System.arraycopy(tmp_arr, 0, result, 0, new_length);
        return result;
    }
}

