/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import geometry.planar.Point;
import geometry.planar.Side;
import geometry.planar.Vector;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class Polygon
implements Serializable {
    private final Collection<Point> corners = new LinkedList<Point>();

    public Polygon(Point[] p_point_arr) {
        if (p_point_arr.length == 0) {
            return;
        }
        for (int i = 0; i < p_point_arr.length; ++i) {
            this.corners.add(p_point_arr[i]);
        }
        boolean corner_removed = true;
        block1: while (corner_removed) {
            corner_removed = false;
            if (this.corners.isEmpty()) {
                return;
            }
            Iterator<Point> i = this.corners.iterator();
            Point curr_ob = i.next();
            while (i.hasNext()) {
                Point next_ob = i.next();
                if (next_ob.equals(curr_ob)) {
                    i.remove();
                    corner_removed = true;
                    continue;
                }
                curr_ob = next_ob;
            }
            i = this.corners.iterator();
            Point prev = i.next();
            Iterator<Point> prev_i = this.corners.iterator();
            if (!i.hasNext()) continue;
            Point curr = i.next();
            prev_i.next();
            while (i.hasNext()) {
                Point next = i.next();
                prev_i.next();
                if (curr.side_of(prev, next) == Side.COLLINEAR) {
                    prev_i.remove();
                    corner_removed = true;
                    continue block1;
                }
                prev = curr;
                curr = next;
            }
        }
    }

    public Point[] corner_array() {
        int corner_count = this.corners.size();
        Point[] result = new Point[corner_count];
        Iterator<Point> it = this.corners.iterator();
        for (int i = 0; i < corner_count; ++i) {
            result[i] = it.next();
        }
        return result;
    }

    public Polygon revert_corners() {
        Point[] corner_arr = this.corner_array();
        Point[] reverse_corner_arr = new Point[corner_arr.length];
        for (int i = 0; i < corner_arr.length; ++i) {
            reverse_corner_arr[i] = corner_arr[corner_arr.length - i - 1];
        }
        return new Polygon(reverse_corner_arr);
    }

    public int winding_number_after_closing() {
        Vector first_side_vector;
        Point[] corner_arr = this.corner_array();
        if (corner_arr.length < 2) {
            return 0;
        }
        Vector prev_side_vector = first_side_vector = corner_arr[1].difference_by(corner_arr[0]);
        int corner_count = corner_arr.length;
        if (corner_arr[0].equals(corner_arr[corner_count - 1])) {
            --corner_count;
        }
        double angle_sum = 0.0;
        for (int i = 1; i <= corner_count; ++i) {
            Vector next_side_vector = i == corner_count - 1 ? corner_arr[0].difference_by(corner_arr[i]) : (i == corner_count ? first_side_vector : corner_arr[i + 1].difference_by(corner_arr[i]));
            angle_sum += prev_side_vector.angle_approx(next_side_vector);
            prev_side_vector = next_side_vector;
        }
        if (Math.abs(angle_sum /= Math.PI * 2) < 0.5) {
            System.out.println("Polygon.winding_number_after_closing: winding number != 0 expected");
        }
        return (int)Math.round(angle_sum);
    }
}

