/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import geometry.planar.Direction;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.IntVector;
import geometry.planar.Limits;
import geometry.planar.Line;
import geometry.planar.RationalPoint;
import geometry.planar.RationalVector;
import geometry.planar.Side;
import geometry.planar.Vector;
import java.io.Serializable;
import java.math.BigInteger;

public abstract class Point
implements Serializable {
    public static final IntPoint ZERO = new IntPoint(0, 0);

    public abstract Point translate_by(Vector var1);

    public abstract Vector difference_by(Point var1);

    public abstract FloatPoint to_float();

    public abstract boolean is_infinite();

    public abstract IntBox surrounding_box();

    public abstract IntOctagon surrounding_octagon();

    public abstract boolean is_contained_in(IntBox var1);

    public abstract Side side_of(Line var1);

    public abstract Point perpendicular_projection(Line var1);

    public static Point get_instance(int p_x, int p_y) {
        IntPoint result = new IntPoint(p_x, p_y);
        if (Math.abs(p_x) > 0x2000000 || Math.abs(p_x) > 0x2000000) {
            return new RationalPoint(result);
        }
        return result;
    }

    public static Point get_instance(BigInteger p_x, BigInteger p_y, BigInteger p_z) {
        if (p_z.signum() < 0) {
            p_x = p_x.negate();
            p_y = p_y.negate();
            p_z = p_z.negate();
        }
        if (p_x.mod(p_z).signum() == 0 && p_x.mod(p_z).signum() == 0) {
            p_x = p_x.divide(p_z);
            p_y = p_y.divide(p_z);
            p_z = BigInteger.ONE;
        }
        if (p_z.equals(BigInteger.ONE) && p_x.abs().compareTo(Limits.CRIT_INT_BIG) <= 0 && p_y.abs().compareTo(Limits.CRIT_INT_BIG) <= 0) {
            return new IntPoint(p_x.intValue(), p_y.intValue());
        }
        return new RationalPoint(p_x, p_y, p_z);
    }

    public Side side_of(Point p_1, Point p_2) {
        Vector v1 = this.difference_by(p_1);
        Vector v2 = p_2.difference_by(p_1);
        return v1.side_of(v2);
    }

    public Direction perpendicular_direction(Line p_line) {
        Side side = this.side_of(p_line);
        if (side == Side.COLLINEAR) {
            return Direction.NULL;
        }
        Direction result = side == Side.ON_THE_RIGHT ? p_line.direction().turn_45_degree(2) : p_line.direction().turn_45_degree(6);
        return result;
    }

    public abstract int compare_x(Point var1);

    public abstract int compare_y(Point var1);

    public int compare_x_y(Point p_other) {
        int result = this.compare_x(p_other);
        if (result == 0) {
            result = this.compare_y(p_other);
        }
        return result;
    }

    public Point turn_90_degree(int p_factor, Point p_pole) {
        Vector v = this.difference_by(p_pole);
        v = v.turn_90_degree(p_factor);
        return p_pole.translate_by(v);
    }

    public Point mirror_vertical(Point p_pole) {
        Vector v = this.difference_by(p_pole);
        v = v.mirror_at_y_axis();
        return p_pole.translate_by(v);
    }

    public Point mirror_horizontal(Point p_pole) {
        Vector v = this.difference_by(p_pole);
        v = v.mirror_at_x_axis();
        return p_pole.translate_by(v);
    }

    abstract Point translate_by(IntVector var1);

    abstract Point translate_by(RationalVector var1);

    abstract Vector difference_by(IntPoint var1);

    abstract Vector difference_by(RationalPoint var1);

    abstract int compare_x(IntPoint var1);

    abstract int compare_x(RationalPoint var1);

    abstract int compare_y(IntPoint var1);

    abstract int compare_y(RationalPoint var1);
}

