/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import datastructures.Signum;
import geometry.planar.Direction;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.IntVector;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.Polyline;
import geometry.planar.PolylineShape;
import geometry.planar.Side;
import geometry.planar.Simplex;
import geometry.planar.TileShape;
import java.io.Serializable;

public class LineSegment
implements Serializable {
    private final Line start;
    private final Line middle;
    private final Line end;
    private transient Point precalculated_start_point = null;
    private transient Point precalculated_end_point = null;

    public LineSegment(Line p_start_line, Line p_middle_line, Line p_end_line) {
        this.start = p_start_line;
        this.middle = p_middle_line;
        this.end = p_end_line;
    }

    public LineSegment(Polyline p_polyline, int p_no) {
        if (p_no <= 0 || p_no >= p_polyline.arr.length - 1) {
            System.out.println("LineSegment from Polyline: p_no out of range");
            this.start = null;
            this.middle = null;
            this.end = null;
            return;
        }
        this.start = p_polyline.arr[p_no - 1];
        this.middle = p_polyline.arr[p_no];
        this.end = p_polyline.arr[p_no + 1];
    }

    public LineSegment(PolylineShape p_shape, int p_no) {
        int line_count = p_shape.border_line_count();
        if (p_no < 0 || p_no >= line_count) {
            System.out.println("LineSegment from TileShape: p_no out of range");
            this.start = null;
            this.middle = null;
            this.end = null;
            return;
        }
        this.start = p_no == 0 ? p_shape.border_line(line_count - 1) : p_shape.border_line(p_no - 1);
        this.middle = p_shape.border_line(p_no);
        this.end = p_no == line_count - 1 ? p_shape.border_line(0) : p_shape.border_line(p_no + 1);
    }

    public Point start_point() {
        if (this.precalculated_start_point == null) {
            this.precalculated_start_point = this.middle.intersection(this.start);
        }
        return this.precalculated_start_point;
    }

    public Point end_point() {
        if (this.precalculated_end_point == null) {
            this.precalculated_end_point = this.middle.intersection(this.end);
        }
        return this.precalculated_end_point;
    }

    public FloatPoint start_point_approx() {
        FloatPoint result = this.precalculated_start_point != null ? this.precalculated_start_point.to_float() : this.start.intersection_approx(this.middle);
        return result;
    }

    public FloatPoint end_point_approx() {
        FloatPoint result = this.precalculated_end_point != null ? this.precalculated_end_point.to_float() : this.end.intersection_approx(this.middle);
        return result;
    }

    public Line get_line() {
        return this.middle;
    }

    public Line get_start_closing_line() {
        return this.start;
    }

    public Line get_end_closing_line() {
        return this.end;
    }

    public LineSegment opposite() {
        return new LineSegment(this.end.opposite(), this.middle.opposite(), this.start.opposite());
    }

    public Polyline to_polyline() {
        Line[] lines = new Line[]{this.start, this.middle, this.end};
        return new Polyline(lines);
    }

    public Simplex to_simplex() {
        Line[] line_arr = new Line[]{this.end_point().side_of(this.start) == Side.ON_THE_RIGHT ? this.start.opposite() : this.start, this.middle, this.middle.opposite(), this.start_point().side_of(this.end) == Side.ON_THE_RIGHT ? this.end.opposite() : this.end};
        Simplex result = Simplex.get_instance(line_arr);
        return result;
    }

    public boolean contains(Point p_point) {
        if (!(p_point instanceof IntPoint)) {
            System.out.println("LineSegments.contains currently only implementet for IntPoints");
            return false;
        }
        if (this.middle.side_of(p_point) != Side.COLLINEAR) {
            return false;
        }
        Direction perpendicular_direction = this.middle.direction().turn_45_degree(2);
        Line perpendicular_line = new Line(p_point, perpendicular_direction);
        Side start_point_side = perpendicular_line.side_of(this.start_point());
        Side end_point_side = perpendicular_line.side_of(this.end_point());
        return start_point_side == Side.COLLINEAR || end_point_side == Side.COLLINEAR || start_point_side != end_point_side;
    }

    public IntBox bounding_box() {
        FloatPoint start_corner = this.middle.intersection_approx(this.start);
        FloatPoint end_corner = this.middle.intersection_approx(this.end);
        double llx = Math.min(start_corner.x, end_corner.x);
        double lly = Math.min(start_corner.y, end_corner.y);
        double urx = Math.max(start_corner.x, end_corner.x);
        double ury = Math.max(start_corner.y, end_corner.y);
        IntPoint lower_left = new IntPoint((int)Math.floor(llx), (int)Math.floor(lly));
        IntPoint upper_right = new IntPoint((int)Math.ceil(urx), (int)Math.ceil(ury));
        return new IntBox(lower_left, upper_right);
    }

    public IntOctagon bounding_octagon() {
        FloatPoint start_corner = this.middle.intersection_approx(this.start);
        FloatPoint end_corner = this.middle.intersection_approx(this.end);
        double lx = Math.floor(Math.min(start_corner.x, end_corner.x));
        double ly = Math.floor(Math.min(start_corner.y, end_corner.y));
        double rx = Math.ceil(Math.max(start_corner.x, end_corner.x));
        double uy = Math.ceil(Math.max(start_corner.y, end_corner.y));
        double start_x_minus_y = start_corner.x - start_corner.y;
        double end_x_minus_y = end_corner.x - end_corner.y;
        double ulx = Math.floor(Math.min(start_x_minus_y, end_x_minus_y));
        double lrx = Math.ceil(Math.max(start_x_minus_y, end_x_minus_y));
        double start_x_plus_y = start_corner.x + start_corner.y;
        double end_x_plus_y = end_corner.x + end_corner.y;
        double llx = Math.floor(Math.min(start_x_plus_y, end_x_plus_y));
        double urx = Math.ceil(Math.max(start_x_plus_y, end_x_plus_y));
        IntOctagon result = new IntOctagon((int)lx, (int)ly, (int)rx, (int)uy, (int)ulx, (int)lrx, (int)llx, (int)urx);
        return result.normalize();
    }

    public LineSegment change_length_approx(double p_new_length) {
        FloatPoint new_end_point = this.start_point_approx().change_length(this.end_point_approx(), p_new_length);
        Direction perpendicular_direction = this.middle.direction().turn_45_degree(2);
        Line new_end_line = new Line((Point)new_end_point.round(), perpendicular_direction);
        LineSegment result = new LineSegment(this.start, this.middle, new_end_line);
        return result;
    }

    public Line[] intersection(LineSegment p_other) {
        if (!this.bounding_box().intersects(p_other.bounding_box())) {
            return new Line[0];
        }
        Side start_point_side = this.start_point().side_of(p_other.middle);
        Side end_point_side = this.end_point().side_of(p_other.middle);
        if (start_point_side == Side.COLLINEAR && end_point_side == Side.COLLINEAR) {
            LineSegment right_line;
            LineSegment left_line;
            LineSegment this_sorted = this.sort_endpoints_in_x_y();
            LineSegment other_sorted = p_other.sort_endpoints_in_x_y();
            if (this_sorted.start_point().compare_x_y(other_sorted.start_point()) <= 0) {
                left_line = this_sorted;
                right_line = other_sorted;
            } else {
                left_line = other_sorted;
                right_line = this_sorted;
            }
            int cmp = left_line.end_point().compare_x_y(right_line.start_point());
            if (cmp < 0) {
                return new Line[0];
            }
            if (cmp == 0) {
                Line[] result = new Line[]{left_line.end};
                return result;
            }
            Line[] result = new Line[]{right_line.start, right_line.end_point().compare_x_y(left_line.end_point()) >= 0 ? left_line.end : right_line.end};
            return result;
        }
        if (start_point_side == end_point_side || p_other.start_point().side_of(this.middle) == p_other.end_point().side_of(this.middle)) {
            return new Line[0];
        }
        Line[] result = new Line[]{p_other.middle};
        return result;
    }

    public boolean intersects(LineSegment p_other) {
        Line[] intersections = this.intersection(p_other);
        return intersections.length > 0;
    }

    public boolean overlaps(LineSegment p_other) {
        Line[] intersections = this.intersection(p_other);
        return intersections.length > 1;
    }

    public IntPoint[] stair_approximation(double p_width, boolean p_to_the_right) {
        int stair_count;
        int stair_width;
        int abs_dy;
        boolean function_of_x;
        IntPoint end_point;
        IntPoint start_point = this.start_point().to_float().round();
        if (start_point.equals(end_point = this.end_point().to_float().round())) {
            return new IntPoint[0];
        }
        if (start_point.x == end_point.x || start_point.y == end_point.y) {
            IntPoint[] result = new IntPoint[]{start_point, end_point};
            return result;
        }
        int dx = end_point.x - start_point.x;
        int dy = end_point.y - start_point.y;
        int abs_dx = Math.abs(dx);
        boolean bl = function_of_x = abs_dx >= (abs_dy = Math.abs(dy));
        if (function_of_x) {
            stair_width = (int)Math.round(p_width * (double)abs_dx / (double)abs_dy);
            stair_count = (abs_dx - 1) / stair_width + 1;
            if (end_point.x < start_point.x) {
                stair_width = -stair_width;
            }
        } else {
            stair_width = (int)Math.round(p_width * (double)abs_dy / (double)abs_dx);
            stair_count = (abs_dy - 1) / stair_width + 1;
            if (end_point.y < start_point.y) {
                stair_width = -stair_width;
            }
        }
        IntPoint[] result = new IntPoint[2 * stair_count + 1];
        result[0] = start_point;
        double det = (double)dx * (double)dy;
        boolean change_x_first = p_to_the_right && det > 0.0 || !p_to_the_right && det < 0.0;
        int curr_index = 0;
        int prev_line_point_x = start_point.x;
        int prev_line_point_y = start_point.y;
        for (int i = 1; i < stair_count; ++i) {
            int curr_line_point_y;
            int curr_line_point_x;
            if (function_of_x) {
                curr_line_point_x = start_point.x + i * stair_width;
                curr_line_point_y = (int)Math.round(this.get_line().function_value_approx(curr_line_point_x));
            } else {
                curr_line_point_y = start_point.y + i * stair_width;
                curr_line_point_x = (int)Math.round(this.get_line().function_in_y_value_approx(curr_line_point_y));
            }
            result[++curr_index] = change_x_first ? new IntPoint(curr_line_point_x, prev_line_point_y) : new IntPoint(prev_line_point_x, curr_line_point_y);
            result[++curr_index] = new IntPoint(curr_line_point_x, curr_line_point_y);
            prev_line_point_x = curr_line_point_x;
            prev_line_point_y = curr_line_point_y;
        }
        result[++curr_index] = change_x_first ? new IntPoint(end_point.x, prev_line_point_y) : new IntPoint(prev_line_point_x, end_point.y);
        result[++curr_index] = end_point;
        return result;
    }

    public IntPoint[] stair_approximation_45(double p_width, boolean p_to_the_right) {
        int stair_count;
        int stair_width;
        IntPoint end_point;
        IntPoint start_point = this.start_point().to_float().round();
        if (start_point.equals(end_point = this.end_point().to_float().round())) {
            return new IntPoint[0];
        }
        IntVector delta = end_point.difference_by(start_point);
        if (delta.is_multiple_of_45_degree()) {
            IntPoint[] result = new IntPoint[]{start_point, end_point};
            return result;
        }
        IntVector abs_delta = new IntVector(Math.abs(delta.x), Math.abs(delta.y));
        boolean function_of_x = abs_delta.x >= abs_delta.y;
        double det = (double)delta.x * (double)delta.y;
        if (function_of_x) {
            stair_width = (int)Math.round(p_width * (double)abs_delta.x / (double)abs_delta.y);
            stair_count = (abs_delta.x - 1) / stair_width + 1;
            if (end_point.x < start_point.x) {
                stair_width = -stair_width;
            }
        } else {
            stair_width = (int)Math.round(p_width * (double)abs_delta.y / (double)abs_delta.x);
            stair_count = (abs_delta.y - 1) / stair_width + 1;
            if (end_point.y < start_point.y) {
                stair_width = -stair_width;
            }
        }
        IntPoint[] result = new IntPoint[2 * stair_count + 1];
        result[0] = start_point;
        IntPoint prev_line_point = start_point;
        int curr_index = 0;
        for (int i = 1; i <= stair_count; ++i) {
            boolean diagonal_first;
            int curr_y;
            int curr_x;
            IntPoint curr_line_point;
            if (i == stair_count) {
                curr_line_point = end_point;
            } else {
                if (function_of_x) {
                    curr_x = start_point.x + i * stair_width;
                    curr_y = (int)Math.round(this.get_line().function_value_approx(curr_x));
                } else {
                    curr_y = start_point.y + i * stair_width;
                    curr_x = (int)Math.round(this.get_line().function_value_approx(curr_y));
                }
                curr_line_point = new IntPoint(curr_x, curr_y);
            }
            if (function_of_x) {
                boolean bl = diagonal_first = p_to_the_right && det < 0.0 || !p_to_the_right && det > 0.0;
                if (diagonal_first) {
                    curr_x = prev_line_point.x + Signum.as_int(stair_width) * Math.abs(curr_line_point.y - prev_line_point.y);
                    curr_y = curr_line_point.y;
                } else {
                    curr_x = curr_line_point.x - Signum.as_int(stair_width) * Math.abs(curr_line_point.y - prev_line_point.y);
                    curr_y = prev_line_point.y;
                }
            } else {
                boolean bl = diagonal_first = p_to_the_right && det > 0.0 || !p_to_the_right && det < 0.0;
                if (diagonal_first) {
                    curr_x = curr_line_point.x;
                    curr_y = prev_line_point.y + Signum.as_int(stair_width) * Math.abs(curr_line_point.x - prev_line_point.x);
                } else {
                    curr_x = prev_line_point.x;
                    curr_y = curr_line_point.y - Signum.as_int(stair_width) * Math.abs(curr_line_point.x - prev_line_point.x);
                }
            }
            result[++curr_index] = new IntPoint(curr_x, curr_y);
            result[++curr_index] = curr_line_point;
            prev_line_point = curr_line_point;
        }
        return result;
    }

    public int[] border_intersections(TileShape p_shape) {
        int[] empty_result = new int[]{};
        if (!this.bounding_box().intersects(p_shape.bounding_box())) {
            return empty_result;
        }
        int edge_count = p_shape.border_line_count();
        Line prev_line = p_shape.border_line(edge_count - 1);
        Line curr_line = p_shape.border_line(0);
        int[] result = new int[2];
        Point[] intersection = new Point[2];
        int intersection_count = 0;
        Point line_start = this.start_point();
        Point line_end = this.end_point();
        for (int edge_line_no = 0; edge_line_no < edge_count; ++edge_line_no) {
            Line next_line = edge_line_no == edge_count - 1 ? p_shape.border_line(0) : p_shape.border_line(edge_line_no + 1);
            Side start_point_side = curr_line.side_of(line_start);
            Side end_point_side = curr_line.side_of(line_end);
            if (start_point_side == Side.ON_THE_LEFT && end_point_side == Side.ON_THE_LEFT) {
                return empty_result;
            }
            if (start_point_side == Side.COLLINEAR && end_point_side != Side.ON_THE_RIGHT) {
                return empty_result;
            }
            if (end_point_side == Side.COLLINEAR && start_point_side != Side.ON_THE_RIGHT) {
                return empty_result;
            }
            if (start_point_side != Side.ON_THE_RIGHT || end_point_side != Side.ON_THE_RIGHT) {
                Point is = this.middle.intersection(curr_line);
                Side prev_line_side_of_is = prev_line.side_of(is);
                Side next_line_side_of_is = next_line.side_of(is);
                if (prev_line_side_of_is != Side.ON_THE_LEFT && next_line_side_of_is != Side.ON_THE_LEFT) {
                    if (prev_line_side_of_is == Side.COLLINEAR) {
                        Point prev_prev_corner = edge_line_no == 0 ? p_shape.corner(edge_count - 1) : p_shape.corner(edge_line_no - 1);
                        Point next_corner = edge_line_no == edge_count - 1 ? p_shape.corner(0) : p_shape.corner(edge_line_no + 1);
                        Side prev_prev_corner_side = this.middle.side_of(prev_prev_corner);
                        Side next_corner_side = this.middle.side_of(next_corner);
                        if (prev_prev_corner_side == Side.COLLINEAR || next_corner_side == Side.COLLINEAR || prev_prev_corner_side == next_corner_side) {
                            return empty_result;
                        }
                    }
                    if (next_line_side_of_is == Side.COLLINEAR) {
                        Point prev_corner = p_shape.corner(edge_line_no);
                        Point next_next_corner = edge_line_no == edge_count - 2 ? p_shape.corner(0) : (edge_line_no == edge_count - 1 ? p_shape.corner(1) : p_shape.corner(edge_line_no + 2));
                        Side prev_corner_side = this.middle.side_of(prev_corner);
                        Side next_next_corner_side = this.middle.side_of(next_next_corner);
                        if (prev_corner_side == Side.COLLINEAR || next_next_corner_side == Side.COLLINEAR || prev_corner_side == next_next_corner_side) {
                            return empty_result;
                        }
                    }
                    boolean intersection_already_handeled = false;
                    for (int i = 0; i < intersection_count; ++i) {
                        if (!is.equals(intersection[i])) continue;
                        intersection_already_handeled = true;
                        break;
                    }
                    if (!intersection_already_handeled) {
                        if (intersection_count < result.length) {
                            result[intersection_count] = edge_line_no;
                            intersection[intersection_count] = is;
                            ++intersection_count;
                        } else {
                            System.out.println("border_intersections: intersection_count to big!");
                        }
                    }
                }
            }
            prev_line = curr_line;
            curr_line = next_line;
        }
        if (intersection_count == 0) {
            return empty_result;
        }
        if (intersection_count == 2) {
            FloatPoint is0 = intersection[0].to_float();
            FloatPoint is1 = intersection[1].to_float();
            FloatPoint curr_start = line_start.to_float();
            if (curr_start.distance_square(is1) < curr_start.distance_square(is0)) {
                int tmp = result[0];
                result[0] = result[1];
                result[1] = tmp;
            }
            return result;
        }
        if (intersection_count != 1) {
            System.out.println("LineSegment.border_intersections: intersection_count 1 expected");
        }
        int[] normalised_result = new int[]{result[0]};
        return normalised_result;
    }

    public LineSegment sort_endpoints_in_x_y() {
        LineSegment result;
        boolean swap_endlines;
        boolean bl = swap_endlines = this.start_point().compare_x_y(this.end_point()) > 0;
        if (swap_endlines) {
            result = new LineSegment(this.end, this.middle, this.start);
            result.precalculated_start_point = this.precalculated_end_point;
            result.precalculated_end_point = this.precalculated_start_point;
        } else {
            result = this;
        }
        return result;
    }
}

