/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import geometry.planar.Circle;
import geometry.planar.FloatPoint;
import geometry.planar.FortyfiveDegreeDirection;
import geometry.planar.IntBox;
import geometry.planar.IntPoint;
import geometry.planar.IntVector;
import geometry.planar.Limits;
import geometry.planar.Line;
import geometry.planar.RegularTileShape;
import geometry.planar.Shape;
import geometry.planar.ShapeBoundingDirections;
import geometry.planar.Side;
import geometry.planar.Simplex;
import geometry.planar.TileShape;
import geometry.planar.Vector;
import java.io.Serializable;

public class IntOctagon
extends RegularTileShape
implements Serializable {
    public static final IntOctagon EMPTY = new IntOctagon(0x2000000, 0x2000000, -33554432, -33554432, 0x2000000, -33554432, 0x2000000, -33554432);
    public final int lx;
    public final int ly;
    public final int rx;
    public final int uy;
    public final int ulx;
    public final int lrx;
    public final int llx;
    public final int urx;
    private Simplex precalculated_to_simplex = null;

    public IntOctagon(int p_lx, int p_ly, int p_rx, int p_uy, int p_ulx, int p_lrx, int p_llx, int p_urx) {
        this.lx = p_lx;
        this.ly = p_ly;
        this.rx = p_rx;
        this.uy = p_uy;
        this.ulx = p_ulx;
        this.lrx = p_lrx;
        this.llx = p_llx;
        this.urx = p_urx;
    }

    @Override
    public boolean is_empty() {
        return this == EMPTY;
    }

    @Override
    public boolean is_IntOctagon() {
        return true;
    }

    @Override
    public boolean is_bounded() {
        return true;
    }

    @Override
    public boolean corner_is_bounded(int p_no) {
        return true;
    }

    @Override
    public IntBox bounding_box() {
        return new IntBox(this.lx, this.ly, this.rx, this.uy);
    }

    @Override
    public IntOctagon bounding_octagon() {
        return this;
    }

    @Override
    public IntOctagon bounding_tile() {
        return this;
    }

    @Override
    public int dimension() {
        if (this == EMPTY) {
            return -1;
        }
        int result = this.rx > this.lx && this.uy > this.ly && this.lrx > this.ulx && this.urx > this.llx ? 2 : (this.rx == this.lx && this.uy == this.ly ? 0 : 1);
        return result;
    }

    @Override
    public IntPoint corner(int p_no) {
        int y;
        int x;
        switch (p_no) {
            case 0: {
                x = this.llx - this.ly;
                y = this.ly;
                break;
            }
            case 1: {
                x = this.lrx + this.ly;
                y = this.ly;
                break;
            }
            case 2: {
                x = this.rx;
                y = this.rx - this.lrx;
                break;
            }
            case 3: {
                x = this.rx;
                y = this.urx - this.rx;
                break;
            }
            case 4: {
                x = this.urx - this.uy;
                y = this.uy;
                break;
            }
            case 5: {
                x = this.ulx + this.uy;
                y = this.uy;
                break;
            }
            case 6: {
                x = this.lx;
                y = this.lx - this.ulx;
                break;
            }
            case 7: {
                x = this.lx;
                y = this.llx - this.lx;
                break;
            }
            default: {
                throw new IllegalArgumentException("IntOctagon.corner: p_no out of range");
            }
        }
        return new IntPoint(x, y);
    }

    public int corner_y(int p_no) {
        int y;
        switch (p_no) {
            case 0: {
                y = this.ly;
                break;
            }
            case 1: {
                y = this.ly;
                break;
            }
            case 2: {
                y = this.rx - this.lrx;
                break;
            }
            case 3: {
                y = this.urx - this.rx;
                break;
            }
            case 4: {
                y = this.uy;
                break;
            }
            case 5: {
                y = this.uy;
                break;
            }
            case 6: {
                y = this.lx - this.ulx;
                break;
            }
            case 7: {
                y = this.llx - this.lx;
                break;
            }
            default: {
                throw new IllegalArgumentException("IntOctagon.corner: p_no out of range");
            }
        }
        return y;
    }

    public int corner_x(int p_no) {
        int x;
        switch (p_no) {
            case 0: {
                x = this.llx - this.ly;
                break;
            }
            case 1: {
                x = this.lrx + this.ly;
                break;
            }
            case 2: {
                x = this.rx;
                break;
            }
            case 3: {
                x = this.rx;
                break;
            }
            case 4: {
                x = this.urx - this.uy;
                break;
            }
            case 5: {
                x = this.ulx + this.uy;
                break;
            }
            case 6: {
                x = this.lx;
                break;
            }
            case 7: {
                x = this.lx;
                break;
            }
            default: {
                throw new IllegalArgumentException("IntOctagon.corner: p_no out of range");
            }
        }
        return x;
    }

    @Override
    public double area() {
        double result = (double)(this.llx - this.ly) * (double)(this.ly - this.llx + this.lx);
        result += (double)(this.lrx + this.ly) * (double)(this.rx - this.lrx - this.ly);
        result += (double)this.rx * (double)(this.urx - 2 * this.rx - this.ly + this.uy + this.lrx);
        result += (double)(this.urx - this.uy) * (double)(this.uy - this.urx + this.rx);
        result += (double)(this.ulx + this.uy) * (double)(this.lx - this.ulx - this.uy);
        return 0.5 * Math.abs(result += (double)this.lx * (double)(this.llx - 2 * this.lx - this.uy + this.ly + this.ulx));
    }

    @Override
    public int border_line_count() {
        return 8;
    }

    @Override
    public Line border_line(int p_no) {
        int b_y;
        int b_x;
        int a_y;
        int a_x;
        switch (p_no) {
            case 0: {
                a_x = 0;
                a_y = this.ly;
                b_x = 1;
                b_y = this.ly;
                break;
            }
            case 1: {
                a_x = this.lrx;
                a_y = 0;
                b_x = this.lrx + 1;
                b_y = 1;
                break;
            }
            case 2: {
                a_x = this.rx;
                a_y = 0;
                b_x = this.rx;
                b_y = 1;
                break;
            }
            case 3: {
                a_x = this.urx;
                a_y = 0;
                b_x = this.urx - 1;
                b_y = 1;
                break;
            }
            case 4: {
                a_x = 0;
                a_y = this.uy;
                b_x = -1;
                b_y = this.uy;
                break;
            }
            case 5: {
                a_x = this.ulx;
                a_y = 0;
                b_x = this.ulx - 1;
                b_y = -1;
                break;
            }
            case 6: {
                a_x = this.lx;
                a_y = 0;
                b_x = this.lx;
                b_y = -1;
                break;
            }
            case 7: {
                a_x = this.llx;
                a_y = 0;
                b_x = this.llx + 1;
                b_y = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("IntOctagon.edge_line: p_no out of range");
            }
        }
        return new Line(a_x, a_y, b_x, b_y);
    }

    @Override
    public IntOctagon translate_by(Vector p_rel_coor) {
        if (p_rel_coor.equals(Vector.ZERO)) {
            return this;
        }
        IntVector rel_coor = (IntVector)p_rel_coor;
        return new IntOctagon(this.lx + rel_coor.x, this.ly + rel_coor.y, this.rx + rel_coor.x, this.uy + rel_coor.y, this.ulx + rel_coor.x - rel_coor.y, this.lrx + rel_coor.x - rel_coor.y, this.llx + rel_coor.x + rel_coor.y, this.urx + rel_coor.x + rel_coor.y);
    }

    @Override
    public double max_width() {
        double width_1 = Math.max(this.rx - this.lx, this.uy - this.ly);
        double width2 = Math.max(this.urx - this.llx, this.lrx - this.ulx);
        double result = Math.max(width_1, width2 / Limits.sqrt2);
        return result;
    }

    @Override
    public double min_width() {
        double width_1 = Math.min(this.rx - this.lx, this.uy - this.ly);
        double width2 = Math.min(this.urx - this.llx, this.lrx - this.ulx);
        double result = Math.min(width_1, width2 / Limits.sqrt2);
        return result;
    }

    @Override
    public IntOctagon offset(double p_distance) {
        int width = (int)Math.round(p_distance);
        if (width == 0) {
            return this;
        }
        int dia_width = (int)Math.round(Limits.sqrt2 * p_distance);
        IntOctagon result = new IntOctagon(this.lx - width, this.ly - width, this.rx + width, this.uy + width, this.ulx - dia_width, this.lrx + dia_width, this.llx - dia_width, this.urx + dia_width);
        return result.normalize();
    }

    @Override
    public IntOctagon enlarge(double p_offset) {
        return this.offset(p_offset);
    }

    @Override
    public boolean contains(RegularTileShape p_other) {
        return p_other.is_contained_in(this);
    }

    @Override
    public RegularTileShape union(RegularTileShape p_other) {
        return p_other.union(this);
    }

    @Override
    public TileShape intersection(TileShape p_other) {
        return p_other.intersection(this);
    }

    public IntOctagon normalize() {
        int diag_left_x;
        int diag_right_x;
        int diag_lower_y;
        int diag_upper_y;
        if (this.lx > this.rx || this.ly > this.uy || this.llx > this.urx || this.ulx > this.lrx) {
            return EMPTY;
        }
        int new_lx = this.lx;
        int new_rx = this.rx;
        int new_ly = this.ly;
        int new_uy = this.uy;
        int new_llx = this.llx;
        int new_ulx = this.ulx;
        int new_lrx = this.lrx;
        int new_urx = this.urx;
        if (new_lx < new_llx - new_uy) {
            new_lx = new_llx - new_uy;
        }
        if (new_lx < new_ulx + new_ly) {
            new_lx = new_ulx + new_ly;
        }
        if (new_rx > new_urx - new_ly) {
            new_rx = new_urx - new_ly;
        }
        if (new_rx > new_lrx + new_uy) {
            new_rx = new_lrx + new_uy;
        }
        if (new_ly < new_lx - new_lrx) {
            new_ly = new_lx - new_lrx;
        }
        if (new_ly < new_llx - new_rx) {
            new_ly = new_llx - new_rx;
        }
        if (new_uy > new_urx - new_lx) {
            new_uy = new_urx - new_lx;
        }
        if (new_uy > new_rx - new_ulx) {
            new_uy = new_rx - new_ulx;
        }
        if (new_llx - new_lx < new_ly) {
            new_llx = new_lx + new_ly;
        }
        if (new_rx - new_lrx < new_ly) {
            new_lrx = new_rx - new_ly;
        }
        if (new_urx - new_rx > new_uy) {
            new_urx = new_uy + new_rx;
        }
        if (new_lx - new_ulx > new_uy) {
            new_ulx = new_lx - new_uy;
        }
        if (new_uy > (diag_upper_y = (int)Math.ceil((double)(new_urx - new_ulx) / 2.0))) {
            new_uy = diag_upper_y;
        }
        if (new_ly < (diag_lower_y = (int)Math.floor((double)(new_llx - new_lrx) / 2.0))) {
            new_ly = diag_lower_y;
        }
        if (new_rx > (diag_right_x = (int)Math.ceil((double)(new_urx + new_lrx) / 2.0))) {
            new_rx = diag_right_x;
        }
        if (new_lx < (diag_left_x = (int)Math.floor((double)(new_llx + new_ulx) / 2.0))) {
            new_lx = diag_left_x;
        }
        if (new_lx > new_rx || new_ly > new_uy || new_llx > new_urx || new_ulx > new_lrx) {
            return EMPTY;
        }
        return new IntOctagon(new_lx, new_ly, new_rx, new_uy, new_ulx, new_lrx, new_llx, new_urx);
    }

    public boolean is_normalized() {
        IntOctagon on = this.normalize();
        boolean result = this.lx == on.lx && this.ly == on.ly && this.rx == on.rx && this.uy == on.uy && this.llx == on.llx && this.lrx == on.lrx && this.ulx == on.ulx && this.urx == on.urx;
        return result;
    }

    @Override
    public Simplex to_Simplex() {
        if (this.is_empty()) {
            return Simplex.EMPTY;
        }
        if (this.precalculated_to_simplex == null) {
            Line[] line_arr = new Line[8];
            for (int i = 0; i < 8; ++i) {
                line_arr[i] = this.border_line(i);
            }
            Simplex curr_simplex = new Simplex(line_arr);
            this.precalculated_to_simplex = curr_simplex.remove_redundant_lines();
        }
        return this.precalculated_to_simplex;
    }

    @Override
    public RegularTileShape bounding_shape(ShapeBoundingDirections p_dirs) {
        return p_dirs.bounds(this);
    }

    @Override
    public boolean intersects(Shape p_other) {
        return p_other.intersects(this);
    }

    @Override
    public boolean contains(FloatPoint p_point) {
        if ((double)this.lx > p_point.x || (double)this.ly > p_point.y || (double)this.rx < p_point.x || (double)this.uy < p_point.y) {
            return false;
        }
        double tmp_1 = p_point.x - p_point.y;
        double tmp_2 = p_point.x + p_point.y;
        return !((double)this.ulx > tmp_1 || (double)this.lrx < tmp_1 || (double)this.llx > tmp_2) && !((double)this.urx < tmp_2);
    }

    public Side side_of_border_line(int p_x, int p_y, int p_border_line_no) {
        int tmp;
        if (p_border_line_no == 0) {
            tmp = this.ly - p_y;
        } else if (p_border_line_no == 2) {
            tmp = p_x - this.rx;
        } else if (p_border_line_no == 4) {
            tmp = p_y - this.uy;
        } else if (p_border_line_no == 6) {
            tmp = this.lx - p_x;
        } else if (p_border_line_no == 1) {
            tmp = p_x - p_y - this.lrx;
        } else if (p_border_line_no == 3) {
            tmp = p_x + p_y - this.urx;
        } else if (p_border_line_no == 5) {
            tmp = this.ulx + p_y - p_x;
        } else if (p_border_line_no == 7) {
            tmp = this.llx - p_x - p_y;
        } else {
            System.out.println("IntOctagon.side_of_border_line: p_border_line_no out of range");
            tmp = 0;
        }
        Side result = tmp < 0 ? Side.ON_THE_LEFT : (tmp > 0 ? Side.ON_THE_RIGHT : Side.COLLINEAR);
        return result;
    }

    @Override
    Simplex intersection(Simplex p_other) {
        return p_other.intersection(this);
    }

    @Override
    public IntOctagon intersection(IntOctagon p_other) {
        IntOctagon result = new IntOctagon(Math.max(this.lx, p_other.lx), Math.max(this.ly, p_other.ly), Math.min(this.rx, p_other.rx), Math.min(this.uy, p_other.uy), Math.max(this.ulx, p_other.ulx), Math.min(this.lrx, p_other.lrx), Math.max(this.llx, p_other.llx), Math.min(this.urx, p_other.urx));
        return result.normalize();
    }

    @Override
    IntOctagon intersection(IntBox p_other) {
        return this.intersection(p_other.to_IntOctagon());
    }

    @Override
    public boolean is_contained_in(IntBox p_box) {
        return this.lx >= p_box.ll.x && this.ly >= p_box.ll.y && this.rx <= p_box.ur.x && this.uy <= p_box.ur.y;
    }

    @Override
    public boolean is_contained_in(IntOctagon p_other) {
        boolean result = this.lx >= p_other.lx && this.ly >= p_other.ly && this.rx <= p_other.rx && this.uy <= p_other.uy && this.llx >= p_other.llx && this.ulx >= p_other.ulx && this.lrx <= p_other.lrx && this.urx <= p_other.urx;
        return result;
    }

    @Override
    public IntOctagon union(IntOctagon p_other) {
        IntOctagon result = new IntOctagon(Math.min(this.lx, p_other.lx), Math.min(this.ly, p_other.ly), Math.max(this.rx, p_other.rx), Math.max(this.uy, p_other.uy), Math.min(this.ulx, p_other.ulx), Math.max(this.lrx, p_other.lrx), Math.min(this.llx, p_other.llx), Math.max(this.urx, p_other.urx));
        return result;
    }

    @Override
    public boolean intersects(IntBox p_other) {
        return this.intersects(p_other.to_IntOctagon());
    }

    @Override
    public boolean intersects(IntOctagon p_other) {
        int is_lrx;
        int is_urx;
        int is_uy;
        int is_rx;
        int is_lx = p_other.lx > this.lx ? p_other.lx : this.lx;
        if (is_lx > (is_rx = p_other.rx < this.rx ? p_other.rx : this.rx)) {
            return false;
        }
        int is_ly = p_other.ly > this.ly ? p_other.ly : this.ly;
        if (is_ly > (is_uy = p_other.uy < this.uy ? p_other.uy : this.uy)) {
            return false;
        }
        int is_llx = p_other.llx > this.llx ? p_other.llx : this.llx;
        if (is_llx > (is_urx = p_other.urx < this.urx ? p_other.urx : this.urx)) {
            return false;
        }
        int is_ulx = p_other.ulx > this.ulx ? p_other.ulx : this.ulx;
        return is_ulx <= (is_lrx = p_other.lrx < this.lrx ? p_other.lrx : this.lrx);
    }

    public boolean overlaps(IntOctagon p_other) {
        int is_lrx;
        int is_urx;
        int is_uy;
        int is_rx;
        int is_lx = p_other.lx > this.lx ? p_other.lx : this.lx;
        if (is_lx >= (is_rx = p_other.rx < this.rx ? p_other.rx : this.rx)) {
            return false;
        }
        int is_ly = p_other.ly > this.ly ? p_other.ly : this.ly;
        if (is_ly >= (is_uy = p_other.uy < this.uy ? p_other.uy : this.uy)) {
            return false;
        }
        int is_llx = p_other.llx > this.llx ? p_other.llx : this.llx;
        if (is_llx >= (is_urx = p_other.urx < this.urx ? p_other.urx : this.urx)) {
            return false;
        }
        int is_ulx = p_other.ulx > this.ulx ? p_other.ulx : this.ulx;
        return is_ulx < (is_lrx = p_other.lrx < this.lrx ? p_other.lrx : this.lrx);
    }

    @Override
    public boolean intersects(Simplex p_other) {
        return p_other.intersects(this);
    }

    @Override
    public boolean intersects(Circle p_other) {
        return p_other.intersects(this);
    }

    @Override
    public IntOctagon union(IntBox p_other) {
        return this.union(p_other.to_IntOctagon());
    }

    public int left_x_value(int p_y) {
        int result = Math.max(this.lx, this.ulx + p_y);
        return Math.max(result, this.llx - p_y);
    }

    public int right_x_value(int p_y) {
        int result = Math.min(this.rx, this.urx - p_y);
        return Math.min(result, this.lrx + p_y);
    }

    public int lower_y_value(int p_x) {
        int result = Math.max(this.ly, this.llx - p_x);
        return Math.max(result, p_x - this.lrx);
    }

    public int upper_y_value(int p_x) {
        int result = Math.min(this.uy, p_x - this.ulx);
        return Math.min(result, this.urx - p_x);
    }

    @Override
    public Side compare(RegularTileShape p_other, int p_edge_no) {
        Side result = p_other.compare(this, p_edge_no);
        return result.negate();
    }

    @Override
    public Side compare(IntOctagon p_other, int p_edge_no) {
        Side result;
        switch (p_edge_no) {
            case 0: {
                if (this.ly > p_other.ly) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.ly < p_other.ly) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 1: {
                if (this.lrx < p_other.lrx) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.lrx > p_other.lrx) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 2: {
                if (this.rx < p_other.rx) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.rx > p_other.rx) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 3: {
                if (this.urx < p_other.urx) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.urx > p_other.urx) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 4: {
                if (this.uy < p_other.uy) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.uy > p_other.uy) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 5: {
                if (this.ulx > p_other.ulx) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.ulx < p_other.ulx) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 6: {
                if (this.lx > p_other.lx) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.lx < p_other.lx) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 7: {
                if (this.llx > p_other.llx) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.llx < p_other.llx) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            default: {
                throw new IllegalArgumentException("IntBox.compare: p_edge_no out of range");
            }
        }
        return result;
    }

    @Override
    public Side compare(IntBox p_other, int p_edge_no) {
        return this.compare(p_other.to_IntOctagon(), p_edge_no);
    }

    @Override
    public int border_line_index(Line p_line) {
        System.out.println("edge_index_of_line not yet implemented for octagons");
        return -1;
    }

    public IntPoint border_point(IntPoint p_point, FortyfiveDegreeDirection p_dir) {
        int result_y;
        int result_x;
        switch (p_dir) {
            case RIGHT: {
                result_x = Math.min(this.rx, this.urx - p_point.y);
                result_x = Math.min(result_x, this.lrx + p_point.y);
                result_y = p_point.y;
                break;
            }
            case LEFT: {
                result_x = Math.max(this.lx, this.ulx + p_point.y);
                result_x = Math.max(result_x, this.llx - p_point.y);
                result_y = p_point.y;
                break;
            }
            case UP: {
                result_x = p_point.x;
                result_y = Math.min(this.uy, p_point.x - this.ulx);
                result_y = Math.min(result_y, this.urx - p_point.x);
                break;
            }
            case DOWN: {
                result_x = p_point.x;
                result_y = Math.max(this.ly, this.llx - p_point.x);
                result_y = Math.max(result_y, p_point.x - this.lrx);
                break;
            }
            case RIGHT45: {
                result_x = (int)Math.ceil(0.5 * (double)(p_point.x - p_point.y + this.urx));
                result_x = Math.min(result_x, this.rx);
                result_x = Math.min(result_x, p_point.x - p_point.x + this.uy);
                result_y = p_point.y - p_point.x + result_x;
                break;
            }
            case UP45: {
                result_x = (int)Math.floor(0.5 * (double)(p_point.x + p_point.y + this.ulx));
                result_x = Math.max(result_x, this.lx);
                result_x = Math.max(result_x, p_point.x + p_point.y - this.uy);
                result_y = p_point.y + p_point.x - result_x;
                break;
            }
            case LEFT45: {
                result_x = (int)Math.floor(0.5 * (double)(p_point.x - p_point.y + this.llx));
                result_x = Math.max(result_x, this.lx);
                result_x = Math.max(result_x, p_point.x - p_point.y + this.ly);
                result_y = p_point.y - p_point.x + result_x;
                break;
            }
            case DOWN45: {
                result_x = (int)Math.ceil(0.5 * (double)(p_point.x + p_point.y + this.lrx));
                result_x = Math.min(result_x, this.rx);
                result_x = Math.min(result_x, p_point.x + p_point.y - this.ly);
                result_y = p_point.y + p_point.x - result_x;
                break;
            }
            default: {
                System.out.println("IntOctagon.border_point: unexpected 45 degree direction");
                result_x = 0;
                result_y = 0;
            }
        }
        return new IntPoint(result_x, result_y);
    }

    public IntPoint[] nearest_border_projections(IntPoint p_point, int p_max_result_points) {
        if (!this.contains(p_point) || p_max_result_points <= 0) {
            return new IntPoint[0];
        }
        p_max_result_points = Math.min(p_max_result_points, 8);
        IntPoint[] result = new IntPoint[p_max_result_points];
        double[] min_dist = new double[p_max_result_points];
        for (int i = 0; i < p_max_result_points; ++i) {
            min_dist[i] = Double.MAX_VALUE;
        }
        FloatPoint inside_point = p_point.to_float();
        block1: for (FortyfiveDegreeDirection curr_dir : FortyfiveDegreeDirection.values()) {
            IntPoint curr_border_point = this.border_point(p_point, curr_dir);
            double curr_dist = inside_point.distance_square(curr_border_point.to_float());
            for (int i = 0; i < p_max_result_points; ++i) {
                if (!(curr_dist < min_dist[i])) continue;
                for (int k = p_max_result_points - 1; k > i; --k) {
                    min_dist[k] = min_dist[k - 1];
                    result[k] = result[k - 1];
                }
                min_dist[i] = curr_dist;
                result[i] = curr_border_point;
                continue block1;
            }
        }
        return result;
    }

    Side border_line_side_of(FloatPoint p_point, int p_line_no, double p_tolerance) {
        Side result;
        if (p_line_no == 0) {
            result = p_point.y > (double)this.ly + p_tolerance ? Side.ON_THE_RIGHT : (p_point.y < (double)this.ly - p_tolerance ? Side.ON_THE_LEFT : Side.COLLINEAR);
        } else if (p_line_no == 2) {
            result = p_point.x < (double)this.rx - p_tolerance ? Side.ON_THE_RIGHT : (p_point.x > (double)this.rx + p_tolerance ? Side.ON_THE_LEFT : Side.COLLINEAR);
        } else if (p_line_no == 4) {
            result = p_point.y < (double)this.uy - p_tolerance ? Side.ON_THE_RIGHT : (p_point.y > (double)this.uy + p_tolerance ? Side.ON_THE_LEFT : Side.COLLINEAR);
        } else if (p_line_no == 6) {
            result = p_point.x > (double)this.lx + p_tolerance ? Side.ON_THE_RIGHT : (p_point.x < (double)this.lx - p_tolerance ? Side.ON_THE_LEFT : Side.COLLINEAR);
        } else if (p_line_no == 1) {
            double tmp = p_point.y - p_point.x + (double)this.lrx;
            result = tmp > p_tolerance ? Side.ON_THE_RIGHT : (tmp < -p_tolerance ? Side.ON_THE_LEFT : Side.COLLINEAR);
        } else if (p_line_no == 3) {
            double tmp = p_point.x + p_point.y - (double)this.urx;
            result = tmp < -p_tolerance ? Side.ON_THE_RIGHT : (tmp > p_tolerance ? Side.ON_THE_LEFT : Side.COLLINEAR);
        } else if (p_line_no == 5) {
            double tmp = p_point.y - p_point.x + (double)this.ulx;
            result = tmp < -p_tolerance ? Side.ON_THE_RIGHT : (tmp > p_tolerance ? Side.ON_THE_LEFT : Side.COLLINEAR);
        } else if (p_line_no == 7) {
            double tmp = p_point.x + p_point.y - (double)this.llx;
            result = tmp > p_tolerance ? Side.ON_THE_RIGHT : (tmp < -p_tolerance ? Side.ON_THE_LEFT : Side.COLLINEAR);
        } else {
            System.out.println("IntOctagon.border_line_side_of: p_line_no out of range");
            result = Side.COLLINEAR;
        }
        return result;
    }

    @Override
    public boolean is_IntBox() {
        if (this.llx != this.lx + this.ly) {
            return false;
        }
        if (this.lrx != this.rx - this.ly) {
            return false;
        }
        if (this.urx != this.rx + this.uy) {
            return false;
        }
        return this.ulx == this.lx - this.uy;
    }

    @Override
    public TileShape simplify() {
        if (this.is_IntBox()) {
            return this.bounding_box();
        }
        return this;
    }

    @Override
    public TileShape[] cutout(TileShape p_shape) {
        return p_shape.cutout_from(this);
    }

    IntOctagon[] cutout_from(IntBox p_d) {
        int i;
        IntOctagon c = this.intersection(p_d);
        if (this.is_empty() || c.dimension() < this.dimension()) {
            IntOctagon[] result = new IntOctagon[]{p_d.to_IntOctagon()};
            return result;
        }
        IntBox[] boxes = new IntBox[]{new IntBox(p_d.ll.x, c.llx - c.lx, c.lx, c.lx - c.ulx), new IntBox(c.rx, c.rx - c.lrx, p_d.ur.x, c.urx - c.rx), new IntBox(c.llx - c.ly, p_d.ll.y, c.lrx + c.ly, c.ly), new IntBox(c.ulx + c.uy, c.uy, c.urx - c.uy, p_d.ur.y)};
        IntOctagon[] octagons = new IntOctagon[4];
        IntOctagon curr_oct = new IntOctagon(p_d.ll.x, boxes[0].ur.y, boxes[3].ll.x, p_d.ur.y, -33554432, c.ulx, -33554432, 0x2000000);
        octagons[0] = curr_oct.normalize();
        curr_oct = new IntOctagon(p_d.ll.x, p_d.ll.y, boxes[2].ll.x, boxes[0].ll.y, -33554432, 0x2000000, -33554432, c.llx);
        octagons[1] = curr_oct.normalize();
        curr_oct = new IntOctagon(boxes[2].ur.x, p_d.ll.y, p_d.ur.x, boxes[1].ll.y, c.lrx, 0x2000000, -33554432, 0x2000000);
        octagons[2] = curr_oct.normalize();
        curr_oct = new IntOctagon(boxes[3].ur.x, boxes[1].ur.y, p_d.ur.x, p_d.ur.y, -33554432, 0x2000000, c.urx, 0x2000000);
        octagons[3] = curr_oct.normalize();
        IntBox b = boxes[0];
        IntOctagon o = octagons[0];
        if (b.ur.x - b.ll.x > o.uy - o.ly) {
            boxes[0] = new IntBox(b.ll.x, b.ll.y, b.ur.x, o.uy);
            curr_oct = new IntOctagon(b.ur.x, o.ly, o.rx, o.uy, o.ulx, o.lrx, o.llx, o.urx);
            octagons[0] = curr_oct.normalize();
        }
        b = boxes[3];
        o = octagons[0];
        if (b.ur.y - b.ll.y > o.rx - o.lx) {
            boxes[3] = new IntBox(o.lx, b.ll.y, b.ur.x, b.ur.y);
            curr_oct = new IntOctagon(o.lx, o.ly, o.rx, b.ll.y, o.ulx, o.lrx, o.llx, o.urx);
            octagons[0] = curr_oct.normalize();
        }
        b = boxes[3];
        o = octagons[3];
        if (b.ur.y - b.ll.y > o.rx - o.lx) {
            boxes[3] = new IntBox(b.ll.x, b.ll.y, o.rx, b.ur.y);
            curr_oct = new IntOctagon(o.lx, o.ly, o.rx, o.uy, o.ulx, o.lrx, o.llx, o.urx);
            octagons[3] = curr_oct.normalize();
        }
        b = boxes[1];
        o = octagons[3];
        if (b.ur.x - b.ll.x > o.uy - o.ly) {
            boxes[1] = new IntBox(b.ll.x, b.ll.y, b.ur.x, o.uy);
            curr_oct = new IntOctagon(o.lx, o.ly, b.ll.x, o.uy, o.ulx, o.lrx, o.llx, o.urx);
            octagons[3] = curr_oct.normalize();
        }
        b = boxes[1];
        o = octagons[2];
        if (b.ur.x - b.ll.x > o.uy - o.ly) {
            boxes[1] = new IntBox(b.ll.x, o.ly, b.ur.x, b.ur.y);
            curr_oct = new IntOctagon(o.lx, o.ly, b.ll.x, o.uy, o.ulx, o.lrx, o.llx, o.urx);
            octagons[2] = curr_oct.normalize();
        }
        b = boxes[2];
        o = octagons[2];
        if (b.ur.y - b.ll.y > o.rx - o.lx) {
            boxes[2] = new IntBox(b.ll.x, b.ll.y, o.rx, b.ur.y);
            curr_oct = new IntOctagon(o.lx, b.ur.y, o.rx, o.uy, o.ulx, o.lrx, o.llx, o.urx);
            octagons[2] = curr_oct.normalize();
        }
        b = boxes[2];
        o = octagons[1];
        if (b.ur.y - b.ll.y > o.rx - o.lx) {
            boxes[2] = new IntBox(o.lx, b.ll.y, b.ur.x, b.ur.y);
            curr_oct = new IntOctagon(o.lx, b.ur.y, o.rx, o.uy, o.ulx, o.lrx, o.llx, o.urx);
            octagons[1] = curr_oct.normalize();
        }
        b = boxes[0];
        o = octagons[1];
        if (b.ur.x - b.ll.x > o.uy - o.ly) {
            boxes[0] = new IntBox(b.ll.x, o.ly, b.ur.x, b.ur.y);
            curr_oct = new IntOctagon(b.ur.x, o.ly, o.rx, o.uy, o.ulx, o.lrx, o.llx, o.urx);
            octagons[1] = curr_oct.normalize();
        }
        IntOctagon[] result = new IntOctagon[8];
        for (i = 0; i < 4; ++i) {
            result[i] = boxes[i].to_IntOctagon();
        }
        for (i = 0; i < 4; ++i) {
            result[4 + i] = octagons[i];
        }
        return result;
    }

    IntOctagon[] cutout_from(IntOctagon p_d) {
        IntOctagon c = this.intersection(p_d);
        if (this.is_empty() || c.dimension() < this.dimension()) {
            IntOctagon[] result = new IntOctagon[]{p_d};
            return result;
        }
        IntOctagon[] result = new IntOctagon[8];
        int tmp = c.llx - c.lx;
        result[0] = new IntOctagon(p_d.lx, tmp, c.lx, c.lx - c.ulx, p_d.ulx, p_d.lrx, p_d.llx, p_d.urx);
        int tmp2 = c.llx - c.ly;
        result[1] = new IntOctagon(p_d.lx, p_d.ly, tmp2, tmp, p_d.ulx, p_d.lrx, p_d.llx, c.llx);
        tmp = c.lrx + c.ly;
        result[2] = new IntOctagon(tmp2, p_d.ly, tmp, c.ly, p_d.ulx, p_d.lrx, p_d.llx, p_d.urx);
        tmp2 = c.rx - c.lrx;
        result[3] = new IntOctagon(tmp, p_d.ly, p_d.rx, tmp2, c.lrx, p_d.lrx, p_d.llx, p_d.urx);
        tmp = c.urx - c.rx;
        result[4] = new IntOctagon(c.rx, tmp2, p_d.rx, tmp, p_d.ulx, p_d.lrx, p_d.llx, p_d.urx);
        tmp2 = c.urx - c.uy;
        result[5] = new IntOctagon(tmp2, tmp, p_d.rx, p_d.uy, p_d.ulx, p_d.lrx, c.urx, p_d.urx);
        tmp = c.ulx + c.uy;
        result[6] = new IntOctagon(tmp, c.uy, tmp2, p_d.uy, p_d.ulx, p_d.lrx, p_d.llx, p_d.urx);
        tmp2 = c.lx - c.ulx;
        result[7] = new IntOctagon(p_d.lx, tmp2, tmp, p_d.uy, p_d.ulx, c.ulx, p_d.llx, p_d.urx);
        for (int i = 0; i < 8; ++i) {
            result[i] = result[i].normalize();
        }
        IntOctagon curr_1 = result[0];
        IntOctagon curr_2 = result[7];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_1.rx - curr_1.left_x_value(curr_1.uy) > curr_2.upper_y_value(curr_1.rx) - curr_2.ly) {
            curr_1 = new IntOctagon(Math.min(curr_1.lx, curr_2.lx), curr_1.ly, curr_1.rx, curr_2.uy, curr_2.ulx, curr_1.lrx, curr_1.llx, curr_2.urx);
            curr_2 = new IntOctagon(curr_1.rx, curr_2.ly, curr_2.rx, curr_2.uy, curr_2.ulx, curr_2.lrx, curr_2.llx, curr_2.urx);
            result[0] = curr_1.normalize();
            result[7] = curr_2.normalize();
        }
        curr_1 = result[7];
        curr_2 = result[6];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.upper_y_value(curr_1.rx) - curr_2.ly > curr_1.rx - curr_1.left_x_value(curr_2.ly)) {
            curr_2 = new IntOctagon(curr_1.lx, curr_2.ly, curr_2.rx, Math.max(curr_2.uy, curr_1.uy), curr_1.ulx, curr_2.lrx, curr_1.llx, curr_2.urx);
            curr_1 = new IntOctagon(curr_1.lx, curr_1.ly, curr_1.rx, curr_2.ly, curr_1.ulx, curr_1.lrx, curr_1.llx, curr_1.urx);
            result[7] = curr_1.normalize();
            result[6] = curr_2.normalize();
        }
        curr_1 = result[6];
        curr_2 = result[5];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.upper_y_value(curr_1.rx) - curr_1.ly > curr_2.right_x_value(curr_1.ly) - curr_2.lx) {
            curr_1 = new IntOctagon(curr_1.lx, curr_1.ly, curr_2.rx, Math.max(curr_2.uy, curr_1.uy), curr_1.ulx, curr_2.lrx, curr_1.llx, curr_2.urx);
            curr_2 = new IntOctagon(curr_2.lx, curr_2.ly, curr_2.rx, curr_1.ly, curr_2.ulx, curr_2.lrx, curr_2.llx, curr_2.urx);
            result[6] = curr_1.normalize();
            result[5] = curr_2.normalize();
        }
        curr_1 = result[5];
        curr_2 = result[4];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.right_x_value(curr_2.uy) - curr_2.lx > curr_1.upper_y_value(curr_2.lx) - curr_2.uy) {
            curr_2 = new IntOctagon(curr_2.lx, curr_2.ly, Math.max(curr_2.rx, curr_1.rx), curr_1.uy, curr_1.ulx, curr_2.lrx, curr_2.llx, curr_1.urx);
            curr_1 = new IntOctagon(curr_1.lx, curr_1.ly, curr_2.lx, curr_1.uy, curr_1.ulx, curr_1.lrx, curr_1.llx, curr_1.urx);
            result[5] = curr_1.normalize();
            result[4] = curr_2.normalize();
        }
        curr_1 = result[4];
        curr_2 = result[3];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_1.right_x_value(curr_1.ly) - curr_1.lx > curr_1.ly - curr_2.lower_y_value(curr_1.lx)) {
            curr_1 = new IntOctagon(curr_1.lx, curr_2.ly, Math.max(curr_2.rx, curr_1.rx), curr_1.uy, curr_1.ulx, curr_2.lrx, curr_2.llx, curr_1.urx);
            curr_2 = new IntOctagon(curr_2.lx, curr_2.ly, curr_1.lx, curr_2.uy, curr_2.ulx, curr_2.lrx, curr_2.llx, curr_2.urx);
            result[4] = curr_1.normalize();
            result[3] = curr_2.normalize();
        }
        curr_1 = result[3];
        curr_2 = result[2];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.uy - curr_2.lower_y_value(curr_2.rx) > curr_1.right_x_value(curr_2.uy) - curr_2.rx) {
            curr_2 = new IntOctagon(curr_2.lx, Math.min(curr_1.ly, curr_2.ly), curr_1.rx, curr_2.uy, curr_2.ulx, curr_1.lrx, curr_2.llx, curr_1.urx);
            curr_1 = new IntOctagon(curr_1.lx, curr_2.uy, curr_1.rx, curr_1.uy, curr_1.ulx, curr_1.lrx, curr_1.llx, curr_1.urx);
            result[3] = curr_1.normalize();
            result[2] = curr_2.normalize();
        }
        curr_1 = result[2];
        curr_2 = result[1];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_1.uy - curr_1.lower_y_value(curr_1.lx) > curr_1.lx - curr_2.left_x_value(curr_1.uy)) {
            curr_1 = new IntOctagon(curr_2.lx, Math.min(curr_1.ly, curr_2.ly), curr_1.rx, curr_1.uy, curr_2.ulx, curr_1.lrx, curr_2.llx, curr_1.urx);
            curr_2 = new IntOctagon(curr_2.lx, curr_1.uy, curr_2.rx, curr_2.uy, curr_2.ulx, curr_2.lrx, curr_2.llx, curr_2.urx);
            result[2] = curr_1.normalize();
            result[1] = curr_2.normalize();
        }
        curr_1 = result[1];
        curr_2 = result[0];
        if (!curr_1.is_empty() && !curr_2.is_empty() && curr_2.rx - curr_2.left_x_value(curr_2.ly) > curr_2.ly - curr_1.lower_y_value(curr_2.rx)) {
            curr_2 = new IntOctagon(Math.min(curr_2.lx, curr_1.lx), curr_1.ly, curr_2.rx, curr_2.uy, curr_2.ulx, curr_1.lrx, curr_1.llx, curr_2.urx);
            curr_1 = new IntOctagon(curr_2.rx, curr_1.ly, curr_1.rx, curr_1.uy, curr_1.ulx, curr_1.lrx, curr_1.llx, curr_1.urx);
            result[1] = curr_1.normalize();
            result[0] = curr_2.normalize();
        }
        return result;
    }

    Simplex[] cutout_from(Simplex p_simplex) {
        return this.to_Simplex().cutout_from(p_simplex);
    }
}

