/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import datastructures.Signum;
import geometry.planar.BigIntDirection;
import geometry.planar.Direction;
import geometry.planar.IntVector;
import geometry.planar.Vector;
import java.io.Serializable;

public class IntDirection
extends Direction
implements Serializable {
    public final int x;
    public final int y;

    @Override
    public boolean is_orthogonal() {
        return this.x == 0 || this.y == 0;
    }

    @Override
    public boolean is_diagonal() {
        return Math.abs(this.x) == Math.abs(this.y);
    }

    @Override
    public Vector get_vector() {
        return new IntVector(this.x, this.y);
    }

    IntDirection(int p_x, int p_y) {
        this.x = p_x;
        this.y = p_y;
    }

    IntDirection(IntVector p_vector) {
        this.x = p_vector.x;
        this.y = p_vector.y;
    }

    @Override
    int compareTo(IntDirection p_other) {
        if (this.y > 0) {
            if (p_other.y < 0) {
                return -1;
            }
            if (p_other.y == 0) {
                if (p_other.x > 0) {
                    return 1;
                }
                return -1;
            }
        } else if (this.y < 0) {
            if (p_other.y >= 0) {
                return 1;
            }
        } else {
            if (this.x > 0) {
                if (p_other.y != 0 || p_other.x < 0) {
                    return -1;
                }
                return 0;
            }
            if (p_other.y > 0 || p_other.y == 0 && p_other.x > 0) {
                return 1;
            }
            if (p_other.y < 0) {
                return -1;
            }
            return 0;
        }
        double determinant = (double)p_other.x * (double)this.y - (double)p_other.y * (double)this.x;
        return Signum.as_int(determinant);
    }

    @Override
    public Direction opposite() {
        return new IntDirection(-this.x, -this.y);
    }

    @Override
    public Direction turn_45_degree(int p_factor) {
        int new_y;
        int new_x;
        int n = p_factor % 8;
        switch (n) {
            case 0: {
                new_x = this.x;
                new_y = this.y;
                break;
            }
            case 1: {
                new_x = this.x - this.y;
                new_y = this.x + this.y;
                break;
            }
            case 2: {
                new_x = -this.y;
                new_y = this.x;
                break;
            }
            case 3: {
                new_x = -this.x - this.y;
                new_y = this.x - this.y;
                break;
            }
            case 4: {
                new_x = -this.x;
                new_y = -this.y;
                break;
            }
            case 5: {
                new_x = this.y - this.x;
                new_y = -this.x - this.y;
                break;
            }
            case 6: {
                new_x = this.y;
                new_y = -this.x;
                break;
            }
            case 7: {
                new_x = this.x + this.y;
                new_y = this.y - this.x;
                break;
            }
            default: {
                new_x = 0;
                new_y = 0;
            }
        }
        return new IntDirection(new_x, new_y);
    }

    @Override
    public int compareTo(Direction p_other_direction) {
        return -p_other_direction.compareTo(this);
    }

    @Override
    int compareTo(BigIntDirection p_other) {
        return -p_other.compareTo(this);
    }

    final double determinant(IntDirection p_other) {
        return (double)this.x * (double)p_other.y - (double)this.y * (double)p_other.x;
    }
}

