/*
 * Decompiled with CFR 0.152.
 */
package geometry.planar;

import geometry.planar.Circle;
import geometry.planar.Direction;
import geometry.planar.FloatPoint;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.Line;
import geometry.planar.RegularTileShape;
import geometry.planar.Shape;
import geometry.planar.ShapeBoundingDirections;
import geometry.planar.Side;
import geometry.planar.Simplex;
import geometry.planar.TileShape;
import geometry.planar.Vector;
import java.io.Serializable;

public class IntBox
extends RegularTileShape
implements Serializable {
    public static final IntBox EMPTY = new IntBox(0x2000000, 0x2000000, -33554432, -33554432);
    public final IntPoint ll;
    public final IntPoint ur;

    public IntBox(IntPoint p_ll, IntPoint p_ur) {
        this.ll = p_ll;
        this.ur = p_ur;
    }

    public IntBox(int p_ll_x, int p_ll_y, int p_ur_x, int p_ur_y) {
        this.ll = new IntPoint(p_ll_x, p_ll_y);
        this.ur = new IntPoint(p_ur_x, p_ur_y);
    }

    @Override
    public boolean is_IntOctagon() {
        return true;
    }

    @Override
    public boolean is_empty() {
        return this.ll.x > this.ur.x || this.ll.y > this.ur.y;
    }

    @Override
    public int border_line_count() {
        return 4;
    }

    public int width() {
        return this.ur.x - this.ll.x;
    }

    public int height() {
        return this.ur.y - this.ll.y;
    }

    @Override
    public double max_width() {
        return Math.max(this.ur.x - this.ll.x, this.ur.y - this.ll.y);
    }

    @Override
    public double min_width() {
        return Math.min(this.ur.x - this.ll.x, this.ur.y - this.ll.y);
    }

    @Override
    public double area() {
        return (double)(this.ur.x - this.ll.x) * (double)(this.ur.y - this.ll.y);
    }

    @Override
    public double circumference() {
        return 2 * (this.ur.x - this.ll.x + (this.ur.y - this.ll.y));
    }

    @Override
    public IntPoint corner(int p_no) {
        if (p_no == 0) {
            return this.ll;
        }
        if (p_no == 1) {
            return new IntPoint(this.ur.x, this.ll.y);
        }
        if (p_no == 2) {
            return this.ur;
        }
        if (p_no == 3) {
            return new IntPoint(this.ll.x, this.ur.y);
        }
        throw new IllegalArgumentException("IntBox.corner: p_no out of range");
    }

    @Override
    public int dimension() {
        if (this.is_empty()) {
            return -1;
        }
        if (this.ll.equals(this.ur)) {
            return 0;
        }
        if (this.ur.x == this.ll.x || this.ll.y == this.ur.y) {
            return 1;
        }
        return 2;
    }

    public boolean contains_inside(IntPoint p_point) {
        return p_point.x > this.ll.x && p_point.x < this.ur.x && p_point.y > this.ll.y && p_point.y < this.ur.y;
    }

    @Override
    public boolean is_IntBox() {
        return true;
    }

    @Override
    public TileShape simplify() {
        return this;
    }

    public FloatPoint nearest_point(FloatPoint p_from_point) {
        double x = p_from_point.x <= (double)this.ll.x ? (double)this.ll.x : (p_from_point.x >= (double)this.ur.x ? (double)this.ur.x : p_from_point.x);
        double y = p_from_point.y <= (double)this.ll.y ? (double)this.ll.y : (p_from_point.y >= (double)this.ur.y ? (double)this.ur.y : p_from_point.y);
        return new FloatPoint(x, y);
    }

    public IntPoint[] nearest_border_projections(IntPoint p_point, int p_max_result_points) {
        int second_min_diff;
        int min_diff;
        if (p_max_result_points <= 0) {
            return new IntPoint[0];
        }
        p_max_result_points = Math.min(p_max_result_points, 2);
        IntPoint[] result = new IntPoint[p_max_result_points];
        int lower_x_diff = p_point.x - this.ll.x;
        int upper_x_diff = this.ur.x - p_point.x;
        int lower_y_diff = p_point.y - this.ll.y;
        int upper_y_diff = this.ur.y - p_point.y;
        int nearest_projection_x = p_point.x;
        int nearest_projection_y = p_point.y;
        int second_nearest_projection_x = p_point.x;
        int second_nearest_projection_y = p_point.y;
        if (lower_x_diff <= upper_x_diff) {
            min_diff = lower_x_diff;
            second_min_diff = upper_x_diff;
            nearest_projection_x = this.ll.x;
            second_nearest_projection_x = this.ur.x;
        } else {
            min_diff = upper_x_diff;
            second_min_diff = lower_x_diff;
            nearest_projection_x = this.ur.x;
            second_nearest_projection_x = this.ll.x;
        }
        if (lower_y_diff < min_diff) {
            second_min_diff = min_diff;
            min_diff = lower_y_diff;
            second_nearest_projection_x = nearest_projection_x;
            second_nearest_projection_y = nearest_projection_y;
            nearest_projection_x = p_point.x;
            nearest_projection_y = this.ll.y;
        } else if (lower_y_diff < second_min_diff) {
            second_min_diff = lower_y_diff;
            second_nearest_projection_x = p_point.x;
            second_nearest_projection_y = this.ll.y;
        }
        if (upper_y_diff < min_diff) {
            second_min_diff = min_diff;
            min_diff = upper_y_diff;
            second_nearest_projection_x = nearest_projection_x;
            second_nearest_projection_y = nearest_projection_y;
            nearest_projection_x = p_point.x;
            nearest_projection_y = this.ur.y;
        } else if (upper_y_diff < second_min_diff) {
            second_min_diff = upper_y_diff;
            second_nearest_projection_x = p_point.x;
            second_nearest_projection_y = this.ur.y;
        }
        result[0] = new IntPoint(nearest_projection_x, nearest_projection_y);
        if (result.length > 1) {
            result[1] = new IntPoint(second_nearest_projection_x, second_nearest_projection_y);
        }
        return result;
    }

    @Override
    public double distance(FloatPoint p_from_point) {
        return p_from_point.distance(this.nearest_point(p_from_point));
    }

    public double weighted_distance(IntBox p_other, double p_horizontal_weight, double p_vertical_weight) {
        double result;
        double max_ll_x = Math.max(this.ll.x, p_other.ll.x);
        double max_ll_y = Math.max(this.ll.y, p_other.ll.y);
        double min_ur_x = Math.min(this.ur.x, p_other.ur.x);
        double min_ur_y = Math.min(this.ur.y, p_other.ur.y);
        if (min_ur_x >= max_ll_x) {
            result = Math.max(p_vertical_weight * (max_ll_y - min_ur_y), 0.0);
        } else if (min_ur_y >= max_ll_y) {
            result = Math.max(p_horizontal_weight * (max_ll_x - min_ur_x), 0.0);
        } else {
            double delta_x = max_ll_x - min_ur_x;
            double delta_y = max_ll_y - min_ur_y;
            result = Math.sqrt((delta_x *= p_horizontal_weight) * delta_x + (delta_y *= p_vertical_weight) * delta_y);
        }
        return result;
    }

    @Override
    public IntBox bounding_box() {
        return this;
    }

    @Override
    public IntOctagon bounding_octagon() {
        return this.to_IntOctagon();
    }

    @Override
    public boolean is_bounded() {
        return true;
    }

    @Override
    public IntBox bounding_tile() {
        return this;
    }

    @Override
    public boolean corner_is_bounded(int p_no) {
        return true;
    }

    @Override
    public RegularTileShape union(RegularTileShape p_other) {
        return p_other.union(this);
    }

    @Override
    public IntBox union(IntBox p_other) {
        int llx = Math.min(this.ll.x, p_other.ll.x);
        int lly = Math.min(this.ll.y, p_other.ll.y);
        int urx = Math.max(this.ur.x, p_other.ur.x);
        int ury = Math.max(this.ur.y, p_other.ur.y);
        return new IntBox(llx, lly, urx, ury);
    }

    @Override
    public IntBox intersection(IntBox p_other) {
        if (p_other.ll.x > this.ur.x) {
            return EMPTY;
        }
        if (p_other.ll.y > this.ur.y) {
            return EMPTY;
        }
        if (this.ll.x > p_other.ur.x) {
            return EMPTY;
        }
        if (this.ll.y > p_other.ur.y) {
            return EMPTY;
        }
        int llx = Math.max(this.ll.x, p_other.ll.x);
        int urx = Math.min(this.ur.x, p_other.ur.x);
        int lly = Math.max(this.ll.y, p_other.ll.y);
        int ury = Math.min(this.ur.y, p_other.ur.y);
        return new IntBox(llx, lly, urx, ury);
    }

    @Override
    public TileShape intersection(TileShape p_other) {
        return p_other.intersection(this);
    }

    @Override
    IntOctagon intersection(IntOctagon p_other) {
        return p_other.intersection(this.to_IntOctagon());
    }

    @Override
    Simplex intersection(Simplex p_other) {
        return p_other.intersection(this.to_Simplex());
    }

    @Override
    public boolean intersects(Shape p_other) {
        return p_other.intersects(this);
    }

    @Override
    public boolean intersects(IntBox p_other) {
        if (p_other.ll.x > this.ur.x) {
            return false;
        }
        if (p_other.ll.y > this.ur.y) {
            return false;
        }
        if (this.ll.x > p_other.ur.x) {
            return false;
        }
        return this.ll.y <= p_other.ur.y;
    }

    public boolean overlaps(IntBox p_other) {
        if (p_other.ll.x >= this.ur.x) {
            return false;
        }
        if (p_other.ll.y >= this.ur.y) {
            return false;
        }
        if (this.ll.x >= p_other.ur.x) {
            return false;
        }
        return this.ll.y < p_other.ur.y;
    }

    @Override
    public boolean contains(RegularTileShape p_other) {
        return p_other.is_contained_in(this);
    }

    @Override
    public RegularTileShape bounding_shape(ShapeBoundingDirections p_dirs) {
        return p_dirs.bounds(this);
    }

    @Override
    public IntOctagon enlarge(double p_offset) {
        return this.bounding_octagon().offset(p_offset);
    }

    @Override
    public IntBox translate_by(Vector p_rel_coor) {
        if (p_rel_coor.equals(Vector.ZERO)) {
            return this;
        }
        IntPoint new_ll = (IntPoint)this.ll.translate_by(p_rel_coor);
        IntPoint new_ur = (IntPoint)this.ur.translate_by(p_rel_coor);
        return new IntBox(new_ll, new_ur);
    }

    @Override
    public IntBox turn_90_degree(int p_factor, IntPoint p_pole) {
        IntPoint p1 = (IntPoint)this.ll.turn_90_degree(p_factor, p_pole);
        IntPoint p2 = (IntPoint)this.ur.turn_90_degree(p_factor, p_pole);
        int llx = Math.min(p1.x, p2.x);
        int lly = Math.min(p1.y, p2.y);
        int urx = Math.max(p1.x, p2.x);
        int ury = Math.max(p1.y, p2.y);
        return new IntBox(llx, lly, urx, ury);
    }

    @Override
    public Line border_line(int p_no) {
        int b_y;
        int b_x;
        int a_y;
        int a_x;
        switch (p_no) {
            case 0: {
                a_x = 0;
                a_y = this.ll.y;
                b_x = 1;
                b_y = this.ll.y;
                break;
            }
            case 1: {
                a_x = this.ur.x;
                a_y = 0;
                b_x = this.ur.x;
                b_y = 1;
                break;
            }
            case 2: {
                a_x = 0;
                a_y = this.ur.y;
                b_x = -1;
                b_y = this.ur.y;
                break;
            }
            case 3: {
                a_x = this.ll.x;
                a_y = 0;
                b_x = this.ll.x;
                b_y = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("IntBox.edge_line: p_no out of range");
            }
        }
        return new Line(a_x, a_y, b_x, b_y);
    }

    @Override
    public int border_line_index(Line p_line) {
        System.out.println("edge_index_of_line not yet implemented for IntBoxes");
        return -1;
    }

    @Override
    public IntBox offset(double p_dist) {
        if (p_dist == 0.0 || this.is_empty()) {
            return this;
        }
        int dist = (int)Math.round(p_dist);
        IntPoint lower_left = new IntPoint(this.ll.x - dist, this.ll.y - dist);
        IntPoint upper_right = new IntPoint(this.ur.x + dist, this.ur.y + dist);
        return new IntBox(lower_left, upper_right);
    }

    public IntBox horizontal_offset(double p_dist) {
        if (p_dist == 0.0 || this.is_empty()) {
            return this;
        }
        int dist = (int)Math.round(p_dist);
        IntPoint lower_left = new IntPoint(this.ll.x - dist, this.ll.y);
        IntPoint upper_right = new IntPoint(this.ur.x + dist, this.ur.y);
        return new IntBox(lower_left, upper_right);
    }

    public IntBox vertical_offset(double p_dist) {
        if (p_dist == 0.0 || this.is_empty()) {
            return this;
        }
        int dist = (int)Math.round(p_dist);
        IntPoint lower_left = new IntPoint(this.ll.x, this.ll.y - dist);
        IntPoint upper_right = new IntPoint(this.ur.x, this.ur.y + dist);
        return new IntBox(lower_left, upper_right);
    }

    public IntBox shrink(int p_width) {
        int ur_y;
        int ll_y;
        int ur_x;
        int ll_x;
        if (2 * p_width <= this.ur.x - this.ll.x) {
            ll_x = this.ll.x + p_width;
            ur_x = this.ur.x - p_width;
        } else {
            ur_x = ll_x = (this.ll.x + this.ur.x) / 2;
        }
        if (2 * p_width <= this.ur.y - this.ll.y) {
            ll_y = this.ll.y + p_width;
            ur_y = this.ur.y - p_width;
        } else {
            ur_y = ll_y = (this.ll.y + this.ur.y) / 2;
        }
        return new IntBox(ll_x, ll_y, ur_x, ur_y);
    }

    @Override
    public Side compare(RegularTileShape p_other, int p_edge_no) {
        Side result = p_other.compare(this, p_edge_no);
        return result.negate();
    }

    @Override
    public Side compare(IntBox p_other, int p_edge_no) {
        Side result;
        switch (p_edge_no) {
            case 0: {
                if (this.ll.y > p_other.ll.y) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.ll.y < p_other.ll.y) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 1: {
                if (this.ur.x < p_other.ur.x) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.ur.x > p_other.ur.x) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 2: {
                if (this.ur.y < p_other.ur.y) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.ur.y > p_other.ur.y) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            case 3: {
                if (this.ll.x > p_other.ll.x) {
                    result = Side.ON_THE_LEFT;
                    break;
                }
                if (this.ll.x < p_other.ll.x) {
                    result = Side.ON_THE_RIGHT;
                    break;
                }
                result = Side.COLLINEAR;
                break;
            }
            default: {
                throw new IllegalArgumentException("IntBox.compare: p_edge_no out of range");
            }
        }
        return result;
    }

    public IntOctagon to_IntOctagon() {
        return new IntOctagon(this.ll.x, this.ll.y, this.ur.x, this.ur.y, this.ll.x - this.ur.y, this.ur.x - this.ll.y, this.ll.x + this.ll.y, this.ur.x + this.ur.y);
    }

    @Override
    public Simplex to_Simplex() {
        Line[] line_arr = this.is_empty() ? new Line[]{} : new Line[]{Line.get_instance(this.ll, Direction.RIGHT), Line.get_instance(this.ur, Direction.UP), Line.get_instance(this.ur, Direction.LEFT), Line.get_instance(this.ll, Direction.DOWN)};
        return new Simplex(line_arr);
    }

    @Override
    public boolean is_contained_in(IntBox p_other) {
        if (this.is_empty() || this == p_other) {
            return true;
        }
        return this.ll.x >= p_other.ll.x && this.ll.y >= p_other.ll.y && this.ur.x <= p_other.ur.x && this.ur.y <= p_other.ur.y;
    }

    public boolean contains_in_interiour(IntBox p_other) {
        if (p_other.is_empty()) {
            return true;
        }
        return p_other.ll.x > this.ll.x && p_other.ll.y > this.ll.y && p_other.ur.x < this.ur.x && p_other.ur.y < this.ur.y;
    }

    public IntBox nearest_part(IntBox p_from_box) {
        int ll_x = p_from_box.ll.x >= this.ll.x ? p_from_box.ll.x : (p_from_box.ur.x >= this.ll.x ? this.ll.x : p_from_box.ur.x);
        int ur_x = p_from_box.ur.x <= this.ur.x ? p_from_box.ur.x : (p_from_box.ll.x <= this.ur.x ? this.ur.x : p_from_box.ll.x);
        int ll_y = p_from_box.ll.y >= this.ll.y ? p_from_box.ll.y : (p_from_box.ur.y >= this.ll.y ? this.ll.y : p_from_box.ur.y);
        int ur_y = p_from_box.ur.y <= this.ur.y ? p_from_box.ur.y : (p_from_box.ll.y <= this.ur.y ? this.ur.y : p_from_box.ll.y);
        return new IntBox(ll_x, ll_y, ur_x, ur_y);
    }

    @Override
    public boolean is_contained_in(IntOctagon p_other) {
        return p_other.contains(this.to_IntOctagon());
    }

    @Override
    public boolean intersects(IntOctagon p_other) {
        return p_other.intersects(this.to_IntOctagon());
    }

    @Override
    public boolean intersects(Simplex p_other) {
        return p_other.intersects(this.to_Simplex());
    }

    @Override
    public boolean intersects(Circle p_other) {
        return p_other.intersects(this);
    }

    @Override
    public IntOctagon union(IntOctagon p_other) {
        return p_other.union(this.to_IntOctagon());
    }

    @Override
    public Side compare(IntOctagon p_other, int p_edge_no) {
        return this.to_IntOctagon().compare(p_other, p_edge_no);
    }

    public IntBox[] divide_into_sections(double p_max_section_width) {
        if (p_max_section_width <= 0.0) {
            return new IntBox[0];
        }
        double length = this.ur.x - this.ll.x;
        double height = this.ur.y - this.ll.y;
        int x_count = (int)Math.ceil(length / p_max_section_width);
        int y_count = (int)Math.ceil(height / p_max_section_width);
        int section_length_x = (int)Math.ceil(length / (double)x_count);
        int section_length_y = (int)Math.ceil(height / (double)y_count);
        IntBox[] result = new IntBox[x_count * y_count];
        int curr_index = 0;
        for (int j = 0; j < y_count; ++j) {
            int curr_lly = this.ll.y + j * section_length_y;
            int curr_ury = j == y_count - 1 ? this.ur.y : curr_lly + section_length_y;
            for (int i = 0; i < x_count; ++i) {
                int curr_llx = this.ll.x + i * section_length_x;
                int curr_urx = i == x_count - 1 ? this.ur.x : curr_llx + section_length_x;
                result[curr_index] = new IntBox(curr_llx, curr_lly, curr_urx, curr_ury);
                ++curr_index;
            }
        }
        return result;
    }

    @Override
    public TileShape[] cutout(TileShape p_shape) {
        TileShape[] tmp_result = p_shape.cutout_from(this);
        TileShape[] result = new TileShape[tmp_result.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tmp_result[i].simplify();
        }
        return result;
    }

    IntBox[] cutout_from(IntBox p_d) {
        IntBox c = this.intersection(p_d);
        if (this.is_empty() || c.dimension() < this.dimension()) {
            IntBox[] result = new IntBox[]{p_d};
            return result;
        }
        IntBox[] result = new IntBox[]{new IntBox(p_d.ll.x, p_d.ll.y, c.ur.x, c.ll.y), new IntBox(p_d.ll.x, c.ll.y, c.ll.x, p_d.ur.y), new IntBox(c.ur.x, p_d.ll.y, p_d.ur.x, c.ur.y), new IntBox(c.ll.x, c.ur.y, p_d.ur.x, p_d.ur.y)};
        IntBox b = null;
        if (c.ll.x - p_d.ll.x > c.ll.y - p_d.ll.y) {
            b = result[0];
            result[0] = new IntBox(c.ll.x, b.ll.y, b.ur.x, b.ur.y);
            b = result[1];
            result[1] = new IntBox(b.ll.x, p_d.ll.y, b.ur.x, b.ur.y);
        }
        if (p_d.ur.y - c.ur.y > c.ll.x - p_d.ll.x) {
            b = result[1];
            result[1] = new IntBox(b.ll.x, b.ll.y, b.ur.x, c.ur.y);
            b = result[3];
            result[3] = new IntBox(p_d.ll.x, b.ll.y, b.ur.x, b.ur.y);
        }
        if (p_d.ur.x - c.ur.x > p_d.ur.y - c.ur.y) {
            b = result[2];
            result[2] = new IntBox(b.ll.x, b.ll.y, b.ur.x, p_d.ur.y);
            b = result[3];
            result[3] = new IntBox(b.ll.x, b.ll.y, c.ur.x, b.ur.y);
        }
        if (c.ll.y - p_d.ll.y > p_d.ur.x - c.ur.x) {
            b = result[0];
            result[0] = new IntBox(b.ll.x, b.ll.y, p_d.ur.x, b.ur.y);
            b = result[2];
            result[2] = new IntBox(b.ll.x, c.ll.y, b.ur.x, b.ur.y);
        }
        return result;
    }

    Simplex[] cutout_from(Simplex p_simplex) {
        return this.to_Simplex().cutout_from(p_simplex);
    }

    IntOctagon[] cutout_from(IntOctagon p_oct) {
        return this.to_IntOctagon().cutout_from(p_oct);
    }
}

