/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import datastructures.IdentifierType;
import datastructures.IndentFileWriter;
import designformats.specctra.Circle;
import designformats.specctra.CoordinateTransform;
import designformats.specctra.DsnFile;
import designformats.specctra.Keyword;
import designformats.specctra.Layer;
import designformats.specctra.LayerStructure;
import designformats.specctra.Polygon;
import designformats.specctra.PolygonPath;
import designformats.specctra.PolylinePath;
import designformats.specctra.Rectangle;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import geometry.planar.Area;
import geometry.planar.PolylineArea;
import geometry.planar.PolylineShape;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Shape {
    public final Layer layer;

    public abstract void write_scope(IndentFileWriter var1, IdentifierType var2) throws IOException;

    public abstract void write_scope_int(IndentFileWriter var1, IdentifierType var2) throws IOException;

    public static final Shape read_scope(Scanner p_scanner, LayerStructure p_layer_structure) {
        Shape result = null;
        try {
            Object next_token = p_scanner.next_token();
            if (next_token == Keyword.OPEN_BRACKET) {
                next_token = p_scanner.next_token();
            }
            if (next_token == Keyword.RECTANGLE) {
                result = Shape.read_rectangle_scope(p_scanner, p_layer_structure);
            } else if (next_token == Keyword.POLYGON) {
                result = Shape.read_polygon_scope(p_scanner, p_layer_structure);
            } else if (next_token == Keyword.CIRCLE) {
                result = Shape.read_circle_scope(p_scanner, p_layer_structure);
            } else if (next_token == Keyword.POLYGON_PATH) {
                result = Shape.read_polygon_path_scope(p_scanner, p_layer_structure);
            } else {
                ScopeKeyword.skip_scope(p_scanner);
            }
        }
        catch (IOException e) {
            System.out.println("Shape.read_scope: IO error scanning file");
            System.out.println(e);
            return result;
        }
        return result;
    }

    public static PolylinePath read_polyline_path_scope(Scanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Layer layer = null;
            Object next_token = p_scanner.next_token();
            if (next_token == Keyword.PCB_SCOPE) {
                layer = Layer.PCB;
            } else if (next_token == Keyword.SIGNAL) {
                layer = Layer.SIGNAL;
            } else {
                if (p_layer_structure == null) {
                    System.out.println("PolylinePath.read_scope: only layer types pcb or signal expected");
                    return null;
                }
                if (!(next_token instanceof String)) {
                    System.out.println("PolylinePath.read_scope: layer name string expected");
                    return null;
                }
                int layer_no = p_layer_structure.get_no((String)next_token);
                if (layer_no < 0 || layer_no >= p_layer_structure.arr.length) {
                    System.out.print("Shape.read_polyline_path_scope: layer name ");
                    System.out.print((String)next_token);
                    System.out.println(" not found in layer structure ");
                    return null;
                }
                layer = p_layer_structure.arr[layer_no];
            }
            LinkedList<Object> corner_list = new LinkedList<Object>();
            while ((next_token = p_scanner.next_token()) != Keyword.CLOSED_BRACKET) {
                corner_list.add(next_token);
            }
            if (corner_list.size() < 5) {
                System.out.println("PolylinePath.read_scope: to few numbers in scope");
                return null;
            }
            Iterator it = corner_list.iterator();
            double width = 0.0;
            Object next_object = it.next();
            if (next_object instanceof Double) {
                width = (Double)next_object;
            } else if (next_object instanceof Integer) {
                width = ((Integer)next_object).intValue();
            } else {
                System.out.println("PolylinePath.read_scope: number expected");
                return null;
            }
            double[] corner_arr = new double[corner_list.size() - 1];
            for (int i = 0; i < corner_arr.length; ++i) {
                next_object = it.next();
                if (next_object instanceof Double) {
                    corner_arr[i] = (Double)next_object;
                    continue;
                }
                if (next_object instanceof Integer) {
                    corner_arr[i] = ((Integer)next_object).intValue();
                    continue;
                }
                System.out.println("Shape.read_polygon_path_scope: number expected");
                return null;
            }
            return new PolylinePath(layer, width, corner_arr);
        }
        catch (IOException e) {
            System.out.println("PolylinePath.read_scope: IO error scanning file");
            System.out.println(e);
            return null;
        }
    }

    public static final ReadAreaScopeResult read_area_scope(Scanner p_scanner, LayerStructure p_layer_structure, boolean p_skip_window_scopes) {
        Shape curr_shape;
        String curr_name;
        LinkedList<Shape> shape_list = new LinkedList<Shape>();
        String clearance_class_name = null;
        String area_name = null;
        boolean result_ok = true;
        Object next_token = null;
        try {
            next_token = p_scanner.next_token();
        }
        catch (IOException e) {
            System.out.println("Shape.read_area_scope: IO error scanning file");
            return null;
        }
        if (next_token instanceof String && !(curr_name = (String)next_token).isEmpty()) {
            area_name = curr_name;
        }
        if ((curr_shape = Shape.read_scope(p_scanner, p_layer_structure)) == null) {
            result_ok = false;
        }
        shape_list.add(curr_shape);
        next_token = null;
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("Shape.read_area_scope: IO error scanning file");
                return null;
            }
            if (next_token == null) {
                System.out.println("Shape.read_area_scope: unexpected end of file");
                return null;
            }
            if (next_token == Keyword.CLOSED_BRACKET) break;
            if (prev_token != Keyword.OPEN_BRACKET) continue;
            if (next_token == Keyword.WINDOW && !p_skip_window_scopes) {
                Shape hole_shape = Shape.read_scope(p_scanner, p_layer_structure);
                shape_list.add(hole_shape);
                try {
                    next_token = p_scanner.next_token();
                }
                catch (IOException e) {
                    System.out.println("Shape.read_area_scope: IO error scanning file");
                    return null;
                }
                if (next_token == Keyword.CLOSED_BRACKET) continue;
                System.out.println("Shape.read_area_scope: closed bracket expected");
                return null;
            }
            if (next_token == Keyword.CLEARANCE_CLASS) {
                clearance_class_name = DsnFile.read_string_scope(p_scanner);
                continue;
            }
            ScopeKeyword.skip_scope(p_scanner);
        }
        if (!result_ok) {
            return null;
        }
        return new ReadAreaScopeResult(area_name, shape_list, clearance_class_name);
    }

    public static Rectangle read_rectangle_scope(Scanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Layer rect_layer = null;
            double[] rect_coor = new double[4];
            Object next_token = p_scanner.next_token();
            if (next_token == Keyword.PCB_SCOPE) {
                rect_layer = Layer.PCB;
            } else if (next_token == Keyword.SIGNAL) {
                rect_layer = Layer.SIGNAL;
            } else if (p_layer_structure != null) {
                if (!(next_token instanceof String)) {
                    System.out.println("Shape.read_rectangle_scope: layer name string expected");
                    return null;
                }
                String layer_name = (String)next_token;
                int layer_no = p_layer_structure.get_no(layer_name);
                if (layer_no < 0 || layer_no >= p_layer_structure.arr.length) {
                    System.out.println("Shape.read_rectangle_scope: layer name " + layer_name + " not found in layer structure ");
                } else {
                    rect_layer = p_layer_structure.arr[layer_no];
                }
            } else {
                rect_layer = Layer.SIGNAL;
            }
            for (int i = 0; i < 4; ++i) {
                next_token = p_scanner.next_token();
                if (next_token instanceof Double) {
                    rect_coor[i] = (Double)next_token;
                    continue;
                }
                if (next_token instanceof Integer) {
                    rect_coor[i] = ((Integer)next_token).intValue();
                    continue;
                }
                System.out.println("Shape.read_rectangle_scope: number expected");
                return null;
            }
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("Shape.read_rectangle_scope ) expected");
                return null;
            }
            if (rect_layer == null) {
                return null;
            }
            return new Rectangle(rect_layer, rect_coor);
        }
        catch (IOException e) {
            System.out.println("Shape.read_rectangle_scope: IO error scanning file");
            System.out.println(e);
            return null;
        }
    }

    public static Polygon read_polygon_scope(Scanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Layer polygon_layer = null;
            boolean layer_ok = true;
            Object next_token = p_scanner.next_token();
            if (next_token == Keyword.PCB_SCOPE) {
                polygon_layer = Layer.PCB;
            } else if (next_token == Keyword.SIGNAL) {
                polygon_layer = Layer.SIGNAL;
            } else {
                if (p_layer_structure == null) {
                    System.out.println("Shape.read_polygon_scope: only layer types pcb or signal expected");
                    return null;
                }
                if (!(next_token instanceof String)) {
                    System.out.println("Shape.read_polygon_scope: layer name string expected");
                    return null;
                }
                int layer_no = p_layer_structure.get_no((String)next_token);
                if (layer_no < 0 || layer_no >= p_layer_structure.arr.length) {
                    System.out.print("Shape.read_polygon_scope: layer name ");
                    System.out.print((String)next_token);
                    System.out.println(" not found in layer structure ");
                    layer_ok = false;
                } else {
                    polygon_layer = p_layer_structure.arr[layer_no];
                }
            }
            next_token = p_scanner.next_token();
            LinkedList<Object> coor_list = new LinkedList<Object>();
            while (true) {
                if ((next_token = p_scanner.next_token()) == null) {
                    System.out.println("Shape.read_polygon_scope: unexpected end of file");
                    return null;
                }
                if (next_token == Keyword.OPEN_BRACKET) {
                    ScopeKeyword.skip_scope(p_scanner);
                    next_token = p_scanner.next_token();
                }
                if (next_token == Keyword.CLOSED_BRACKET) break;
                coor_list.add(next_token);
            }
            if (!layer_ok) {
                return null;
            }
            double[] coor_arr = new double[coor_list.size()];
            Iterator it = coor_list.iterator();
            for (int i = 0; i < coor_arr.length; ++i) {
                Object next_object = it.next();
                if (next_object instanceof Double) {
                    coor_arr[i] = (Double)next_object;
                    continue;
                }
                if (next_object instanceof Integer) {
                    coor_arr[i] = ((Integer)next_object).intValue();
                    continue;
                }
                System.out.println("Shape.read_polygon_scope: number expected");
                return null;
            }
            return new Polygon(polygon_layer, coor_arr);
        }
        catch (IOException e) {
            System.out.println("Rectangle.read_scope: IO error scanning file");
            System.out.println(e);
            return null;
        }
    }

    public static Circle read_circle_scope(Scanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Layer circle_layer = null;
            boolean layer_ok = true;
            double[] circle_coor = new double[3];
            Object next_token = p_scanner.next_token();
            if (next_token == Keyword.PCB_SCOPE) {
                circle_layer = Layer.PCB;
            } else if (next_token == Keyword.SIGNAL) {
                circle_layer = Layer.SIGNAL;
            } else {
                if (p_layer_structure == null) {
                    System.out.println("Shape.read_circle_scope: p_layer_structure != null expected");
                    return null;
                }
                if (!(next_token instanceof String)) {
                    System.out.println("Shape.read_circle_scope: string for layer_name expected");
                    return null;
                }
                int layer_no = p_layer_structure.get_no((String)next_token);
                if (layer_no < 0 || layer_no >= p_layer_structure.arr.length) {
                    System.out.print("Shape.read_circle_scope: layer with name ");
                    System.out.print((String)next_token);
                    System.out.println(" not found in layer stracture ");
                    layer_ok = false;
                } else {
                    circle_layer = p_layer_structure.arr[layer_no];
                }
            }
            int curr_index = 0;
            while ((next_token = p_scanner.next_token()) != Keyword.CLOSED_BRACKET) {
                if (curr_index > 2) {
                    System.out.println("Shape.read_circle_scope: closed bracket expected");
                    return null;
                }
                if (next_token instanceof Double) {
                    circle_coor[curr_index] = (Double)next_token;
                } else if (next_token instanceof Integer) {
                    circle_coor[curr_index] = ((Integer)next_token).intValue();
                } else {
                    System.out.println("Shape.read_circle_scope: number expected");
                    return null;
                }
                ++curr_index;
            }
            if (!layer_ok) {
                return null;
            }
            return new Circle(circle_layer, circle_coor);
        }
        catch (IOException e) {
            System.out.println("Shape.read_rectangle_scope: IO error scanning file");
            System.out.println(e);
            return null;
        }
    }

    public static PolygonPath read_polygon_path_scope(Scanner p_scanner, LayerStructure p_layer_structure) {
        try {
            Layer layer = null;
            boolean layer_ok = true;
            Object next_token = p_scanner.next_token();
            if (next_token == Keyword.PCB_SCOPE) {
                layer = Layer.PCB;
            } else if (next_token == Keyword.SIGNAL) {
                layer = Layer.SIGNAL;
            } else {
                if (p_layer_structure == null) {
                    System.out.println("Shape.read_polygon_path_scope: only layer types pcb or signal expected");
                    return null;
                }
                if (!(next_token instanceof String)) {
                    System.out.println("Path.read_scope: layer name string expected");
                    return null;
                }
                int layer_no = p_layer_structure.get_no((String)next_token);
                if (layer_no < 0 || layer_no >= p_layer_structure.arr.length) {
                    System.out.print("Shape.read_polygon_path_scope: layer with name ");
                    System.out.print((String)next_token);
                    System.out.println(" not found in layer structure ");
                    layer_ok = false;
                } else {
                    layer = p_layer_structure.arr[layer_no];
                }
            }
            LinkedList<Object> corner_list = new LinkedList<Object>();
            while (true) {
                if ((next_token = p_scanner.next_token()) == Keyword.OPEN_BRACKET) {
                    ScopeKeyword.skip_scope(p_scanner);
                    next_token = p_scanner.next_token();
                }
                if (next_token == Keyword.CLOSED_BRACKET) break;
                corner_list.add(next_token);
            }
            if (corner_list.size() < 5) {
                System.out.println("Shape.read_polygon_path_scope: to few numbers in scope");
                return null;
            }
            if (!layer_ok) {
                return null;
            }
            Iterator it = corner_list.iterator();
            double width = 0.0;
            Object next_object = it.next();
            if (next_object instanceof Double) {
                width = (Double)next_object;
            } else if (next_object instanceof Integer) {
                width = ((Integer)next_object).intValue();
            } else {
                System.out.println("Shape.read_polygon_path_scope: number expected");
                return null;
            }
            double[] coordinate_arr = new double[corner_list.size() - 1];
            for (int i = 0; i < coordinate_arr.length; ++i) {
                next_object = it.next();
                if (next_object instanceof Double) {
                    coordinate_arr[i] = (Double)next_object;
                    continue;
                }
                if (next_object instanceof Integer) {
                    coordinate_arr[i] = ((Integer)next_object).intValue();
                    continue;
                }
                System.out.println("Shape.read_polygon_path_scope: number expected");
                return null;
            }
            return new PolygonPath(layer, width, coordinate_arr);
        }
        catch (IOException e) {
            System.out.println("Shape.read_polygon_path_scope: IO error scanning file");
            System.out.println(e);
            return null;
        }
    }

    public static Area transform_area_to_board(Collection<Shape> p_area, CoordinateTransform p_coordinate_transform) {
        Area result;
        int hole_count = p_area.size() - 1;
        if (hole_count <= -1) {
            System.out.println("Shape.transform_area_to_board: p_area.size() > 0 expected");
            return null;
        }
        Iterator<Shape> it = p_area.iterator();
        Shape boundary = it.next();
        geometry.planar.Shape boundary_shape = boundary.transform_to_board(p_coordinate_transform);
        if (hole_count == 0) {
            result = boundary_shape;
        } else {
            if (!(boundary_shape instanceof PolylineShape)) {
                System.out.println("Shape.transform_area_to_board: PolylineShape expected");
                return null;
            }
            PolylineShape border = (PolylineShape)boundary_shape;
            PolylineShape[] holes = new PolylineShape[hole_count];
            for (int i = 0; i < holes.length; ++i) {
                geometry.planar.Shape hole_shape = it.next().transform_to_board(p_coordinate_transform);
                if (!(hole_shape instanceof PolylineShape)) {
                    System.out.println("Shape.transform_area_to_board: PolylineShape expected");
                    return null;
                }
                holes[i] = (PolylineShape)hole_shape;
            }
            result = new PolylineArea(border, holes);
        }
        return result;
    }

    public static Area transform_area_to_board_rel(Collection<Shape> p_area, CoordinateTransform p_coordinate_transform) {
        Area result;
        int hole_count = p_area.size() - 1;
        if (hole_count <= -1) {
            System.out.println("Shape.transform_area_to_board_rel: p_area.size() > 0 expected");
            return null;
        }
        Iterator<Shape> it = p_area.iterator();
        Shape boundary = it.next();
        geometry.planar.Shape boundary_shape = boundary.transform_to_board_rel(p_coordinate_transform);
        if (hole_count == 0) {
            result = boundary_shape;
        } else {
            if (!(boundary_shape instanceof PolylineShape)) {
                System.out.println("Shape.transform_area_to_board_rel: PolylineShape expected");
                return null;
            }
            PolylineShape border = (PolylineShape)boundary_shape;
            PolylineShape[] holes = new PolylineShape[hole_count];
            for (int i = 0; i < holes.length; ++i) {
                geometry.planar.Shape hole_shape = it.next().transform_to_board_rel(p_coordinate_transform);
                if (!(hole_shape instanceof PolylineShape)) {
                    System.out.println("Shape.transform_area_to_board: PolylineShape expected");
                    return null;
                }
                holes[i] = (PolylineShape)hole_shape;
            }
            result = new PolylineArea(border, holes);
        }
        return result;
    }

    public void write_hole_scope(IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.start_scope();
        p_file.write("window");
        this.write_scope(p_file, p_identifier_type);
        p_file.end_scope();
    }

    public abstract geometry.planar.Shape transform_to_board(CoordinateTransform var1);

    public abstract Rectangle bounding_box();

    public abstract geometry.planar.Shape transform_to_board_rel(CoordinateTransform var1);

    protected Shape(Layer p_layer) {
        this.layer = p_layer;
    }

    static class ReadAreaScopeResult {
        String area_name;
        final Collection<Shape> shape_list;
        final String clearance_class_name;

        private ReadAreaScopeResult(String p_area_name, Collection<Shape> p_shape_list, String p_clearance_class_name) {
            this.area_name = p_area_name;
            this.shape_list = p_shape_list;
            this.clearance_class_name = p_clearance_class_name;
        }
    }
}

