/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import board.Layer;
import datastructures.IdentifierType;
import datastructures.IndentFileWriter;
import designformats.specctra.Keyword;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import designformats.specctra.WriteScopeParameter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import rules.BoardRules;
import rules.ClearanceMatrix;
import rules.NetClass;

public abstract class Rule {
    public static Collection<Rule> read_scope(Scanner p_scanner) {
        LinkedList<Rule> result = new LinkedList<Rule>();
        Object next_token = null;
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("Rule.read_scope: IO error scanning file");
                System.out.println(e);
                return null;
            }
            if (next_token == null) {
                System.out.println("Rule.read_scope: unexpected end of file");
                return null;
            }
            if (next_token == Keyword.CLOSED_BRACKET) break;
            if (prev_token != Keyword.OPEN_BRACKET) continue;
            Rule curr_rule = null;
            if (next_token == Keyword.WIDTH) {
                curr_rule = Rule.read_width_rule(p_scanner);
            } else if (next_token == Keyword.CLEARANCE) {
                curr_rule = Rule.read_clearance_rule(p_scanner);
            } else {
                ScopeKeyword.skip_scope(p_scanner);
            }
            if (curr_rule == null) continue;
            result.add(curr_rule);
        }
        return result;
    }

    public static LayerRule read_layer_rule_scope(Scanner p_scanner) {
        try {
            Object next_token;
            LinkedList<String> layer_names = new LinkedList<String>();
            LinkedList<Rule> rule_list = new LinkedList<Rule>();
            while (true) {
                p_scanner.yybegin(4);
                next_token = p_scanner.next_token();
                if (next_token == Keyword.OPEN_BRACKET) break;
                if (!(next_token instanceof String)) {
                    System.out.println("Rule.read_layer_rule_scope: string expected");
                    return null;
                }
                layer_names.add((String)next_token);
            }
            while ((next_token = p_scanner.next_token()) != Keyword.CLOSED_BRACKET) {
                if (next_token != Keyword.RULE) {
                    System.out.println("Rule.read_layer_rule_scope: rule expected");
                    return null;
                }
                rule_list.addAll(Rule.read_scope(p_scanner));
            }
            return new LayerRule(layer_names, rule_list);
        }
        catch (IOException e) {
            System.out.println("Rule.read_layer_rule_scope: IO error scanning file");
            return null;
        }
    }

    public static WidthRule read_width_rule(Scanner p_scanner) {
        try {
            double value;
            Object next_token = p_scanner.next_token();
            if (next_token instanceof Double) {
                value = (Double)next_token;
            } else if (next_token instanceof Integer) {
                value = ((Integer)next_token).intValue();
            } else {
                System.out.println("Rule.read_width_rule: number expected");
                return null;
            }
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("Rule.read_width_rule: closing bracket expected");
                return null;
            }
            return new WidthRule(value);
        }
        catch (IOException e) {
            System.out.println("Rule.read_width_rule: IO error scanning file");
            return null;
        }
    }

    public static void write_scope(NetClass p_net_class, WriteScopeParameter p_par) throws IOException {
        p_par.file.start_scope();
        p_par.file.write("rule");
        int default_trace_half_width = p_net_class.get_trace_half_width(0);
        double trace_width = 2.0 * p_par.coordinate_transform.board_to_dsn(default_trace_half_width);
        p_par.file.new_line();
        p_par.file.write("(width ");
        p_par.file.write(new Double(trace_width).toString());
        p_par.file.write(")");
        p_par.file.end_scope();
        for (int i = 1; i < p_par.board.layer_structure.arr.length; ++i) {
            if (p_net_class.get_trace_half_width(i) == default_trace_half_width) continue;
            Rule.write_layer_rule(p_net_class, i, p_par);
        }
    }

    private static void write_layer_rule(NetClass p_net_class, int p_layer_no, WriteScopeParameter p_par) throws IOException {
        p_par.file.start_scope();
        p_par.file.write("layer_rule ");
        Layer curr_board_layer = p_par.board.layer_structure.arr[p_layer_no];
        p_par.file.write(curr_board_layer.name);
        p_par.file.start_scope();
        p_par.file.write("rule ");
        int curr_trace_half_width = p_net_class.get_trace_half_width(p_layer_no);
        double trace_width = 2.0 * p_par.coordinate_transform.board_to_dsn(curr_trace_half_width);
        p_par.file.new_line();
        p_par.file.write("(width ");
        p_par.file.write(new Double(trace_width).toString());
        p_par.file.write(") ");
        p_par.file.end_scope();
        p_par.file.end_scope();
    }

    public static void write_default_rule(WriteScopeParameter p_par, int p_layer) throws IOException {
        p_par.file.start_scope();
        p_par.file.write("rule");
        double trace_width = 2.0 * p_par.coordinate_transform.board_to_dsn(p_par.board.rules.get_default_net_class().get_trace_half_width(0));
        p_par.file.new_line();
        p_par.file.write("(width ");
        p_par.file.write(new Double(trace_width).toString());
        p_par.file.write(")");
        int default_cl_no = BoardRules.default_clearance_class();
        int default_board_clearance = p_par.board.rules.clearance_matrix.value(default_cl_no, default_cl_no, p_layer);
        double default_clearance = p_par.coordinate_transform.board_to_dsn(default_board_clearance);
        p_par.file.new_line();
        p_par.file.write("(clear ");
        p_par.file.write(new Double(default_clearance).toString());
        p_par.file.write(")");
        Double smd_to_turn_dist = p_par.coordinate_transform.board_to_dsn(p_par.board.rules.get_pin_edge_to_turn_dist());
        p_par.file.new_line();
        p_par.file.write("(clear ");
        p_par.file.write(smd_to_turn_dist.toString());
        p_par.file.write(" (type smd_to_turn_gap))");
        int cl_count = p_par.board.rules.clearance_matrix.get_class_count();
        for (int i = 1; i <= cl_count; ++i) {
            Rule.write_clearance_rules(p_par, p_layer, i, cl_count, default_board_clearance);
        }
        p_par.file.end_scope();
    }

    private static void write_clearance_rules(WriteScopeParameter p_par, int p_layer, int p_cl_class, int p_max_cl_class, int p_default_clearance) throws IOException {
        ClearanceMatrix cl_matrix = p_par.board.rules.clearance_matrix;
        for (int i = p_cl_class; i < p_max_cl_class; ++i) {
            int curr_board_clearance = cl_matrix.value(p_cl_class, i, p_layer);
            if (curr_board_clearance == p_default_clearance) continue;
            double curr_clearance = p_par.coordinate_transform.board_to_dsn(curr_board_clearance);
            p_par.file.new_line();
            p_par.file.write("(clear ");
            p_par.file.write(new Double(curr_clearance).toString());
            p_par.file.write(" (type ");
            p_par.identifier_type.write(cl_matrix.get_name(p_cl_class), p_par.file);
            p_par.file.write("_");
            p_par.identifier_type.write(cl_matrix.get_name(i), p_par.file);
            p_par.file.write("))");
        }
    }

    public static ClearanceRule read_clearance_rule(Scanner p_scanner) {
        try {
            double value;
            Object next_token = p_scanner.next_token();
            if (next_token instanceof Double) {
                value = (Double)next_token;
            } else if (next_token instanceof Integer) {
                value = ((Integer)next_token).intValue();
            } else {
                System.out.println("Rule.read_clearance_rule: number expected");
                return null;
            }
            LinkedList<String> class_pairs = new LinkedList<String>();
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                if (next_token != Keyword.OPEN_BRACKET) {
                    System.out.println("Rule.read_clearance_rule: ( expected");
                    return null;
                }
                next_token = p_scanner.next_token();
                if (next_token != Keyword.TYPE) {
                    System.out.println("Rule.read_clearance_rule: type expected");
                    return null;
                }
                while (true) {
                    p_scanner.yybegin(7);
                    next_token = p_scanner.next_token();
                    if (next_token == Keyword.CLOSED_BRACKET) break;
                    if (!(next_token instanceof String)) {
                        System.out.println("Rule.read_clearance_rule: string expected");
                        return null;
                    }
                    class_pairs.add((String)next_token);
                }
                next_token = p_scanner.next_token();
                if (next_token != Keyword.CLOSED_BRACKET) {
                    System.out.println("Rule.read_clearance_rule: closing bracket expected");
                    return null;
                }
            }
            return new ClearanceRule(value, class_pairs);
        }
        catch (IOException e) {
            System.out.println("Rule.read_clearance_rule: IO error scanning file");
            return null;
        }
    }

    public static void write_item_clearance_class(String p_name, IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.new_line();
        p_file.write("(clearance_class ");
        p_identifier_type.write(p_name, p_file);
        p_file.write(")");
    }

    public static class LayerRule {
        final Collection<String> layer_names;
        final Collection<Rule> rules;

        LayerRule(Collection<String> p_layer_names, Collection<Rule> p_rules) {
            this.layer_names = p_layer_names;
            this.rules = p_rules;
        }
    }

    public static class ClearanceRule
    extends Rule {
        final double value;
        final Collection<String> clearance_class_pairs;

        public ClearanceRule(double p_value, Collection<String> p_class_pairs) {
            this.value = p_value;
            this.clearance_class_pairs = p_class_pairs;
        }
    }

    public static class WidthRule
    extends Rule {
        final double value;

        public WidthRule(double p_value) {
            this.value = p_value;
        }
    }
}

