/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import board.Communication;
import board.Unit;
import datastructures.IndentFileWriter;
import designformats.specctra.Keyword;
import designformats.specctra.ReadScopeParameter;
import designformats.specctra.ScopeKeyword;
import java.io.IOException;

public class Resolution
extends ScopeKeyword {
    public Resolution() {
        super("resolution");
    }

    @Override
    public boolean read_scope(ReadScopeParameter p_par) {
        try {
            Object next_token = p_par.scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("Resolution.read_scope: string expected");
                return false;
            }
            p_par.unit = Unit.from_string((String)next_token);
            if (p_par.unit == null) {
                System.out.println("Resolution.read_scope: unit mil, inch or mm expected");
                return false;
            }
            next_token = p_par.scanner.next_token();
            if (!(next_token instanceof Integer)) {
                System.out.println("Resolution.read_scope: integer expected");
                return false;
            }
            p_par.resolution = (Integer)next_token;
            next_token = p_par.scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("Resolution.read_scope: closing bracket expected");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            System.out.println("Resolution.read_scope: IO error scanning file");
            return false;
        }
    }

    public static void write_scope(IndentFileWriter p_file, Communication p_board_communication) throws IOException {
        p_file.new_line();
        p_file.write("(resolution ");
        p_file.write(p_board_communication.unit.toString());
        p_file.write(" ");
        p_file.write(new Integer(p_board_communication.resolution).toString());
        p_file.write(")");
    }
}

