/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import datastructures.IdentifierType;
import datastructures.IndentFileWriter;
import designformats.specctra.CoordinateTransform;
import designformats.specctra.Layer;
import designformats.specctra.Path;
import designformats.specctra.Rectangle;
import geometry.planar.Shape;
import java.io.IOException;

public class PolylinePath
extends Path {
    public PolylinePath(Layer p_layer, double p_width, double[] p_corner_arr) {
        super(p_layer, p_width, p_corner_arr);
    }

    @Override
    public void write_scope(IndentFileWriter p_file, IdentifierType p_identifier) throws IOException {
        p_file.start_scope();
        p_file.write("polyline_path ");
        p_identifier.write(this.layer.name, p_file);
        p_file.write(" ");
        p_file.write(new Double(this.width).toString());
        int line_count = this.coordinate_arr.length / 4;
        for (int i = 0; i < line_count; ++i) {
            p_file.new_line();
            for (int j = 0; j < 4; ++j) {
                p_file.write(new Double(this.coordinate_arr[4 * i + j]).toString());
                p_file.write(" ");
            }
        }
        p_file.end_scope();
    }

    @Override
    public void write_scope_int(IndentFileWriter p_file, IdentifierType p_identifier) throws IOException {
        p_file.start_scope();
        p_file.write("polyline_path ");
        p_identifier.write(this.layer.name, p_file);
        p_file.write(" ");
        p_file.write(new Double(this.width).toString());
        int line_count = this.coordinate_arr.length / 4;
        for (int i = 0; i < line_count; ++i) {
            p_file.new_line();
            for (int j = 0; j < 4; ++j) {
                Integer curr_coor = (int)Math.round(this.coordinate_arr[4 * i + j]);
                p_file.write(curr_coor.toString());
                p_file.write(" ");
            }
        }
        p_file.end_scope();
    }

    @Override
    public Shape transform_to_board_rel(CoordinateTransform p_coordinate_transform) {
        System.out.println("PolylinePath.transform_to_board_rel not implemented");
        return null;
    }

    @Override
    public Shape transform_to_board(CoordinateTransform p_coordinate_transform) {
        System.out.println("PolylinePath.transform_to_board_rel not implemented");
        return null;
    }

    @Override
    public Rectangle bounding_box() {
        System.out.println("PolylinePath.boundingbox not implemented");
        return null;
    }
}

