/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import board.Component;
import designformats.specctra.Keyword;
import designformats.specctra.ReadScopeParameter;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import designformats.specctra.WriteScopeParameter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import library.LogicalPart;
import library.LogicalParts;

public class PartLibrary
extends ScopeKeyword {
    public PartLibrary() {
        super("part_library");
    }

    @Override
    public boolean read_scope(ReadScopeParameter p_par) {
        Object next_token = null;
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_par.scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("PartLibrary.read_scope: IO error scanning file");
                System.out.println(e);
                return false;
            }
            if (next_token == null) {
                System.out.println("PartLibrary.read_scope: unexpected end of file");
                return false;
            }
            if (next_token == CLOSED_BRACKET) break;
            if (prev_token != OPEN_BRACKET) continue;
            if (next_token == Keyword.LOGICAL_PART_MAPPING) {
                LogicalPartMapping next_mapping = this.read_logical_part_mapping(p_par.scanner);
                if (next_mapping == null) {
                    return false;
                }
                p_par.logical_part_mappings.add(next_mapping);
                continue;
            }
            if (next_token == Keyword.LOGICAL_PART) {
                LogicalPart next_part = this.read_logical_part(p_par.scanner);
                if (next_part == null) {
                    return false;
                }
                p_par.logical_parts.add(next_part);
                continue;
            }
            PartLibrary.skip_scope(p_par.scanner);
        }
        return true;
    }

    public static void write_scope(WriteScopeParameter p_par) throws IOException {
        int j;
        library.LogicalPart curr_part;
        int i;
        LogicalParts logical_parts = p_par.board.library.logical_parts;
        if (logical_parts.count() <= 0) {
            return;
        }
        p_par.file.start_scope();
        p_par.file.write("part_library");
        for (i = 1; i <= logical_parts.count(); ++i) {
            curr_part = logical_parts.get(i);
            p_par.file.start_scope();
            p_par.file.write("logical_part_mapping ");
            p_par.identifier_type.write(curr_part.name, p_par.file);
            p_par.file.new_line();
            p_par.file.write("(comp");
            for (j = 1; j <= p_par.board.components.count(); ++j) {
                Component curr_compomnent = p_par.board.components.get(j);
                if (curr_compomnent.get_logical_part() != curr_part) continue;
                p_par.file.write(" ");
                p_par.file.write(curr_compomnent.name);
            }
            p_par.file.write(")");
            p_par.file.end_scope();
        }
        for (i = 1; i <= logical_parts.count(); ++i) {
            curr_part = logical_parts.get(i);
            p_par.file.start_scope();
            p_par.file.write("logical_part ");
            p_par.identifier_type.write(curr_part.name, p_par.file);
            p_par.file.new_line();
            for (j = 0; j < curr_part.pin_count(); ++j) {
                p_par.file.new_line();
                LogicalPart.PartPin curr_pin = curr_part.get_pin(j);
                p_par.file.write("(pin ");
                p_par.identifier_type.write(curr_pin.pin_name, p_par.file);
                p_par.file.write(" 0 ");
                p_par.identifier_type.write(curr_pin.gate_name, p_par.file);
                p_par.file.write(" ");
                Integer gate_swap_code = curr_pin.gate_swap_code;
                p_par.file.write(gate_swap_code.toString());
                p_par.file.write(" ");
                p_par.identifier_type.write(curr_pin.gate_pin_name, p_par.file);
                p_par.file.write(" ");
                Integer gate_pin_swap_code = curr_pin.gate_pin_swap_code;
                p_par.file.write(gate_pin_swap_code.toString());
                p_par.file.write(")");
            }
            p_par.file.end_scope();
        }
        p_par.file.end_scope();
    }

    private LogicalPartMapping read_logical_part_mapping(Scanner p_scanner) {
        try {
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("PartLibrary.read_logical_part_mapping: string expected");
                return null;
            }
            String name = (String)next_token;
            next_token = p_scanner.next_token();
            if (next_token != Keyword.OPEN_BRACKET) {
                System.out.println("PartLibrary.read_logical_part_mapping: open bracket expected");
                return null;
            }
            next_token = p_scanner.next_token();
            if (next_token != Keyword.COMPONENT_SCOPE) {
                System.out.println("PartLibrary.read_logical_part_mapping: Keyword.COMPONENT_SCOPE expected");
                return null;
            }
            TreeSet<String> result = new TreeSet<String>();
            while (true) {
                p_scanner.yybegin(3);
                next_token = p_scanner.next_token();
                if (next_token == Keyword.CLOSED_BRACKET) break;
                if (!(next_token instanceof String)) {
                    System.out.println("PartLibrary.read_logical_part_mapping: string expected");
                    return null;
                }
                result.add((String)next_token);
            }
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("PartLibrary.read_logical_part_mapping: closing bracket expected");
                return null;
            }
            return new LogicalPartMapping(name, result);
        }
        catch (IOException e) {
            System.out.println("PartLibrary.read_logical_part_mapping: IO error scanning file");
            return null;
        }
    }

    private LogicalPart read_logical_part(Scanner p_scanner) {
        String part_name;
        LinkedList<PartPin> part_pins;
        block9: {
            boolean read_ok;
            part_pins = new LinkedList<PartPin>();
            Object next_token = null;
            try {
                next_token = p_scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("PartLibrary.read_logical_part: IO error scanning file");
                return null;
            }
            if (!(next_token instanceof String)) {
                System.out.println("PartLibrary.read_logical_part: string expected");
                return null;
            }
            part_name = (String)next_token;
            do {
                Object prev_token = next_token;
                try {
                    next_token = p_scanner.next_token();
                }
                catch (IOException e) {
                    System.out.println("PartLibrary.read_logical_part: IO error scanning file");
                    return null;
                }
                if (next_token == null) {
                    System.out.println("PartLibrary.read_logical_part: unexpected end of file");
                    return null;
                }
                if (next_token == CLOSED_BRACKET) break block9;
                read_ok = true;
                if (prev_token != OPEN_BRACKET) continue;
                if (next_token == Keyword.PIN) {
                    PartPin curr_part_pin = this.read_part_pin(p_scanner);
                    if (curr_part_pin == null) {
                        return null;
                    }
                    part_pins.add(curr_part_pin);
                    continue;
                }
                PartLibrary.skip_scope(p_scanner);
            } while (read_ok);
            return null;
        }
        return new LogicalPart(part_name, part_pins);
    }

    private PartPin read_part_pin(Scanner p_scanner) {
        try {
            p_scanner.yybegin(3);
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("PartLibrary.read_part_pin: string expected");
                return null;
            }
            String pin_name = (String)next_token;
            next_token = p_scanner.next_token();
            if (!(next_token instanceof Integer)) {
                System.out.println("PartLibrary.read_part_pin: integer expected");
                return null;
            }
            p_scanner.yybegin(3);
            next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("PartLibrary.read_part_pin: string expected");
                return null;
            }
            String gate_name = (String)next_token;
            next_token = p_scanner.next_token();
            if (!(next_token instanceof Integer)) {
                System.out.println("PartLibrary.read_part_pin: integer expected");
                return null;
            }
            int gate_swap_code = (Integer)next_token;
            p_scanner.yybegin(3);
            next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("PartLibrary.read_part_pin: string expected");
                return null;
            }
            String gate_pin_name = (String)next_token;
            next_token = p_scanner.next_token();
            if (!(next_token instanceof Integer)) {
                System.out.println("PartLibrary.read_part_pin: integer expected");
                return null;
            }
            int gate_pin_swap_code = (Integer)next_token;
            while ((next_token = p_scanner.next_token()) != Keyword.CLOSED_BRACKET) {
            }
            return new PartPin(pin_name, gate_name, gate_swap_code, gate_pin_name, gate_pin_swap_code);
        }
        catch (IOException e) {
            System.out.println("PartLibrary.read_part_pin: IO error scanning file");
            return null;
        }
    }

    public static class LogicalPart {
        public final String name;
        public final Collection<PartPin> part_pins;

        private LogicalPart(String p_name, Collection<PartPin> p_part_pins) {
            this.name = p_name;
            this.part_pins = p_part_pins;
        }
    }

    public static class PartPin {
        public final String pin_name;
        public final String gate_name;
        public final int gate_swap_code;
        public final String gate_pin_name;
        public final int gate_pin_swap_code;

        private PartPin(String p_pin_name, String p_gate_name, int p_gate_swap_code, String p_gate_pin_name, int p_gate_pin_swap_code) {
            this.pin_name = p_pin_name;
            this.gate_name = p_gate_name;
            this.gate_swap_code = p_gate_swap_code;
            this.gate_pin_name = p_gate_pin_name;
            this.gate_pin_swap_code = p_gate_pin_swap_code;
        }
    }

    public static class LogicalPartMapping {
        public final String name;
        public final SortedSet<String> components;

        private LogicalPartMapping(String p_name, SortedSet<String> p_components) {
            this.name = p_name;
            this.components = p_components;
        }
    }
}

