/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import board.Communication;
import datastructures.IdentifierType;
import datastructures.IndentFileWriter;
import designformats.specctra.DsnFile;
import designformats.specctra.Keyword;
import designformats.specctra.ReadScopeParameter;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import java.io.IOException;

public class Parser
extends ScopeKeyword {
    public Parser() {
        super("parser");
    }

    @Override
    public boolean read_scope(ReadScopeParameter p_par) {
        block11: {
            boolean read_ok;
            Object next_token = null;
            do {
                Object prev_token = next_token;
                try {
                    next_token = p_par.scanner.next_token();
                }
                catch (IOException e) {
                    System.out.println("Parser.read_scope: IO error scanning file");
                    return false;
                }
                if (next_token == null) {
                    System.out.println("Parser.read_scope: unexpected end of file");
                    return false;
                }
                if (next_token == CLOSED_BRACKET) break block11;
                read_ok = true;
                if (prev_token != OPEN_BRACKET) continue;
                if (next_token == Keyword.STRING_QUOTE) {
                    String quote_char = Parser.read_quote_char(p_par.scanner);
                    if (quote_char == null) {
                        return false;
                    }
                    p_par.string_quote = quote_char;
                    continue;
                }
                if (next_token == Keyword.HOST_CAD) {
                    p_par.host_cad = DsnFile.read_string_scope(p_par.scanner);
                    continue;
                }
                if (next_token == Keyword.HOST_VERSION) {
                    p_par.host_version = DsnFile.read_string_scope(p_par.scanner);
                    continue;
                }
                if (next_token == Keyword.CONSTANT) {
                    String[] curr_constant = Parser.read_constant(p_par);
                    if (curr_constant == null) continue;
                    p_par.constants.add(curr_constant);
                    continue;
                }
                if (next_token == Keyword.WRITE_RESOLUTION) {
                    p_par.write_resolution = Parser.read_write_solution(p_par);
                    continue;
                }
                if (next_token == Keyword.GENERATED_BY_FREEROUTE) {
                    p_par.dsn_file_generated_by_host = false;
                    Parser.skip_scope(p_par.scanner);
                    continue;
                }
                Parser.skip_scope(p_par.scanner);
            } while (read_ok);
            return false;
        }
        return true;
    }

    private static Communication.SpecctraParserInfo.WriteResolution read_write_solution(ReadScopeParameter p_par) {
        try {
            Object next_token = p_par.scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("Parser.read_write_solution: string expected");
                return null;
            }
            String resolution_string = (String)next_token;
            next_token = p_par.scanner.next_token();
            if (!(next_token instanceof Integer)) {
                System.out.println("Parser.read_write_solution: integer expected expected");
                return null;
            }
            int resolution_value = (Integer)next_token;
            next_token = p_par.scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("Parser.read_write_solution: closing_bracket expected");
                return null;
            }
            return new Communication.SpecctraParserInfo.WriteResolution(resolution_string, resolution_value);
        }
        catch (IOException e) {
            System.out.println("Parser.read_write_solution: IO error scanning file");
            return null;
        }
    }

    private static String[] read_constant(ReadScopeParameter p_par) {
        try {
            String[] result = new String[2];
            p_par.scanner.yybegin(3);
            Object next_token = p_par.scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("Parser.read_constant: string expected");
                return null;
            }
            result[0] = (String)next_token;
            p_par.scanner.yybegin(3);
            next_token = p_par.scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("Parser.read_constant: string expected");
                return null;
            }
            result[1] = (String)next_token;
            next_token = p_par.scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("Parser.read_constant: closing_bracket expected");
                return null;
            }
            return result;
        }
        catch (IOException e) {
            System.out.println("Parser.read_constant: IO error scanning file");
            return null;
        }
    }

    public static void write_scope(IndentFileWriter p_file, Communication.SpecctraParserInfo p_parser_info, IdentifierType p_identifier_type, boolean p_reduced) throws IOException {
        p_file.start_scope();
        p_file.write("parser");
        if (!p_reduced) {
            p_file.new_line();
            p_file.write("(string_quote ");
            p_file.write(p_parser_info.string_quote);
            p_file.write(")");
            p_file.new_line();
            p_file.write("(space_in_quoted_tokens on)");
        }
        if (p_parser_info.host_cad != null) {
            p_file.new_line();
            p_file.write("(host_cad ");
            p_identifier_type.write(p_parser_info.host_cad, p_file);
            p_file.write(")");
        }
        if (p_parser_info.host_version != null) {
            p_file.new_line();
            p_file.write("(host_version ");
            p_identifier_type.write(p_parser_info.host_version, p_file);
            p_file.write(")");
        }
        if (p_parser_info.constants != null) {
            for (String[] curr_constant : p_parser_info.constants) {
                p_file.new_line();
                p_file.write("(constant ");
                for (int i = 0; i < curr_constant.length; ++i) {
                    p_identifier_type.write(curr_constant[i], p_file);
                    p_file.write(" ");
                }
                p_file.write(")");
            }
        }
        if (p_parser_info.write_resolution != null) {
            p_file.new_line();
            p_file.write("(write_resolution ");
            p_file.write(p_parser_info.write_resolution.char_name.substring(0, 1));
            p_file.write(" ");
            Integer positive_int = p_parser_info.write_resolution.positive_int;
            p_file.write(positive_int.toString());
            p_file.write(")");
        }
        if (!p_reduced) {
            p_file.new_line();
            p_file.write("(generated_by_freeroute)");
        }
        p_file.end_scope();
    }

    private static String read_quote_char(Scanner p_scanner) {
        try {
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("Parser.read_quote_char: string expected");
                return null;
            }
            String result = (String)next_token;
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("Parser.read_quote_char: closing bracket expected");
                return null;
            }
            return result;
        }
        catch (IOException e) {
            System.out.println("Parser.read_quote_char: IO error scanning file");
            return null;
        }
    }
}

