/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import board.Item;
import designformats.specctra.Component;
import designformats.specctra.Keyword;
import designformats.specctra.Layer;
import designformats.specctra.LayerStructure;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import designformats.specctra.Shape;
import designformats.specctra.WriteScopeParameter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import library.Package;
import library.Padstack;

public class Package {
    public final String name;
    public final PinInfo[] pin_info_arr;
    public final Collection<Shape> outline;
    public final Collection<Shape.ReadAreaScopeResult> keepouts;
    public final Collection<Shape.ReadAreaScopeResult> via_keepouts;
    public final Collection<Shape.ReadAreaScopeResult> place_keepouts;
    public final boolean is_front;

    public Package(String p_name, PinInfo[] p_pin_info_arr, Collection<Shape> p_outline, Collection<Shape.ReadAreaScopeResult> p_keepouts, Collection<Shape.ReadAreaScopeResult> p_via_keepouts, Collection<Shape.ReadAreaScopeResult> p_place_keepouts, boolean p_is_front) {
        this.name = p_name;
        this.pin_info_arr = p_pin_info_arr;
        this.outline = p_outline;
        this.keepouts = p_keepouts;
        this.via_keepouts = p_via_keepouts;
        this.place_keepouts = p_place_keepouts;
        this.is_front = p_is_front;
    }

    public static Package read_scope(Scanner p_scanner, LayerStructure p_layer_structure) {
        try {
            boolean is_front = true;
            LinkedList<Shape> outline = new LinkedList<Shape>();
            LinkedList<Shape.ReadAreaScopeResult> keepouts = new LinkedList<Shape.ReadAreaScopeResult>();
            LinkedList<Shape.ReadAreaScopeResult> via_keepouts = new LinkedList<Shape.ReadAreaScopeResult>();
            LinkedList<Shape.ReadAreaScopeResult> place_keepouts = new LinkedList<Shape.ReadAreaScopeResult>();
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("Package.read_scope: String expected");
                return null;
            }
            String package_name = (String)next_token;
            LinkedList<PinInfo> pin_info_list = new LinkedList<PinInfo>();
            while (true) {
                Shape.ReadAreaScopeResult keepout_area;
                Object prev_token = next_token;
                next_token = p_scanner.next_token();
                if (next_token == null) {
                    System.out.println("Package.read_scope: unexpected end of file");
                    return null;
                }
                if (next_token == Keyword.CLOSED_BRACKET) break;
                if (prev_token != Keyword.OPEN_BRACKET) continue;
                if (next_token == Keyword.PIN) {
                    PinInfo next_pin = Package.read_pin_info(p_scanner);
                    if (next_pin == null) {
                        return null;
                    }
                    pin_info_list.add(next_pin);
                    continue;
                }
                if (next_token == Keyword.SIDE) {
                    is_front = Package.read_placement_side(p_scanner);
                    continue;
                }
                if (next_token == Keyword.OUTLINE) {
                    Shape curr_shape = Shape.read_scope(p_scanner, p_layer_structure);
                    if (curr_shape != null) {
                        outline.add(curr_shape);
                    }
                    if ((next_token = p_scanner.next_token()) == Keyword.CLOSED_BRACKET) continue;
                    System.out.println("Package.read_scope: closed bracket expected");
                    return null;
                }
                if (next_token == Keyword.KEEPOUT) {
                    keepout_area = Shape.read_area_scope(p_scanner, p_layer_structure, false);
                    if (keepout_area == null) continue;
                    keepouts.add(keepout_area);
                    continue;
                }
                if (next_token == Keyword.VIA_KEEPOUT) {
                    keepout_area = Shape.read_area_scope(p_scanner, p_layer_structure, false);
                    if (keepout_area == null) continue;
                    via_keepouts.add(keepout_area);
                    continue;
                }
                if (next_token == Keyword.PLACE_KEEPOUT) {
                    keepout_area = Shape.read_area_scope(p_scanner, p_layer_structure, false);
                    if (keepout_area == null) continue;
                    place_keepouts.add(keepout_area);
                    continue;
                }
                ScopeKeyword.skip_scope(p_scanner);
            }
            PinInfo[] pin_info_arr = new PinInfo[pin_info_list.size()];
            Iterator it = pin_info_list.iterator();
            for (int i = 0; i < pin_info_arr.length; ++i) {
                pin_info_arr[i] = (PinInfo)it.next();
            }
            return new Package(package_name, pin_info_arr, outline, keepouts, via_keepouts, place_keepouts, is_front);
        }
        catch (IOException e) {
            System.out.println("Package.read_scope: IO error scanning file");
            System.out.println(e);
            return null;
        }
    }

    public static void write_scope(WriteScopeParameter p_par, library.Package p_package) throws IOException {
        int i;
        p_par.file.start_scope();
        p_par.file.write("image ");
        p_par.identifier_type.write(p_package.name, p_par.file);
        p_par.file.new_line();
        p_par.file.write("(side ");
        if (p_package.is_front) {
            p_par.file.write("front)");
        } else {
            p_par.file.write("back)");
        }
        for (i = 0; i < p_package.pin_count(); ++i) {
            Package.Pin curr_pin = p_package.get_pin(i);
            p_par.file.new_line();
            p_par.file.write("(pin ");
            Padstack curr_padstack = p_par.board.library.padstacks.get(curr_pin.padstack_no);
            p_par.identifier_type.write(curr_padstack.name, p_par.file);
            p_par.file.write(" ");
            p_par.identifier_type.write(curr_pin.name, p_par.file);
            double[] rel_coor = p_par.coordinate_transform.board_to_dsn(curr_pin.relative_location);
            for (int j = 0; j < rel_coor.length; ++j) {
                p_par.file.write(" ");
                p_par.file.write(new Double(rel_coor[j]).toString());
            }
            int rotation = (int)Math.round(curr_pin.rotation_in_degree);
            if (rotation != 0) {
                p_par.file.write("(rotate ");
                p_par.file.write(new Integer(rotation).toString());
                p_par.file.write(")");
            }
            p_par.file.write(")");
        }
        for (i = 0; i < p_package.keepout_arr.length; ++i) {
            Package.write_package_keepout(p_package.keepout_arr[i], p_par, false);
        }
        for (i = 0; i < p_package.via_keepout_arr.length; ++i) {
            Package.write_package_keepout(p_package.via_keepout_arr[i], p_par, true);
        }
        for (i = 0; i < p_package.outline.length; ++i) {
            p_par.file.start_scope();
            p_par.file.write("outline");
            Shape curr_outline = p_par.coordinate_transform.board_to_dsn_rel(p_package.outline[i], Layer.SIGNAL);
            curr_outline.write_scope(p_par.file, p_par.identifier_type);
            p_par.file.end_scope();
        }
        p_par.file.end_scope();
    }

    private static void write_package_keepout(Package.Keepout p_keepout, WriteScopeParameter p_par, boolean p_is_via_keepout) throws IOException {
        geometry.planar.Shape[] holes;
        geometry.planar.Shape boundary_shape;
        Layer keepout_layer;
        if (p_keepout.layer >= 0) {
            board.Layer board_layer = p_par.board.layer_structure.arr[p_keepout.layer];
            keepout_layer = new Layer(board_layer.name, p_keepout.layer, board_layer.is_signal);
        } else {
            keepout_layer = Layer.SIGNAL;
        }
        if (p_keepout.area instanceof geometry.planar.Shape) {
            boundary_shape = (geometry.planar.Shape)p_keepout.area;
            holes = new geometry.planar.Shape[]{};
        } else {
            boundary_shape = p_keepout.area.get_border();
            holes = p_keepout.area.get_holes();
        }
        p_par.file.start_scope();
        if (p_is_via_keepout) {
            p_par.file.write("via_keepout");
        } else {
            p_par.file.write("keepout");
        }
        Shape dsn_shape = p_par.coordinate_transform.board_to_dsn(boundary_shape, keepout_layer);
        if (dsn_shape != null) {
            dsn_shape.write_scope(p_par.file, p_par.identifier_type);
        }
        for (int j = 0; j < holes.length; ++j) {
            Shape dsn_hole = p_par.coordinate_transform.board_to_dsn(holes[j], keepout_layer);
            dsn_hole.write_hole_scope(p_par.file, p_par.identifier_type);
        }
        p_par.file.end_scope();
    }

    private static PinInfo read_pin_info(Scanner p_scanner) {
        try {
            p_scanner.yybegin(3);
            String padstack_name = null;
            Object next_token = p_scanner.next_token();
            if (next_token instanceof String) {
                padstack_name = (String)next_token;
            } else if (next_token instanceof Integer) {
                padstack_name = ((Integer)next_token).toString();
            } else {
                System.out.println("Package.read_pin_info: String or Integer expected");
                return null;
            }
            double rotation = 0.0;
            p_scanner.yybegin(3);
            next_token = p_scanner.next_token();
            if (next_token == Keyword.OPEN_BRACKET) {
                next_token = p_scanner.next_token();
                if (next_token == Keyword.ROTATE) {
                    rotation = Package.read_rotation(p_scanner);
                } else {
                    ScopeKeyword.skip_scope(p_scanner);
                }
                p_scanner.yybegin(3);
                next_token = p_scanner.next_token();
            }
            String pin_name = null;
            if (next_token instanceof String) {
                pin_name = (String)next_token;
            } else if (next_token instanceof Integer) {
                pin_name = ((Integer)next_token).toString();
            } else {
                System.out.println("Package.read_pin_info: String or Integer expected");
                return null;
            }
            double[] pin_coor = new double[2];
            for (int i = 0; i < 2; ++i) {
                next_token = p_scanner.next_token();
                if (next_token instanceof Double) {
                    pin_coor[i] = (Double)next_token;
                    continue;
                }
                if (next_token instanceof Integer) {
                    pin_coor[i] = ((Integer)next_token).intValue();
                    continue;
                }
                System.out.println("Package.read_pin_info: number expected");
                return null;
            }
            while (true) {
                Object prev_token = next_token;
                next_token = p_scanner.next_token();
                if (next_token == null) {
                    System.out.println("Package.read_pin_info: unexpected end of file");
                    return null;
                }
                if (next_token == Keyword.CLOSED_BRACKET) break;
                if (prev_token != Keyword.OPEN_BRACKET) continue;
                if (next_token == Keyword.ROTATE) {
                    rotation = Package.read_rotation(p_scanner);
                    continue;
                }
                ScopeKeyword.skip_scope(p_scanner);
            }
            return new PinInfo(padstack_name, pin_name, pin_coor, rotation);
        }
        catch (IOException e) {
            System.out.println("Package.read_pin_info: IO error while scanning file");
            return null;
        }
    }

    private static double read_rotation(Scanner p_scanner) {
        double result = 0.0;
        try {
            Object next_token = p_scanner.next_token();
            if (next_token instanceof Integer) {
                result = ((Integer)next_token).intValue();
            } else if (next_token instanceof Double) {
                result = (Double)next_token;
            } else {
                System.out.println("Package.read_rotation: number expected");
            }
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("Package.read_rotation: closing bracket expected");
            }
        }
        catch (IOException e) {
            System.out.println("Package.read_rotation: IO error while scanning file");
        }
        return result;
    }

    public static void write_placement_scope(WriteScopeParameter p_par, library.Package p_package) throws IOException {
        Collection<Item> board_items = p_par.board.get_items();
        boolean component_found = false;
        for (int i = 1; i <= p_par.board.components.count(); ++i) {
            board.Component curr_component = p_par.board.components.get(i);
            if (curr_component.get_package() != p_package) continue;
            boolean undeleted_item_found = false;
            for (Item curr_item : board_items) {
                if (curr_item.get_component_no() != curr_component.no) continue;
                undeleted_item_found = true;
                break;
            }
            if (!undeleted_item_found && curr_component.is_placed()) continue;
            if (!component_found) {
                p_par.file.start_scope();
                p_par.file.write("component ");
                p_par.identifier_type.write(p_package.name, p_par.file);
                component_found = true;
            }
            Component.write_scope(p_par, curr_component);
        }
        if (component_found) {
            p_par.file.end_scope();
        }
    }

    private static boolean read_placement_side(Scanner p_scanner) throws IOException {
        Object next_token = p_scanner.next_token();
        boolean result = next_token != Keyword.BACK;
        next_token = p_scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            System.out.println("Package.read_placement_side: closing bracket expected");
        }
        return result;
    }

    public static class PinInfo {
        public final String padstack_name;
        public final String pin_name;
        public final double[] rel_coor;
        public final double rotation;

        PinInfo(String p_padstack_name, String p_pin_name, double[] p_rel_coor, double p_rotation) {
            this.padstack_name = p_padstack_name;
            this.pin_name = p_pin_name;
            this.rel_coor = p_rel_coor;
            this.rotation = p_rotation;
        }
    }
}

