/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import board.RoutingBoard;
import designformats.specctra.CoordinateTransform;
import designformats.specctra.DsnFile;
import designformats.specctra.Keyword;
import designformats.specctra.Layer;
import designformats.specctra.LayerStructure;
import designformats.specctra.Package;
import designformats.specctra.ReadScopeParameter;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import designformats.specctra.Shape;
import designformats.specctra.WriteScopeParameter;
import geometry.planar.Area;
import geometry.planar.ConvexShape;
import geometry.planar.IntVector;
import geometry.planar.PolygonShape;
import geometry.planar.Simplex;
import geometry.planar.TileShape;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import library.Package;
import library.Packages;
import library.Padstack;
import library.Padstacks;

public class Library
extends ScopeKeyword {
    public Library() {
        super("library");
    }

    @Override
    public boolean read_scope(ReadScopeParameter p_par) {
        int i;
        RoutingBoard board = p_par.board_handling.get_routing_board();
        board.library.padstacks = new Padstacks(p_par.board_handling.get_routing_board().layer_structure);
        LinkedList<Package> package_list = new LinkedList<Package>();
        Object next_token = null;
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_par.scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("Library.read_scope: IO error scanning file");
                System.out.println(e);
                return false;
            }
            if (next_token == null) {
                System.out.println("Library.read_scope: unexpected end of file");
                return false;
            }
            if (next_token == CLOSED_BRACKET) break;
            if (prev_token != OPEN_BRACKET) continue;
            if (next_token == Keyword.PADSTACK) {
                if (Library.read_padstack_scope(p_par.scanner, p_par.layer_structure, p_par.coordinate_transform, board.library.padstacks)) continue;
                return false;
            }
            if (next_token == Keyword.IMAGE) {
                Package curr_package = Package.read_scope(p_par.scanner, p_par.layer_structure);
                if (curr_package == null) {
                    return false;
                }
                package_list.add(curr_package);
                continue;
            }
            Library.skip_scope(p_par.scanner);
        }
        if (p_par.via_padstack_names != null) {
            Padstack[] via_padstacks = new Padstack[p_par.via_padstack_names.size()];
            Iterator<String> it = p_par.via_padstack_names.iterator();
            int found_padstack_count = 0;
            for (i = 0; i < via_padstacks.length; ++i) {
                String curr_padstack_name = it.next();
                Padstack curr_padstack = board.library.padstacks.get(curr_padstack_name);
                if (curr_padstack != null) {
                    via_padstacks[found_padstack_count] = curr_padstack;
                    ++found_padstack_count;
                    continue;
                }
                System.out.print("Library.read_scope: via padstack with name ");
                System.out.print(curr_padstack_name);
                System.out.println(" not found");
            }
            if (found_padstack_count != via_padstacks.length) {
                Padstack[] corrected_padstacks = new Padstack[found_padstack_count];
                System.arraycopy(via_padstacks, 0, corrected_padstacks, 0, found_padstack_count);
                via_padstacks = corrected_padstacks;
            }
            board.library.set_via_padstacks(via_padstacks);
        }
        board.library.packages = new Packages(board.library.padstacks);
        for (Package curr_package : package_list) {
            Package.Pin[] pin_arr = new Package.Pin[curr_package.pin_info_arr.length];
            for (i = 0; i < pin_arr.length; ++i) {
                Package.PinInfo pin_info = curr_package.pin_info_arr[i];
                int rel_x = (int)Math.round(p_par.coordinate_transform.dsn_to_board(pin_info.rel_coor[0]));
                int rel_y = (int)Math.round(p_par.coordinate_transform.dsn_to_board(pin_info.rel_coor[1]));
                IntVector rel_coor = new IntVector(rel_x, rel_y);
                Padstack board_padstack = board.library.padstacks.get(pin_info.padstack_name);
                if (board_padstack == null) {
                    System.out.println("Library.read_scope: board padstack not found");
                    return false;
                }
                pin_arr[i] = new Package.Pin(pin_info.pin_name, board_padstack.no, rel_coor, pin_info.rotation);
            }
            geometry.planar.Shape[] outline_arr = new geometry.planar.Shape[curr_package.outline.size()];
            Iterator<Shape> it3 = curr_package.outline.iterator();
            for (int i2 = 0; i2 < outline_arr.length; ++i2) {
                Shape curr_shape = it3.next();
                if (curr_shape != null) {
                    outline_arr[i2] = curr_shape.transform_to_board_rel(p_par.coordinate_transform);
                    continue;
                }
                System.out.println("Library.read_scope: outline shape is null");
            }
            this.generate_missing_keepout_names("keepout_", curr_package.keepouts);
            this.generate_missing_keepout_names("via_keepout_", curr_package.via_keepouts);
            this.generate_missing_keepout_names("place_keepout_", curr_package.place_keepouts);
            Package.Keepout[] keepout_arr = new Package.Keepout[curr_package.keepouts.size()];
            Iterator<Shape.ReadAreaScopeResult> it2 = curr_package.keepouts.iterator();
            for (int i3 = 0; i3 < keepout_arr.length; ++i3) {
                Shape.ReadAreaScopeResult curr_keepout = it2.next();
                Layer curr_layer = curr_keepout.shape_list.iterator().next().layer;
                Area curr_area = Shape.transform_area_to_board_rel(curr_keepout.shape_list, p_par.coordinate_transform);
                keepout_arr[i3] = new Package.Keepout(curr_keepout.area_name, curr_area, curr_layer.no);
            }
            Package.Keepout[] via_keepout_arr = new Package.Keepout[curr_package.via_keepouts.size()];
            it2 = curr_package.via_keepouts.iterator();
            for (int i4 = 0; i4 < via_keepout_arr.length; ++i4) {
                Shape.ReadAreaScopeResult curr_keepout = it2.next();
                Layer curr_layer = curr_keepout.shape_list.iterator().next().layer;
                Area curr_area = Shape.transform_area_to_board_rel(curr_keepout.shape_list, p_par.coordinate_transform);
                via_keepout_arr[i4] = new Package.Keepout(curr_keepout.area_name, curr_area, curr_layer.no);
            }
            Package.Keepout[] place_keepout_arr = new Package.Keepout[curr_package.place_keepouts.size()];
            it2 = curr_package.place_keepouts.iterator();
            for (int i5 = 0; i5 < place_keepout_arr.length; ++i5) {
                Shape.ReadAreaScopeResult curr_keepout = it2.next();
                Layer curr_layer = curr_keepout.shape_list.iterator().next().layer;
                Area curr_area = Shape.transform_area_to_board_rel(curr_keepout.shape_list, p_par.coordinate_transform);
                place_keepout_arr[i5] = new Package.Keepout(curr_keepout.area_name, curr_area, curr_layer.no);
            }
            board.library.packages.add(curr_package.name, pin_arr, outline_arr, keepout_arr, via_keepout_arr, place_keepout_arr, curr_package.is_front);
        }
        return true;
    }

    public static void write_scope(WriteScopeParameter p_par) throws IOException {
        int i;
        p_par.file.start_scope();
        p_par.file.write("library");
        for (i = 1; i <= p_par.board.library.packages.count(); ++i) {
            Package.write_scope(p_par, p_par.board.library.packages.get(i));
        }
        for (i = 1; i <= p_par.board.library.padstacks.count(); ++i) {
            Library.write_padstack_scope(p_par, p_par.board.library.padstacks.get(i));
        }
        p_par.file.end_scope();
    }

    public static void write_padstack_scope(WriteScopeParameter p_par, Padstack p_padstack) throws IOException {
        int last_layer_no;
        int first_layer_no;
        for (first_layer_no = 0; first_layer_no < p_par.board.get_layer_count() && p_padstack.get_shape(first_layer_no) == null; ++first_layer_no) {
        }
        for (last_layer_no = p_par.board.get_layer_count() - 1; last_layer_no >= 0 && p_padstack.get_shape(last_layer_no) == null; --last_layer_no) {
        }
        if (first_layer_no >= p_par.board.get_layer_count() || last_layer_no < 0) {
            System.out.println("Library.write_padstack_scope: padstack shape not found");
            return;
        }
        p_par.file.start_scope();
        p_par.file.write("padstack ");
        p_par.identifier_type.write(p_padstack.name, p_par.file);
        for (int i = first_layer_no; i <= last_layer_no; ++i) {
            ConvexShape curr_board_shape = p_padstack.get_shape(i);
            if (curr_board_shape == null) continue;
            board.Layer board_layer = p_par.board.layer_structure.arr[i];
            Layer curr_layer = new Layer(board_layer.name, i, board_layer.is_signal);
            Shape curr_shape = p_par.coordinate_transform.board_to_dsn_rel(curr_board_shape, curr_layer);
            p_par.file.start_scope();
            p_par.file.write("shape");
            curr_shape.write_scope(p_par.file, p_par.identifier_type);
            p_par.file.end_scope();
        }
        if (!p_padstack.attach_allowed) {
            p_par.file.new_line();
            p_par.file.write("(attach off)");
        }
        if (p_padstack.placed_absolute) {
            p_par.file.new_line();
            p_par.file.write("(absolute on)");
        }
        p_par.file.end_scope();
    }

    static boolean read_padstack_scope(Scanner p_scanner, LayerStructure p_layer_structure, CoordinateTransform p_coordinate_transform, Padstacks p_board_padstacks) {
        String padstack_name = null;
        boolean is_drilllable = true;
        boolean placed_absolute = false;
        LinkedList<Shape> shape_list = new LinkedList<Shape>();
        try {
            Object next_token = p_scanner.next_token();
            if (next_token instanceof String) {
                padstack_name = (String)next_token;
            } else {
                System.out.println("Library.read_padstack_scope: unexpected padstack identifier");
                return false;
            }
            while (next_token != Keyword.CLOSED_BRACKET) {
                Object prev_token = next_token;
                next_token = p_scanner.next_token();
                if (prev_token != Keyword.OPEN_BRACKET) continue;
                if (next_token == Keyword.SHAPE) {
                    Shape curr_shape = Shape.read_scope(p_scanner, p_layer_structure);
                    if (curr_shape != null) {
                        shape_list.add(curr_shape);
                    }
                    Object curr_next_token = p_scanner.next_token();
                    while (curr_next_token == Keyword.OPEN_BRACKET) {
                        ScopeKeyword.skip_scope(p_scanner);
                        curr_next_token = p_scanner.next_token();
                    }
                    if (curr_next_token == Keyword.CLOSED_BRACKET) continue;
                    System.out.println("Library.read_padstack_scope: closing bracket expected");
                    return false;
                }
                if (next_token == Keyword.ATTACH) {
                    is_drilllable = DsnFile.read_on_off_scope(p_scanner);
                    continue;
                }
                if (next_token == Keyword.ABSOLUTE) {
                    placed_absolute = DsnFile.read_on_off_scope(p_scanner);
                    continue;
                }
                ScopeKeyword.skip_scope(p_scanner);
            }
        }
        catch (IOException e) {
            System.out.println("Library.read_padstack_scope: IO error scanning file");
            System.out.println(e);
            return false;
        }
        if (p_board_padstacks.get(padstack_name) != null) {
            return true;
        }
        if (shape_list.isEmpty()) {
            System.out.print("Library.read_padstack_scope: shape not found for padstack with name ");
            System.out.println(padstack_name);
            return true;
        }
        ConvexShape[] padstack_shapes = new ConvexShape[p_layer_structure.arr.length];
        for (Shape pad_shape : shape_list) {
            ConvexShape convex_shape;
            geometry.planar.Shape curr_shape = pad_shape.transform_to_board_rel(p_coordinate_transform);
            if (curr_shape instanceof ConvexShape) {
                convex_shape = (ConvexShape)curr_shape;
            } else {
                TileShape[] convex_shapes;
                if (curr_shape instanceof PolygonShape) {
                    curr_shape = ((PolygonShape)curr_shape).convex_hull();
                }
                if ((convex_shapes = curr_shape.split_to_convex()).length != 1) {
                    System.out.println("Library.read_padstack_scope: convex shape expected");
                }
                if ((convex_shape = convex_shapes[0]) instanceof Simplex) {
                    convex_shape = ((Simplex)convex_shape).simplify();
                }
            }
            ConvexShape padstack_shape = convex_shape;
            if (padstack_shape != null && padstack_shape.dimension() < 2) {
                System.out.print("Library.read_padstack_scope: shape is not an area ");
                padstack_shape = padstack_shape.offset(1.0);
                if (padstack_shape.dimension() < 2) {
                    padstack_shape = null;
                }
            }
            if (pad_shape.layer == Layer.PCB || pad_shape.layer == Layer.SIGNAL) {
                for (int i = 0; i < padstack_shapes.length; ++i) {
                    padstack_shapes[i] = padstack_shape;
                }
                continue;
            }
            int shape_layer = p_layer_structure.get_no(pad_shape.layer.name);
            if (shape_layer < 0 || shape_layer >= padstack_shapes.length) {
                System.out.println("Library.read_padstack_scope: layer number found");
                return false;
            }
            padstack_shapes[shape_layer] = padstack_shape;
        }
        p_board_padstacks.add(padstack_name, padstack_shapes, is_drilllable, placed_absolute);
        return true;
    }

    private void generate_missing_keepout_names(String p_keepout_type, Collection<Shape.ReadAreaScopeResult> p_keepout_list) {
        boolean all_names_existing = true;
        for (Shape.ReadAreaScopeResult curr_keepout : p_keepout_list) {
            if (curr_keepout.area_name != null) continue;
            all_names_existing = false;
            break;
        }
        if (all_names_existing) {
            return;
        }
        Integer curr_name_index = 1;
        for (Shape.ReadAreaScopeResult curr_keepout : p_keepout_list) {
            curr_keepout.area_name = p_keepout_type + curr_name_index.toString();
            curr_name_index = curr_name_index + 1;
        }
    }
}

