/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import board.BoardObservers;
import board.BoardOutline;
import board.ConductionArea;
import board.FixedState;
import board.Item;
import board.Layer;
import board.LayerStructure;
import board.RoutingBoard;
import board.TestLevel;
import board.Trace;
import datastructures.IdNoGenerator;
import datastructures.IndentFileWriter;
import designformats.specctra.Keyword;
import designformats.specctra.Library;
import designformats.specctra.Network;
import designformats.specctra.Parser;
import designformats.specctra.PartLibrary;
import designformats.specctra.Placement;
import designformats.specctra.ReadScopeParameter;
import designformats.specctra.Resolution;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import designformats.specctra.SpecctraFileScanner;
import designformats.specctra.Structure;
import designformats.specctra.Wiring;
import designformats.specctra.WriteScopeParameter;
import geometry.planar.TileShape;
import interactive.AutorouteSettings;
import interactive.BoardHandling;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import rules.Net;

public class DsnFile {
    static final String CLASS_CLEARANCE_SEPARATOR = "-";

    public static ReadResult read(InputStream p_input_stream, BoardHandling p_board_handling, BoardObservers p_observers, IdNoGenerator p_item_id_no_generator, TestLevel p_test_level) {
        ReadResult result;
        SpecctraFileScanner scanner = new SpecctraFileScanner(p_input_stream);
        Object curr_token = null;
        for (int i = 0; i < 3; ++i) {
            try {
                curr_token = scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("DsnFile.read: IO error scanning file");
                System.out.println(e);
                return ReadResult.ERROR;
            }
            boolean keyword_ok = true;
            if (i == 0) {
                keyword_ok = curr_token == Keyword.OPEN_BRACKET;
            } else if (i == 1) {
                keyword_ok = curr_token == Keyword.PCB_SCOPE;
                scanner.yybegin(3);
            }
            if (keyword_ok) continue;
            System.out.println("DsnFile.read: specctra dsn file format expected");
            return ReadResult.ERROR;
        }
        ReadScopeParameter read_scope_par = new ReadScopeParameter(scanner, p_board_handling, p_observers, p_item_id_no_generator, p_test_level);
        boolean read_ok = Keyword.PCB_SCOPE.read_scope(read_scope_par);
        if (read_ok) {
            result = ReadResult.OK;
            if (read_scope_par.autoroute_settings == null) {
                DsnFile.adjust_plane_autoroute_settings(p_board_handling);
            }
        } else {
            result = !read_scope_par.board_outline_ok ? ReadResult.OUTLINE_MISSING : ReadResult.ERROR;
        }
        return result;
    }

    private static boolean adjust_plane_autoroute_settings(BoardHandling p_board_handling) {
        RoutingBoard routing_board = p_board_handling.get_routing_board();
        LayerStructure board_layer_structure = routing_board.layer_structure;
        if (board_layer_structure.arr.length <= 2) {
            return false;
        }
        for (Layer curr_layer : board_layer_structure.arr) {
            if (curr_layer.is_signal) continue;
            return false;
        }
        boolean[] layer_contains_wires_arr = new boolean[board_layer_structure.arr.length];
        boolean[] changed_layer_arr = new boolean[board_layer_structure.arr.length];
        for (int i = 0; i < layer_contains_wires_arr.length; ++i) {
            layer_contains_wires_arr[i] = false;
            changed_layer_arr[i] = false;
        }
        LinkedList<ConductionArea> conduction_area_list = new LinkedList<ConductionArea>();
        Collection<Item> item_list = routing_board.get_items();
        for (Item curr_item : item_list) {
            if (curr_item instanceof Trace) {
                int curr_layer = ((Trace)curr_item).get_layer();
                layer_contains_wires_arr[curr_layer] = true;
                continue;
            }
            if (!(curr_item instanceof ConductionArea)) continue;
            conduction_area_list.add((ConductionArea)curr_item);
        }
        boolean nothing_changed = true;
        BoardOutline board_outline = routing_board.get_outline();
        double board_area = 0.0;
        for (int i = 0; i < board_outline.shape_count(); ++i) {
            TileShape[] curr_piece_arr = board_outline.get_shape(i).split_to_convex();
            if (curr_piece_arr == null) continue;
            for (TileShape curr_piece : curr_piece_arr) {
                board_area += curr_piece.area();
            }
        }
        for (ConductionArea curr_conduction_area : conduction_area_list) {
            int layer_no = curr_conduction_area.get_layer();
            if (layer_contains_wires_arr[layer_no]) continue;
            Layer curr_layer = routing_board.layer_structure.arr[layer_no];
            if (!curr_layer.is_signal || layer_no == 0 || layer_no == board_layer_structure.arr.length - 1) continue;
            TileShape[] convex_pieces = curr_conduction_area.get_area().split_to_convex();
            double curr_area = 0.0;
            for (TileShape curr_piece : convex_pieces) {
                curr_area += curr_piece.area();
            }
            if (curr_area < 0.5 * board_area) continue;
            for (int i = 0; i < curr_conduction_area.net_count(); ++i) {
                Net curr_net = routing_board.rules.nets.get(curr_conduction_area.get_net_no(i));
                curr_net.set_contains_plane(true);
                nothing_changed = false;
            }
            changed_layer_arr[layer_no] = true;
            if (curr_conduction_area.get_fixed_state().ordinal() >= FixedState.USER_FIXED.ordinal()) continue;
            curr_conduction_area.set_fixed_state(FixedState.USER_FIXED);
        }
        if (nothing_changed) {
            return false;
        }
        AutorouteSettings autoroute_settings = p_board_handling.settings.autoroute_settings;
        int layer_count = routing_board.get_layer_count();
        boolean curr_preferred_direction_is_horizontal = autoroute_settings.get_preferred_direction_is_horizontal(0);
        for (int i = 0; i < layer_count; ++i) {
            if (changed_layer_arr[i]) {
                autoroute_settings.set_layer_active(i, false);
                continue;
            }
            if (!autoroute_settings.get_layer_active(i)) continue;
            autoroute_settings.set_preferred_direction_is_horizontal(i, curr_preferred_direction_is_horizontal);
            curr_preferred_direction_is_horizontal = !curr_preferred_direction_is_horizontal;
        }
        return true;
    }

    public static boolean write(BoardHandling p_board_handling, OutputStream p_file, String p_design_name, boolean p_compat_mode) {
        IndentFileWriter output_file = new IndentFileWriter(p_file);
        if (output_file == null) {
            System.out.println("unable to write dsn file");
            return false;
        }
        try {
            DsnFile.write_pcb_scope(p_board_handling, output_file, p_design_name, p_compat_mode);
        }
        catch (IOException e) {
            System.out.println("unable to write dsn file");
            return false;
        }
        try {
            output_file.close();
        }
        catch (IOException e) {
            System.out.println("unable to close dsn file");
            return false;
        }
        return true;
    }

    private static void write_pcb_scope(BoardHandling p_board_handling, IndentFileWriter p_file, String p_design_name, boolean p_compat_mode) throws IOException {
        RoutingBoard routing_board = p_board_handling.get_routing_board();
        WriteScopeParameter write_scope_parameter = new WriteScopeParameter(routing_board, p_board_handling.settings.autoroute_settings, p_file, routing_board.communication.specctra_parser_info.string_quote, routing_board.communication.coordinate_transform, p_compat_mode);
        p_file.start_scope();
        p_file.write("PCB ");
        write_scope_parameter.identifier_type.write(p_design_name, p_file);
        Parser.write_scope(write_scope_parameter.file, write_scope_parameter.board.communication.specctra_parser_info, write_scope_parameter.identifier_type, false);
        Resolution.write_scope(p_file, routing_board.communication);
        Structure.write_scope(write_scope_parameter);
        Placement.write_scope(write_scope_parameter);
        Library.write_scope(write_scope_parameter);
        PartLibrary.write_scope(write_scope_parameter);
        Network.write_scope(write_scope_parameter);
        Wiring.write_scope(write_scope_parameter);
        p_file.end_scope();
    }

    static boolean read_on_off_scope(Scanner p_scanner) {
        try {
            Object next_token = p_scanner.next_token();
            boolean result = false;
            if (next_token == Keyword.ON) {
                result = true;
            } else if (next_token != Keyword.OFF) {
                System.out.println("DsnFile.read_boolean: Keyword.OFF expected");
            }
            ScopeKeyword.skip_scope(p_scanner);
            return result;
        }
        catch (IOException e) {
            System.out.println("DsnFile.read_boolean: IO error scanning file");
            return false;
        }
    }

    static int read_integer_scope(Scanner p_scanner) {
        try {
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof Integer)) {
                System.out.println("DsnFile.read_integer_scope: number expected");
                return 0;
            }
            int value = (Integer)next_token;
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("DsnFile.read_integer_scope: closing bracket expected");
                return 0;
            }
            return value;
        }
        catch (IOException e) {
            System.out.println("DsnFile.read_integer_scope: IO error scanning file");
            return 0;
        }
    }

    static double read_float_scope(Scanner p_scanner) {
        try {
            double value;
            Object next_token = p_scanner.next_token();
            if (next_token instanceof Double) {
                value = (Double)next_token;
            } else if (next_token instanceof Integer) {
                value = ((Integer)next_token).intValue();
            } else {
                System.out.println("DsnFile.read_float_scope: number expected");
                return 0.0;
            }
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("DsnFile.read_float_scope: closing bracket expected");
                return 0.0;
            }
            return value;
        }
        catch (IOException e) {
            System.out.println("DsnFile.read_float_scope: IO error scanning file");
            return 0.0;
        }
    }

    public static String read_string_scope(Scanner p_scanner) {
        try {
            p_scanner.yybegin(3);
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("DsnFile:read_string_scope: String expected");
                return null;
            }
            String result = (String)next_token;
            next_token = p_scanner.next_token();
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("DsnFile.read_string_scope: closing bracket expected");
            }
            return result;
        }
        catch (IOException e) {
            System.out.println("DsnFile.read_string_scope: IO error scanning file");
            return null;
        }
    }

    public static Collection<String> read_string_list_scope(Scanner p_scanner) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            while (true) {
                p_scanner.yybegin(3);
                Object next_token = p_scanner.next_token();
                if (next_token != Keyword.CLOSED_BRACKET) {
                    if (!(next_token instanceof String)) {
                        System.out.println("DsnFileread_string_list_scope: string expected");
                        return null;
                    }
                    result.add((String)next_token);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println("DsnFile.read_string_list_scope: IO error scanning file");
        }
        return result;
    }

    public static enum ReadResult {
        OK,
        OUTLINE_MISSING,
        ERROR;

    }
}

