/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import designformats.specctra.Circle;
import designformats.specctra.Layer;
import designformats.specctra.Polygon;
import designformats.specctra.Rectangle;
import designformats.specctra.Shape;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.Line;
import geometry.planar.PolylineShape;
import geometry.planar.Vector;
import java.io.Serializable;

public class CoordinateTransform
implements Serializable {
    private final double scale_factor;
    private final double base_x;
    private final double base_y;

    public CoordinateTransform(double p_scale_factor, double p_base_x, double p_base_y) {
        this.scale_factor = p_scale_factor;
        this.base_x = p_base_x;
        this.base_y = p_base_y;
    }

    public double board_to_dsn(double p_val) {
        return p_val / this.scale_factor;
    }

    public double dsn_to_board(double p_val) {
        return p_val * this.scale_factor;
    }

    public double[] board_to_dsn(FloatPoint p_point) {
        double[] result = new double[]{this.board_to_dsn(p_point.x) + this.base_x, this.board_to_dsn(p_point.y) + this.base_y};
        return result;
    }

    public double[] board_to_dsn_rel(FloatPoint p_point) {
        double[] result = new double[]{this.board_to_dsn(p_point.x), this.board_to_dsn(p_point.y)};
        return result;
    }

    public double[] board_to_dsn(FloatPoint[] p_points) {
        double[] result = new double[2 * p_points.length];
        for (int i = 0; i < p_points.length; ++i) {
            result[2 * i] = this.board_to_dsn(p_points[i].x) + this.base_x;
            result[2 * i + 1] = this.board_to_dsn(p_points[i].y) + this.base_y;
        }
        return result;
    }

    public double[] board_to_dsn(Line[] p_lines) {
        double[] result = new double[4 * p_lines.length];
        for (int i = 0; i < p_lines.length; ++i) {
            FloatPoint a = p_lines[i].a.to_float();
            FloatPoint b = p_lines[i].b.to_float();
            result[4 * i] = this.board_to_dsn(a.x) + this.base_x;
            result[4 * i + 1] = this.board_to_dsn(a.y) + this.base_y;
            result[4 * i + 2] = this.board_to_dsn(b.x) + this.base_x;
            result[4 * i + 3] = this.board_to_dsn(b.y) + this.base_y;
        }
        return result;
    }

    public double[] board_to_dsn_rel(FloatPoint[] p_points) {
        double[] result = new double[2 * p_points.length];
        for (int i = 0; i < p_points.length; ++i) {
            result[2 * i] = this.board_to_dsn(p_points[i].x);
            result[2 * i + 1] = this.board_to_dsn(p_points[i].y);
        }
        return result;
    }

    public double[] board_to_dsn(Vector p_vector) {
        double[] result = new double[2];
        FloatPoint v = p_vector.to_float();
        result[0] = this.board_to_dsn(v.x);
        result[1] = this.board_to_dsn(v.y);
        return result;
    }

    public FloatPoint dsn_to_board(double[] p_tuple) {
        double x = this.dsn_to_board(p_tuple[0] - this.base_x);
        double y = this.dsn_to_board(p_tuple[1] - this.base_y);
        return new FloatPoint(x, y);
    }

    public FloatPoint dsn_to_board_rel(double[] p_tuple) {
        double x = this.dsn_to_board(p_tuple[0]);
        double y = this.dsn_to_board(p_tuple[1]);
        return new FloatPoint(x, y);
    }

    public double[] board_to_dsn(IntBox p_box) {
        double[] result = new double[]{(double)p_box.ll.x / this.scale_factor + this.base_x, (double)p_box.ll.y / this.scale_factor + this.base_y, (double)p_box.ur.x / this.scale_factor + this.base_x, (double)p_box.ur.y / this.scale_factor + this.base_y};
        return result;
    }

    public double[] board_to_dsn_rel(IntBox p_box) {
        double[] result = new double[]{(double)p_box.ll.x / this.scale_factor, (double)p_box.ll.y / this.scale_factor, (double)p_box.ur.x / this.scale_factor, (double)p_box.ur.y / this.scale_factor};
        return result;
    }

    public Shape board_to_dsn(geometry.planar.Shape p_board_shape, Layer p_layer) {
        Shape result;
        if (p_board_shape instanceof IntBox) {
            result = new Rectangle(p_layer, this.board_to_dsn((IntBox)p_board_shape));
        } else if (p_board_shape instanceof PolylineShape) {
            FloatPoint[] corners = ((PolylineShape)p_board_shape).corner_approx_arr();
            double[] coors = this.board_to_dsn(corners);
            result = new Polygon(p_layer, coors);
        } else if (p_board_shape instanceof geometry.planar.Circle) {
            geometry.planar.Circle board_circle = (geometry.planar.Circle)p_board_shape;
            double diameter = 2.0 * this.board_to_dsn(board_circle.radius);
            double[] center_coor = this.board_to_dsn(board_circle.center.to_float());
            result = new Circle(p_layer, diameter, center_coor[0], center_coor[1]);
        } else {
            System.out.println("CoordinateTransform.board_to_dsn not yet implemented for p_board_shape");
            result = null;
        }
        return result;
    }

    public Shape board_to_dsn_rel(geometry.planar.Shape p_board_shape, Layer p_layer) {
        Shape result;
        if (p_board_shape instanceof IntBox) {
            result = new Rectangle(p_layer, this.board_to_dsn_rel((IntBox)p_board_shape));
        } else if (p_board_shape instanceof PolylineShape) {
            FloatPoint[] corners = ((PolylineShape)p_board_shape).corner_approx_arr();
            double[] coors = this.board_to_dsn_rel(corners);
            result = new Polygon(p_layer, coors);
        } else if (p_board_shape instanceof geometry.planar.Circle) {
            geometry.planar.Circle board_circle = (geometry.planar.Circle)p_board_shape;
            double diameter = 2.0 * this.board_to_dsn(board_circle.radius);
            double[] center_coor = this.board_to_dsn_rel(board_circle.center.to_float());
            result = new Circle(p_layer, diameter, center_coor[0], center_coor[1]);
        } else {
            System.out.println("CoordinateTransform.board_to_dsn not yet implemented for p_board_shape");
            result = null;
        }
        return result;
    }
}

