/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import board.BasicBoard;
import board.Item;
import board.ObstacleArea;
import board.Pin;
import datastructures.UndoableObjects;
import designformats.specctra.ComponentPlacement;
import designformats.specctra.DsnFile;
import designformats.specctra.Keyword;
import designformats.specctra.ReadScopeParameter;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import designformats.specctra.WriteScopeParameter;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import library.Package;

public class Component
extends ScopeKeyword {
    public Component() {
        super("component");
    }

    @Override
    public boolean read_scope(ReadScopeParameter p_par) {
        try {
            ComponentPlacement component_placement = Component.read_scope(p_par.scanner);
            if (component_placement == null) {
                return false;
            }
            p_par.placement_list.add(component_placement);
        }
        catch (IOException e) {
            System.out.println("Component.read_scope: IO error scanning file");
            return false;
        }
        return true;
    }

    public static ComponentPlacement read_scope(Scanner p_scanner) throws IOException {
        Object next_token = p_scanner.next_token();
        if (!(next_token instanceof String)) {
            System.out.println("Component.read_scope: component name expected");
            return null;
        }
        String name = (String)next_token;
        ComponentPlacement component_placement = new ComponentPlacement(name);
        Object prev_token = next_token;
        next_token = p_scanner.next_token();
        while (next_token != Keyword.CLOSED_BRACKET) {
            ComponentPlacement.ComponentLocation next_location;
            if (prev_token == Keyword.OPEN_BRACKET && next_token == Keyword.PLACE && (next_location = Component.read_place_scope(p_scanner)) != null) {
                component_placement.locations.add(next_location);
            }
            prev_token = next_token;
            next_token = p_scanner.next_token();
        }
        return component_placement;
    }

    public static void write_scope(WriteScopeParameter p_par, board.Component p_component) throws IOException {
        int i;
        p_par.file.start_scope();
        p_par.file.write("place ");
        p_par.file.new_line();
        p_par.identifier_type.write(p_component.name, p_par.file);
        if (p_component.is_placed()) {
            double[] coor = p_par.coordinate_transform.board_to_dsn(p_component.get_location().to_float());
            for (i = 0; i < coor.length; ++i) {
                p_par.file.write(" ");
                p_par.file.write(new Double(coor[i]).toString());
            }
            if (p_component.placed_on_front()) {
                p_par.file.write(" front ");
            } else {
                p_par.file.write(" back ");
            }
            int rotation = (int)Math.round(p_component.get_rotation_in_degree());
            p_par.file.write(new Integer(rotation).toString());
        }
        if (p_component.position_fixed) {
            p_par.file.new_line();
            p_par.file.write(" (lock_type position)");
        }
        int pin_count = p_component.get_package().pin_count();
        for (i = 0; i < pin_count; ++i) {
            Component.write_pin_info(p_par, p_component, i);
        }
        Component.write_keepout_infos(p_par, p_component);
        p_par.file.end_scope();
    }

    private static void write_pin_info(WriteScopeParameter p_par, board.Component p_component, int p_pin_no) throws IOException {
        if (!p_component.is_placed()) {
            return;
        }
        Package.Pin package_pin = p_component.get_package().get_pin(p_pin_no);
        if (package_pin == null) {
            System.out.println("Component.write_pin_info: package pin not found");
            return;
        }
        Pin component_pin = p_par.board.get_pin(p_component.no, p_pin_no);
        if (component_pin == null) {
            System.out.println("Component.write_pin_info: component pin not found");
            return;
        }
        String cl_class_name = p_par.board.rules.clearance_matrix.get_name(component_pin.clearance_class_no());
        if (cl_class_name == null) {
            System.out.println("Component.write_pin_info: clearance class  name not found");
            return;
        }
        p_par.file.new_line();
        p_par.file.write("(pin ");
        p_par.identifier_type.write(package_pin.name, p_par.file);
        p_par.file.write(" (clearance_class ");
        p_par.identifier_type.write(cl_class_name, p_par.file);
        p_par.file.write("))");
    }

    private static void write_keepout_infos(WriteScopeParameter p_par, board.Component p_component) throws IOException {
        if (!p_component.is_placed()) {
            return;
        }
        for (int j = 0; j < 3; ++j) {
            String keepout_type;
            Package.Keepout[] curr_keepout_arr;
            if (j == 0) {
                curr_keepout_arr = p_component.get_package().keepout_arr;
                keepout_type = "(keepout ";
            } else if (j == 1) {
                curr_keepout_arr = p_component.get_package().via_keepout_arr;
                keepout_type = "(via_keepout ";
            } else {
                curr_keepout_arr = p_component.get_package().place_keepout_arr;
                keepout_type = "(place_keepout ";
            }
            for (int i = 0; i < curr_keepout_arr.length; ++i) {
                Package.Keepout curr_keepout = curr_keepout_arr[i];
                ObstacleArea curr_obstacle_area = Component.get_keepout(p_par.board, p_component.no, curr_keepout.name);
                if (curr_obstacle_area == null || curr_obstacle_area.clearance_class_no() == 0) continue;
                String cl_class_name = p_par.board.rules.clearance_matrix.get_name(curr_obstacle_area.clearance_class_no());
                if (cl_class_name == null) {
                    System.out.println("Component.write_keepout_infos: clearance class name not found");
                    return;
                }
                p_par.file.new_line();
                p_par.file.write(keepout_type);
                p_par.identifier_type.write(curr_keepout.name, p_par.file);
                p_par.file.write(" (clearance_class ");
                p_par.identifier_type.write(cl_class_name, p_par.file);
                p_par.file.write("))");
            }
        }
    }

    private static ObstacleArea get_keepout(BasicBoard p_board, int p_component_no, String p_name) {
        Item curr_item;
        Iterator<UndoableObjects.UndoableObjectNode> it = p_board.item_list.start_read_object();
        while ((curr_item = (Item)p_board.item_list.read_object(it)) != null) {
            if (curr_item.get_component_no() != p_component_no || !(curr_item instanceof ObstacleArea)) continue;
            ObstacleArea curr_area = (ObstacleArea)curr_item;
            if (curr_area.name == null || !curr_area.name.equals(p_name)) continue;
            return curr_area;
        }
        return null;
    }

    private static ComponentPlacement.ComponentLocation read_place_scope(Scanner p_scanner) {
        try {
            double rotation;
            TreeMap<String, ComponentPlacement.ItemClearanceInfo> pin_infos = new TreeMap<String, ComponentPlacement.ItemClearanceInfo>();
            TreeMap<String, ComponentPlacement.ItemClearanceInfo> keepout_infos = new TreeMap<String, ComponentPlacement.ItemClearanceInfo>();
            TreeMap<String, ComponentPlacement.ItemClearanceInfo> via_keepout_infos = new TreeMap<String, ComponentPlacement.ItemClearanceInfo>();
            TreeMap<String, ComponentPlacement.ItemClearanceInfo> place_keepout_infos = new TreeMap<String, ComponentPlacement.ItemClearanceInfo>();
            Object next_token = p_scanner.next_token();
            if (!(next_token instanceof String)) {
                System.out.println("Component.read_place_scope: String expected");
                return null;
            }
            String name = (String)next_token;
            double[] location = new double[2];
            for (int i = 0; i < 2; ++i) {
                next_token = p_scanner.next_token();
                if (next_token instanceof Double) {
                    location[i] = (Double)next_token;
                    continue;
                }
                if (next_token instanceof Integer) {
                    location[i] = ((Integer)next_token).intValue();
                    continue;
                }
                if (next_token == Keyword.CLOSED_BRACKET) {
                    return new ComponentPlacement.ComponentLocation(name, null, true, 0.0, false, pin_infos, keepout_infos, via_keepout_infos, place_keepout_infos);
                }
                System.out.println("Component.read_place_scope: number  expected");
                return null;
            }
            next_token = p_scanner.next_token();
            boolean is_front = true;
            if (next_token == Keyword.BACK) {
                is_front = false;
            } else if (next_token != Keyword.FRONT) {
                System.out.println("Component.read_place_scope: Keyword.FRONT expected");
            }
            next_token = p_scanner.next_token();
            if (next_token instanceof Double) {
                rotation = (Double)next_token;
            } else if (next_token instanceof Integer) {
                rotation = ((Integer)next_token).intValue();
            } else {
                System.out.println("Component.read_place_scope: number expected");
                return null;
            }
            boolean position_fixed = false;
            next_token = p_scanner.next_token();
            while (next_token == Keyword.OPEN_BRACKET) {
                ComponentPlacement.ItemClearanceInfo curr_keepout_info;
                next_token = p_scanner.next_token();
                if (next_token == Keyword.LOCK_TYPE) {
                    position_fixed = Component.read_lock_type(p_scanner);
                } else if (next_token == Keyword.PIN) {
                    ComponentPlacement.ItemClearanceInfo curr_pin_info = Component.read_item_clearance_info(p_scanner);
                    if (curr_pin_info == null) {
                        return null;
                    }
                    pin_infos.put(curr_pin_info.name, curr_pin_info);
                } else if (next_token == Keyword.KEEPOUT) {
                    curr_keepout_info = Component.read_item_clearance_info(p_scanner);
                    if (curr_keepout_info == null) {
                        return null;
                    }
                    keepout_infos.put(curr_keepout_info.name, curr_keepout_info);
                } else if (next_token == Keyword.VIA_KEEPOUT) {
                    curr_keepout_info = Component.read_item_clearance_info(p_scanner);
                    if (curr_keepout_info == null) {
                        return null;
                    }
                    via_keepout_infos.put(curr_keepout_info.name, curr_keepout_info);
                } else if (next_token == Keyword.PLACE_KEEPOUT) {
                    curr_keepout_info = Component.read_item_clearance_info(p_scanner);
                    if (curr_keepout_info == null) {
                        return null;
                    }
                    place_keepout_infos.put(curr_keepout_info.name, curr_keepout_info);
                } else {
                    Component.skip_scope(p_scanner);
                }
                next_token = p_scanner.next_token();
            }
            if (next_token != Keyword.CLOSED_BRACKET) {
                System.out.println("Component.read_place_scope: ) expected");
                return null;
            }
            ComponentPlacement.ComponentLocation result = new ComponentPlacement.ComponentLocation(name, location, is_front, rotation, position_fixed, pin_infos, keepout_infos, via_keepout_infos, place_keepout_infos);
            return result;
        }
        catch (IOException e) {
            System.out.println("Component.read_scope: IO error scanning file");
            System.out.println(e);
            return null;
        }
    }

    private static ComponentPlacement.ItemClearanceInfo read_item_clearance_info(Scanner p_scanner) throws IOException {
        p_scanner.yybegin(3);
        Object next_token = p_scanner.next_token();
        if (!(next_token instanceof String)) {
            System.out.println("Component.read_item_clearance_info: String expected");
            return null;
        }
        String name = (String)next_token;
        String cl_class_name = null;
        next_token = p_scanner.next_token();
        while (next_token == Keyword.OPEN_BRACKET) {
            next_token = p_scanner.next_token();
            if (next_token == Keyword.CLEARANCE_CLASS) {
                cl_class_name = DsnFile.read_string_scope(p_scanner);
            } else {
                Component.skip_scope(p_scanner);
            }
            next_token = p_scanner.next_token();
        }
        if (next_token != Keyword.CLOSED_BRACKET) {
            System.out.println("Component.read_item_clearance_info: ) expected");
            return null;
        }
        if (cl_class_name == null) {
            System.out.println("Component.read_item_clearance_info: clearance class name not found");
            return null;
        }
        return new ComponentPlacement.ItemClearanceInfo(name, cl_class_name);
    }

    private static boolean read_lock_type(Scanner p_scanner) throws IOException {
        Object next_token;
        boolean result = false;
        while ((next_token = p_scanner.next_token()) != Keyword.CLOSED_BRACKET) {
            if (next_token != Keyword.POSITION) continue;
            result = true;
        }
        return result;
    }
}

