/*
 * Decompiled with CFR 0.152.
 */
package designformats.specctra;

import designformats.specctra.DsnFile;
import designformats.specctra.Keyword;
import designformats.specctra.Scanner;
import designformats.specctra.ScopeKeyword;
import designformats.specctra.Structure;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class Circuit {
    public static ReadScopeResult read_scope(Scanner p_scanner) {
        Object next_token = null;
        double min_trace_length = 0.0;
        double max_trace_length = 0.0;
        LinkedList<String> use_via = new LinkedList<String>();
        LinkedList<String> use_layer = new LinkedList<String>();
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("Circuit.read_scope: IO error scanning file");
                return null;
            }
            if (next_token == null) {
                System.out.println("Circuit.read_scope: unexpected end of file");
                return null;
            }
            if (next_token == Keyword.CLOSED_BRACKET) break;
            if (prev_token != Keyword.OPEN_BRACKET) continue;
            if (next_token == Keyword.LENGTH) {
                LengthMatchingRule length_rule = Circuit.read_length_scope(p_scanner);
                if (length_rule == null) continue;
                min_trace_length = length_rule.min_length;
                max_trace_length = length_rule.max_length;
                continue;
            }
            if (next_token == Keyword.USE_VIA) {
                use_via.addAll(Structure.read_via_padstacks(p_scanner));
                continue;
            }
            if (next_token == Keyword.USE_LAYER) {
                use_layer.addAll(DsnFile.read_string_list_scope(p_scanner));
                continue;
            }
            ScopeKeyword.skip_scope(p_scanner);
        }
        return new ReadScopeResult(max_trace_length, min_trace_length, use_via, use_layer);
    }

    static LengthMatchingRule read_length_scope(Scanner p_scanner) {
        LengthMatchingRule result = null;
        double[] length_arr = new double[2];
        Object next_token = null;
        for (int i = 0; i < 2; ++i) {
            try {
                next_token = p_scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("Circuit.read_length_scope: IO error scanning file");
                return null;
            }
            if (next_token instanceof Double) {
                length_arr[i] = (Double)next_token;
                continue;
            }
            if (next_token instanceof Integer) {
                length_arr[i] = ((Integer)next_token).intValue();
                continue;
            }
            System.out.println("Circuit.read_length_scope: number expected");
            return null;
        }
        result = new LengthMatchingRule(length_arr[0], length_arr[1]);
        while (true) {
            Object prev_token = next_token;
            try {
                next_token = p_scanner.next_token();
            }
            catch (IOException e) {
                System.out.println("Circuit.read_length_scope: IO error scanning file");
                return null;
            }
            if (next_token == null) {
                System.out.println("Circuit.read_length_scope: unexpected end of file");
                return null;
            }
            if (next_token == Keyword.CLOSED_BRACKET) break;
            if (prev_token != Keyword.OPEN_BRACKET) continue;
            ScopeKeyword.skip_scope(p_scanner);
        }
        return result;
    }

    private static class LengthMatchingRule {
        public final double max_length;
        public final double min_length;

        public LengthMatchingRule(double p_max_length, double p_min_length) {
            this.max_length = p_max_length;
            this.min_length = p_min_length;
        }
    }

    public static class ReadScopeResult {
        public final double max_length;
        public final double min_length;
        public final Collection<String> use_via;
        public final Collection<String> use_layer;

        public ReadScopeResult(double p_max_length, double p_min_length, Collection<String> p_use_via, Collection<String> p_use_layer) {
            this.max_length = p_max_length;
            this.min_length = p_min_length;
            this.use_via = p_use_via;
            this.use_layer = p_use_layer;
        }
    }
}

