/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class UndoableObjects
implements Serializable {
    private ConcurrentMap<Storable, UndoableObjectNode> objects = new ConcurrentSkipListMap<Storable, UndoableObjectNode>();
    private int stack_level = 0;
    private Vector<Collection<UndoableObjectNode>> deleted_objects_stack = new Vector();
    private boolean redo_possible = false;

    public Iterator<UndoableObjectNode> start_read_object() {
        Collection object_list = this.objects.values();
        return object_list.iterator();
    }

    public Storable read_object(Iterator<UndoableObjectNode> p_it) {
        while (p_it.hasNext()) {
            UndoableObjectNode curr_node = p_it.next();
            if (curr_node == null || curr_node.level > this.stack_level) continue;
            return curr_node.object;
        }
        return null;
    }

    public void insert(Storable p_object) {
        this.disable_redo();
        UndoableObjectNode curr_undoable_object = new UndoableObjectNode(p_object, this.stack_level);
        this.objects.put(p_object, curr_undoable_object);
    }

    public boolean delete(Storable p_object) {
        this.disable_redo();
        Collection<UndoableObjectNode> curr_delete_list = this.deleted_objects_stack.isEmpty() ? null : this.deleted_objects_stack.lastElement();
        UndoableObjectNode object_node = (UndoableObjectNode)this.objects.get(p_object);
        if (object_node == null) {
            return false;
        }
        if (object_node.object != p_object) {
            System.out.println("UndoableObjectList.delete: Object inconsistent");
            return false;
        }
        if (curr_delete_list != null) {
            if (object_node.level < this.stack_level) {
                curr_delete_list.add(object_node);
            } else if (object_node.undo_object != null) {
                curr_delete_list.add(object_node.undo_object);
            }
        }
        this.objects.remove(p_object);
        return true;
    }

    public void generate_snapshot() {
        this.disable_redo();
        LinkedList curr_deleted_objects_list = new LinkedList();
        this.deleted_objects_stack.add(curr_deleted_objects_list);
        ++this.stack_level;
    }

    public boolean undo(Collection<Storable> p_cancelled_objects, Collection<Storable> p_restored_objects) {
        if (this.stack_level == 0) {
            return false;
        }
        for (UndoableObjectNode curr_node : this.objects.values()) {
            if (curr_node.level != this.stack_level) continue;
            if (curr_node.undo_object != null) {
                curr_node.undo_object.redo_object = curr_node;
                this.objects.put(curr_node.object, curr_node.undo_object);
                if (p_restored_objects != null) {
                    p_restored_objects.add(curr_node.undo_object.object);
                }
            }
            if (p_cancelled_objects == null) continue;
            p_cancelled_objects.add(curr_node.object);
        }
        Collection<UndoableObjectNode> curr_delete_list = this.deleted_objects_stack.elementAt(this.stack_level - 1);
        for (UndoableObjectNode curr_deleted_node : curr_delete_list) {
            this.objects.put(curr_deleted_node.object, curr_deleted_node);
            if (p_restored_objects == null) continue;
            p_restored_objects.add(curr_deleted_node.object);
        }
        --this.stack_level;
        this.redo_possible = true;
        return true;
    }

    public boolean redo(Collection<Storable> p_cancelled_objects, Collection<Storable> p_restored_objects) {
        if (this.stack_level >= this.deleted_objects_stack.size()) {
            return false;
        }
        ++this.stack_level;
        for (UndoableObjectNode curr_node : this.objects.values()) {
            if (curr_node.redo_object != null && curr_node.redo_object.level == this.stack_level) {
                this.objects.put(curr_node.object, curr_node.redo_object);
                if (p_cancelled_objects != null) {
                    p_cancelled_objects.add(curr_node.object);
                }
                if (p_restored_objects == null) continue;
                p_restored_objects.add(curr_node.redo_object.object);
                continue;
            }
            if (curr_node.level != this.stack_level) continue;
            p_restored_objects.add(curr_node.object);
        }
        Collection<UndoableObjectNode> curr_delete_list = this.deleted_objects_stack.elementAt(this.stack_level - 1);
        for (UndoableObjectNode curr_deleted_node : curr_delete_list) {
            while (curr_deleted_node.redo_object != null && curr_deleted_node.redo_object.level <= this.stack_level) {
                curr_deleted_node = curr_deleted_node.redo_object;
            }
            if (this.objects.remove(curr_deleted_node.object) == null) {
                System.out.println("previous deleted object not found");
            }
            if (p_restored_objects != null && p_restored_objects.remove(curr_deleted_node.object) || p_cancelled_objects == null) continue;
            p_cancelled_objects.add(curr_deleted_node.object);
        }
        return true;
    }

    public boolean pop_snapshot() {
        this.disable_redo();
        if (this.stack_level == 0) {
            return false;
        }
        for (UndoableObjectNode curr_node : this.objects.values()) {
            if (curr_node.level == this.stack_level - 1) {
                if (curr_node.redo_object == null || curr_node.redo_object.level != this.stack_level) continue;
                curr_node.redo_object.undo_object = curr_node.undo_object;
                if (curr_node.undo_object == null) continue;
                curr_node.undo_object.redo_object = curr_node.redo_object;
                continue;
            }
            if (curr_node.level < this.stack_level) continue;
            --curr_node.level;
        }
        int deleted_objects_stack_size = this.deleted_objects_stack.size();
        if (deleted_objects_stack_size >= 2) {
            Collection<UndoableObjectNode> from_delete_list = this.deleted_objects_stack.elementAt(deleted_objects_stack_size - 1);
            Collection<UndoableObjectNode> to_delete_list = this.deleted_objects_stack.elementAt(deleted_objects_stack_size - 2);
            for (UndoableObjectNode curr_deleted_node : from_delete_list) {
                if (curr_deleted_node.level < this.stack_level - 1) {
                    to_delete_list.add(curr_deleted_node);
                    continue;
                }
                if (curr_deleted_node.undo_object == null) continue;
                to_delete_list.add(curr_deleted_node.undo_object);
            }
        }
        this.deleted_objects_stack.remove(deleted_objects_stack_size - 1);
        --this.stack_level;
        return true;
    }

    public void save_for_undo(Storable p_object) {
        this.disable_redo();
        UndoableObjectNode curr_node = (UndoableObjectNode)this.objects.get(p_object);
        if (curr_node == null) {
            System.out.println("UndoableObjects.save_for_undo: object node not found");
            return;
        }
        if (curr_node.level < this.stack_level) {
            UndoableObjectNode old_node = new UndoableObjectNode((Storable)p_object.clone(), curr_node.level);
            old_node.undo_object = curr_node.undo_object;
            old_node.redo_object = curr_node;
            curr_node.undo_object = old_node;
            curr_node.level = this.stack_level;
            return;
        }
    }

    private void disable_redo() {
        if (!this.redo_possible) {
            return;
        }
        this.redo_possible = false;
        for (int i = this.deleted_objects_stack.size() - 1; i >= this.stack_level; --i) {
            this.deleted_objects_stack.remove(i);
        }
        Iterator it = this.objects.values().iterator();
        while (it.hasNext()) {
            UndoableObjectNode curr_node = (UndoableObjectNode)it.next();
            if (curr_node.level > this.stack_level) {
                it.remove();
                continue;
            }
            if (curr_node.level != this.stack_level) continue;
            curr_node.redo_object = null;
        }
    }

    public static class UndoableObjectNode
    implements Serializable {
        final Storable object;
        int level;
        UndoableObjectNode undo_object;
        UndoableObjectNode redo_object;

        UndoableObjectNode(Storable p_object, int p_level) {
            this.object = p_object;
            this.level = p_level;
            this.undo_object = null;
            this.redo_object = null;
        }
    }

    public static interface Storable
    extends Comparable<Object> {
        public Object clone();
    }
}

