/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.ArrayStack;
import datastructures.ShapeTree;
import geometry.planar.RegularTileShape;
import geometry.planar.ShapeBoundingDirections;
import java.util.Set;
import java.util.TreeSet;

public class MinAreaTree
extends ShapeTree {
    protected ArrayStack<ShapeTree.TreeNode> node_stack = new ArrayStack(10000);

    public MinAreaTree(ShapeBoundingDirections p_directions) {
        super(p_directions);
    }

    public Set<ShapeTree.Leaf> overlaps(RegularTileShape p_shape) {
        ShapeTree.TreeNode curr_node;
        TreeSet<ShapeTree.Leaf> found_overlaps = new TreeSet<ShapeTree.Leaf>();
        if (this.root == null) {
            return found_overlaps;
        }
        this.node_stack.reset();
        this.node_stack.push(this.root);
        while ((curr_node = this.node_stack.pop()) != null) {
            if (!curr_node.bounding_shape.intersects(p_shape)) continue;
            if (curr_node instanceof ShapeTree.Leaf) {
                found_overlaps.add((ShapeTree.Leaf)curr_node);
                continue;
            }
            this.node_stack.push(((ShapeTree.InnerNode)curr_node).first_child);
            this.node_stack.push(((ShapeTree.InnerNode)curr_node).second_child);
        }
        return found_overlaps;
    }

    @Override
    void insert(ShapeTree.Leaf p_leaf) {
        ++this.leaf_count;
        if (this.root == null) {
            this.root = p_leaf;
            return;
        }
        ShapeTree.Leaf leaf_to_replace = this.position_locate(this.root, p_leaf);
        RegularTileShape new_bounds = p_leaf.bounding_shape.union(leaf_to_replace.bounding_shape);
        ShapeTree.InnerNode curr_parent = leaf_to_replace.parent;
        ShapeTree.InnerNode new_node = new ShapeTree.InnerNode(new_bounds, curr_parent);
        if (leaf_to_replace.parent != null) {
            if (leaf_to_replace == curr_parent.first_child) {
                curr_parent.first_child = new_node;
            } else {
                curr_parent.second_child = new_node;
            }
        }
        leaf_to_replace.parent = new_node;
        p_leaf.parent = new_node;
        new_node.first_child = leaf_to_replace;
        new_node.second_child = p_leaf;
        if (this.root == leaf_to_replace) {
            this.root = new_node;
        }
    }

    private final ShapeTree.Leaf position_locate(ShapeTree.TreeNode p_curr_node, ShapeTree.Leaf p_leaf_to_insert) {
        ShapeTree.TreeNode curr_node = p_curr_node;
        while (!(curr_node instanceof ShapeTree.Leaf)) {
            RegularTileShape second_child_shape;
            RegularTileShape union_with_second_child_shape;
            double second_area_increase;
            ShapeTree.InnerNode curr_inner_node = (ShapeTree.InnerNode)curr_node;
            curr_inner_node.bounding_shape = p_leaf_to_insert.bounding_shape.union(curr_inner_node.bounding_shape);
            RegularTileShape first_child_shape = curr_inner_node.first_child.bounding_shape;
            RegularTileShape union_with_first_child_shape = p_leaf_to_insert.bounding_shape.union(first_child_shape);
            double first_area_increase = union_with_first_child_shape.area() - first_child_shape.area();
            if (first_area_increase <= (second_area_increase = (union_with_second_child_shape = p_leaf_to_insert.bounding_shape.union(second_child_shape = curr_inner_node.second_child.bounding_shape)).area() - second_child_shape.area())) {
                curr_node = curr_inner_node.first_child;
                continue;
            }
            curr_node = curr_inner_node.second_child;
        }
        return (ShapeTree.Leaf)curr_node;
    }

    @Override
    public void remove_leaf(ShapeTree.Leaf p_leaf) {
        RegularTileShape new_bounds;
        ShapeTree.InnerNode grand_parent;
        ShapeTree.TreeNode other_leaf;
        if (p_leaf == null) {
            return;
        }
        ShapeTree.InnerNode parent = p_leaf.parent;
        p_leaf.bounding_shape = null;
        p_leaf.parent = null;
        p_leaf.object = null;
        --this.leaf_count;
        if (parent == null) {
            this.root = null;
            return;
        }
        if (parent.second_child == p_leaf) {
            other_leaf = parent.first_child;
        } else if (parent.first_child == p_leaf) {
            other_leaf = parent.second_child;
        } else {
            System.out.println("MinAreaTree.remove_leaf: parent inconsistent");
            other_leaf = null;
        }
        other_leaf.parent = grand_parent = parent.parent;
        if (grand_parent == null) {
            this.root = other_leaf;
        } else if (grand_parent.second_child == parent) {
            grand_parent.second_child = other_leaf;
        } else if (grand_parent.first_child == parent) {
            grand_parent.first_child = other_leaf;
        } else {
            System.out.println("MinAreaTree.remove_leaf: grand_parent inconsistent");
        }
        parent.parent = null;
        parent.first_child = null;
        parent.second_child = null;
        parent.bounding_shape = null;
        ShapeTree.InnerNode node_to_recalculate = grand_parent;
        while (node_to_recalculate != null && !(new_bounds = node_to_recalculate.second_child.bounding_shape.union(node_to_recalculate.first_child.bounding_shape)).contains(node_to_recalculate.bounding_shape)) {
            node_to_recalculate.bounding_shape = new_bounds;
            node_to_recalculate = node_to_recalculate.parent;
        }
    }
}

