/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class IndentFileWriter
extends OutputStreamWriter {
    private int current_indent_level = 0;
    private static final String INDENT_STRING = "  ";
    private static final String BEGIN_SCOPE = "(";
    private static final String END_SCOPE = ")";

    public IndentFileWriter(OutputStream p_stream) {
        super(p_stream);
    }

    public void start_scope() {
        this.new_line();
        try {
            this.write(BEGIN_SCOPE);
        }
        catch (IOException e) {
            System.out.println("IndentFileWriter.start_scope: unable to write to file");
        }
        ++this.current_indent_level;
    }

    public void end_scope() {
        --this.current_indent_level;
        this.new_line();
        try {
            this.write(END_SCOPE);
        }
        catch (IOException e) {
            System.out.println("IndentFileWriter.end_scope: unable to write to file");
        }
    }

    public void new_line() {
        try {
            this.write("\n");
            for (int i = 0; i < this.current_indent_level; ++i) {
                this.write(INDENT_STRING);
            }
        }
        catch (IOException e) {
            System.out.println("IndentFileWriter.new_line: unable to write to file");
        }
    }
}

