/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import java.math.BigInteger;

public class BigIntAux {
    static final byte[] trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    public static final BigInteger determinant(BigInteger p_x_1, BigInteger p_y_1, BigInteger p_x_2, BigInteger p_y_2) {
        BigInteger tmp1 = p_x_1.multiply(p_y_2);
        BigInteger tmp2 = p_x_2.multiply(p_y_1);
        return tmp1.subtract(tmp2);
    }

    public static final BigInteger[] add_rational_coordinates(BigInteger[] p_first, BigInteger[] p_second) {
        BigInteger[] result = new BigInteger[3];
        if (p_first[2].equals(p_second[2])) {
            result[2] = p_first[2];
            result[0] = p_first[0].add(p_second[0]);
            result[1] = p_first[1].add(p_second[1]);
        } else {
            result[2] = p_first[2].multiply(p_second[2]);
            BigInteger tmp_1 = p_first[0].multiply(p_second[2]);
            BigInteger tmp_2 = p_second[0].multiply(p_first[2]);
            result[0] = tmp_1.add(tmp_2);
            tmp_1 = p_first[1].multiply(p_second[2]);
            tmp_2 = p_second[1].multiply(p_first[2]);
            result[1] = tmp_1.add(tmp_2);
        }
        return result;
    }

    public static final int binaryGcd(int a, int b) {
        int t;
        int x;
        if (b == 0) {
            return a;
        }
        if (a == 0) {
            return b;
        }
        int aZeros = 0;
        while ((x = a & 0xFF) == 0) {
            a >>>= 8;
            aZeros += 8;
        }
        byte y = trailingZeroTable[x];
        aZeros += y;
        a >>>= y;
        int bZeros = 0;
        while ((x = b & 0xFF) == 0) {
            b >>>= 8;
            bZeros += 8;
        }
        y = trailingZeroTable[x];
        b >>>= y;
        int n = t = aZeros < (bZeros += y) ? aZeros : bZeros;
        while (a != b) {
            if (a + Integer.MIN_VALUE > b + Integer.MIN_VALUE) {
                a -= b;
                while ((x = a & 0xFF) == 0) {
                    a >>>= 8;
                }
                a >>>= trailingZeroTable[x];
                continue;
            }
            b -= a;
            while ((x = b & 0xFF) == 0) {
                b >>>= 8;
            }
            b >>>= trailingZeroTable[x];
        }
        return a << t;
    }

    private BigIntAux() {
    }
}

