/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

public class ArrayStack<p_element_type> {
    private int level = -1;
    private p_element_type[] node_arr;

    public ArrayStack(int p_max_stack_depth) {
        this.node_arr = new Object[p_max_stack_depth];
    }

    public void reset() {
        this.level = -1;
    }

    public void push(p_element_type p_element) {
        ++this.level;
        if (this.level >= this.node_arr.length) {
            this.reallocate();
        }
        this.node_arr[this.level] = p_element;
    }

    public p_element_type pop() {
        if (this.level < 0) {
            return null;
        }
        p_element_type result = this.node_arr[this.level];
        --this.level;
        return result;
    }

    private void reallocate() {
        Object[] new_arr = new Object[4 * this.node_arr.length];
        System.arraycopy(this.node_arr, 0, new_arr, 0, this.node_arr.length);
        this.node_arr = new_arr;
    }
}

