/*
 * Decompiled with CFR 0.152.
 */
package boardgraphics;

import java.io.Serializable;

public class ColorIntensityTable
implements Serializable {
    private final double[] arr;

    public ColorIntensityTable() {
        this.arr = new double[ObjectNames.values().length];
        this.arr[ObjectNames.TRACES.ordinal()] = 0.4;
        this.arr[ObjectNames.VIAS.ordinal()] = 0.6;
        this.arr[ObjectNames.PINS.ordinal()] = 0.6;
        this.arr[ObjectNames.CONDUCTION_AREAS.ordinal()] = 0.2;
        this.arr[ObjectNames.KEEPOUTS.ordinal()] = 0.2;
        this.arr[ObjectNames.VIA_KEEPOUTS.ordinal()] = 0.2;
        this.arr[ObjectNames.PLACE_KEEPOUTS.ordinal()] = 0.2;
        this.arr[ObjectNames.COMPONENT_OUTLINES.ordinal()] = 1.0;
        this.arr[ObjectNames.HILIGHT.ordinal()] = 0.8;
        this.arr[ObjectNames.INCOMPLETES.ordinal()] = 1.0;
        this.arr[ObjectNames.LENGTH_MATCHING_AREAS.ordinal()] = 0.1;
    }

    public ColorIntensityTable(ColorIntensityTable p_color_intesity_table) {
        this.arr = new double[p_color_intesity_table.arr.length];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = p_color_intesity_table.arr[i];
        }
    }

    public double get_value(int p_no) {
        if (p_no < 0 || p_no >= ObjectNames.values().length) {
            System.out.println("ColorIntensityTable.get_value: p_no out of range");
            return 0.0;
        }
        return this.arr[p_no];
    }

    public void set_value(int p_no, double p_value) {
        if (p_no < 0 || p_no >= ObjectNames.values().length) {
            System.out.println("ColorIntensityTable.set_value: p_no out of range");
            return;
        }
        this.arr[p_no] = p_value;
    }

    public static enum ObjectNames {
        TRACES,
        VIAS,
        PINS,
        CONDUCTION_AREAS,
        KEEPOUTS,
        VIA_KEEPOUTS,
        PLACE_KEEPOUTS,
        COMPONENT_OUTLINES,
        HILIGHT,
        INCOMPLETES,
        LENGTH_MATCHING_AREAS;

    }
}

