/*
 * Decompiled with CFR 0.152.
 */
package board;

import autoroute.CompleteFreeSpaceExpansionRoom;
import autoroute.IncompleteFreeSpaceExpansionRoom;
import board.AngleRestriction;
import board.BasicBoard;
import board.BoardOutline;
import board.DrillItem;
import board.Item;
import board.ObstacleArea;
import board.Pin;
import board.PolylineTrace;
import board.SearchTreeObject;
import board.TestLevel;
import board.Unit;
import datastructures.MinAreaTree;
import datastructures.ShapeTree;
import datastructures.Signum;
import geometry.planar.ConvexShape;
import geometry.planar.FloatPoint;
import geometry.planar.IntBox;
import geometry.planar.IntOctagon;
import geometry.planar.Line;
import geometry.planar.LineSegment;
import geometry.planar.Polyline;
import geometry.planar.PolylineShape;
import geometry.planar.RegularTileShape;
import geometry.planar.Shape;
import geometry.planar.ShapeBoundingDirections;
import geometry.planar.Side;
import geometry.planar.Simplex;
import geometry.planar.TileShape;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import rules.ClearanceMatrix;

public class ShapeSearchTree
extends MinAreaTree {
    public final int compensated_clearance_class_no;
    protected final BasicBoard board;
    private static int last_generated_id_no = 0;

    ShapeSearchTree(ShapeBoundingDirections p_directions, BasicBoard p_board, int p_compensated_clearance_class_no) {
        super(p_directions);
        this.compensated_clearance_class_no = p_compensated_clearance_class_no;
        this.board = p_board;
    }

    public boolean is_clearance_compensation_used() {
        return this.compensated_clearance_class_no > 0;
    }

    public int clearance_compensation_value(int p_clearance_class_no, int p_layer) {
        if (p_clearance_class_no <= 0) {
            return 0;
        }
        int result = this.board.rules.clearance_matrix.value(p_clearance_class_no, this.compensated_clearance_class_no, p_layer) - this.board.rules.clearance_matrix.clearance_compensation_value(this.compensated_clearance_class_no, p_layer);
        return Math.max(result, 0);
    }

    void change_entries(PolylineTrace p_obj, Polyline p_new_polyline, int p_keep_at_start_count, int p_keep_at_end_count) {
        int i;
        int compensated_half_width = p_obj.get_half_width() + this.clearance_compensation_value(p_obj.clearance_class_no(), p_obj.get_layer());
        TileShape[] changed_shapes = this.offset_shapes(p_new_polyline, compensated_half_width, p_keep_at_start_count, p_new_polyline.arr.length - 1 - p_keep_at_end_count);
        int old_shape_count = p_obj.tree_shape_count(this);
        int new_shape_count = changed_shapes.length + p_keep_at_start_count + p_keep_at_end_count;
        ShapeTree.Leaf[] new_leaf_arr = new ShapeTree.Leaf[new_shape_count];
        TileShape[] new_precalculated_tree_shapes = new TileShape[new_shape_count];
        ShapeTree.Leaf[] old_entries = p_obj.get_search_tree_entries(this);
        for (i = 0; i < p_keep_at_start_count; ++i) {
            new_leaf_arr[i] = old_entries[i];
            new_precalculated_tree_shapes[i] = p_obj.get_tree_shape(this, i);
        }
        for (i = p_keep_at_start_count; i < old_shape_count - p_keep_at_end_count; ++i) {
            this.remove_leaf(old_entries[i]);
        }
        for (i = 0; i < p_keep_at_end_count; ++i) {
            int new_index = new_shape_count - p_keep_at_end_count + i;
            int old_index = old_shape_count - p_keep_at_end_count + i;
            new_leaf_arr[new_index] = old_entries[old_index];
            new_leaf_arr[new_index].shape_index_in_object = new_index;
            new_precalculated_tree_shapes[new_index] = p_obj.get_tree_shape(this, old_index);
        }
        for (i = p_keep_at_start_count; i < new_shape_count - p_keep_at_end_count; ++i) {
            new_precalculated_tree_shapes[i] = changed_shapes[i - p_keep_at_start_count];
        }
        p_obj.set_precalculated_tree_shapes(new_precalculated_tree_shapes, this);
        for (i = p_keep_at_start_count; i < new_shape_count - p_keep_at_end_count; ++i) {
            new_leaf_arr[i] = this.insert(p_obj, i);
        }
        p_obj.set_search_tree_entries(new_leaf_arr, this);
    }

    void merge_entries_in_front(PolylineTrace p_from_trace, PolylineTrace p_to_trace, Polyline p_joined_polyline, int p_from_entry_no, int p_to_entry_no) {
        int curr_ind;
        int i;
        int compensated_half_width = p_to_trace.get_half_width() + this.clearance_compensation_value(p_to_trace.clearance_class_no(), p_to_trace.get_layer());
        TileShape[] link_shapes = this.offset_shapes(p_joined_polyline, compensated_half_width, p_from_entry_no, p_to_entry_no);
        boolean change_order = p_from_trace.first_corner().equals(p_to_trace.first_corner());
        int from_shape_count_minus_1 = p_from_trace.tile_shape_count() - 1;
        int remove_no = change_order ? 0 : from_shape_count_minus_1;
        ShapeTree.Leaf[] from_trace_entries = p_from_trace.get_search_tree_entries(this);
        ShapeTree.Leaf[] to_trace_entries = p_to_trace.get_search_tree_entries(this);
        this.remove_leaf(from_trace_entries[remove_no]);
        this.remove_leaf(to_trace_entries[0]);
        int new_shape_count = from_trace_entries.length + link_shapes.length + to_trace_entries.length - 2;
        ShapeTree.Leaf[] new_leaf_arr = new ShapeTree.Leaf[new_shape_count];
        int old_to_shape_count = to_trace_entries.length;
        TileShape[] new_precalculated_tree_shapes = new TileShape[new_shape_count];
        for (i = 0; i < from_shape_count_minus_1; ++i) {
            int from_no = change_order ? from_shape_count_minus_1 - i : i;
            new_precalculated_tree_shapes[i] = p_from_trace.get_tree_shape(this, from_no);
            new_leaf_arr[i] = from_trace_entries[from_no];
            new_leaf_arr[i].object = p_to_trace;
            new_leaf_arr[i].shape_index_in_object = i;
        }
        for (i = 1; i < old_to_shape_count; ++i) {
            curr_ind = from_shape_count_minus_1 + link_shapes.length + i - 1;
            new_precalculated_tree_shapes[curr_ind] = p_to_trace.get_tree_shape(this, i);
            new_leaf_arr[curr_ind] = to_trace_entries[i];
            new_leaf_arr[curr_ind].shape_index_in_object = curr_ind;
        }
        for (i = 0; i < link_shapes.length; ++i) {
            curr_ind = from_shape_count_minus_1 + i;
            new_precalculated_tree_shapes[curr_ind] = link_shapes[i];
        }
        p_to_trace.set_precalculated_tree_shapes(new_precalculated_tree_shapes, this);
        for (i = 0; i < link_shapes.length; ++i) {
            curr_ind = from_shape_count_minus_1 + i;
            new_leaf_arr[curr_ind] = this.insert(p_to_trace, curr_ind);
        }
        p_to_trace.set_search_tree_entries(new_leaf_arr, this);
    }

    void merge_entries_at_end(PolylineTrace p_from_trace, PolylineTrace p_to_trace, Polyline p_joined_polyline, int p_from_entry_no, int p_to_entry_no) {
        int curr_ind;
        int i;
        int compensated_half_width = p_to_trace.get_half_width() + this.clearance_compensation_value(p_to_trace.clearance_class_no(), p_to_trace.get_layer());
        TileShape[] link_shapes = this.offset_shapes(p_joined_polyline, compensated_half_width, p_from_entry_no, p_to_entry_no);
        boolean change_order = p_from_trace.last_corner().equals(p_to_trace.last_corner());
        ShapeTree.Leaf[] from_trace_entries = p_from_trace.get_search_tree_entries(this);
        ShapeTree.Leaf[] to_trace_entries = p_to_trace.get_search_tree_entries(this);
        int to_shape_count_minus_1 = p_to_trace.tile_shape_count() - 1;
        this.remove_leaf(to_trace_entries[to_shape_count_minus_1]);
        int remove_no = change_order ? p_from_trace.tile_shape_count() - 1 : 0;
        this.remove_leaf(from_trace_entries[remove_no]);
        int new_shape_count = from_trace_entries.length + link_shapes.length + to_trace_entries.length - 2;
        ShapeTree.Leaf[] new_leaf_arr = new ShapeTree.Leaf[new_shape_count];
        TileShape[] new_precalculated_tree_shapes = new TileShape[new_shape_count];
        for (i = 0; i < to_shape_count_minus_1; ++i) {
            new_precalculated_tree_shapes[i] = p_to_trace.get_tree_shape(this, i);
            new_leaf_arr[i] = to_trace_entries[i];
        }
        for (i = 1; i < from_trace_entries.length; ++i) {
            curr_ind = to_shape_count_minus_1 + link_shapes.length + i - 1;
            int from_no = change_order ? from_trace_entries.length - i - 1 : i;
            new_precalculated_tree_shapes[curr_ind] = p_from_trace.get_tree_shape(this, from_no);
            new_leaf_arr[curr_ind] = from_trace_entries[from_no];
            new_leaf_arr[curr_ind].object = p_to_trace;
            new_leaf_arr[curr_ind].shape_index_in_object = curr_ind;
        }
        for (i = 0; i < link_shapes.length; ++i) {
            curr_ind = to_shape_count_minus_1 + i;
            new_precalculated_tree_shapes[curr_ind] = link_shapes[i];
        }
        p_to_trace.set_precalculated_tree_shapes(new_precalculated_tree_shapes, this);
        for (i = 0; i < link_shapes.length; ++i) {
            curr_ind = to_shape_count_minus_1 + i;
            new_leaf_arr[curr_ind] = this.insert(p_to_trace, curr_ind);
        }
        p_to_trace.set_search_tree_entries(new_leaf_arr, this);
    }

    void reuse_entries_after_cutout(PolylineTrace p_from_trace, PolylineTrace p_start_piece, PolylineTrace p_end_piece) {
        ShapeTree.Leaf[] start_piece_leaf_arr = new ShapeTree.Leaf[p_start_piece.polyline().arr.length - 2];
        ShapeTree.Leaf[] from_trace_entries = p_from_trace.get_search_tree_entries(this);
        for (int i = 0; i < start_piece_leaf_arr.length - 1; ++i) {
            start_piece_leaf_arr[i] = from_trace_entries[i];
            start_piece_leaf_arr[i].object = p_start_piece;
            start_piece_leaf_arr[i].shape_index_in_object = i;
            from_trace_entries[i] = null;
        }
        start_piece_leaf_arr[start_piece_leaf_arr.length - 1] = this.insert(p_start_piece, start_piece_leaf_arr.length - 1);
        ShapeTree.Leaf[] end_piece_leaf_arr = new ShapeTree.Leaf[p_end_piece.polyline().arr.length - 2];
        end_piece_leaf_arr[0] = this.insert(p_end_piece, 0);
        for (int i = 1; i < end_piece_leaf_arr.length; ++i) {
            int from_index = from_trace_entries.length - end_piece_leaf_arr.length + i;
            end_piece_leaf_arr[i] = from_trace_entries[from_index];
            end_piece_leaf_arr[i].object = p_end_piece;
            end_piece_leaf_arr[i].shape_index_in_object = i;
            from_trace_entries[from_index] = null;
        }
        p_start_piece.set_search_tree_entries(start_piece_leaf_arr, this);
        p_end_piece.set_search_tree_entries(end_piece_leaf_arr, this);
    }

    public void overlapping_objects(ConvexShape p_shape, int p_layer, int[] p_ignore_net_nos, Set<SearchTreeObject> p_obstacles) {
        LinkedList<ShapeTree.TreeEntry> tree_entries = new LinkedList<ShapeTree.TreeEntry>();
        this.overlapping_tree_entries(p_shape, p_layer, p_ignore_net_nos, tree_entries);
        if (p_obstacles != null) {
            for (ShapeTree.TreeEntry curr_entry : tree_entries) {
                p_obstacles.add((SearchTreeObject)curr_entry.object);
            }
        }
    }

    public Set<SearchTreeObject> overlapping_objects(ConvexShape p_shape, int p_layer) {
        TreeSet<SearchTreeObject> result = new TreeSet<SearchTreeObject>();
        this.overlapping_objects(p_shape, p_layer, new int[0], result);
        return result;
    }

    public void overlapping_tree_entries(ConvexShape p_shape, int p_layer, Collection<ShapeTree.TreeEntry> p_tree_entries) {
        this.overlapping_tree_entries(p_shape, p_layer, new int[0], p_tree_entries);
    }

    public void overlapping_tree_entries(ConvexShape p_shape, int p_layer, int[] p_ignore_net_nos, Collection<ShapeTree.TreeEntry> p_tree_entries) {
        if (p_shape == null) {
            return;
        }
        if (p_tree_entries == null) {
            System.out.println("board.ShapeSearchTree.overlaps: p_obstacle_entries is null");
            return;
        }
        RegularTileShape bounds = p_shape.bounding_shape(this.bounding_directions);
        if (bounds == null) {
            System.out.println("board.ShapeSearchTree.overlaps: p_shape not bounded");
            return;
        }
        Set<ShapeTree.Leaf> tmp_list = this.overlaps(bounds);
        Iterator it = tmp_list.iterator();
        boolean is_45_degree = p_shape instanceof IntOctagon;
        while (it.hasNext()) {
            boolean ignore_object;
            ShapeTree.Leaf curr_leaf = (ShapeTree.Leaf)it.next();
            SearchTreeObject curr_object = (SearchTreeObject)curr_leaf.object;
            int shape_index = curr_leaf.shape_index_in_object;
            boolean bl = ignore_object = p_layer >= 0 && curr_object.shape_layer(shape_index) != p_layer;
            if (!ignore_object) {
                for (int i = 0; i < p_ignore_net_nos.length; ++i) {
                    if (curr_object.is_obstacle(p_ignore_net_nos[i])) continue;
                    ignore_object = true;
                }
            }
            if (ignore_object) continue;
            TileShape curr_shape = curr_object.get_tree_shape(this, curr_leaf.shape_index_in_object);
            boolean add_item = is_45_degree && curr_shape instanceof IntOctagon ? true : curr_shape.intersects(p_shape);
            if (!add_item) continue;
            ShapeTree.TreeEntry new_entry = new ShapeTree.TreeEntry(curr_object, shape_index);
            p_tree_entries.add(new_entry);
        }
    }

    void overlapping_tree_entries_with_clearance(ConvexShape p_shape, int p_layer, int[] p_ignore_net_nos, int p_cl_type, Collection<ShapeTree.TreeEntry> p_obstacle_entries) {
        if (p_shape == null) {
            return;
        }
        if (p_obstacle_entries == null) {
            System.out.println("board.ShapeSearchTree.overlaps_with_clearance: p_obstacle_entries is null");
            return;
        }
        ClearanceMatrix cl_matrix = this.board.rules.clearance_matrix;
        RegularTileShape bounds = p_shape.bounding_shape(this.bounding_directions);
        if (bounds == null) {
            System.out.println("board.ShapeSearchTree.overlaps_with_clearance: p_shape is not bounded");
            bounds = this.board.get_bounding_box();
        }
        int max_clearance = (int)(1.2 * (double)cl_matrix.max_value(p_cl_type, p_layer));
        RegularTileShape offset_bounds = (RegularTileShape)bounds.offset(max_clearance);
        Set<ShapeTree.Leaf> tmp_list = this.overlaps(offset_bounds);
        Iterator it1 = tmp_list.iterator();
        TreeSet<EntrySortedByClearance> sorted_items = new TreeSet<EntrySortedByClearance>();
        while (it1.hasNext()) {
            boolean ignore_item;
            ShapeTree.Leaf curr_leaf = (ShapeTree.Leaf)it1.next();
            Item curr_item = (Item)curr_leaf.object;
            int shape_index = curr_leaf.shape_index_in_object;
            boolean bl = ignore_item = p_layer >= 0 && curr_item.shape_layer(shape_index) != p_layer;
            if (!ignore_item) {
                for (int i = 0; i < p_ignore_net_nos.length; ++i) {
                    if (curr_item.is_obstacle(p_ignore_net_nos[i])) continue;
                    ignore_item = true;
                }
            }
            if (ignore_item) continue;
            int curr_clearance = cl_matrix.value(p_cl_type, curr_item.clearance_class_no(), p_layer);
            EntrySortedByClearance sorted_ob = new EntrySortedByClearance(curr_leaf, curr_clearance);
            sorted_items.add(sorted_ob);
        }
        Iterator it = sorted_items.iterator();
        int curr_half_clearance = 0;
        ConvexShape curr_offset_shape = p_shape;
        while (it.hasNext()) {
            TileShape tmp_shape;
            ConvexShape tmp_offset_shape;
            EntrySortedByClearance tmp_entry = (EntrySortedByClearance)it.next();
            int tmp_half_clearance = tmp_entry.clearance / 2;
            if (tmp_half_clearance != curr_half_clearance) {
                curr_half_clearance = tmp_half_clearance;
                curr_offset_shape = (TileShape)p_shape.enlarge(curr_half_clearance);
            }
            if (!curr_offset_shape.intersects(tmp_offset_shape = (ConvexShape)(tmp_shape = tmp_entry.leaf.object.get_tree_shape(this, tmp_entry.leaf.shape_index_in_object)).enlarge(curr_half_clearance))) continue;
            p_obstacle_entries.add(new ShapeTree.TreeEntry(tmp_entry.leaf.object, tmp_entry.leaf.shape_index_in_object));
        }
    }

    public void overlapping_objects_with_clearance(ConvexShape p_shape, int p_layer, int[] p_ignore_net_nos, int p_cl_type, Set<SearchTreeObject> p_obstacles) {
        LinkedList<ShapeTree.TreeEntry> tree_entries = new LinkedList<ShapeTree.TreeEntry>();
        if (this.is_clearance_compensation_used()) {
            this.overlapping_tree_entries(p_shape, p_layer, p_ignore_net_nos, tree_entries);
        } else {
            this.overlapping_tree_entries_with_clearance(p_shape, p_layer, p_ignore_net_nos, p_cl_type, tree_entries);
        }
        if (p_obstacles != null) {
            for (ShapeTree.TreeEntry curr_entry : tree_entries) {
                p_obstacles.add((SearchTreeObject)curr_entry.object);
            }
        }
    }

    public Set<Item> overlapping_items_with_clearance(ConvexShape p_shape, int p_layer, int[] p_ignore_net_nos, int p_clearance_class) {
        TreeSet<SearchTreeObject> overlaps = new TreeSet<SearchTreeObject>();
        this.overlapping_objects_with_clearance(p_shape, p_layer, p_ignore_net_nos, p_clearance_class, overlaps);
        TreeSet<Item> result = new TreeSet<Item>();
        for (SearchTreeObject curr_object : overlaps) {
            if (!(curr_object instanceof Item)) continue;
            result.add((Item)curr_object);
        }
        return result;
    }

    public Collection<ShapeTree.TreeEntry> overlapping_tree_entries_with_clearance(ConvexShape p_shape, int p_layer, int[] p_ignore_net_nos, int p_clearance_class) {
        LinkedList<ShapeTree.TreeEntry> result = new LinkedList<ShapeTree.TreeEntry>();
        if (this.is_clearance_compensation_used()) {
            this.overlapping_tree_entries(p_shape, p_layer, p_ignore_net_nos, result);
        } else {
            this.overlapping_tree_entries_with_clearance(p_shape, p_layer, p_ignore_net_nos, p_clearance_class, result);
        }
        return result;
    }

    public Collection<IncompleteFreeSpaceExpansionRoom> complete_shape(IncompleteFreeSpaceExpansionRoom p_room, int p_net_no, SearchTreeObject p_ignore_object, TileShape p_ignore_shape) {
        ShapeTree.TreeNode curr_node;
        if (p_room.get_contained_shape() == null) {
            System.out.println("ShapeSearchTree.complete_shape: p_shape_to_be_contained != null expected");
            return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        }
        if (this.root == null) {
            return new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        }
        TileShape start_shape = this.board.get_bounding_box();
        if (p_room.get_shape() != null) {
            start_shape = start_shape.intersection(p_room.get_shape());
        }
        RegularTileShape bounding_shape = start_shape.bounding_shape(this.bounding_directions);
        Collection<IncompleteFreeSpaceExpansionRoom> result = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        if (start_shape.dimension() == 2) {
            IncompleteFreeSpaceExpansionRoom new_room = new IncompleteFreeSpaceExpansionRoom(start_shape, p_room.get_layer(), p_room.get_contained_shape());
            result.add(new_room);
        }
        this.node_stack.reset();
        this.node_stack.push(this.root);
        int room_layer = p_room.get_layer();
        while ((curr_node = (ShapeTree.TreeNode)this.node_stack.pop()) != null) {
            if (!curr_node.bounding_shape.intersects(bounding_shape)) continue;
            if (curr_node instanceof ShapeTree.Leaf) {
                ShapeTree.Leaf curr_leaf = (ShapeTree.Leaf)curr_node;
                SearchTreeObject curr_object = (SearchTreeObject)curr_leaf.object;
                int shape_index = curr_leaf.shape_index_in_object;
                if (!curr_object.is_trace_obstacle(p_net_no) || curr_object.shape_layer(shape_index) != room_layer || curr_object == p_ignore_object) continue;
                TileShape curr_object_shape = curr_object.get_tree_shape(this, shape_index);
                LinkedList<IncompleteFreeSpaceExpansionRoom> new_result = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
                RegularTileShape new_bounding_shape = IntOctagon.EMPTY;
                for (IncompleteFreeSpaceExpansionRoom curr_incomplete_room : result) {
                    boolean something_changed = false;
                    TileShape intersection = curr_incomplete_room.get_shape().intersection(curr_object_shape);
                    if (intersection.dimension() == 2) {
                        boolean ignore_expansion_room;
                        boolean bl = ignore_expansion_room = curr_object instanceof CompleteFreeSpaceExpansionRoom && p_ignore_shape != null && p_ignore_shape.contains(intersection);
                        if (!ignore_expansion_room) {
                            something_changed = true;
                            new_result.addAll(this.restrain_shape(curr_incomplete_room, curr_object_shape));
                            for (IncompleteFreeSpaceExpansionRoom tmp_room : new_result) {
                                new_bounding_shape = new_bounding_shape.union(tmp_room.get_shape().bounding_shape(this.bounding_directions));
                            }
                        }
                    }
                    if (something_changed) continue;
                    new_result.add(curr_incomplete_room);
                    new_bounding_shape = new_bounding_shape.union(curr_incomplete_room.get_shape().bounding_shape(this.bounding_directions));
                }
                result = new_result;
                bounding_shape = new_bounding_shape;
                continue;
            }
            this.node_stack.push(((ShapeTree.InnerNode)curr_node).first_child);
            this.node_stack.push(((ShapeTree.InnerNode)curr_node).second_child);
        }
        result = this.divide_large_room(result, this.board.get_bounding_box());
        return result;
    }

    private Collection<IncompleteFreeSpaceExpansionRoom> restrain_shape(IncompleteFreeSpaceExpansionRoom p_incomplete_room, TileShape p_obstacle_shape) {
        Line curr_line;
        LineSegment curr_line_segment;
        int i;
        Simplex obstacle_simplex = p_obstacle_shape.to_Simplex();
        Simplex shape_to_be_contained = p_incomplete_room.get_contained_shape().to_Simplex();
        LinkedList<IncompleteFreeSpaceExpansionRoom> result = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        TileShape room_shape = p_incomplete_room.get_shape();
        int layer = p_incomplete_room.get_layer();
        if (shape_to_be_contained.is_empty()) {
            if (this.board.get_test_level().ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                System.out.println("ShapeSearchTree.restrain_shape: p_shape_to_be_contained is empty");
            }
            return result;
        }
        Line cut_line = null;
        double cut_line_distance = -1.0;
        for (i = 0; i < obstacle_simplex.border_line_count(); ++i) {
            double curr_min_distance;
            curr_line_segment = new LineSegment(obstacle_simplex, i);
            if (!room_shape.is_intersected_interiour_by(curr_line_segment) || !((curr_min_distance = shape_to_be_contained.distance_to_the_left(curr_line = obstacle_simplex.border_line(i))) > cut_line_distance)) continue;
            cut_line_distance = curr_min_distance;
            cut_line = curr_line.opposite();
        }
        if (cut_line != null) {
            TileShape result_piece = TileShape.get_instance(cut_line);
            if (room_shape != null) {
                result_piece = room_shape.intersection(result_piece);
            }
            if (result_piece.dimension() >= 2) {
                result.add(new IncompleteFreeSpaceExpansionRoom(result_piece, layer, shape_to_be_contained));
            }
        } else {
            if (shape_to_be_contained.dimension() < 1) {
                return result;
            }
            for (i = 0; i < obstacle_simplex.border_line_count(); ++i) {
                curr_line_segment = new LineSegment(obstacle_simplex, i);
                if (!room_shape.is_intersected_interiour_by(curr_line_segment) || shape_to_be_contained.side_of(curr_line = obstacle_simplex.border_line(i)) != Side.COLLINEAR) continue;
                cut_line = curr_line.opposite();
                break;
            }
            if (cut_line == null) {
                return result;
            }
            TileShape cut_half_plane = TileShape.get_instance(cut_line);
            TileShape new_shape_to_be_contained = ((TileShape)shape_to_be_contained).intersection(cut_half_plane);
            TileShape result_piece = room_shape == null ? cut_half_plane : room_shape.intersection(cut_half_plane);
            if (result_piece.dimension() >= 2) {
                result.add(new IncompleteFreeSpaceExpansionRoom(result_piece, layer, new_shape_to_be_contained));
            }
            TileShape opposite_half_plane = TileShape.get_instance(cut_line.opposite());
            TileShape rest_piece = room_shape == null ? opposite_half_plane : room_shape.intersection(opposite_half_plane);
            if (rest_piece.dimension() >= 2) {
                TileShape rest_shape_to_be_contained = ((TileShape)shape_to_be_contained).intersection(opposite_half_plane);
                IncompleteFreeSpaceExpansionRoom rest_incomplete_room = new IncompleteFreeSpaceExpansionRoom(rest_piece, layer, rest_shape_to_be_contained);
                result.addAll(this.restrain_shape(rest_incomplete_room, obstacle_simplex));
            }
        }
        return result;
    }

    public void reduce_trace_shape_at_tie_pin(Pin p_tie_pin, PolylineTrace p_trace) {
        FloatPoint compare_corner;
        int trace_shape_no;
        TileShape pin_shape = p_tie_pin.get_tree_shape_on_layer(this, p_trace.get_layer());
        if (p_trace.first_corner().equals(p_tie_pin.get_center())) {
            trace_shape_no = 0;
            compare_corner = p_trace.polyline().corner_approx(1);
        } else if (p_trace.last_corner().equals(p_tie_pin.get_center())) {
            trace_shape_no = p_trace.corner_count() - 2;
            compare_corner = p_trace.polyline().corner_approx(p_trace.corner_count() - 2);
        } else {
            return;
        }
        TileShape trace_shape = p_trace.get_tree_shape(this, trace_shape_no);
        TileShape intersection = trace_shape.intersection(pin_shape);
        if (intersection.dimension() < 2) {
            return;
        }
        TileShape[] shape_pieces = trace_shape.cutout(pin_shape);
        TileShape new_trace_shape = Simplex.EMPTY;
        for (int i = 0; i < shape_pieces.length; ++i) {
            if (shape_pieces[i].dimension() != 2 || new_trace_shape != Simplex.EMPTY && !shape_pieces[i].contains(compare_corner)) continue;
            new_trace_shape = shape_pieces[i];
        }
        this.change_item_shape(p_trace, trace_shape_no, new_trace_shape);
    }

    void change_item_shape(Item p_item, int p_shape_no, TileShape p_new_shape) {
        ShapeTree.Leaf[] old_entries = p_item.get_search_tree_entries(this);
        ShapeTree.Leaf[] new_leaf_arr = new ShapeTree.Leaf[old_entries.length];
        TileShape[] new_precalculated_tree_shapes = new TileShape[old_entries.length];
        this.remove_leaf(old_entries[p_shape_no]);
        for (int i = 0; i < new_precalculated_tree_shapes.length; ++i) {
            if (i == p_shape_no) {
                new_precalculated_tree_shapes[i] = p_new_shape;
                continue;
            }
            new_precalculated_tree_shapes[i] = p_item.get_tree_shape(this, i);
            new_leaf_arr[i] = old_entries[i];
        }
        p_item.set_precalculated_tree_shapes(new_precalculated_tree_shapes, this);
        new_leaf_arr[p_shape_no] = this.insert(p_item, p_shape_no);
        p_item.set_search_tree_entries(new_leaf_arr, this);
    }

    TileShape[] calculate_tree_shapes(DrillItem p_drill_item) {
        if (this.board == null) {
            return new TileShape[0];
        }
        TileShape[] result = new TileShape[p_drill_item.tile_shape_count()];
        for (int i = 0; i < result.length; ++i) {
            Shape curr_shape = p_drill_item.get_shape(i);
            if (curr_shape == null) {
                result[i] = null;
                continue;
            }
            TileShape curr_tile_shape = this.board.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE ? curr_shape.bounding_box() : (this.board.rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE ? curr_shape.bounding_octagon() : curr_shape.bounding_tile());
            int offset_width = this.clearance_compensation_value(p_drill_item.clearance_class_no(), p_drill_item.shape_layer(i));
            if (curr_tile_shape == null) {
                System.out.println("ShapeSearchTree.calculate_tree_shapes: shape is null");
            } else {
                curr_tile_shape = (TileShape)curr_tile_shape.enlarge(offset_width);
            }
            result[i] = curr_tile_shape;
        }
        return result;
    }

    TileShape[] calculate_tree_shapes(ObstacleArea p_obstacle_area) {
        if (this.board == null) {
            return new TileShape[0];
        }
        TileShape[] convex_shapes = p_obstacle_area.split_to_convex();
        if (convex_shapes == null) {
            return new TileShape[0];
        }
        double max_tree_shape_width = 50000.0;
        if (this.board.communication.host_cad_exists()) {
            max_tree_shape_width = Math.min(500.0 * this.board.communication.get_resolution(Unit.MIL), max_tree_shape_width);
        }
        LinkedList<TileShape> tree_shape_list = new LinkedList<TileShape>();
        for (int i = 0; i < convex_shapes.length; ++i) {
            TileShape curr_convex_shape = convex_shapes[i];
            int offset_width = this.clearance_compensation_value(p_obstacle_area.clearance_class_no(), p_obstacle_area.get_layer());
            curr_convex_shape = (TileShape)curr_convex_shape.enlarge(offset_width);
            TileShape[] curr_tree_shapes = curr_convex_shape.divide_into_sections(max_tree_shape_width);
            for (int j = 0; j < curr_tree_shapes.length; ++j) {
                tree_shape_list.add(curr_tree_shapes[j]);
            }
        }
        TileShape[] result = new TileShape[tree_shape_list.size()];
        Iterator it = tree_shape_list.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (TileShape)it.next();
        }
        return result;
    }

    TileShape[] calculate_tree_shapes(BoardOutline p_board_outline) {
        TileShape[] result;
        if (this.board == null) {
            return new TileShape[0];
        }
        if (p_board_outline.keepout_outside_outline_generated()) {
            int i;
            TileShape[] convex_shapes = p_board_outline.get_keepout_area().split_to_convex();
            if (convex_shapes == null) {
                return new TileShape[0];
            }
            LinkedList<TileShape> tree_shape_list = new LinkedList<TileShape>();
            for (int layer_no = 0; layer_no < this.board.layer_structure.arr.length; ++layer_no) {
                for (i = 0; i < convex_shapes.length; ++i) {
                    TileShape curr_convex_shape = convex_shapes[i];
                    int offset_width = this.clearance_compensation_value(p_board_outline.clearance_class_no(), 0);
                    curr_convex_shape = (TileShape)curr_convex_shape.enlarge(offset_width);
                    tree_shape_list.add(curr_convex_shape);
                }
            }
            result = new TileShape[tree_shape_list.size()];
            Iterator it = tree_shape_list.iterator();
            for (i = 0; i < result.length; ++i) {
                result[i] = (TileShape)it.next();
            }
        } else {
            result = new TileShape[p_board_outline.line_count() * this.board.layer_structure.arr.length];
            int half_width = p_board_outline.get_half_width();
            Line[] curr_line_arr = new Line[3];
            int curr_no = 0;
            for (int layer_no = 0; layer_no < this.board.layer_structure.arr.length; ++layer_no) {
                for (int shape_no = 0; shape_no < p_board_outline.shape_count(); ++shape_no) {
                    PolylineShape curr_outline_shape = p_board_outline.get_shape(shape_no);
                    int border_line_count = curr_outline_shape.border_line_count();
                    curr_line_arr[0] = curr_outline_shape.border_line(border_line_count - 1);
                    for (int i = 0; i < border_line_count; ++i) {
                        curr_line_arr[1] = curr_outline_shape.border_line(i);
                        curr_line_arr[2] = curr_outline_shape.border_line((i + 1) % border_line_count);
                        Polyline tmp_polyline = new Polyline(curr_line_arr);
                        int cmp_value = this.clearance_compensation_value(p_board_outline.clearance_class_no(), 0);
                        result[curr_no] = tmp_polyline.offset_shape(half_width + cmp_value, 0);
                        ++curr_no;
                        curr_line_arr[0] = curr_line_arr[1];
                    }
                }
            }
        }
        return result;
    }

    TileShape offset_shape(Polyline p_polyline, int p_half_width, int p_no) {
        return p_polyline.offset_shape(p_half_width, p_no);
    }

    public TileShape[] offset_shapes(Polyline p_polyline, int p_half_width, int p_from_no, int p_to_no) {
        return p_polyline.offset_shapes(p_half_width, p_from_no, p_to_no);
    }

    TileShape[] calculate_tree_shapes(PolylineTrace p_trace) {
        if (this.board == null) {
            return new TileShape[0];
        }
        int offset_width = p_trace.get_half_width() + this.clearance_compensation_value(p_trace.clearance_class_no(), p_trace.get_layer());
        TileShape[] result = new TileShape[p_trace.tile_shape_count()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.offset_shape(p_trace.polyline(), offset_width, i);
        }
        return result;
    }

    protected Collection<IncompleteFreeSpaceExpansionRoom> divide_large_room(Collection<IncompleteFreeSpaceExpansionRoom> p_room_list, IntBox p_board_bounding_box) {
        if (p_room_list.size() != 1) {
            return p_room_list;
        }
        IncompleteFreeSpaceExpansionRoom curr_room = p_room_list.iterator().next();
        IntBox room_bounding_box = curr_room.get_shape().bounding_box();
        if (2 * room_bounding_box.height() <= p_board_bounding_box.height() || 2 * room_bounding_box.width() <= p_board_bounding_box.width()) {
            return p_room_list;
        }
        double max_section_width = 0.5 * (double)Math.max(p_board_bounding_box.height(), p_board_bounding_box.width());
        TileShape[] section_arr = curr_room.get_shape().divide_into_sections(max_section_width);
        LinkedList<IncompleteFreeSpaceExpansionRoom> result = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        for (TileShape curr_section : section_arr) {
            TileShape curr_shape_to_be_contained = curr_section.intersection(curr_room.get_contained_shape());
            IncompleteFreeSpaceExpansionRoom curr_section_room = new IncompleteFreeSpaceExpansionRoom(curr_section, curr_room.get_layer(), curr_shape_to_be_contained);
            result.add(curr_section_room);
        }
        return result;
    }

    boolean validate_entries(Item p_item) {
        ShapeTree.Leaf[] curr_tree_entries = p_item.get_search_tree_entries(this);
        for (int i = 0; i < curr_tree_entries.length; ++i) {
            ShapeTree.Leaf curr_leaf = curr_tree_entries[i];
            if (curr_leaf.shape_index_in_object == i) continue;
            System.out.println("tree entry inconsistent for Item");
            return false;
        }
        return true;
    }

    private static class EntrySortedByClearance
    implements Comparable<EntrySortedByClearance> {
        ShapeTree.Leaf leaf;
        int clearance;
        private final int entry_id_no;

        EntrySortedByClearance(ShapeTree.Leaf p_leaf, int p_clearance) {
            this.leaf = p_leaf;
            this.clearance = p_clearance;
            if (last_generated_id_no >= Integer.MAX_VALUE) {
                last_generated_id_no = 0;
            } else {
                ++last_generated_id_no;
            }
            this.entry_id_no = last_generated_id_no;
        }

        @Override
        public int compareTo(EntrySortedByClearance p_other) {
            if (this.clearance != p_other.clearance) {
                return Signum.as_int(this.clearance - p_other.clearance);
            }
            return this.entry_id_no - p_other.entry_id_no;
        }
    }
}

