/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.Item;
import board.PolylineTrace;
import board.PullTightAlgo;
import board.RoutingBoard;
import datastructures.Signum;
import datastructures.Stoppable;
import geometry.planar.Direction;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.Limits;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.Polyline;
import geometry.planar.Side;
import geometry.planar.TileShape;
import java.util.Set;

class PullTightAlgoAnyAngle
extends PullTightAlgo {
    private static double SKIP_LENGTH = 10.0;

    PullTightAlgoAnyAngle(RoutingBoard p_board, int[] p_only_net_no_arr, Stoppable p_stoppable_thread, int p_time_limit, Point p_keep_point, int p_keep_point_layer) {
        super(p_board, p_only_net_no_arr, p_stoppable_thread, p_time_limit, p_keep_point, p_keep_point_layer);
    }

    @Override
    Polyline pull_tight(Polyline p_polyline) {
        Polyline new_result = this.avoid_acid_traps(p_polyline);
        Polyline prev_result = null;
        while (new_result != prev_result && !this.is_stop_requested()) {
            prev_result = new_result;
            Polyline tmp = this.skip_segments_of_length_0(prev_result);
            Polyline tmp0 = this.reduce_lines(tmp);
            Polyline tmp1 = this.skip_lines(tmp0);
            Polyline tmp2 = this.reduce_corners(tmp1);
            Polyline tmp3 = this.reposition_lines(tmp2);
            new_result = this.smoothen_corners(tmp3);
        }
        return new_result;
    }

    private Polyline reduce_corners(Polyline p_polyline) {
        if (p_polyline.arr.length < 4) {
            return p_polyline;
        }
        int last_index = p_polyline.arr.length - 4;
        Line[] new_lines = new Line[p_polyline.arr.length];
        new_lines[0] = p_polyline.arr[0];
        new_lines[1] = p_polyline.arr[1];
        int new_line_index = 1;
        boolean polyline_changed = false;
        Line[] curr_lines = new Line[3];
        for (int i = 0; i <= last_index; ++i) {
            boolean in_clip_shape;
            boolean skip_line = false;
            FloatPoint new_a = new_lines[new_line_index - 1].intersection_approx(new_lines[new_line_index]);
            FloatPoint new_b = p_polyline.corner_approx(i + 2);
            boolean bl = in_clip_shape = this.curr_clip_shape == null || this.curr_clip_shape.contains(new_a) && this.curr_clip_shape.contains(new_b) && this.curr_clip_shape.contains(p_polyline.corner_approx(new_line_index));
            if (in_clip_shape) {
                Point new_corner;
                FloatPoint check_is;
                double dist;
                Direction dir;
                FloatPoint skip_corner = new_lines[new_line_index].intersection_approx(p_polyline.arr[i + 2]);
                curr_lines[1] = new Line((Point)new_a.round(), new_b.round());
                boolean ok = true;
                if (new_line_index == 1) {
                    if (!(p_polyline.first_corner() instanceof IntPoint)) {
                        ok = false;
                    } else {
                        dir = curr_lines[1].direction();
                        curr_lines[0] = Line.get_instance(p_polyline.first_corner(), dir.turn_45_degree(2));
                    }
                } else {
                    curr_lines[0] = new_lines[new_line_index - 1];
                }
                if (i == last_index) {
                    if (!(p_polyline.last_corner() instanceof IntPoint)) {
                        ok = false;
                    } else {
                        dir = curr_lines[1].direction();
                        curr_lines[2] = Line.get_instance(p_polyline.last_corner(), dir.turn_45_degree(2));
                    }
                } else {
                    curr_lines[2] = p_polyline.arr[i + 3];
                }
                double check_dist = 100.0;
                if (ok && (dist = (check_is = curr_lines[0].intersection_approx(curr_lines[1])).distance_square(new_a)) > 100.0) {
                    ok = false;
                }
                if (ok && (dist = (check_is = curr_lines[1].intersection_approx(curr_lines[2])).distance_square(new_b)) > 100.0) {
                    ok = false;
                }
                if (ok && i == 1 && !(p_polyline.first_corner() instanceof IntPoint) && (new_corner = curr_lines[0].intersection(curr_lines[1])).side_of(new_lines[0]) != p_polyline.corner(1).side_of(new_lines[0])) {
                    ok = false;
                }
                if (ok && i == last_index - 1 && !(p_polyline.last_corner() instanceof IntPoint) && (new_corner = curr_lines[1].intersection(curr_lines[2])).side_of(new_lines[0]) != p_polyline.corner(p_polyline.corner_count() - 2).side_of(new_lines[0])) {
                    ok = false;
                }
                Polyline curr_polyline = null;
                if (ok) {
                    curr_polyline = new Polyline(curr_lines);
                    if (curr_polyline.arr.length != 3) {
                        ok = false;
                    }
                    double length_before = skip_corner.distance(new_a) + skip_corner.distance(new_b);
                    double length_after = curr_polyline.length_approx() + 1.5;
                    if (length_after >= length_before) {
                        ok = false;
                    }
                }
                if (ok) {
                    TileShape shape_to_check = curr_polyline.offset_shape(this.curr_half_width, 0);
                    skip_line = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
                }
            }
            if (skip_line) {
                polyline_changed = true;
                new_lines[new_line_index] = curr_lines[1];
                if (new_line_index == 1) {
                    new_lines[0] = curr_lines[0];
                }
                if (i == last_index) {
                    new_lines[++new_line_index] = curr_lines[2];
                }
                if (this.board.changed_area != null) {
                    this.board.changed_area.join(new_a, this.curr_layer);
                    this.board.changed_area.join(new_b, this.curr_layer);
                }
            } else {
                new_lines[++new_line_index] = p_polyline.arr[i + 2];
                if (i == last_index) {
                    new_lines[++new_line_index] = p_polyline.arr[i + 3];
                }
            }
            if (!new_lines[new_line_index].is_parallel(new_lines[new_line_index - 1])) continue;
            --new_line_index;
        }
        if (!polyline_changed) {
            return p_polyline;
        }
        Line[] cleaned_new_lines = new Line[new_line_index + 1];
        System.arraycopy(new_lines, 0, cleaned_new_lines, 0, cleaned_new_lines.length);
        Polyline result = new Polyline(cleaned_new_lines);
        return result;
    }

    private Polyline smoothen_corners(Polyline p_polyline) {
        if (p_polyline.arr.length < 4) {
            return p_polyline;
        }
        boolean polyline_changed = false;
        Line[] line_arr = new Line[p_polyline.arr.length];
        System.arraycopy(p_polyline.arr, 0, line_arr, 0, line_arr.length);
        for (int i = 0; i < line_arr.length - 3; ++i) {
            Line new_line = this.smoothen_corner(line_arr, i);
            if (new_line == null) continue;
            polyline_changed = true;
            Line[] tmp_lines = new Line[line_arr.length + 1];
            System.arraycopy(line_arr, 0, tmp_lines, 0, i + 2);
            tmp_lines[i + 2] = new_line;
            System.arraycopy(line_arr, i + 2, tmp_lines, i + 3, tmp_lines.length - (i + 3));
            line_arr = tmp_lines;
            ++i;
        }
        if (!polyline_changed) {
            return p_polyline;
        }
        return new Polyline(line_arr);
    }

    @Override
    Polyline reposition_lines(Polyline p_polyline) {
        if (p_polyline.arr.length < 5) {
            return p_polyline;
        }
        boolean polyline_changed = false;
        Line[] line_arr = new Line[p_polyline.arr.length];
        System.arraycopy(p_polyline.arr, 0, line_arr, 0, line_arr.length);
        for (int i = 0; i < line_arr.length - 4; ++i) {
            Line new_line = this.reposition_line(line_arr, i);
            if (new_line == null) continue;
            polyline_changed = true;
            line_arr[i + 2] = new_line;
            if (line_arr[i + 2].is_parallel(line_arr[i + 1]) || line_arr[i + 2].is_parallel(line_arr[i + 3])) break;
        }
        if (!polyline_changed) {
            return p_polyline;
        }
        return new Polyline(line_arr);
    }

    private Polyline reduce_lines(Polyline p_polyline) {
        if (p_polyline.arr.length < 6) {
            return p_polyline;
        }
        boolean polyline_changed = false;
        Line[] line_arr = p_polyline.arr;
        for (int i = 2; i < line_arr.length - 2; ++i) {
            FloatPoint next_next_corner;
            FloatPoint prev_prev_corner;
            double translate_dist;
            boolean in_clip_shape;
            FloatPoint prev_corner = line_arr[i - 2].intersection_approx(line_arr[i - 1]);
            FloatPoint next_corner = line_arr[i + 1].intersection_approx(line_arr[i + 2]);
            boolean bl = in_clip_shape = this.curr_clip_shape == null || this.curr_clip_shape.contains(prev_corner) && this.curr_clip_shape.contains(next_corner);
            if (!in_clip_shape) continue;
            Line translate_line = line_arr[i];
            double prev_dist = translate_line.signed_distance(prev_corner);
            double next_dist = translate_line.signed_distance(next_corner);
            if (Signum.of(prev_dist) != Signum.of(next_dist) || (translate_dist = Math.abs(prev_dist) < Math.abs(next_dist) ? prev_dist : next_dist) == 0.0) continue;
            Side line_side = translate_line.side_of(prev_corner);
            Line new_line = translate_line.translate(-translate_dist);
            int sign = Signum.as_int(translate_dist);
            Side new_line_side_of_prev_corner = new_line.side_of(prev_corner);
            Side new_line_side_of_next_corner = new_line.side_of(next_corner);
            while (new_line_side_of_prev_corner == line_side && new_line_side_of_next_corner == line_side) {
                new_line = translate_line.translate(-(translate_dist += (double)sign * 0.5));
                new_line_side_of_prev_corner = new_line.side_of(prev_corner);
                new_line_side_of_next_corner = new_line.side_of(next_corner);
            }
            int crossed_corners_before_count = 0;
            int crossed_corners_after_count = 0;
            if (new_line_side_of_prev_corner != line_side) {
                ++crossed_corners_before_count;
            }
            if (new_line_side_of_next_corner != line_side) {
                ++crossed_corners_after_count;
            }
            if (crossed_corners_before_count > 1 || crossed_corners_after_count > 1 || crossed_corners_before_count > 0 && (i < 3 || new_line.side_of(prev_prev_corner = line_arr[i - 3].intersection_approx(line_arr[i - 2])) != line_side) || crossed_corners_after_count > 0 && (i >= line_arr.length - 3 || new_line.side_of(next_next_corner = line_arr[i + 2].intersection_approx(line_arr[i + 3])) != line_side)) continue;
            Line[] curr_lines = new Line[line_arr.length - crossed_corners_before_count - crossed_corners_after_count];
            int keep_before_ind = i - crossed_corners_before_count;
            System.arraycopy(line_arr, 0, curr_lines, 0, keep_before_ind);
            curr_lines[keep_before_ind] = new_line;
            System.arraycopy(line_arr, i + 1 + crossed_corners_after_count, curr_lines, keep_before_ind + 1, curr_lines.length - (keep_before_ind + 1));
            Polyline tmp = new Polyline(curr_lines);
            boolean check_ok = false;
            if (tmp.arr.length == curr_lines.length) {
                TileShape shape_to_check = tmp.offset_shape(this.curr_half_width, keep_before_ind - 1);
                check_ok = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
            }
            if (!check_ok) continue;
            if (this.board.changed_area != null) {
                this.board.changed_area.join(prev_corner, this.curr_layer);
                this.board.changed_area.join(next_corner, this.curr_layer);
            }
            polyline_changed = true;
            line_arr = curr_lines;
            --i;
        }
        if (!polyline_changed) {
            return p_polyline;
        }
        return new Polyline(line_arr);
    }

    private Line smoothen_corner(Line[] p_line_arr, int p_start_no) {
        double max_translate_dist;
        FloatPoint nearest_point;
        if (p_line_arr.length - p_start_no < 4) {
            return null;
        }
        FloatPoint curr_corner = p_line_arr[p_start_no + 1].intersection_approx(p_line_arr[p_start_no + 2]);
        if (this.curr_clip_shape != null && !this.curr_clip_shape.contains(curr_corner)) {
            return null;
        }
        double cosinus_angle = p_line_arr[p_start_no + 1].cos_angle(p_line_arr[p_start_no + 2]);
        if (cosinus_angle > 0.999) {
            return null;
        }
        FloatPoint prev_corner = p_line_arr[p_start_no].intersection_approx(p_line_arr[p_start_no + 1]);
        FloatPoint next_corner = p_line_arr[p_start_no + 2].intersection_approx(p_line_arr[p_start_no + 3]);
        Direction prev_dir = p_line_arr[p_start_no + 1].direction();
        Direction next_dir = p_line_arr[p_start_no + 2].direction();
        Direction middle_dir = prev_dir.middle_approx(next_dir);
        Line translate_line = Line.get_instance(curr_corner.round(), middle_dir);
        double prev_dist = translate_line.signed_distance(prev_corner);
        double next_dist = translate_line.signed_distance(next_corner);
        if (Math.abs(prev_dist) < Math.abs(next_dist)) {
            nearest_point = prev_corner;
            max_translate_dist = prev_dist;
        } else {
            nearest_point = next_corner;
            max_translate_dist = next_dist;
        }
        if (Math.abs(max_translate_dist) < 1.0) {
            return null;
        }
        Line[] curr_lines = new Line[p_line_arr.length + 1];
        System.arraycopy(p_line_arr, 0, curr_lines, 0, p_start_no + 2);
        System.arraycopy(p_line_arr, p_start_no + 2, curr_lines, p_start_no + 3, curr_lines.length - p_start_no - 3);
        double translate_dist = max_translate_dist;
        double delta_dist = max_translate_dist;
        Side side_of_nearest_point = translate_line.side_of(nearest_point);
        int sign = Signum.as_int(max_translate_dist);
        Line result = null;
        while (Math.abs(delta_dist) > (double)this.min_translate_dist) {
            boolean check_ok = false;
            Line new_line = translate_line.translate(-translate_dist);
            Side new_line_side_of_nearest_point = new_line.side_of(nearest_point);
            if (new_line_side_of_nearest_point == side_of_nearest_point || new_line_side_of_nearest_point == Side.COLLINEAR) {
                curr_lines[p_start_no + 2] = new_line;
                Polyline tmp = new Polyline(curr_lines);
                if (tmp.arr.length == curr_lines.length) {
                    TileShape shape_to_check = tmp.offset_shape(this.curr_half_width, p_start_no + 1);
                    check_ok = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
                }
                delta_dist /= 2.0;
                if (check_ok) {
                    result = curr_lines[p_start_no + 2];
                    if (translate_dist == max_translate_dist) break;
                    translate_dist += delta_dist;
                    continue;
                }
                translate_dist -= delta_dist;
                continue;
            }
            double shorten_value = (double)sign * 0.5;
            max_translate_dist -= shorten_value;
            translate_dist -= shorten_value;
            delta_dist -= shorten_value;
        }
        if (result == null) {
            return null;
        }
        if (this.board.changed_area != null) {
            FloatPoint new_prev_corner = curr_lines[p_start_no].intersection_approx(curr_lines[p_start_no + 1]);
            FloatPoint new_next_corner = curr_lines[p_start_no + 3].intersection_approx(curr_lines[p_start_no + 4]);
            this.board.changed_area.join(new_prev_corner, this.curr_layer);
            this.board.changed_area.join(new_next_corner, this.curr_layer);
        }
        return result;
    }

    @Override
    protected Line reposition_line(Line[] p_line_arr, int p_start_no) {
        double max_translate_dist;
        FloatPoint nearest_point;
        if (p_line_arr.length - p_start_no < 5) {
            return null;
        }
        if (this.curr_clip_shape != null) {
            for (int i = 1; i < 3; ++i) {
                FloatPoint curr_corner = p_line_arr[p_start_no + i].intersection_approx(p_line_arr[p_start_no + i + 1]);
                if (this.curr_clip_shape.contains(curr_corner)) continue;
                return null;
            }
        }
        Line translate_line = p_line_arr[p_start_no + 2];
        FloatPoint prev_corner = p_line_arr[p_start_no].intersection_approx(p_line_arr[p_start_no + 1]);
        FloatPoint next_corner = p_line_arr[p_start_no + 3].intersection_approx(p_line_arr[p_start_no + 4]);
        double prev_dist = translate_line.signed_distance(prev_corner);
        int corners_skipped_before = 0;
        int corners_skipped_after = 0;
        double c_epsilon = 0.001;
        while (Math.abs(prev_dist) < 0.001) {
            int curr_no;
            if ((curr_no = p_start_no - ++corners_skipped_before) < 0) {
                return null;
            }
            prev_corner = p_line_arr[curr_no].intersection_approx(p_line_arr[curr_no + 1]);
            prev_dist = translate_line.signed_distance(prev_corner);
        }
        double next_dist = translate_line.signed_distance(next_corner);
        while (Math.abs(next_dist) < 0.001) {
            int curr_no;
            if ((curr_no = p_start_no + 3 + ++corners_skipped_after) >= p_line_arr.length - 2) {
                return null;
            }
            next_corner = p_line_arr[curr_no].intersection_approx(p_line_arr[curr_no + 1]);
            next_dist = translate_line.signed_distance(next_corner);
        }
        if (Signum.of(prev_dist) != Signum.of(next_dist)) {
            return null;
        }
        if (Math.abs(prev_dist) < Math.abs(next_dist)) {
            nearest_point = prev_corner;
            max_translate_dist = prev_dist;
        } else {
            nearest_point = next_corner;
            max_translate_dist = next_dist;
        }
        Line[] curr_lines = new Line[p_line_arr.length];
        System.arraycopy(p_line_arr, 0, curr_lines, 0, p_start_no + 2);
        System.arraycopy(p_line_arr, p_start_no + 3, curr_lines, p_start_no + 3, curr_lines.length - p_start_no - 3);
        double translate_dist = max_translate_dist;
        double delta_dist = max_translate_dist;
        Side side_of_nearest_point = translate_line.side_of(nearest_point);
        int sign = Signum.as_int(max_translate_dist);
        Line result = null;
        boolean first_time = true;
        while (first_time || Math.abs(delta_dist) > (double)this.min_translate_dist) {
            Side new_line_side_of_nearest_point;
            boolean check_ok = false;
            Line new_line = translate_line.translate(-translate_dist);
            if (first_time && Math.abs(translate_dist) < 1.0) {
                if (new_line.equals(translate_line)) {
                    IntPoint rounded_nearest_point = nearest_point.round();
                    if (nearest_point.distance(rounded_nearest_point.to_float()) < Math.abs(translate_dist)) {
                        new_line = Line.get_instance(rounded_nearest_point, translate_line.direction());
                    }
                    first_time = false;
                }
                if (new_line.equals(translate_line)) {
                    return null;
                }
            }
            if ((new_line_side_of_nearest_point = new_line.side_of(nearest_point)) == side_of_nearest_point || new_line_side_of_nearest_point == Side.COLLINEAR) {
                double curr_translate_dist;
                Line curr_translate_line;
                int i;
                first_time = false;
                curr_lines[p_start_no + 2] = new_line;
                Line prev_translated_line = new_line;
                for (i = 0; i < corners_skipped_before; ++i) {
                    int prev_line_no = p_start_no + 1 - corners_skipped_before;
                    FloatPoint curr_prev_corner = prev_translated_line.intersection_approx(curr_lines[prev_line_no]);
                    curr_translate_line = p_line_arr[p_start_no + 1 - i];
                    curr_translate_dist = curr_translate_line.signed_distance(curr_prev_corner);
                    curr_lines[p_start_no + 1 - i] = prev_translated_line = curr_translate_line.translate(-curr_translate_dist);
                }
                prev_translated_line = new_line;
                for (i = 0; i < corners_skipped_after; ++i) {
                    int next_line_no = p_start_no + 3 + corners_skipped_after;
                    FloatPoint curr_next_corner = prev_translated_line.intersection_approx(curr_lines[next_line_no]);
                    curr_translate_line = p_line_arr[p_start_no + 3 + i];
                    curr_translate_dist = curr_translate_line.signed_distance(curr_next_corner);
                    curr_lines[p_start_no + 3 + i] = prev_translated_line = curr_translate_line.translate(-curr_translate_dist);
                }
                Polyline tmp = new Polyline(curr_lines);
                if (tmp.arr.length == curr_lines.length) {
                    TileShape shape_to_check = tmp.offset_shape(this.curr_half_width, p_start_no + 1);
                    check_ok = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
                }
                delta_dist /= 2.0;
                if (check_ok) {
                    result = curr_lines[p_start_no + 2];
                    if (translate_dist == max_translate_dist) break;
                    translate_dist += delta_dist;
                    continue;
                }
                translate_dist -= delta_dist;
                continue;
            }
            double shorten_value = (double)sign * 0.5;
            max_translate_dist -= shorten_value;
            translate_dist -= shorten_value;
            delta_dist -= shorten_value;
        }
        if (result == null) {
            return null;
        }
        if (this.board.changed_area != null) {
            FloatPoint new_prev_corner = curr_lines[p_start_no].intersection_approx(curr_lines[p_start_no + 1]);
            FloatPoint new_next_corner = curr_lines[p_start_no + 3].intersection_approx(curr_lines[p_start_no + 4]);
            this.board.changed_area.join(new_prev_corner, this.curr_layer);
            this.board.changed_area.join(new_next_corner, this.curr_layer);
        }
        return result;
    }

    private Polyline skip_lines(Polyline p_polyline) {
        block0: for (int i = 1; i < p_polyline.arr.length - 3; ++i) {
            for (int j = 0; j <= 1; ++j) {
                TileShape shape_to_check;
                Side side2;
                boolean in_clip_shape;
                FloatPoint corner2;
                FloatPoint corner1;
                Line curr_line;
                if (j == 0) {
                    curr_line = p_polyline.arr[i + 2];
                    corner1 = p_polyline.corner_approx(i);
                    corner2 = p_polyline.corner_approx(i - 1);
                } else {
                    curr_line = p_polyline.arr[i];
                    corner1 = p_polyline.corner_approx(i + 1);
                    corner2 = p_polyline.corner_approx(i + 2);
                }
                boolean bl = in_clip_shape = this.curr_clip_shape == null || this.curr_clip_shape.contains(corner1) && this.curr_clip_shape.contains(corner2);
                if (!in_clip_shape) continue;
                Side side1 = curr_line.side_of(corner1);
                if (side1 != (side2 = curr_line.side_of(corner2))) {
                    Polyline reduced_polyline = p_polyline.skip_lines(i + 1, i + 1);
                    if (reduced_polyline.arr.length == p_polyline.arr.length - 1) {
                        TileShape shape_to_check2;
                        int shape_no = i - 1;
                        if (j == 0) {
                            ++shape_no;
                        }
                        if (this.board.check_trace_shape(shape_to_check2 = reduced_polyline.offset_shape(this.curr_half_width, shape_no), this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins)) {
                            if (this.board.changed_area != null) {
                                this.board.changed_area.join(corner1, this.curr_layer);
                                this.board.changed_area.join(corner2, this.curr_layer);
                            }
                            return reduced_polyline;
                        }
                    }
                }
                if (i >= p_polyline.arr.length - 4) continue block0;
                FloatPoint corner3 = j == 1 ? p_polyline.corner_approx(i + 3) : p_polyline.corner_approx(i + 1);
                if (this.curr_clip_shape != null && !this.curr_clip_shape.contains(corner3)) continue;
                if (j == 0) {
                    curr_line = p_polyline.arr[i + 3];
                    side1 = curr_line.side_of(corner1);
                    side2 = curr_line.side_of(corner2);
                } else {
                    side1 = curr_line.side_of(corner3);
                }
                if (side1 == side2) continue;
                Polyline reduced_polyline = p_polyline.skip_lines(i + 1, i + 2);
                if (reduced_polyline.arr.length != p_polyline.arr.length - 2) continue;
                int shape_no = i - 1;
                if (j == 0) {
                    ++shape_no;
                }
                if (!this.board.check_trace_shape(shape_to_check = reduced_polyline.offset_shape(this.curr_half_width, shape_no), this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins)) continue;
                if (this.board.changed_area != null) {
                    this.board.changed_area.join(corner1, this.curr_layer);
                    this.board.changed_area.join(corner2, this.curr_layer);
                    this.board.changed_area.join(corner3, this.curr_layer);
                }
                return reduced_polyline;
            }
        }
        return p_polyline;
    }

    @Override
    Polyline smoothen_start_corner_at_trace(PolylineTrace p_trace) {
        boolean acute_angle = false;
        boolean bend = false;
        FloatPoint other_trace_corner_approx = null;
        Line other_trace_line = null;
        Line other_prev_trace_line = null;
        Polyline trace_polyline = p_trace.polyline();
        Point curr_end_corner = trace_polyline.corner(0);
        if (this.curr_clip_shape != null && this.curr_clip_shape.is_outside(curr_end_corner)) {
            return null;
        }
        Point curr_prev_end_corner = trace_polyline.corner(1);
        boolean skip_short_segment = !(curr_end_corner instanceof IntPoint) && curr_end_corner.to_float().distance_square(curr_prev_end_corner.to_float()) < SKIP_LENGTH;
        int start_line_no = 1;
        if (skip_short_segment) {
            if (trace_polyline.corner_count() < 3) {
                return null;
            }
            curr_prev_end_corner = trace_polyline.corner(2);
            ++start_line_no;
        }
        Side prev_corner_side = null;
        Direction line_direction = trace_polyline.arr[start_line_no].direction();
        Direction prev_line_direction = trace_polyline.arr[start_line_no + 1].direction();
        Set<Item> contact_list = p_trace.get_start_contacts();
        for (Item curr_contact : contact_list) {
            if (curr_contact instanceof PolylineTrace && !curr_contact.is_shove_fixed()) {
                Line curr_other_prev_trace_line;
                Line curr_other_trace_line;
                FloatPoint curr_other_trace_corner_approx;
                Polyline contact_trace_polyline = ((PolylineTrace)curr_contact).polyline();
                if (contact_trace_polyline.first_corner().equals(curr_end_corner)) {
                    curr_other_trace_corner_approx = contact_trace_polyline.corner_approx(1);
                    curr_other_trace_line = contact_trace_polyline.arr[1];
                    curr_other_prev_trace_line = contact_trace_polyline.arr[2];
                } else {
                    int curr_corner_no = contact_trace_polyline.corner_count() - 2;
                    curr_other_trace_corner_approx = contact_trace_polyline.corner_approx(curr_corner_no);
                    curr_other_trace_line = contact_trace_polyline.arr[curr_corner_no + 1].opposite();
                    curr_other_prev_trace_line = contact_trace_polyline.arr[curr_corner_no];
                }
                Side curr_prev_corner_side = curr_prev_end_corner.side_of(curr_other_trace_line);
                Signum curr_projection = line_direction.projection(curr_other_trace_line.direction());
                boolean other_trace_found = false;
                if (curr_projection == Signum.POSITIVE && curr_prev_corner_side != Side.COLLINEAR) {
                    acute_angle = true;
                    other_trace_found = true;
                } else if (curr_projection == Signum.ZERO && trace_polyline.corner_count() > 2 && prev_line_direction.projection(curr_other_trace_line.direction()) == Signum.POSITIVE) {
                    bend = true;
                    other_trace_found = true;
                }
                if (!other_trace_found) continue;
                other_trace_corner_approx = curr_other_trace_corner_approx;
                other_trace_line = curr_other_trace_line;
                prev_corner_side = curr_prev_corner_side;
                other_prev_trace_line = curr_other_prev_trace_line;
                continue;
            }
            return null;
        }
        int new_line_count = trace_polyline.arr.length + 1;
        int diff = 1;
        if (skip_short_segment) {
            --new_line_count;
            --diff;
        }
        if (acute_angle) {
            Direction new_line_dir = prev_corner_side == Side.ON_THE_LEFT ? other_trace_line.direction().turn_45_degree(2) : other_trace_line.direction().turn_45_degree(6);
            Line translate_line = Line.get_instance(curr_end_corner.to_float().round(), new_line_dir);
            double translate_dist = (Limits.sqrt2 - 1.0) * (double)this.curr_half_width;
            double prev_corner_dist = Math.abs(translate_line.signed_distance(curr_prev_end_corner.to_float()));
            double other_dist = Math.abs(translate_line.signed_distance(other_trace_corner_approx));
            translate_dist = Math.min(translate_dist, prev_corner_dist);
            if ((translate_dist = Math.min(translate_dist, other_dist)) >= 0.99) {
                translate_dist = Math.max(translate_dist - 1.0, 1.0);
                if (translate_line.side_of(curr_prev_end_corner) == Side.ON_THE_LEFT) {
                    translate_dist = -translate_dist;
                }
                Line add_line = translate_line.translate(translate_dist);
                Line[] new_lines = new Line[new_line_count];
                new_lines[0] = other_trace_line;
                new_lines[1] = add_line;
                for (int i = 2; i < new_lines.length; ++i) {
                    new_lines[i] = trace_polyline.arr[i - diff];
                }
                return new Polyline(new_lines);
            }
        } else if (bend) {
            Line[] check_line_arr = new Line[new_line_count];
            check_line_arr[0] = other_prev_trace_line;
            check_line_arr[1] = other_trace_line;
            for (int i = 2; i < check_line_arr.length; ++i) {
                check_line_arr[i] = trace_polyline.arr[i - diff];
            }
            Line new_line = this.reposition_line(check_line_arr, 0);
            if (new_line != null) {
                Line[] new_lines = new Line[trace_polyline.arr.length];
                new_lines[0] = other_trace_line;
                new_lines[1] = new_line;
                for (int i = 2; i < new_lines.length; ++i) {
                    new_lines[i] = trace_polyline.arr[i];
                }
                return new Polyline(new_lines);
            }
        }
        return null;
    }

    @Override
    Polyline smoothen_end_corner_at_trace(PolylineTrace p_trace) {
        boolean acute_angle = false;
        boolean bend = false;
        FloatPoint other_trace_corner_approx = null;
        Line other_trace_line = null;
        Line other_prev_trace_line = null;
        Polyline trace_polyline = p_trace.polyline();
        Point curr_end_corner = trace_polyline.last_corner();
        if (this.curr_clip_shape != null && this.curr_clip_shape.is_outside(curr_end_corner)) {
            return null;
        }
        Point curr_prev_end_corner = trace_polyline.corner(trace_polyline.corner_count() - 2);
        boolean skip_short_segment = !(curr_end_corner instanceof IntPoint) && curr_end_corner.to_float().distance_square(curr_prev_end_corner.to_float()) < SKIP_LENGTH;
        int end_line_no = trace_polyline.arr.length - 2;
        if (skip_short_segment) {
            if (trace_polyline.corner_count() < 3) {
                return null;
            }
            curr_prev_end_corner = trace_polyline.corner(trace_polyline.corner_count() - 3);
            --end_line_no;
        }
        Side prev_corner_side = null;
        Direction line_direction = trace_polyline.arr[end_line_no].direction().opposite();
        Direction prev_line_direction = trace_polyline.arr[end_line_no].direction().opposite();
        Set<Item> contact_list = p_trace.get_end_contacts();
        for (Item curr_contact : contact_list) {
            if (curr_contact instanceof PolylineTrace && !curr_contact.is_shove_fixed()) {
                Line curr_other_prev_trace_line;
                Line curr_other_trace_line;
                FloatPoint curr_other_trace_corner_approx;
                Polyline contact_trace_polyline = ((PolylineTrace)curr_contact).polyline();
                if (contact_trace_polyline.corner_count() <= 2) continue;
                if (contact_trace_polyline.first_corner().equals(curr_end_corner)) {
                    curr_other_trace_corner_approx = contact_trace_polyline.corner_approx(1);
                    curr_other_trace_line = contact_trace_polyline.arr[1];
                    curr_other_prev_trace_line = contact_trace_polyline.arr[2];
                } else {
                    int curr_corner_no = contact_trace_polyline.corner_count() - 2;
                    curr_other_trace_corner_approx = contact_trace_polyline.corner_approx(curr_corner_no);
                    curr_other_trace_line = contact_trace_polyline.arr[curr_corner_no + 1].opposite();
                    curr_other_prev_trace_line = contact_trace_polyline.arr[curr_corner_no];
                }
                Side curr_prev_corner_side = curr_prev_end_corner.side_of(curr_other_trace_line);
                Signum curr_projection = line_direction.projection(curr_other_trace_line.direction());
                boolean other_trace_found = false;
                if (curr_projection == Signum.POSITIVE && curr_prev_corner_side != Side.COLLINEAR) {
                    acute_angle = true;
                    other_trace_found = true;
                } else if (curr_projection == Signum.ZERO && trace_polyline.corner_count() > 2 && prev_line_direction.projection(curr_other_trace_line.direction()) == Signum.POSITIVE) {
                    bend = true;
                    other_trace_found = true;
                }
                if (!other_trace_found) continue;
                other_trace_corner_approx = curr_other_trace_corner_approx;
                other_trace_line = curr_other_trace_line;
                prev_corner_side = curr_prev_corner_side;
                other_prev_trace_line = curr_other_prev_trace_line;
                continue;
            }
            return null;
        }
        int new_line_count = trace_polyline.arr.length + 1;
        int diff = 0;
        if (skip_short_segment) {
            --new_line_count;
            ++diff;
        }
        if (acute_angle) {
            Direction new_line_dir = prev_corner_side == Side.ON_THE_LEFT ? other_trace_line.direction().turn_45_degree(6) : other_trace_line.direction().turn_45_degree(2);
            Line translate_line = Line.get_instance(curr_end_corner.to_float().round(), new_line_dir);
            double translate_dist = (Limits.sqrt2 - 1.0) * (double)this.curr_half_width;
            double prev_corner_dist = Math.abs(translate_line.signed_distance(curr_prev_end_corner.to_float()));
            double other_dist = Math.abs(translate_line.signed_distance(other_trace_corner_approx));
            translate_dist = Math.min(translate_dist, prev_corner_dist);
            if ((translate_dist = Math.min(translate_dist, other_dist)) >= 0.99) {
                translate_dist = Math.max(translate_dist - 1.0, 1.0);
                if (translate_line.side_of(curr_prev_end_corner) == Side.ON_THE_LEFT) {
                    translate_dist = -translate_dist;
                }
                Line add_line = translate_line.translate(translate_dist);
                Line[] new_lines = new Line[new_line_count];
                for (int i = 0; i < trace_polyline.arr.length - 1; ++i) {
                    new_lines[i] = trace_polyline.arr[i];
                }
                new_lines[new_lines.length - 2] = add_line;
                new_lines[new_lines.length - 1] = other_trace_line;
                return new Polyline(new_lines);
            }
        } else if (bend) {
            Line[] check_line_arr = new Line[new_line_count];
            for (int i = 0; i < check_line_arr.length - 2; ++i) {
                check_line_arr[i] = trace_polyline.arr[i + diff];
            }
            check_line_arr[check_line_arr.length - 2] = other_trace_line;
            check_line_arr[check_line_arr.length - 1] = other_prev_trace_line;
            Line new_line = this.reposition_line(check_line_arr, check_line_arr.length - 5);
            if (new_line != null) {
                Line[] new_lines = new Line[trace_polyline.arr.length];
                for (int i = 0; i < new_lines.length - 2; ++i) {
                    new_lines[i] = trace_polyline.arr[i];
                }
                new_lines[new_lines.length - 2] = new_line;
                new_lines[new_lines.length - 1] = other_trace_line;
                return new Polyline(new_lines);
            }
        }
        return null;
    }
}

