/*
 * Decompiled with CFR 0.152.
 */
package board;

import board.PolylineTrace;
import board.PullTightAlgo;
import board.RoutingBoard;
import datastructures.Stoppable;
import geometry.planar.FloatPoint;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.Polyline;
import geometry.planar.TileShape;

class PullTightAlgo90
extends PullTightAlgo {
    public PullTightAlgo90(RoutingBoard p_board, int[] p_only_net_no_arr, Stoppable p_stoppable_thread, int p_time_limit, Point p_keep_point, int p_keep_point_layer) {
        super(p_board, p_only_net_no_arr, p_stoppable_thread, p_time_limit, p_keep_point, p_keep_point_layer);
    }

    @Override
    Polyline pull_tight(Polyline p_polyline) {
        Polyline new_result = this.avoid_acid_traps(p_polyline);
        Polyline prev_result = null;
        while (new_result != prev_result && !this.is_stop_requested()) {
            prev_result = new_result;
            Polyline tmp1 = this.try_skip_second_corner(prev_result);
            Polyline tmp2 = this.try_skip_corners(tmp1);
            new_result = this.reposition_lines(tmp2);
        }
        return new_result;
    }

    private Polyline try_skip_second_corner(Polyline p_polyline) {
        if (p_polyline.arr.length < 5) {
            return p_polyline;
        }
        Line[] check_lines = new Line[]{p_polyline.arr[1], p_polyline.arr[0], p_polyline.arr[3], p_polyline.arr[4]};
        Polyline check_polyline = new Polyline(check_lines);
        if (check_polyline.arr.length != 4 || this.curr_clip_shape != null && !this.curr_clip_shape.contains(check_polyline.corner_approx(1))) {
            return p_polyline;
        }
        for (int i = 0; i < 2; ++i) {
            TileShape shape_to_check = check_polyline.offset_shape(this.curr_half_width, i);
            if (this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins)) continue;
            return p_polyline;
        }
        Line[] new_lines = new Line[p_polyline.arr.length - 1];
        new_lines[0] = p_polyline.arr[1];
        new_lines[1] = p_polyline.arr[0];
        for (int i = 2; i < new_lines.length; ++i) {
            new_lines[i] = p_polyline.arr[i + 1];
        }
        return new Polyline(new_lines);
    }

    private Polyline try_skip_corners(Polyline p_polyline) {
        int i;
        Line[] new_lines = new Line[p_polyline.arr.length];
        new_lines[0] = p_polyline.arr[0];
        new_lines[1] = p_polyline.arr[1];
        int new_line_index = 1;
        boolean polyline_changed = false;
        Line[] check_lines = new Line[4];
        boolean second_last_corner_skipped = false;
        for (i = 5; i <= p_polyline.arr.length; ++i) {
            boolean in_clip_shape;
            boolean skip_lines = false;
            boolean bl = in_clip_shape = this.curr_clip_shape == null || this.curr_clip_shape.contains(p_polyline.corner_approx(i - 3));
            if (in_clip_shape) {
                TileShape shape_to_check;
                check_lines[0] = new_lines[new_line_index - 1];
                check_lines[1] = new_lines[new_line_index];
                check_lines[2] = p_polyline.arr[i - 1];
                check_lines[3] = i < p_polyline.arr.length ? p_polyline.arr[i] : p_polyline.arr[i - 2];
                Polyline check_polyline = new Polyline(check_lines);
                boolean bl2 = skip_lines = check_polyline.arr.length == 4 && (this.curr_clip_shape == null || this.curr_clip_shape.contains(check_polyline.corner_approx(1)));
                if (skip_lines) {
                    shape_to_check = check_polyline.offset_shape(this.curr_half_width, 0);
                    skip_lines = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
                }
                if (skip_lines) {
                    shape_to_check = check_polyline.offset_shape(this.curr_half_width, 1);
                    skip_lines = this.board.check_trace_shape(shape_to_check, this.curr_layer, this.curr_net_no_arr, this.curr_cl_type, this.contact_pins);
                }
            }
            if (skip_lines) {
                if (i == p_polyline.arr.length) {
                    second_last_corner_skipped = true;
                }
                if (this.board.changed_area != null) {
                    FloatPoint new_corner = check_lines[1].intersection_approx(check_lines[2]);
                    this.board.changed_area.join(new_corner, this.curr_layer);
                    FloatPoint skipped_corner = p_polyline.arr[i - 2].intersection_approx(p_polyline.arr[i - 3]);
                    this.board.changed_area.join(skipped_corner, this.curr_layer);
                }
                polyline_changed = true;
                ++i;
                continue;
            }
            new_lines[++new_line_index] = p_polyline.arr[i - 3];
        }
        if (!polyline_changed) {
            return p_polyline;
        }
        if (second_last_corner_skipped) {
            new_lines[++new_line_index] = p_polyline.arr[p_polyline.arr.length - 1];
            new_lines[++new_line_index] = p_polyline.arr[p_polyline.arr.length - 2];
        } else {
            for (i = 3; i > 0; --i) {
                new_lines[++new_line_index] = p_polyline.arr[p_polyline.arr.length - i];
            }
        }
        Line[] cleaned_new_lines = new Line[new_line_index + 1];
        System.arraycopy(new_lines, 0, cleaned_new_lines, 0, cleaned_new_lines.length);
        Polyline result = new Polyline(cleaned_new_lines);
        return result;
    }

    @Override
    Polyline smoothen_start_corner_at_trace(PolylineTrace p_trace) {
        return null;
    }

    @Override
    Polyline smoothen_end_corner_at_trace(PolylineTrace p_trace) {
        return null;
    }
}

